<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;

class AuthorHistory extends BaseModelCommon
{
    use HasFactory;

    protected $table = 'rvw_article_author_history';
    protected $primaryKey = 'rcd_id';
    public $timestamps = false;


    protected $fillable = [
        'aah_art_id',
        'aah_auth_ids',
        'aah_posted_by',
        'aah_posted_date',
        'aah_proxy_id',
        'aah_operation',
    ];


    /**
     * Relationship to the rvw_users.
     */
    public function article()
    {
        return $this->belongsTo(Articles::class, 'aah_art_id', 'art_id');
    }

    protected $casts = [
        'aah_auth_ids' => 'array'
    ] ;

    protected static function booted()
    {
        static::creating(function ($item) {
            $item->aah_operation = 'i';
            $item->aah_posted_date = Carbon::now();
            $item->aah_posted_by = session('user_id') ?? 0;
            $item->aah_proxy_id = session('proxy_id') ?? 0;
        });

        static::updating(function ($item) {
            $item->aah_operation = 'u';
            $item->aah_posted_date = Carbon::now();
            $item->aah_posted_by =session('user_id') ?? 0;
            $item->aah_proxy_id = session('proxy_id') ?? 0;
        });
    }



    public static function isAuthorsListChanged($art_id)
    {
        $data['authors_added'] = false;
        $data['authors_removed'] = false;
        $data['authors_order_changed'] = false;
        $history = self::where('aah_art_id', $art_id)->orderBy('aah_id', 'DESC')->limit(2)->get(['aah_auth_ids']);
        if($history && count($history) == 2)
        {
            $data['changed'] = getArraySymmetricalDifference($history[0]->aah_auth_ids, $history[1]->aah_auth_ids);
            $added = array_diff($history[0]->aah_auth_ids, $history[1]->aah_auth_ids);
            $removed = array_diff($history[1]->aah_auth_ids, $history[0]->aah_auth_ids);
            $data['authors_removed'] =  count($removed) > 0;
            $data['authors_added'] =  count($added) > 0;
            if(!$removed && !$added)
            $data['author_order_change'] = $history[0]->aah_auth_ids != $history[1]->aah_auth_ids;
        }

        return $data;
    }

    public static function updateAuthorHistory($art_id)
    {
        $authors = Authors::getAuthorListAsArray($art_id);
        if($authors){
            return AuthorHistory::create(['aah_art_id' => $art_id, 'aah_auth_ids' => $authors]);
        }
        return ;
    }
}
