<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class Author_country_map extends BaseModel
{
    use HasFactory;
    public  $table='rvw_article_author_country_map';
    protected $primaryKey = 'acm_id';
    public static $column_prefix='acm_';

	public static function get_author_map_info($jnl_id,$join_article = FALSE){


        DB::enableQueryLog();

        $classname = get_called_class();
		$table = (new $classname)->getTable();
		$country_table = (new \App\Models\Country())->getTable();
        $author_affiliation_table = (new \App\Models\Authors_affiliation())->getTable();
        $author_table = (new \App\Models\Authors())->getTable();
        $article_table = (new \App\Models\Articles())->getTable();
        $article_type_table = (new \App\Models\Article_types())->getTable();
        $where="artp_jnl_id=? AND auaff_prime_affiliation='y' AND auth_corr_author='y' AND art_status='y'";
		DB::enableQueryLog();
		$result = DB::table($country_table);
		$result->selectRaw('cnt_country,acm_longitude,acm_latitude,auaff_address_line2,auaff_id');
        $result->join($author_affiliation_table ,'auaff_cnt_id','=','cnt_id');
        if($join_article == TRUE)
		{
        $result->join($author_table ,'auaff_auth_id','=','auth_id');
        $result->join($article_table ,'auth_art_id','=','art_id');
        $result->leftjoin($article_type_table ,'art_artp_id','=','auaff_id');
        $result->leftjoin($table ,'acm_auaff_id','=','auaff_id');
		$result->whereRaw($where, [$jnl_id]);
        }
        else
        {
        $result->join($table ,'acm_auaff_id','=','auaff_id');
        $result->whereRaw("acm_jnl_id=?", [$jnl_id]);
        $result->groupBy('auaff_cnt_id');
        }
		return $result->get();
        // $queries = DB::getQueryLog();
        //  dd($queries);
	}



}
