<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Authorize extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable;
    public $table='rvw_users';
    protected $primaryKey = 'usr_id';
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'usr_username',
        'usr_pwd',
        'usr_title',
        'usr_first_name',
        'usr_middle_name',
        'usr_last_name',
        'usr_email',
        'usr_image'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'usr_pwd',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }
    public function getJWTCustomClaims()
    {
        return ['user_id'=>$this->usr_id,
        'user_role'=>$this->usr_roles
    
    ];
    }

    public function getAuthPassword()
    {
        return $this->usr_pwd;
    }
    public function getAvatarAttribute($value)
    {
       if(empty($value)){
       	return asset('images/avatar.png');
       }else{
        return asset('storage/users/'.$value);
       	//return Storage::url('app/public/avatar/'.$value);
       }
    }
    public function getImageAttribute($value)
    {
      return $this->attributes['usr_image'] ? URL::to('/uploads/' . $this->attributes['usr_image']) : null; 
    }

}
