<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Authors extends BaseModel
{
    use HasFactory;

    public  $table='rvw_article_authors';
    protected $primaryKey = 'auth_id';
    public static $column_prefix='auth_';
	public static $tbk_table= 'tbk_article_authors';


    public static function coauthor_with_affiliation($article_id) {

        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $usertable= (new \App\Models\User())->getTable();
        $groupby="{$table}.auth_id";
		$result=DB::table($table);
        $result->join($usertable,'auth_usr_id','=','usr_id');
        $result->whereRaw("auth_art_id={$article_id}");
        $result->orderBy('auth_order');
        $result->groupBy($groupby);
		return $result->get();
		
	}
    //get author details with user table   Author order is different in Preview Submission
	public static function get_author_user_details($select= '*',$condition = array(),$order_by = '') {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $usertable= (new \App\Models\User())->getTable();
        $result=DB::table($table);
        $result->selectRaw($select);
		$result->join($usertable,'auth_usr_id','=','usr_id');
		if($condition != '')
			$result->whereRaw($condition);
		if($order_by != '')
			$result->orderBy($order_by);
		return $result->get();
	}

    public static function get_email_record($select,$condition)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $user_table = (new \App\Models\User)->getTable();
        $email=DB::table($table);
        $email->selectRaw($select);
        $email->join($user_table,'auth_usr_id','=','usr_id');
        $email->whereRaw($condition);
        $result = $email->get();
		return $result;
	}
    public static function get_author_affiliations($article_id, $user_id=null) {
	
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $authors_affiliation_table = (new \App\Models\Authors_affiliation)->getTable();
        $result=DB::table($table);
        $result->select('*');
        $result->leftjoin($authors_affiliation_table,'auth_id','=','auaff_auth_id');
        // $result->whereRaw("auth_art_id={$article_id}");
        $result->whereRaw("auth_art_id= ?");
        if($user_id != null) {
            $result->whereRaw("auth_usr_id= ?");
        }
        if($user_id == null)
        $result->setBindings([$article_id]);
        else
        $result->setBindings([$article_id, $user_id]);

        return $result->get();
	
	}

    public static function get_corresp_author_details($article_id)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $user_table = (new \App\Models\User)->getTable();
        $author_affiliation_table=(new \App\Models\Authors_affiliation)->getTable();
        $user_affiliation_table=(new \App\Models\User_affiliations)->getTable();
        $affdata=DB::table($table);
        $affdata->selectRaw('usr_id, auth_id, GROUP_CONCAT(auaff_postal_code SEPARATOR \',\') as auaff_pcode, GROUP_CONCAT(usaff_postal_code SEPARATOR \',\') as usaff_pcode,   concat(\'{\',GROUP_CONCAT(DISTINCT concat(\'"\', usaff_id,\'":\',usaff_ringgold_family)   SEPARATOR \', \'),\'}\') AS usaff_ringgold_family, concat(\'{\',GROUP_CONCAT(DISTINCT concat(\'"\', auaff_id,\'":\',auaff_ringgold_family)   SEPARATOR \', \'),\'}\') AS auaff_ringgold_family  , GROUP_CONCAT(usaff_ringgold_id SEPARATOR \',\') as usaff_ringgold_id, GROUP_CONCAT(auaff_ringgold_id SEPARATOR \',\') as auaff_ringgold_id');
        $affdata->join($user_table,'auth_usr_id','=','usr_id');
        $affdata->leftjoin($author_affiliation_table,'auth_id','=','auaff_auth_id');
        $affdata->leftjoin($user_affiliation_table,'auth_usr_id','=','usaff_user_id');
        $affdata->whereRaw('auth_art_id = ' . $article_id);
        $affdata->distinct();
        $result = $affdata->get();
		return $result;
	}
    public static function get_institution_details($article_id)
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $user_table = (new \App\Models\User)->getTable();
        $author_affiliation_table = (new \App\Models\Authors_affiliation)->getTable();
        $user_affiliation_table = (new \App\Models\User_affiliations)->getTable();

        $affdata = DB::table($table)
            ->join($user_table, "{$table}.auth_usr_id", '=', "{$user_table}.usr_id")
            ->leftJoin($author_affiliation_table, "{$table}.auth_id", '=', "{$author_affiliation_table}.auaff_auth_id")
            ->leftJoin($user_affiliation_table, "{$table}.auth_usr_id", '=', "{$user_affiliation_table}.usaff_user_id")
            ->where("{$table}.auth_art_id", $article_id)
            ->distinct()
            ->get([
                "{$user_affiliation_table}.usaff_company",
                "{$user_affiliation_table}.usaff_cnt_id",
                "{$user_affiliation_table}.usaff_postal_code",
                "{$author_affiliation_table}.auaff_company",
                "{$author_affiliation_table}.auaff_cnt_id",
                "{$author_affiliation_table}.auaff_postal_code",
            ]);

        // Grouping the results into user_institution and author_institution
        return $affdata->map(function ($row) {
            return [
                'user_institution' => [
                    'company' => $row->usaff_company,
                    'country_id' => $row->usaff_cnt_id,
                    'postal_code' => $row->usaff_postal_code,
                ],
                'author_institution' => [
                    'company' => $row->auaff_company,
                    'country_id' => $row->auaff_cnt_id,
                    'postal_code' => $row->auaff_postal_code,
                ]
            ];
        });
    }
    public static function get_user_ids_with_matching_institution($institution_combinations)
    {
        $author_affiliation_table = (new \App\Models\Authors_affiliation)->getTable();
        $user_affiliation_table = (new \App\Models\User_affiliations)->getTable();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $author_conditions = DB::table($table)
            ->join($author_affiliation_table, $author_affiliation_table.'.auaff_auth_id', '=', $table.'.auth_id')
            ->select($table.'.auth_usr_id as usr_id')
            ->where(function ($query) use ($institution_combinations, $author_affiliation_table) {
                foreach ($institution_combinations as $combo) {
                    $query->orWhere(function ($q) use ($combo, $author_affiliation_table) {
                        $q->where($author_affiliation_table.'.auaff_company', $combo['company'])
                        ->where($author_affiliation_table.'.auaff_cnt_id', $combo['country_id'])
                        ->where($author_affiliation_table.'.auaff_postal_code', $combo['postal_code']);
                    });
                }
            });

        $user_conditions = DB::table($user_affiliation_table)
            ->select('usaff_user_id as usr_id')
            ->where(function ($query) use ($institution_combinations) {
                foreach ($institution_combinations as $combo) {
                    $query->orWhere(function ($q) use ($combo) {
                        $q->where('usaff_company', $combo['company'])
                        ->where('usaff_cnt_id', $combo['country_id'])
                        ->where('usaff_postal_code', $combo['postal_code']);
                    });
                }
            });

        $result = $author_conditions->union($user_conditions)->distinct()->get()->toArray();
        return $result;
    }
    public static function get_all_article_coauthors_ids($author_ids) {

		$qry = 'SELECT DISTINCT `au`.`auth_usr_id` AS `usr_id` FROM `rvw_article_authors` as `au` WHERE `au`.`auth_art_id` IN (SELECT DISTINCT `art_id` FROM `rvw_articles` INNER JOIN `rvw_article_authors` as `au2` ON `art_id` = `au2`.`auth_art_id` WHERE `au2`.`auth_usr_id` IN (' . implode(',', $author_ids) . '))';
        $result = DB::select($qry);
        return $result;
	}

    public static function get_user_ids_have_post_codes($post_codes)
    {

        $postcodes = "'" . implode("', '", $post_codes) . "'";
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $user_table = (new \App\Models\User)->getTable();
        $author_affiliation_table = (new \App\Models\Authors_affiliation)->getTable();
        $user_affiliation_table = (new \App\Models\User_affiliations)->getTable();

        //           $sql="SELECT DISTINCT auth_usr_id as usr_id FROM {$table} JOIN {$author_affiliation_table} ON auth_id=auaff_auth_id WHERE auaff_postal_code IN (?) UNION SELECT DISTINCT usaff_user_id as usr_id FROM {$user_affiliation_table} WHERE usaff_postal_code IN (?)";
        // DB::enableQueryLog();
        $query1 = DB::table($table)
            ->join($author_affiliation_table, 'auth_id', '=', 'auaff_auth_id')
            ->whereIn('auaff_postal_code', $post_codes)
            ->distinct()
            ->select('auth_usr_id as usr_id');

        $query2 = DB::table($user_affiliation_table)
            ->whereIn('usaff_postal_code', $post_codes)
            ->distinct()
            ->select('usaff_user_id as usr_id');

        $result = $query1->union($query2)->get()->toArray();
        return $result;
    }
    public static function set_author_temp_key($article_id) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $author=DB::table($table);
		$author->whereRaw('auth_art_id = ' . $article_id);
		$author->update(array(
			'auth_temp_id' => NULL
		));
		return $author->get();
	}
    public static function get_orcid_authors($article_id) {
        $user_table = (new \App\Models\User)->getTable();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $author=DB::table($table);
		//#4544 Manage author data listing (normalization)
		$author->selectRaw('auth_id,auth_usr_id,usr_email as auth_email,auth_art_id,auth_id');
		$author->join($user_table, 'auth_usr_id', '=', 'usr_id');
		$author->where('auth_art_id', $article_id);
		$author->whereRaw('usr_orcid_id IS NULL');
		$query = $author->get();
		return $query;
	}
    public static function get_art_all_author_details($article_id)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $user_table = (new \App\Models\User)->getTable();
        $author_affiliation_table=(new \App\Models\Authors_affiliation)->getTable();
        $country_table=(new \App\Models\Country)->getTable();
        $affdata=DB::table($table);
        $affdata->selectRaw('`usr_id`, `usr_title`, `usr_first_name`, `usr_middle_name`, `usr_last_name`, `usr_email`, 
        `usr_orcid_id`, `auth_corr_author`, `auaff_department`, `auaff_company`, `auaff_state`, `auaff_address_line1`, 
        (CASE
            WHEN auaff_type = "e" THEN "Education"
            WHEN auaff_type = "w" THEN "Employment"
            WHEN auaff_type = "c" THEN "Corporate"
            WHEN auaff_type = "g" THEN "Government"
            ELSE "Other"
        END) AS inst_type, `auaff_address_line2`, `auaff_postal_code`, `cnt_country`, `auaff_phone`, `auaff_ringgold_id`, `auaff_ror_id`');
        $affdata->join($user_table,'auth_usr_id','=','usr_id');
        $affdata->leftjoin($author_affiliation_table,'auth_id','=','auaff_auth_id');
        $affdata->leftjoin($country_table,'cnt_id','=','auaff_cnt_id');
        $affdata->whereRaw('auth_art_id = ' . $article_id);
        $affdata->orderBy('auth_corr_author', 'DESC');
        $affdata->orderBy('auth_id', 'ASC');
        $result = $affdata->get();
		return $result;
	}
    public static function get_author_history_details($user_id, $blinded_articles, $authoring_type, $date_format, $legacy_status = false, $journal=NULL, $start = NULL, $limit = NULL)
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $article_table = (new \App\Models\Articles())->getTable();
        $article_keyword_table = (new \App\Models\Article_keywords())->getTable();
        $keyword_table = (new \App\Models\Keywords())->getTable();
        $articleflow_table = (new \App\Models\Article_flow())->getTable();
        $articletypes_table = (new \App\Models\Article_types())->getTable();
        $journal_table = (new \App\Models\Journals())->getTable();
        $article_legacy_table = (new \App\Models\Article_legacydata())->getTable();
        $article_flow_legacy_table = (new \App\Models\Article_flow_legacy())->getTable();

        $art_status = ["b", "n"];
        $date_format = "'{$date_format}'";

        $live_data_sql = DB::table($table)
            ->select([
                'art_artp_id AS artp_id',
                'art_status AS status',
                'aflw_id AS flow_id',
                DB::raw('DATE_FORMAT(art_submission_date, ' . $date_format . ') AS submission_date'),
                DB::raw('DATE_FORMAT(art_decision_date, ' . $date_format . ') AS decision_date'),
                'art_code AS article_code',
                'art_id AS artcle_id',
                'art_title AS title',
                DB::raw('IF(art_submitted_by = ' . $user_id . ', "Submitted", "Co-authored") AS authoring_type'),
                'jnl_journal_name',
                'jnl_journal_code',
                DB::raw('"" AS final_decison'),
                'art_pre_all_ids AS prev_art_ids',
                'art_transfer_article AS transfer_status',
                DB::raw('GROUP_CONCAT(DISTINCT kwd_name SEPARATOR "\t") AS keywords'),
                DB::raw('"live" AS tbl'),
                'art_transfer_article',
                DB::raw('UNIX_TIMESTAMP(art_submission_date) AS mdstamp'),
                DB::raw('IF(art_pre_all_ids IS NOT NULL, SUBSTRING_INDEX(art_pre_all_ids, ",", 1), art_id) AS art_base_id')
            ])
            ->join($article_table, 'art_id', '=', 'auth_art_id')
            ->leftJoin($article_keyword_table, 'ak_art_id', '=', 'art_id')
            ->leftJoin($articleflow_table, 'aflw_art_id', '=', 'art_id')
            ->leftJoin($keyword_table, 'ak_keyword_id', '=', 'kwd_id')
            ->join($articletypes_table, 'artp_id', '=', 'art_artp_id')
            ->join($journal_table, 'jnl_id', '=', 'artp_jnl_id')
            ->where('auth_usr_id', $user_id)
            ->where('art_delete_status', 'n')
            ->whereNotIn('art_status', $art_status);
        if (!empty($authoring_type)) {
            if ($authoring_type == 'Submitted') {
                $live_data_sql->where('art_submitted_by', $user_id);
            } else {
                $live_data_sql->where('art_submitted_by', '!=', $user_id);
            }
        }
        if (!empty($journal)) {
            $live_data_sql->where('jnl_id', $journal);
        }
        if (!empty($blinded_articles)) {
            $live_data_sql->whereNotIn('art_id', $blinded_articles);
        }
        $live_data_sql->groupBy('art_id');

        // Define the legacy_data_sql
        $legacy_data_sql = DB::table($article_legacy_table)
            ->select([
                DB::raw('"" AS artp_id'),
                DB::raw('arld_decision AS status'),
                DB::raw('afld_id AS flow_id'),
                DB::raw('DATE_FORMAT(arld_submission_date, ' . $date_format . ') AS submission_date'),
                DB::raw('DATE_FORMAT(arld_decision_date, ' . $date_format . ') AS decision_date'),
                DB::raw('arld_article_code AS article_code'),
                DB::raw('arld_id AS artcle_id'),
                DB::raw('arld_article_title AS title'),
                DB::raw('IF(arld_submitted_by = ' . $user_id . ', "Submitted", "Co-authored") AS authoring_type'),
                'jnl_journal_name',
                'jnl_journal_code',
                DB::raw('"" AS final_decison'),
                DB::raw('arld_art_pre_all_ids AS prev_art_ids'),
                DB::raw('"n" AS transfer_status'),
                DB::raw('REPLACE(arld_keywords, ",", "\t") AS keywords'),
                DB::raw('"legacy" AS tbl'),
                DB::raw('"" AS art_transfer_article'),
                DB::raw('UNIX_TIMESTAMP(arld_submission_date) AS mdstamp'),
                DB::raw('IF(arld_art_pre_all_ids IS NOT NULL, SUBSTRING_INDEX(arld_art_pre_all_ids, ",", 1), arld_id) AS art_base_id')
            ])
            ->join($journal_table, 'jnl_id', '=', 'arld_jnl_id')
            ->leftJoin($article_flow_legacy_table, 'afld_arld_id', '=', 'arld_id');
        if (!empty($authoring_type)) {
            if ($authoring_type == 'Submitted') {
                $legacy_data_sql->where('arld_submitted_by', $user_id);
            } else {
                $legacy_data_sql->orWhereRaw('FIND_IN_SET(?, arld_author_id) != 0', [$user_id])
                    ->where('arld_submitted_by', '!=', $user_id);
            }
            }else{
                $legacy_data_sql->whereRaw('(arld_submitted_by = ? OR FIND_IN_SET(?, arld_author_id) != 0)', [$user_id, $user_id]);
            // $legacy_data_sql->where('arld_submitted_by', $user_id)->orWhereRaw('FIND_IN_SET(?, arld_author_id) != 0', [$user_id]);
        }
        if (!empty($journal)) {
            $legacy_data_sql->where('jnl_id', $journal);
        }
        $legacy_data_sql->groupBy('arld_id');
        if ($legacy_status) {
            $combinedQuery = $live_data_sql->union($legacy_data_sql);
        } else {
            $combinedQuery = $live_data_sql;
        }
        $data = DB::table(DB::raw("({$combinedQuery->toSql()}) as tb1"))
            ->mergeBindings($combinedQuery)
            ->select([
                'tb1.*',
                DB::raw('GROUP_CONCAT(article_code) AS article_codes'),
                DB::raw('GROUP_CONCAT(artcle_id) AS artcle_ids'),
                DB::raw('GROUP_CONCAT(status) AS gp_status')
            ])
            ->groupBy(['art_base_id', 'artp_id'])
            ->orderBy('mdstamp', 'desc')
            ->paginate($limit);
        return $data;
    }


    public static function getAuthorListAsArray($art_id)
    {
        $authors = self::where('auth_art_id', $art_id)->orderBy('auth_order')->groupBy('auth_art_id')->limit(1)->get([DB::raw("GROUP_CONCAT(auth_id) as auth_list")])?->first()?->auth_list;
        $author_list = [];
        if($authors)
        {
            $author_list = explode(',',$authors);
        }
        return $author_list;
    }

}