<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Authors_affiliation extends BaseModel
{
    use HasFactory;
    public $table='rvw_author_affiliation';
    public static $column_prefix='auaff_';
    protected $primaryKey ='auaff_id';
	public static $tbk_table= 'tbk_author_affiliation';
    
    // public static function get_author_user_details( $select = '*',$condition = array(),  $order_by = NULL)
    // { 
    //     DB::enableQueryLog();
    //     $classname = get_called_class();
    //     $authors_affiliation_table = (new $classname)->getTable();
    //     $country_table=(new \App\Models\Country())->getTable();
    //     $author_table=(new \App\Models\Authors())->getTable();
    //     $usertable= (new \App\Models\User())->getTable();
    //     $result=DB::table($author_table);
    //     $result->select($select);
	// 	$result->join($usertable,'auth_usr_id','=','usr_id');
    //     $result->leftJoin($authors_affiliation_table, $author_table . '.auth_id', '=',$authors_affiliation_table . '.auaff_auth_id');
    //     $result->leftJoin($country_table,$country_table . '.cnt_id', '=', $authors_affiliation_table . '.auaff_cnt_id');
    //     if($condition != '')
    //     $result->whereRaw($condition);
    //     if($order_by != '')
    //     $result->orderBy($order_by,'DESC');
    //     // $queries = DB::getQueryLog();
    //     // dd($queries);
    // return $result->get();
    // }
    public static function user_affiliation($id, $author_single_affiliation = FALSE)
	{
        DB::enableQueryLog();
        $classname = get_called_class();
        $authors_affiliation_table = (new $classname)->getTable();
        $country_table=(new \App\Models\Country())->getTable();
        $result=DB::table($authors_affiliation_table);
        $result->selectRaw('*');
        $result->leftJoin($country_table,$authors_affiliation_table . '.auaff_cnt_id', '=', $country_table . '.cnt_id');
        // $result->leftJoin($authors_affiliation_table, $country_table . '.cnt_id','=', $authors_affiliation_table . '.auaff_cnt_id');
	
		if ($author_single_affiliation == TRUE)
       {         $result->whereRaw('auaff_id ='.$id);
        }
		else
		 {
            $result->whereRaw('auaff_auth_id ='.$id);
        }
            return $result->get();
	}

    public static function get_primary_aff_id($article_id,$join_author_map = FALSE)
	{
        $classname = get_called_class();
        $authors_affiliation_table = (new $classname)->getTable();
        $authors_table=(new \App\Models\Authors())->getTable();
        $article_table=(new \App\Models\Articles())->getTable();
        $result=DB::table($authors_affiliation_table);
        $authorcountry_table=(new \App\Models\Author_country_map())->getTable();
		$result->selectRaw('auaff_id');
		$result->join($authors_table, 'auaff_auth_id','=', 'auth_id');
		$result->join($article_table, 'auth_art_id' ,'=', 'art_id');
		
		if($join_author_map == TRUE)
		{
			$result->join($authorcountry_table,'acm_auaff_id','=','auaff_id');			
		}
		else
		{
			$authors_affiliation_table->whereRaw("auaff_prime_affiliation='y' and auth_corr_author = 'y'");
		}
        $result->where('auth_art_id', $article_id);
		$query = $result->get()->first();
		return $query;
	}


    public static function copy_authors_affiliation($old_article_id, $new_article_id)
	{
		$classname = get_called_class();
        $table = (new $classname)->getTable();
		$today = date('Y-m-d H:i:s', time());
        $authors_table=(new \App\Models\Authors())->getTable();
		$sql = "INSERT INTO " . $table . " (auaff_auth_id,auaff_email,auaff_department,auaff_company,auaff_ringgold_family,auaff_ringgold_id,auaff_address_line1,auaff_address_line2,auaff_cnt_id,auaff_postal_code,auaff_website,auaff_phone,auaff_editable,auaff_posted_by,auaff_posted_date,auaff_proxy_id,auaff_operation,auaff_prime_affiliation) SELECT (select auth_id from " . $authors_table. " where auaff_auth_id = auth_temp_id),auaff_email,auaff_department,auaff_company,auaff_ringgold_family,auaff_ringgold_id,auaff_address_line1,auaff_address_line2,auaff_cnt_id,auaff_postal_code,auaff_website,auaff_phone,auaff_editable,auaff_posted_by,'" . $today . "',auaff_proxy_id,auaff_operation,auaff_prime_affiliation FROM " . $table . "," . $authors_table . " WHERE auth_art_id=" . $old_article_id . " AND auth_id=auaff_auth_id";
		$result = DB::select($sql);
		if ($result)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
}
