<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

use Mavinoo\Batch\BatchFacade as Batch;

class BaseModelCommon extends Model

    {
   /*
    $select- selecting field values
    $criteria - where condition
    $orderby - order by column type in ascending or descending 
    $limit - fetching number of values based on given limit
    $journal_code- corresponding journal code
    $start - 
    $distinct - return only distinct values
    $groupby - arrange identical data into groups
    $sort_order - sort the data in ascending or descending order
    $data -submitted values
*/
    public function get_records_by_raw_query($sql, $count = FALSE,$binding_arr = array())
    {
        // DB::enableQueryLog();
        if(count($binding_arr) > 0)
        {
            $result = DB::connection($this->connection)->select($sql,$binding_arr);
        }
        else
        {
            $result = DB::connection($this->connection)->select($sql);
        }
        
        if($count==TRUE&&isset($result[0]))
        {
            return $result[0];
        }
        else
            return $result;
    }
    /*
    fetch all records based on condition
       
    */
    public function get_all_records($select = '*', $criteria = array(), $orderby = NULL, $limit = NULL, $journal_code = '', $start = NULL, $distinct = NULL,$orderbytype='ASC',$binding_arr = array())
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        if(!empty($journal_code)){
            $table .= $journal_code;
        }
        //DB::enableQueryLog();
        $result = DB::connection($this->connection)->table($table);
        $result->selectRaw($select);
        if (!empty($criteria))
            $result->whereRaw($criteria);
        if (count($binding_arr)>0)
            $result->setBindings($binding_arr);    
        if ($distinct != NULL)
            $result->distinct();
         if($orderby!= NULL)
         $result->orderBy($orderby,$orderbytype);   
         if ($limit != NULL)
            $result->limit($limit);
        $queries = DB::getQueryLog();
        //dd($queries);
        return $result->get();
    }
    /*
    fetch single record  based on condition
    */
    public function get_single_record($select = '*', $criteria = array(), $groupby = NULL,$journal_code = '', $orderby = NULL,$binding_arr = array())
    {
     
        $classname = get_called_class();
        $table = (new $classname)->getTable();

      //  DB::enableQueryLog();
        $result = DB::connection($this->connection)->table($table.$journal_code);
        $result->selectRaw($select);
        if (!empty($criteria))
            $result->whereRaw($criteria);
        if($orderby!= NULL)
            $result->orderByRaw($orderby);   
        if ($groupby != NULL)
            $result->groupBy($groupby);
        if (count($binding_arr)>0)
            $result->setBindings($binding_arr);


        return $result->first();
        //$queries = DB::getQueryLog();
    }
    /*
    get paginated records
    */
    public function get_paginated_records($select = '*', $criteria = NULL, $orderby = NULL, $sort_order = NULL, $limit = NULL)
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        DB::enableQueryLog();
        if ($criteria != NULL) {
            $result = DB::connection($this->connection)->table($table)
                ->selectRaw($select)
                ->whereRaw($criteria)
                ->orderBy($orderby, $sort_order)
                ->paginate($limit);
        } else {

            $result = DB::connection($this->connection)->table($table)
                ->selectRaw($select)
                ->orderBy($orderby, $sort_order)
                ->paginate($limit);
        }
        $queries = DB::getQueryLog();
        // dd($queries);
        return  $result;
    }
    /* 
    get records by joining the tables
    */
    public function get_results_using_joins($tables, $select = '*', $criteria = array(), $records = 'all', $orderby = NULL, $limit = NULL, $journal_code = '', $start = NULL, $distinct = NULL, $custom = FALSE, $group_by = NULL, $paginate = FALSE,$binding_arr = array(),$where_in='')
    {

        DB::enableQueryLog();
        $result = DB::connection($this->connection)->table($tables['main_table']);
        $result->selectRaw($select);
        if (!empty($tables['join_table'])) {

            foreach ($tables['join_table'] as $tbname => $joinfields) {
                if (!empty($joinfields) && count($joinfields) >= '2') {
                    if (isset($joinfields[2]) && $joinfields[2] == 'left') {
                        $result->leftjoin($tbname, $joinfields[0], "=", $joinfields[1]);
                    } else if (isset($joinfields[2]) && $joinfields[2] == 'right') {
                        $result->rightjoin($tbname, $joinfields[0], "=", $joinfields[1]);
                    } else {
                        $result->join($tbname, $joinfields[0], "=", $joinfields[1]);
                    }
                }
            }
        }
        if(is_array($criteria) == TRUE)
        {
            $result->where($criteria);
        }
        else
        {
            $result->whereRaw($criteria);
            if(count($binding_arr) > 0)
            {
                $result->setBindings($binding_arr);
            }
        }
        if(!empty($where_in))
        {
        $result->whereRaw($where_in);
        }
        if ($limit != NULL) {
            $result->skip(0)->take($limit);
        }
        if ($orderby != NULL)
            $result->orderByRaw($orderby);
        $result->get();
        $queries = DB::getQueryLog();
        // dd($queries);
        if ($group_by != NULL)
            $result->groupBy($group_by);
        if ($records == 'single')
            return $result->first();
        else
            return $result->get();
        $queries = DB::getQueryLog();
        //dd($queries);

    }
    /*
    insert values to the table
    */
    public function insert_record($data, $user_data = NULL, $journal_code = '')
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        DB::enableQueryLog();
        $colmn_prefix = (new $classname)::$column_prefix;
        $data[$colmn_prefix . 'posted_date'] = date('Y-m-d H:i:s');
        if ($user_data != NULL) {
            $data[$colmn_prefix . 'posted_by'] = $user_data['user_id'];
            $data[$colmn_prefix . 'proxy_id'] = $user_data['proxy_user_id'];
        }
        if($colmn_prefix !='btchgen_')
        {
            $data[$colmn_prefix . 'operation'] = 'i';
        }
        $id = DB::connection($this->connection)->table($table.$journal_code)->insertGetId($data);
        $queries = DB::getQueryLog();
        return  $id;
    }
    /*
        update record based on condition
        
	 * change_operation is set when:
	 * editing publication article type,
	 * editing submitted author for permitted user and
	 * changing due date. 
	 * $change_operation helps to view timeline by avoiding unnecessory reocords. 
	 * Possible values:
	 * 'p' => for publication edit 
	 * 's' => for editing submitted author 
	 * 'e' => for editing due date
	 */
    public  function update_record($data, $criteria, $user_data = NULL, $journal_code = '', $change_operation = NULL,$binding_arr = array())
    {
        $classname = get_called_class();
        $colmn_prefix = (new $classname)::$column_prefix;

        $table = (new $classname)->getTable();

        DB::enableQueryLog();
        $result = DB::connection($this->connection)->table($table.$journal_code);
        if(is_array($criteria))
        {
            $result->where($criteria);
        }
        else
        {
            $result->whereRaw($criteria);
        }
        if (count($binding_arr)>0)
            $result->setBindings($binding_arr);
        
        if ($user_data != NULL) {
            $data[$colmn_prefix . 'posted_by'] = $user_data['user_id'];
            $data[$colmn_prefix . 'proxy_id'] = $user_data['proxy_user_id'];
        }
        if ($change_operation != NULL) {
            $data[$colmn_prefix . 'operation'] = $change_operation;
        } else{
            $data[$colmn_prefix . 'operation'] = 'u';
        }
        
        $data[$colmn_prefix . 'posted_date'] = date('Y-m-d H:i:s');
        $affected = $result->update($data);
        $queries = DB::getQueryLog();
       //dd($queries);
         return $affected;
    }
    /*
         delete record based on condition
    */
    public function delete_records($criteria, $journal_code = '', $user_data = NULL,$binding_arr = array())
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        DB::enableQueryLog();
    
        $colmn_prefix = (new $classname)::$column_prefix;
        $data[$colmn_prefix . 'operation'] = "u";
        $data[$colmn_prefix . 'posted_date'] = date('Y-m-d H:i:s');
        if ($user_data != NULL) {
            $data[$colmn_prefix . 'posted_by'] = $user_data['user_id'];
            $data[$colmn_prefix . 'proxy_id'] = $user_data['proxy_user_id'];
        }
        $data[$colmn_prefix . 'operation'] = "d";
        $result = DB::connection($this->connection)->table($table.$journal_code);
        if(is_array($criteria))
        {
            $result->where($criteria);
        }
        else
        {
            $result->whereRaw($criteria);
        }
        if (count($binding_arr)>0)
            $result->setBindings($binding_arr);
        
        $result->update($data);
     
        $delete_result = DB::connection($this->connection)->table($table.$journal_code);
        if(is_array($criteria))
        {
            $delete_result->where($criteria);
        }
        else
        {
            $delete_result->whereRaw($criteria);
        }
        if (count($binding_arr)>0)
            $delete_result->setBindings($binding_arr);
        
        $delete_record=$delete_result->delete();
        $queries = DB::getQueryLog();
    
        return $delete_record;
    }
    /*
    group of insert at a time
    */
    public function insert_batch($data, $user_data = NULL)
    {
        DB::enableQueryLog();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $colmn_prefix = (new $classname)::$column_prefix;
        $id = DB::connection($this->connection)->table($table)->insertOrIgnore($data);
        $queries = DB::getQueryLog();
         //dd($queries);
        return $id;
    }

    public function get_field_names()
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
		$columns = DB::connection($this->connection)->getSchemaBuilder()->getColumnListing($table);
		return $columns;
	}
    // public function get_records_where_in($select = '*', $field_name, $collection = array(), $where = '', $orderby = NULL, $limit = NULL, $journal_code = '', $start = NULL)
    // {
    //     DB::enableQueryLog();
    //     $classname = get_called_class();
    //     $table = (new $classname)->getTable();
    //     $result = DB::table($table);
    //     $result->selectRaw($select);
    //     if ($where != NULL)
    //         $result->whereRaw($where);
    //     if (!empty($collection))
    //         $result->whereIn($field_name, $collection);
    //     if ($orderby != NULL)
    //         $result->orderByRaw($orderby);
    //     $result->get();
    //     return $result;
    //     $queries = DB::getQueryLog();
    //     //dd($queries);
    // }

    /*
    * @param $data Array
    * @param $updated_column string
    * @return array
    */
    public function update_batch($data, $updated_column)
    {
      
        $classname = get_called_class();
        DB::enableQueryLog();
        $result =Batch::connection($this->connection)->update(new $classname, $data, $updated_column);
        return $result; 
          $queries = DB::getQueryLog();
         // dd($queries);
    }
    public function copy_table($master_table, $journal_code, $backup_tabale = '')
    {


        $table_name = '';
        if (empty($backup_tabale))
            $table_name = $master_table . '_' .strtolower($journal_code);
        else
            $table_name = $backup_tabale . '_' .strtolower($journal_code);

        DB::connection($this->connection)->select('CREATE TABLE ' . $table_name . ' SELECT * from ' . $master_table . ' LIMIT 0');
        return $table_name;
    }
     /*
    get result using join query with pagination
    */
    
    public function get_results_join_pagination($tables, $select = '*', $criteria = array(), $records = 'all', $orderby = NULL, $sort_order = NULL, $limit = NULL, $journal_code = '', $start = NULL, $distinct = NULL, $custom = FALSE, $group_by = NULL, $paginate = FALSE)
    {
        DB::enableQueryLog();
        if (!empty($tables['join_table']) && !empty($tables['column_prefix1']) && ($tables['column_prefix2'])  && !empty($limit)) {
            if ($criteria != NULL) {
                if(isset($tables['column_where_condition']))
                {
                    $column_prefix1 = $tables['column_prefix1'];
                    $column_prefix2 = $tables['column_prefix2'];
                    $column_where_condition = $tables['column_where_condition'];
                    $column_where_value = $tables['column_where_value'];
                    $result = DB::connection($this->connection)->table($tables['main_table'])
                    ->selectRaw($select)
                    ->leftJoin($tables['join_table'], function ($join) use ($column_prefix1,$column_prefix2,$column_where_condition,$column_where_value) {
                        $join->on($column_prefix1, '=', $column_prefix2)
                             ->where($column_where_condition, '=',  $column_where_value );
                    })
                    ->whereRaw($criteria)
                    ->orderBy($orderby, $sort_order);
                    if($group_by !=NULL)
                        $result->groupByRaw($group_by);
                    $result =$result->paginate($limit);
                }
                else{
                $result = DB::connection($this->connection)->table($tables['main_table'])
                    ->selectRaw($select)
                    ->leftJoin($tables['join_table'], $tables['column_prefix1'], '=', $tables['column_prefix2'])
                    ->whereRaw($criteria)
                    ->orderBy($orderby, $sort_order);
                    if ($group_by != NULL) 
                        $result->groupByRaw($group_by);
                    $result = $result->paginate($limit);
                }
            }
         else {
                $result = DB::connection($this->connection)->table($tables['main_table'])
                    ->selectRaw($select)
                    ->leftJoin($tables['join_table'], $tables['column_prefix1'], '=', $tables['column_prefix2'])
                    ->orderBy($orderby, $sort_order);
                    if($group_by !=NULL)
                        $result->groupByRaw($group_by);
                    $result = $result->paginate($limit);
            }
           
            $queries = DB::getQueryLog();
            // dd($queries);
            return $result;
        } 
    }


public function get_all_tables_in_db($criteria = array()) {
    $sql = 'SELECT table_name FROM information_schema.tables where table_schema= "'.DB::getDatabaseName().'"';
    if(!empty($criteria)){
        $sql.= $criteria;
    }
    $result = DB::connection($this->connection)->select($sql);
    return $result;
}

public function execute_query($sql,$affect_rows = FALSE,$binding_arr= array()) {
    if(count($binding_arr) > 0)
        {
            $result = DB::connection($this->connection)->select($sql,$binding_arr);
        }
        else
        {
            $result = DB::connection($this->connection)->select($sql);
        }
    return $result;	
}

/*
    fetch single record  based on condition with bind parameters
    */
    public function get_single_record_with_bind_cond($select = '*', $criteria = array(),$sting_cond = '',$bind_data= array() ,$groupby = NULL,$journal_code = '', $orderby = NULL)
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();

        $result = DB::connection($this->connection)->table($table.$journal_code);
        $result->selectRaw($select);
        if (!empty($criteria))
        {
            $result->where($criteria);
        }
        elseif(!empty($sting_cond))
        {
            $result->whereRaw($sting_cond);  
            $result->setBindings($bind_data);  
        }
        
        if($orderby!= NULL)
            $result->orderByRaw($orderby);   
        if ($groupby != NULL)
            $result->groupBy($groupby);

        return $result->first();
    }

    /*
    fetch all records based on condition with bind parameters
       
    */
    public function get_all_records_with_bind_cond($select = '*', $criteria = array(),$sting_cond = '',$bind_data= array(), $orderby = NULL, $limit = NULL, $distinct = NULL,$orderbytype='ASC')
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        
        $result = DB::connection($this->connection)->table($table);
        $result->selectRaw($select);
        if (!empty($criteria))
        {
            $result->where($criteria);
        }
        elseif(!empty($sting_cond))
        {
            $result->whereRaw($sting_cond);  
            $result->setBindings($bind_data);  
        }
        
        if ($distinct != NULL)
            $result->distinct();
         if($orderby!= NULL)
         $result->orderBy($orderby,$orderbytype);   
         if ($limit != NULL)
            $result->limit($limit);
        
        return $result->get();
    }

    public function get_results_join_pagination_with_bind_cond($tables, $select = '*', $criteria = array(), $records = 'all', $orderby = NULL, $sort_order = NULL, $limit = NULL,$bind_data= array())
    {
        DB::enableQueryLog();
        if (!empty($tables['join_table']) && !empty($tables['column_prefix1']) && ($tables['column_prefix2'])  && !empty($limit)) {
            if ($criteria != NULL) {
                if(count($bind_data)>0) {
                    $result = DB::connection($this->connection)->table($tables['main_table'])
                    ->selectRaw($select)
                    ->leftJoin($tables['join_table'], $tables['column_prefix1'], '=', $tables['column_prefix2'])
                    ->whereRaw($criteria)
                    ->setBindings($bind_data)
                    ->orderBy($orderby, $sort_order)
                    ->paginate($limit);
                } else {
                    $result = DB::connection($this->connection)->table($tables['main_table'])
                    ->selectRaw($select)
                    ->leftJoin($tables['join_table'], $tables['column_prefix1'], '=', $tables['column_prefix2'])
                    ->whereRaw($criteria)
                    ->orderBy($orderby, $sort_order)
                    ->paginate($limit);
                }
                
            }
         else {
                $result = DB::connection($this->connection)->table($tables['main_table'])
                    ->selectRaw($select)
                    ->leftJoin($tables['join_table'], $tables['column_prefix1'], '=', $tables['column_prefix2'])
                    ->orderBy($orderby, $sort_order)
                    ->paginate($limit);
            }
           
            $queries = DB::getQueryLog();
            //dd($queries);
            return $result;
        } 
    }

    
}
