<?php

namespace App\Models;

use DB;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Classifications extends BaseModel
{
    use HasFactory;
    public  $table = 'rvw_classifications';
    protected $primaryKey = 'cls_id';
    public static $column_prefix = 'cls_';
	protected $guarded = [];



	public static function term_usage($new_term_id, $id, $article_type = FALSE)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
		if ($article_type == TRUE)
			$article_term = " and (`cls_artp_id` IS NULL  or cls_artp_id <> " . $id . ")";
		else
			$article_term = "  and ((`cls_jnl_id` <> " . $id . ") or (`cls_jnl_id` = " . $id . " and `cls_artp_id` IS NOT NULL))";

		$sql = "SELECT count(*) as cnt FROM " . $table . " WHERE `cls_term_id` = " . $new_term_id . $article_term;

        $result = DB::select($sql);
        // $queries = DB::getQueryLog();
        //dd($queries);        
        return $result;
	}
    public static function copy_journal_classification($newjournal_id, $oldjournal_id, $current_user)
	{
        $classification_table = (new \App\Models\Classifications())->getTable();
		$sql = "insert into " . $classification_table . "(cls_jnl_id,cls_term_id,cls_primary_id,cls_artp_id,cls_posted_by,cls_posted_date,cls_old_cls_id,cls_proxy_id) select " . $newjournal_id . ", cls_term_id,cls_primary_id,cls_artp_id," . $current_user . ",'" . date('Y-m-d H:i:s') . "',cls_id,cls_proxy_id  from " . $classification_table . " where cls_jnl_id = " . $oldjournal_id;
		$result = DB::select($sql);       
		if ($result)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	public static function copy_secondary($new_primary_id, $old_primary_id, $article_type_id, $current_user)
	{
		$classification_table = (new \App\Models\Classifications())->getTable();
		$sql = "insert into " . $classification_table . "(cls_jnl_id,cls_term_id,cls_primary_id,cls_artp_id,cls_posted_by,cls_posted_date,cls_old_cls_id) select cls_jnl_id, cls_term_id," . $new_primary_id . "," . $article_type_id . "," . $current_user . ",'" . date('Y-m-d H:i:s') . "',cls_id from " . $classification_table . " where cls_primary_id = " . $old_primary_id . " and cls_primary_id IS NOT NULL";
		$result = DB::select($sql);       
		if ($result)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
}
