<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConveyData extends BaseModelCommon
{
    use HasFactory;

    protected $table = 'rvw_convey_data';
    protected $primaryKey = 'rcd_id';
    public $timestamps = false;


    protected $fillable = [
        'rcd_usr_id',
        'rcd_art_id',
        'rcd_discloser_list_id',
        'rcd_discloser_id',
        'rcd_disclosure_id',
        'rcd_last_invited_date',
        'rcd_disclosure_cmpltn_status',
        'rcd_posted_by',
        'rcd_posted_date',
        'rcd_proxy_id',
        'rcd_operation',
    ];


    /**
     * Relationship to the rvw_users.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'rcd_usr_id', 'usr_id');
    }

    protected static function booted()
    {
        static::creating(function ($item) {
            $item->rcd_disclosure_cmpltn_status = 'i';
            $item->rcd_last_invited_date = Carbon::now();
            $item->rcd_operation = 'i';
            $item->rcd_posted_date = Carbon::now();
            $item->rcd_posted_by = session('user_id') ?? 0;
            $item->rcd_proxy_id = session('proxy_id') ?? 0;
        });

        static::updating(function ($item) {
            $item->rcd_operation = 'u';
            $item->rcd_posted_date = Carbon::now();
            $item->rcd_posted_by =session('user_id') ?? 0;
            $item->rcd_proxy_id = session('proxy_id') ?? 0;
        });
    }


}
