<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Copyright extends BaseModel
{
    public  $table='rvw_copyright';
    protected $primaryKey = 'crt_id';
    public static $column_prefix='crt_';
    use HasFactory;
    
  
    public static function get_copyright($condition, $select = '*', $single=FALSE, $join_users_tbl=false)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $copyright=DB::table($table);
        if($join_users_tbl == true) {
            $select .=  ', CONCAT(concat(UPPER(SUBSTR(usr_title,1,1)),LOWER(SUBSTR(usr_title,2)))," ", usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as usr_name';
        }
        $copyright->selectRaw($select);
        $copyrightmaster_table=(new \App\Models\Copyright_master())->getTable();
		$copyright->join($copyrightmaster_table, 'crt_crtm_id', '=', 'crtm_id');
        $copyright->join($article_flow_table, 'crt_aflw_id', '=', 'aflw_id');
        if($join_users_tbl == true) {
            $users_table=(new \App\Models\User())->getTable();
            $copyright->join($users_table, 'crt_posted_by', '=', 'usr_id');
        }
		$copyright->whereRaw($condition);
        if($single == TRUE)
        {
            $query = $copyright->first();
        }
        else{
            $query = $copyright->get();
		}
		return $query;
	}

    public static function get_copyright_wtih_article($crt_id) {
		$classname = get_called_class();
        $table = (new $classname)->getTable();
        $article_flow_table=(new \App\Models\Article_flow())->getTable();
        $articles_table=(new \App\Models\Articles())->getTable();
        $copyright=DB::table($table);
        $copyright->selectRaw('*');
        $copyright->join($article_flow_table, 'crt_aflw_id', '=', 'aflw_id');
        $copyright->join($articles_table, 'aflw_art_id', '=', 'art_id');
        $copyright->whereRaw("crt_id={$crt_id}");
        $query = $copyright->get();
		return $query;

		// $query = $db_handler->get();  to do later
		// return $query->row(0);
	}
}
