<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Dashboard_settings extends BaseModel
{
    use HasFactory;
    public $table='rvw_dashboard_settings';
    public static $column_prefix='ds_';
    protected $primaryKey ='ds_id';
    public static function get_setting_details( $select = '*',  $orderby = NULL, $sort_order = NULL, $limit = NULL)
    { 
        DB::enableQueryLog();
        $roles_table = (new \App\Models\Roles())->getTable();
        $dashboard_setting_table = (new \App\Models\Dashboard_settings())->getTable();
        $journal_table = (new \App\Models\Journals())->getTable();
                     $result = DB::table($dashboard_setting_table)
                ->selectRaw($select)
                ->Join($journal_table, $dashboard_setting_table . '.ds_jnl_id', '=',$journal_table . '.jnl_id')
                ->Join($roles_table, $dashboard_setting_table . '.ds_role_id', '=',$roles_table . '.role_id')
                ->orderBy($orderby, $sort_order)
                ->paginate($limit);
                // } 
           
            $queries = DB::getQueryLog();
            // dd($queries);
            return $result;
    }

}
