<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Email_send_log extends BaseModel
{
    use HasFactory;
    public  $table='rvw_email_send_log';
    protected $primaryKey = 'esl_id';
    public static $column_prefix='esl_';

	public static function timeline_details($tbk_id, $article_id = null)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $user_table = (new \App\Models\User())->getTable();
        $art_str = "";
        $art_join_str = "";
        if($article_id){
            $art_join_str = " and esl_article_id = $article_id";
            $art_str = " and esl.esl_article_id = $article_id";
        }
        $select="concat_ws(' ', usr.usr_first_name, usr.usr_last_name) AS `posted_user`,concat_ws(' ', pusr.usr_first_name, pusr.usr_last_name) AS `proxy_user`,concat_ws(' ', pusr.usr_first_name, pusr.usr_last_name) AS `proxy_user`,CONCAT(CASE WHEN esl.esl_user_id >0 THEN SUBSTRING((SELECT GROUP_CONCAT(usr.usr_first_name, ' ', `usr`.`usr_last_name`, '[', esl_to, '] ') FROM rvw_email_send_log join rvw_users usr on esl_user_id=usr.usr_id join rvw_articles art ON (art.art_id = esl_article_id $art_join_str) where esl_batch_id IS NOT NULL and esl_batch_id= esl.esl_batch_id GROUP by esl_batch_id, esl_article_id), 1, length((SELECT GROUP_CONCAT(usr.usr_first_name, ' ', `usr`.`usr_last_name`, '[', esl_to, '] ') FROM rvw_email_send_log join rvw_users usr on esl_user_id=usr.usr_id join rvw_articles art ON (art.art_id = esl_article_id $art_join_str) where esl_batch_id IS NOT NULL and esl_batch_id= esl.esl_batch_id GROUP by esl_batch_id, esl_article_id)))ELSE SUBSTRING(esl.esl_to,1,length(esl.esl_to)) END)  AS `to`,concat_ws(' ', cc_usr.usr_first_name, cc_usr.usr_last_name) AS `cc`,esl.esl_posted_date AS `date`,esl.esl_reply_to AS `reply_to`,esl.esl_article_id AS `article_id`,esl.esl_subject AS `subject`,esl.esl_content AS `message_body`";
        $final_sql = DB::table($table." AS esl");
        $final_sql->selectRaw($select);
        $final_sql->leftjoin($user_table .' AS usr','usr.usr_id','=','esl.esl_posted_by');
        $final_sql->leftjoin($user_table .' AS pusr','pusr.usr_id','=','esl.esl_proxy_id');
        $final_sql->leftjoin($user_table .' AS to_whome_usr','to_whome_usr.usr_id','=','esl.esl_user_id');
        $final_sql->leftjoin($user_table .' AS cc_usr','cc_usr.usr_id','=','esl.esl_cc');
		$final_sql->whereRaw("esl.esl_batch_id={$tbk_id} $art_str");
        $final_sql->groupBy('posted_user','proxy_user','to','cc','subject','message_body','date');
        $final_sql->orderBy('esl_id', 'ASC');
        return $final_sql->get()->first();

	}
    /*Task #9861 Specific email id issue*/
    public static function timeline_view_details($tbk_id, $article_id = null){
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $user_table = (new \App\Models\User())->getTable();
        $art_str = "";
        $art_join_str = "";
        if($article_id){
            $art_join_str = " and esl_article_id = $article_id";
            $art_str = " and esl.esl_article_id = $article_id";
        }
       // DB::enableQueryLog();
       /* Taskbot Task #1504 - Email Log "View Details" Not Showing All Recipient Information for review-288 */
        DB::statement("SET SESSION group_concat_max_len = 1000000");
        return  DB::table(function($query)  use ($tbk_id,$art_join_str,$art_str) {
            $query->selectRaw("
                GROUP_CONCAT(DISTINCT `to`) as `to`,
                posted_user,
                proxy_user,
                cc,
                `date`,
                reply_to,
                article_id,
                subject,
                message_body
            ")
            ->from(function($subQuery)  use ($tbk_id,$art_join_str,$art_str) {
                $subQuery->selectRaw("
                    CONCAT_WS(' ', usr.usr_first_name, usr.usr_last_name) AS `posted_user`,
                    CONCAT_WS(' ', pusr.usr_first_name, pusr.usr_last_name) AS `proxy_user`,
                    CONCAT(
                        CASE 
                            WHEN esl.esl_user_id > 0 THEN SUBSTRING(
                                (
                                SELECT
                                    GROUP_CONCAT( DISTINCT
                                        usr.usr_first_name, ' ', usr.usr_last_name, '[', esl_to, '] '
                                    )
                                FROM
                                    rvw_email_send_log
                                JOIN rvw_users usr ON esl_user_id = usr.usr_id
                                JOIN rvw_articles art ON ( art.art_id = esl_article_id {$art_join_str})
                                WHERE
                                    esl_batch_id IS NOT NULL AND esl_batch_id = esl.esl_batch_id
                                GROUP BY
                                    esl_batch_id, esl_article_id
                                ),
                                1,
                                LENGTH(
                                    (
                                    SELECT
                                        GROUP_CONCAT( DISTINCT
                                            usr.usr_first_name, ' ', usr.usr_last_name, '[', esl_to, '] '
                                        )
                                    FROM
                                        rvw_email_send_log
                                    JOIN rvw_users usr ON esl_user_id = usr.usr_id
                                    JOIN rvw_articles art  ON ( art.art_id = esl_article_id {$art_join_str})
                                    WHERE
                                        esl_batch_id IS NOT NULL AND esl_batch_id = esl.esl_batch_id
                                    GROUP BY
                                        esl_batch_id, esl_article_id
                                    )
                                )
                            )
                            ELSE SUBSTRING(esl.esl_to, 1, LENGTH(esl.esl_to))
                        END
                    ) AS `to`,
                    CONCAT_WS(' ', cc_usr.usr_first_name, cc_usr.usr_last_name) AS `cc`,
                    esl.esl_posted_date AS `date`,
                    esl.esl_reply_to AS `reply_to`,
                    esl.esl_article_id AS `article_id`,
                    esl.esl_subject AS `subject`,
                    esl.esl_content AS `message_body`
                ")
                ->from('rvw_email_send_log AS esl')
                ->leftJoin('rvw_users AS usr', 'usr.usr_id', '=', 'esl.esl_posted_by')
                ->leftJoin('rvw_users AS pusr', 'pusr.usr_id', '=', 'esl.esl_proxy_id')
                ->leftJoin('rvw_users AS to_whome_usr', 'to_whome_usr.usr_id', '=', 'esl.esl_user_id')
                ->leftJoin('rvw_users AS cc_usr', 'cc_usr.usr_id', '=', 'esl.esl_cc')
                ->whereRaw("esl.esl_batch_id={$tbk_id} {$art_str}")
                ->groupBy('posted_user', 'proxy_user', 'to', 'cc', 'subject', 'message_body', 'date')
                ->orderBy('esl.esl_id', 'ASC');
            }, 'SENDLOG');
        })->get()->first();
    }
    /*Task #9861 End*/
    public static function insert_receive_record($data, $journal_code = '')
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        DB::enableQueryLog();
        $colmn_prefix = (new $classname)::$column_prefix;
        $id = DB::table($table.$journal_code)->insertGetId($data);
        $queries = DB::getQueryLog();
        return  $id;
    }
    public static function update_receive_record($data, $criteria)
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $result->whereRaw($criteria);
        $result->update($data);
        return $result->get();
    }


}
