<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Event_invited_users extends BaseModel  {
  
    public  $table='rvw_event_invited_users';
    protected $primaryKey = 'evu_id';
    public static $column_prefix='evu_';
    use HasFactory;
    
    public static function get_event_invited_users($select = '*', $criteria = array(),$having = NULL,$sort_field = NULL, $sort_order = NULL, $limit = NULL,$binding_arr = array())
    {
   
     $article_table = (new \App\Models\Articles())->getTable();
     $articletypes_table = (new \App\Models\Article_types())->getTable();
     $journal_table = (new \App\Models\Journals())->getTable();
     $genericflows_table = (new \App\Models\Generic_flows())->getTable();
     $users_table = (new \App\Models\User())->getTable();
     $author_table = (new \App\Models\Authors())->getTable();
     $data=array();
     $classname = get_called_class();
     $table = (new $classname)->getTable();
     $main_sql = DB::table($table. ' as re')
     ->selectRaw(DB::raw($select))
     ->leftjoin($article_table.' as ra','ra.art_id', '=', 're.evu_art_id')
     ->leftjoin($articletypes_table,'art_artp_id', '=', 'evu_artp_id')
     ->leftjoin($journal_table,'artp_jnl_id', '=', 'jnl_id')
     ->leftjoin($users_table. ' as ru','usr_id', '=', 'evu_user_id')
     ->whereRaw($criteria);
    if(count($binding_arr) > 0) {
        $main_sql->setBindings($binding_arr);
    }
     if ($having != NULL)
     $main_sql->havingRaw($having);
 
     if ($sort_field != NULL && $sort_order != NULL)
        $main_sql->orderBy($sort_field, $sort_order);
 
    $data['invited_result']=$main_sql->paginate($limit);
    return  $data;
 
 
    }

}
