<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Generic_discussion extends BaseModel
{
    use HasFactory;
    public $table = 'rvw_generic_discussion';
    public static $column_prefix = 'gdis_';
    protected $primaryKey = 'gdis_id';
    public static function get_generic_discussions($gdis_id,$date_format)
	{ 
        DB::enableQueryLog();
		$Users = (new \App\Models\User())->getTable();
		$Generic_discussion_comments = (new \App\Models\Generic_discussion_comments())->getTable();
        $classname = get_called_class();
		$table = (new $classname)->getTable();
        $select='';
		//$date_format = $date_format;
		$select.='gen_dis.gdis_title,dsc_cmnt.gdsc_gdis_id,dsc_cmnt.gdsc_comment,gen_dis.gdis_participants_by_role_id, gen_dis.gdis_participants_by_usr_id,gen_dis.gdis_proxy_id,gen_dis.gdis_posted_by,dsc_cmnt.gdsc_posted_by,DATE_FORMAT(dsc_cmnt.gdsc_posted_date, "' .$date_format. ' %h:%i") as gdsc_posted_date,  CONCAT(usr.usr_first_name, IF(usr.usr_middle_name IS NULL or usr.usr_middle_name="", " ", CONCAT(" ",usr.usr_middle_name," ")), usr.usr_last_name) as full_name,usr.usr_id,usr.usr_image,';
		$select.='CONCAT(pxr.usr_first_name, IF(pxr.usr_middle_name IS NULL or pxr.usr_middle_name="", " ", CONCAT(" ",pxr.usr_middle_name," ")), pxr.usr_last_name) AS proxy_user ,';
		$select.='DATE_FORMAT(gen_dis.gdis_posted_date, "' . $date_format . ' %h:%i") as gdis_posted_date';
        $final_sql = DB::table($table.' AS gen_dis')
                        ->selectRaw($select)
                        ->leftjoin($Users.' AS usr','usr.usr_id','=','gen_dis.gdis_posted_by')
                        ->leftjoin($Users.' AS pxr','pxr.usr_id','=','gen_dis.gdis_proxy_id')
                        ->join($Generic_discussion_comments.' AS dsc_cmnt','gen_dis.gdis_id','=','dsc_cmnt.gdsc_gdis_id')
                        ;
        $final_sql->where('gen_dis.gdis_id', $gdis_id);  
        $final_sql->orderBy('gen_dis.gdis_id', 'asc');             

		return $final_sql->get();
		
	}

}