<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Generic_flows extends BaseModel
{
    use HasFactory;
    public $table='rvw_journal_workflows';
    protected $primaryKey = 'jwf_id';
    public static $column_prefix='jwf_';

    public static function get_article_type_stages($select = '*', $art_type= [] ,$group_by =array()) {
        DB::enableQueryLog();
        $article_type_table=(new \App\Models\Article_types())->getTable();
        $table_name=(new \App\Models\Generic_flows())->getTable();
        $result = DB::table($table_name)
        ->selectRaw($select)
        ->join($article_type_table, "jwf_fwm_id","=","artp_fwm_id");
        if($art_type != NULL)		
        {
            $result->whereIn('artp_id',$art_type);
        }  
        // else
        // {
        //     $result->where('artp_id',$art_type);
        // }   
        if(!empty($group_by))
            $result->groupBy($group_by);        
    
        return $result->get();
       
    }
    
    public static function get_stage_decisions($stage_id, $child_stages, $check_disable_stage = '') {
		$classname=get_called_class();
        $table=(new $classname)->getTable();
        $result = DB::table($table);
        $article_type_table=(new \App\Models\Article_types())->getTable();
        $result->selectRaw("jwf_id,jwf_stage_name,jwf_stage_type,jwf_parent_stages,jwf_child_stages, jwf_fwm_id,jwf_disable_status,jwf_flow_proceed_type,jwf_assignment");
		$result->join($article_type_table, "jwf_fwm_id", "=", "artp_fwm_id");
        $result->whereRaw("jwf_fwm_id = (SELECT jwf_fwm_id FROM " .$table. " WHERE jwf_id = '$stage_id')");
		$result->whereRaw('(jwf_id IN ("' . implode('","', $child_stages) . '"))');
		if ($check_disable_stage != '') {
			$result->whereRaw("jwf_disable_status = 'n' ");
		}
		$query = $result->get();
		return $query;
	}

    public static function get_completed_flow_journals($select = '*',$status = NULL, $jnl_id = NULL,$type = NULL, $id = NULL, $artp_id = array()) {
		$classname=get_called_class();
        $table=(new $classname)->getTable();
        $result = DB::table($table);
        $result->selectRaw($select);
        
        $temp_flag = ', jnl_id,jnl_journal_name';
		if ($type == 'a') {
            $article_type_table=(new \App\Models\Article_types())->getTable();
			$result->join($article_type_table, "artp_fwm_id", "=", "jwf_fwm_id");
			if ($id != '')
				$result->where('artp_jnl_id', $id);
			$result->where_NOT_IN('artp_id', $artp_id);
			$temp_flag = ',artp_id';
		}
		else {
            $journals_table=(new \App\Models\Journals())->getTable();
            $result->join($journals_table, "jnl_fwm_id", "=", "jwf_fwm_id");
			if ($status != NULL) {
				$result->where('jnl_journal_status', $status);
			}
			if ($jnl_id != '') {
				$result->where('jnl_id', $jnl_id);
			}else{	//fix bug of listing standalone journals while transfer article of normal journal
				$result->where('jnl_standalone', 'n');
			}
		}

		$result->where('jwf_stage_type', 'production');
		$result->groupBy('jwf_fwm_id, jwf_id' . $temp_flag);
		$query = $result->get();
        return $query;
	}

    public static function get_article_next_stage($art_flow_id) {
		$classname=get_called_class();
        $table=(new $classname)->getTable();
        $articleflow_table=(new \App\Models\Article_flow())->getTable();
        $result = DB::table($table);
		$result->selectRaw("jwf_id,jwf_child_stages");
		$result->join($articleflow_table, 'jwf_id', '=' ,'aflw_jwf_id');
		$result->where('aflw_id',$art_flow_id);
		$query = $result->first();
		return $query;

    }
    //for getting journal workflow details with roles
	public static function get_journal_workflow_details($select = '*', $condition=array()) {
		
        $classname=get_called_class();
        $table=(new $classname)->getTable();
        $roles_table=(new \App\Models\Roles())->getTable();
        $result = DB::table($table);
		$result->selectRaw($select);
		$result->leftjoin($roles_table, 'jwf_role_id', '=', 'role_id');
		$result->whereRaw($condition);
		$query = $result->get();
        return $query;

	}
    public static function copy_journal_workflow($insert_fields, $select_fields, $old_flw_id) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $column_prefix = (new $classname)::$column_prefix;
		$sql = 'INSERT INTO ' . $table . ' (' . $insert_fields . ')' .
				' SELECT ' . $select_fields . ' FROM ' . $table . ' WHERE ' . $column_prefix . 'fwm_id=' . $old_flw_id." and jwf_hide_status='n'";
        $result = DB::select($sql);
        if ($result)
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
	}

    /*
    * @param $select string
    * @param $where string
    * @param $where_in string
    * @param $order_by string
    * @return array
    */
    public static function get_artcle_flow($select = '*', $where = NULL, $where_in = NULL, $order_by = NULL,$single=FALSE) {
        $classname          =   get_called_class();
        $table              =   (new $classname)->getTable();
        $articleflow_table  =   (new \App\Models\Article_flow())->getTable();
        $result             =   DB::table($table.' AS c_stg');
		$result->selectRaw($select);
		$result->join($articleflow_table .' as c_flw', 'c_stg.jwf_id', '=' ,'c_flw.aflw_jwf_id');
		//$query = $result->first();
		if ($where) {
			$result->whereRaw($where);
		
		}
		if ($where_in != NULL) {
			foreach ($where_in as $field_name => $field_val) {
				$result->whereIn($field_name, $field_val);
			}
		}
		if ($order_by) {
			// $result->orderBy($order_by);
            $result->orderByRaw($order_by); //if there is multiple columns to sort use orderByRaw
		}
        if($single==true)
        {
            $query = $result->first();
        }
        else
        {
            $query = $result->get();
        }
        return $query;
	}

    public static function get_child_details($get_fields,$child_stages_for_check)
    {
        $classname=get_called_class();
        $table=(new $classname)->getTable();
        $result = DB::table($table);
        $result->selectRaw($get_fields);
        $result->whereRaw('(jwf_id IN ('.$child_stages_for_check.'))');
        $query = $result->get();
        return $query;
    }

    public function article_flow(){
		return $this->hasMany(Article_flow::class, 'aflw_jwf_id');
	}

}
