<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Generic_form_elements extends BaseModel
{
    
    use HasFactory;
    public $table='rvw_generic_form_elements';
    public static $column_prefix='emt_';
    protected $primaryKey = 'emt_id';
    public static $tbk_table='tbk_generic_form_elements';

    public static function check_group_element($data) {
        $select='*';
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $result->selectRaw($select);
        $result->where('emt_gfg_id', $data['groupid']);
        $result->where('emt_gucf_id', $data['formid']);
        $res=$result->get();
        $resCount = $res->count();
        if ($resCount > 0) {
            return true;
        } else {
            return false;
        }
    }
    


    public static function getmax_order_element($formid, $groupid) {
        $select='max(emt_order) as emt_order';
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        //$colmn_prefix = (new $classname)::$column_prefix;
        $result = DB::table($table);
        $result->selectRaw($select);
        $result->where('emt_gucf_id', $formid);
        $result->where('emt_gfg_id', $groupid);
        $res=$result->first();
        return $res->emt_order;
	}

    public static function get_element_orderid($formid, $groupid, $reference_id) {
        $select='emt_order';
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        //$colmn_prefix = (new $classname)::$column_prefix;
        $result = DB::table($table);
        $result->selectRaw($select);
        $result->where('emt_id', $reference_id);
        $result->where('emt_gucf_id', $formid);
        $result->where('emt_gfg_id', $groupid);
        $res=$result->first();
        return $res->emt_order;
	}


    public static function increment_orderids($formid, $groupid, $orderid) {
        DB::enableQueryLog();
        $classname = get_called_class();
        $table = (new $classname)->getTable();        
        $result = DB::table($table);
        $criteria='emt_order >='.$orderid;
        $result->whereRaw($criteria);
        $result->where('emt_gucf_id', $formid);
        $result->where('emt_gfg_id', $groupid);
        $result->update([
            'emt_order'=> DB::raw('emt_order+1')
        ]);
        $queries = DB::getQueryLog();
        // dd($queries);
        return $result;
	}

	public static function move_generic_form_elements($old_form_id, $new_form_id, $current_user) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
		$query = "insert into ".$table."(emt_gucf_id, emt_gfg_id, emt_unique_identifier, emt_element_type,emt_label,emt_required,emt_max_char, emt_min_char, emt_column_type, emt_word_min, emt_word_max, emt_error_msg, emt_place_holder,emt_file_min_cnt,emt_file_max_cnt,emt_file_types,emt_tinymce_required, emt_options, emt_combo_multiple, emt_combo_custom, emt_note_text,emt_user_roles, emt_dependency_required, emt_depending_control,emt_depending_value,emt_order,emt_posted_by,emt_posted_date,emt_old_emt_id,emt_cd_code,emt_identifier_type,emp_populate_from_table,emt_dnd_value,emt_textarea_rows,emt_help_icon,emt_help_icon_text,emt_alignment,emt_populate_data,emt_source_formid,emt_source_elementid,emt_populate_data_pair)
         select ".$new_form_id.",emt_gfg_id,emt_unique_identifier,emt_element_type,emt_label,emt_required,emt_max_char,emt_min_char,emt_column_type, emt_word_min,emt_word_max, emt_error_msg, emt_place_holder,emt_file_min_cnt,emt_file_max_cnt,emt_file_types,emt_tinymce_required, emt_options, emt_combo_multiple, emt_combo_custom, emt_note_text,emt_user_roles,emt_dependency_required, emt_depending_control,emt_depending_value,emt_order," . $current_user . ",'" . date('Y-m-d H:i:s') . "',emt_id,emt_cd_code,emt_identifier_type,emp_populate_from_table,emt_dnd_value,emt_textarea_rows,emt_help_icon,emt_help_icon_text,emt_alignment,emt_populate_data,emt_source_formid,emt_source_elementid,emt_populate_data_pair  from ".$table." where emt_gucf_id =".$old_form_id;
        DB::select($query);
	}

    //update group id in  rvw_generic_form_elements tb
    public static function update_form_element_group($new_form_id) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $generic_form_groups = (new \App\Models\Generic_form_groups())->getTable();
		$query = "update ".$table." set emt_gfg_id =
        (select gfg_id from ".$generic_form_groups." where emt_gfg_id = gfg_old_gfg_id) where emt_gucf_id = " . $new_form_id;
        DB::select($query);
	}

    public static function update_form_element_dependency($new_form_id) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
		$query = "update ".$table." a, ".$table." b set a.emt_depending_control= b.emt_id WHERE b.emt_old_emt_id = a.emt_depending_control  and a.emt_depending_control is not null and 
        a.emt_gucf_id =" . $new_form_id;
        DB::select($query);
	}


    public static function get_form_controls($condition) {
        $select='emt_id,emt_gucf_id,emt_gfg_id,emt_unique_identifier,emt_element_type,emt_label,emt_alignment,emt_required,emt_max_char,emt_min_char,emt_column_type,emt_word_min,emt_word_max,emt_error_msg,emt_place_holder,emt_file_min_cnt,emt_file_max_cnt,emt_file_types,emt_tinymce_required,emp_populate_from_table,emt_options,emt_combo_multiple,emt_combo_custom,emt_note_text,emt_user_roles,emt_dependency_required,emt_depending_control,  emt_depending_value,emt_active,emt_order,right_emt_ids,div_start_emt_id,emt_cd_code,emt_dnd_value,emt_identifier_type,emt_attach_to_mail,emt_textarea_rows,emt_help_icon,emt_help_icon_text,emt_populate_data,emt_source_formid,emt_source_elementid,  emt_dynamic_status,emt_flag_id,emt_hideafterstage,emt_posted_by,emt_posted_date';
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $generic_form_groups = (new \App\Models\Generic_form_groups())->getTable();
        $result->selectRaw($select);
        $result->leftjoin($generic_form_groups, 'gfg_id', '=', 'emt_gfg_id');
        $result->whereRaw($condition);
        $result->orderBy('emt_id');
        return $result->get();
    }

    public static function supporting_files($form_id_arr) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $form_data = implode(',', $form_id_arr);
        $condition = "emt_gucf_id in (" . $form_data . ")";
        return $products = DB::table($table)
        ->selectRaw("sum(emt_tinymce_required) as editor,sum(case when emt_element_type = 'file' then 1 else 0 end) as file_upload")
        ->whereRaw($condition)
        ->get();

	    //$query = "select sum(emt_tinymce_required) as editor, sum(case when emt_element_type = 'file' then 1 else 0 end) as file_upload FROM '".$table."' WHERE emt_gucf_id IN (1) ";
        //DB::select($query);
	}

    public static function get_element_details_with_group($element_id) {        
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $select='emt_id,emt_gucf_id,emt_gfg_id,emt_unique_identifier,emt_element_type,emt_label,emt_alignment,emt_required,emt_max_char,emt_min_char,emt_column_type,emt_word_min,emt_word_max,emt_error_msg,emt_place_holder,emt_file_min_cnt,emt_file_max_cnt,emt_file_types,emt_tinymce_required,emp_populate_from_table,emt_options,emt_combo_multiple,emt_combo_custom,emt_note_text,emt_user_roles,emt_dependency_required,emt_depending_control, emt_depending_value,emt_active,emt_order,right_emt_ids,div_start_emt_id,emt_cd_code,emt_dnd_value, emt_identifier_type,emt_attach_to_mail,emt_textarea_rows,emt_help_icon,emt_help_icon_text,emt_populate_data, emt_source_formid,emt_source_elementid,emt_populate_data_pair,emt_dynamic_status,emt_flag_id,emt_hideafterstage,emt_posted_by,emt_posted_date,emt_old_emt_id,emt_proxy_id,emt_operation,gncf_form_title,gfg_id,gfg_group_name';
        $result = DB::table($table);
        $generic_form_groups = (new \App\Models\Generic_form_groups())->getTable();
        $generic_forms = (new \App\Models\Generic_forms())->getTable();
        $result->selectRaw($select);
        $result->join($generic_form_groups, 'emt_gfg_id', '=', 'gfg_id');
        $result->join($generic_forms, 'emt_gucf_id', '=', 'gncf_id');
        $result->where('emt_id', $element_id);
        $res=$result->first();
        return $res;
	}


    public static function get_all_form_elements($select = '*', $condition = array(), $level = 'global', $level_id = NULL) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $generic_forms = (new \App\Models\Generic_forms())->getTable();
        $article_type_table = (new \App\Models\Article_types())->getTable();
		$generic_table = (new \App\Models\Generic_flows())->getTable();
        $result->selectRaw($select);        
        $result->join($generic_forms, 'emt_gucf_id', '=', 'gncf_id');
        if ($level == 'article_type' && $level_id != NULL) {
            $result->join($generic_table," FIND_IN_SET(gncf_id, REPLACE(REPLACE(REPLACE(`jwf_forms`,'[',''),']',''),'\"','')) ");
            $result->join($article_type_table, 'artp_fwm_id', '=', 'jwf_fwm_id');
            $result->where('artp_id', $level_id);
        }
        if (!empty($condition))
            $result->whereRaw($condition);
        return $result->get();
	}

    public static function get_all_form_elements_unique($select = '*', $condition = array(), $jnl_id = NULL, $article_id = NULL) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $generic_forms = (new \App\Models\Generic_forms())->getTable();
        $article_type_table = (new \App\Models\Article_types())->getTable();
		$generic_table = (new \App\Models\Generic_flows())->getTable();
        $journals_table = (new \App\Models\Journals())->getTable();
        $result->selectRaw($select);        
        $result->join($generic_forms, 'emt_gucf_id', '=', 'gncf_id');
        $result->join($generic_table,\DB::raw("FIND_array_intersect(gncf_id, REPLACE(REPLACE(REPLACE(jwf_forms,'[',''),']',''),'\"','')) "),\DB::raw("'1'"));        // $result->join($generic_table,DB::raw("FIND_IN_SET(gncf_id, REPLACE(REPLACE(REPLACE(`jwf_forms`,'[',''),']',''),'\"',''))"));      
        if ($jnl_id != NULL && $article_id != NULL) {
            $result->join($article_type_table, 'artp_fwm_id', '=', 'jwf_fwm_id');
            $result->where('artp_id', $article_id);
        }else if ($jnl_id != NULL) {
            $result->join($journals_table, 'jnl_fwm_id', '=', 'jwf_fwm_id');
            $result->where('jnl_id', $jnl_id);
        }
        if (!empty($condition))
            $result->whereRaw($condition);
        return $result->get();
	}

    public static function get_data_protection_elements($user_id, $select = '*', $condition = array()) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $generic_forms = (new \App\Models\Generic_forms())->getTable();
        $user_meta = (new \App\Models\User_meta())->getTable();
        $result->selectRaw($select);
        $result->join($generic_forms, 'emt_gucf_id', '=', 'gncf_id');
        $result->leftjoin($user_meta, 'urg_element_id', '=', 'emt_id');
        $result->where('urg_user_id', $user_id);
        $result->whereRaw($condition);
        $result->orderBy('emt_order');
        return $result->get();
    }

    public static function get_form_dependency_elements($form_id,$emt_ids = '') {
        $select='emt_id,emt_depending_control,emt_depending_value';
        $condition = "emt_gucf_id = ? AND emt_depending_control != ?";
        $bind_data = [$form_id,0];         //TASK #7017
        if($emt_ids != '')
        {
            $condition .= ' AND (emt_id IN ('.$emt_ids.') OR (emt_depending_control IN ('.$emt_ids.')))'; 
        }
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $result->selectRaw($select);
        $result->whereRaw($condition);
        $result->setBindings($bind_data);   //TASK #7017
        return $result->get();       
       
    }

    public static function get_element_options($form_id,$upd_id = NULL ) {
        $select='emt_options';
        if($upd_id != '') {
			$condition = "emt_gucf_id='".$form_id."' AND emt_id !='".$upd_id."' AND (emt_element_type='combobox' OR emt_element_type='radiobutton')";
		} else {
			$condition = "emt_gucf_id='".$form_id."' AND (emt_element_type='combobox' OR emt_element_type='radiobutton')";
		}
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $result->selectRaw($select);
        $result->whereRaw($condition);
        return $result->get();       
    }

    public static function get_stage_elements($form_id) {
        $select='emt_options';
        $condition = "emt_gucf_id IN(".$form_id.") AND(emt_element_type='combobox' OR emt_element_type='radiobutton')";
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $result->selectRaw($select);
        $result->whereRaw($condition);
        return $result->get();       
    }    
 
    public static function get_all_form_elements_for_report($type = 'article_unique_fields', $field = true, $search = null, $match_exact = false) {
        if ($search == null) {
            return array();
        }       
        if ($field == true) {
            $condition_value = 'id';
            $label = 'name';
        } else {
            $condition_value = 'condition_value';
            $label = 'label';
        }

        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);

        if ($type == 'user_unique_fields') {
            $condition = array(
                'gncf_jnl_id' => NULL,
                'emt_unique_identifier!=' => NULL);
            $select = '  CONCAT(`emt_unique_identifier`,\'##USER##\') AS ' . $condition_value . ',
  CONCAT(emt_unique_identifier,\': \', emt_label) AS ' . $label . ' ';
        } else {
            $sel_string = '(SELECT DISTINCT CONCAT(`emt_unique_identifier`,\'##\',GROUP_CONCAT(distinct jnl_journal_code),\'##\') 
       FROM rvw_journal_workflows 
INNER join  `rvw_flow_master` ON jwf_fwm_id=fwm_id 
INNER join  `rvw_article_types`  ON artp_fwm_id=fwm_id
INNER join  `rvw_journals` as d ON jnl_id=artp_jnl_id  
WHERE jnl_journal_code is not null and FIND_IN_SET(emt_gucf_id, REPLACE(REPLACE(REPLACE(jwf_forms,\']\',\'\'),\'[\',\'\'),"\"",""))> 0) ';
            $condition = array(
                "($sel_string)!=" => NULL,
                'emt_unique_identifier!=' => NULL);
            if ($search != null) {
                if ($match_exact == false)
                    $condition['emt_unique_identifier LIKE'] = "%$search%";
                else
                    $condition['emt_unique_identifier ='] = "$search";
            }
            $select = $sel_string . ' as  ' . $condition_value . ',
 CONCAT(
    emt_unique_identifier,
     \': \', emt_label  
  ) AS ' . $label . ' ';
        }
        $result->selectRaw($select);
        if (!empty($condition))
            $result->whereRaw($condition);
        $result->groupBy($label);
        return $result->get();   

    }

}
