<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Generic_forms extends BaseModel
{
    use HasFactory;
    public $table = 'rvw_generic_forms';
    public static $column_prefix = 'gncf_';
    protected $primaryKey = 'gncf_id';

    public static function move_generic_from($form_id, $jnl_id, $current_user, $new_form_name = NULL)
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        if (empty($jnl_id)) {
            $gncf_jnl_id = '';
            $jnl_id  = '';
        } else {
            $gncf_jnl_id = 'gncf_jnl_id,';
            $jnl_id      = $jnl_id . ',';
        }
        if (empty($new_form_name)) {
            $new_form_name = "concat(gncf_form_name,' copy')";
        } else {
            $new_form_name = "'" . $new_form_name . "'";
        }
        //Copy master custom forms and create new in the same level-----Ends
        $sql = "insert into " . $table . " (" . $gncf_jnl_id . "gncf_form_type, gncf_form_name,gncf_form_title, gncf_form_layout, gncf_form_description, gncf_posted_by, gncf_posted_date,gncf_proxy_id,gncf_metadata_status) "
            . "select " . $jnl_id . "gncf_form_type," . $new_form_name . ", gncf_form_title, gncf_form_layout, gncf_form_description," . $current_user['user_id'] . ",'" . date('Y-m-d H:i:s') . "'," . $current_user['proxy_user_id'] . ",gncf_metadata_status from " . $table . " where gncf_id = " . $form_id;
        $result = DB::select($sql);
        $queries = DB::getQueryLog();
        $id = DB::connection()->getPdo()->lastInsertId();
        return $id;
    }

	public static function get_generic_forms($select = '*', $criteria = array(), $limit = NULL, $start = NULL, $orderby = NULL) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $journals = (new \App\Models\Journals())->getTable();
        $result->selectRaw($select);		
        $result->leftjoin($journals, 'jnl_id', '=', 'gncf_jnl_id');
        $result->whereRaw($criteria);
        if ($start !== NULL && $limit !== NULL) {
            $result->skip($start);
            $result->take($limit);
        }
        if($orderby != NULL)
            $result->orderBy(DB::raw($orderby));           
		
        return $result->get();
	}


	public static function copy_journal_forms($new_jnl_id, $old_jnl_id, $current_user)
	{
        $classname = get_called_class();
        $tbl_name = (new $classname)->getTable();	
		$sql = "insert into " . $tbl_name . " (gncf_old_id, gncf_jnl_id,gncf_form_type, gncf_form_name,gncf_form_title, gncf_form_layout, gncf_form_description, gncf_posted_by, gncf_posted_date) "
			. "select gncf_id, " . $new_jnl_id . ",gncf_form_type, gncf_form_name, gncf_form_title, gncf_form_layout, gncf_form_description," . $current_user . ",'" . date('Y-m-d H:i:s') . "' from " . $tbl_name . " where gncf_jnl_id = ".$old_jnl_id;
        $result = DB::select($sql);
        if ($result)
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
	}









}
