<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Issue_management extends BaseModel
{
    use HasFactory;

    public  $table='rvw_issue_management';
    public static $tbk_table='tbk_issue_management';
    protected $primaryKey = 'ism_id';
    public static $column_prefix='ism_';

    /*
    * Fetch array model tree of classifications and its childrens
    */
    public static function get_art_issue_details($article_id)
	{
        $classname = get_called_class();
        $Issue_management_table = (new $classname)->getTable();
        $Issues_table = (new \App\Models\Issues)->getTable();
        $Volumes_table = (new \App\Models\Volumes)->getTable();
        $Attachments_tbl1 = (new \App\Models\Issue_attachments)->getTable();
        $Attachments_tbl2 = (new \App\Models\Issue_attachments)->getTable();
        $Articles_table = (new \App\Models\Articles)->getTable();

        $result =   DB::table($Issue_management_table);
		$result->selectRaw('vol_title, iss_number, iss_title, CONCAT(at1.isat_type,"-",at1.isat_page) as front, CONCAT(at2.isat_type,"-",at2.isat_page) as back');
		$result->join($Issues_table, 'iss_id' ,'=' ,'ism_iss_id', '', '', 'inner');
		$result->leftjoin($Volumes_table, 'vol_id' ,'=' ,'iss_vol_id');
        $result->leftJoin($Attachments_tbl1 . ' as at1', function($join) {
            $join->on('at1.isat_iss_id', '=', 'iss_id')
                 ->where('at1.isat_type', '=', 'f');  // Additional condition
        });
        $result->leftJoin($Attachments_tbl2 . ' as at2', function($join) {
            $join->on('at2.isat_iss_id', '=', 'iss_id')
                 ->where('at2.isat_type', '=', 'b');  // Additional condition
        });
		$result->leftjoin($Articles_table, 'art_id', '=', 'ism_art_id');
		$result->where('ism_art_id', $article_id);
		return $result->get();
	}
}
