<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Issues extends BaseModel
{
    use HasFactory;

    public  $table='rvw_issues';
    protected $primaryKey = 'iss_id';
    public static $column_prefix='iss_';

    public static function get_issues($select,$where)
	{
        $classname=get_called_class();
        $table=(new $classname)->getTable();
        $volumeTable=(new \App\Models\Volumes())->getTable();
        $result = DB::table($table)
        ->selectRaw($select)
        ->leftjoin($volumeTable, "vol_id" , "=" , "iss_vol_id"); 
        $result->whereRaw($where);
        return $result->get();
	}
}
