<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class Journal_settings extends BaseModel
{
    use HasFactory;
    public  $table='rvw_journal_settings';
    protected $primaryKey = 'jset_id';
    public static $column_prefix='jset_';
	public static function get_essential_platform_settings($platform_code)
	{
        $journal_table = (new \App\Models\Journals())->getTable();
		$journal_settings_table = (new \App\Models\Journal_settings())->getTable();

        $sql = DB::table($journal_settings_table)
        ->selectRaw('jset_jnl_id,jnl_id,jnl_journal_code,jnl_journal_status,jnl_journal_type, jnl_logo, jnl_journal_name,jnl_journal_description,jnl_fwm_id,jnl_standalone,jnl_standalone_group,jset_date_format, jset_usr_journal_chief, jset_file_type,jset_manage_article, jset_login_user_type,jset_email_permission, jset_min_keyword, jset_max_keyword,jset_review_method,jset_reply_to_email,jset_review_open_decision,jset_review_open_count,jset_publons_key,jset_enable_publons,jset_enable_figshare,jset_create_article_stub, jset_enable_reviewer_connect, jset_reviewer_connect_limit, jset_reviewer_connect_search_years,jset_notification_message,jset_author_confirmation_bw_article_types,jset_author_confirmation_jnl,jset_classification,jset_classification_title,jset_classification_selection_mode,jset_min_classification,jset_max_classification,jnl_article_submission_status,jset_batch_decision,jset_batch_reviews')
        ->join($journal_table,'jnl_id','=','jset_jnl_id')
        ->whereRaw("jnl_journal_code=?", [$platform_code]);
        return $sql->first();
	}
    public static function copy_journal_settings($insert_fields, $select_fields, $jnlSettingsData)
	{
        $classname = get_called_class();
		$table = (new $classname)->getTable();
        $column_prefix = (new $classname)::$column_prefix;
		$sql = 'INSERT INTO ' . $table . ' (' . $insert_fields . ')' .
			' SELECT ' . $select_fields . ' FROM ' . $table . ' WHERE ' . $column_prefix . 'jnl_id=' . $jnlSettingsData['old_jnl_id'] . ' LIMIT 1';
        $result = DB::select($sql);
        $id = DB::connection()->getPdo()->lastInsertId();
		return $id;
	}

    public static function get_essential_journal_settings($journal_code)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();

		$journal_table = (new \App\Models\Journals())->getTable();
		$journal_permission_table = (new \App\Models\Journal_permission())->getTable();

		$sql = DB::table($table)
				->selectRaw('jset_jnl_id,jnl_id,jnl_journal_code,jnl_journal_status,jnl_journal_type, jnl_logo, jnl_journal_name,jnl_journal_description,jnl_fwm_id,jnl_standalone,jnl_standalone_group,jset_date_format, jset_usr_journal_chief, jset_file_type, jp_edit_articles,jset_manage_article, jset_login_user_type,jset_email_permission, jset_min_keyword, jset_max_keyword,jset_review_method,jset_reply_to_email,jset_reply_to_email_traction,jset_review_open_decision,jset_review_open_count,jset_publons_key,jset_enable_publons,jset_enable_figshare,jset_create_article_stub, jset_enable_reviewer_connect, jset_reviewer_connect_limit, jset_reviewer_connect_search_years,jset_notification_message,jp_auto_assign_role,jset_author_confirmation_bw_article_types,jset_author_confirmation_jnl,jset_batch_decision,jset_batch_reviews')
				->join($journal_table,'jnl_id','=','jset_jnl_id')
				->join($journal_permission_table,'jnl_jpm_id','=','jp_jpm_id')
				->where('jnl_journal_code', $journal_code);
		return $sql->get();
	}

    public static function get_tat_days_settings($jnl_id){
        $params = ['exclude_days' => 'i', 'weekends_excluded' => null, 'special_days_excluded' => []];
        $journal_settings_table = (new \App\Models\Journal_settings())->getTable();
        $result = DB::table($journal_settings_table)
                        ->where('jset_jnl_id', '=', $jnl_id)
                        ->get(['jset_tat_exclude_days', 'jset_tat_days_excluded'])?->first();
        if($result){
            if($result->jset_tat_exclude_days != 'i'){
                $params['exclude_days'] = $result->jset_tat_exclude_days;
                $excluded_days = json_decode($result->jset_tat_days_excluded, true);
                $params['weekends_excluded'] = $excluded_days['w'];
                if($result->jset_tat_exclude_days == 's'){
                    $params['special_days_excluded'] = $excluded_days['s'];
                }
        }
    }
    return $params;
    }

}
