<?php

namespace App\Models;

use DB;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Journal_terms extends BaseModel
{
    use HasFactory;
    public  $table = 'rvw_journal_terms';
    protected $primaryKey = 'jntm_id';
    public static $column_prefix = 'jntm_';


    public static function get_articletype_term($arttypeid)
    {
        $journal_term_table = (new \App\Models\Journal_terms())->getTable();
        $sql = "SELECT  `jntm_term_id` FROM  " . $journal_term_table . " WHERE  `jntm_artp_id` ='".$arttypeid."' AND jntm_term_id NOT IN ( SELECT  `jntm_term_id` FROM  " . $journal_term_table . " WHERE  `jntm_artp_id` !=" . $arttypeid . " or `jntm_artp_id` IS NULL)";      
        $result = DB::select($sql);
        return $result;
    }
    public static function delete_journal_terms($jrnl_id, $arttypeid = NULL)
	{
        $journal_term_table = (new \App\Models\Journal_terms())->getTable();

		if ($arttypeid != NULL)
		{
			$condition = "jntm_artp_id =" . $arttypeid;
		}
		else
		{
			$condition = "jntm_artp_id IS NULL and jntm_jnl_id=" . $jrnl_id;
		}
		$sql = "DELETE FROM " . $journal_term_table . " WHERE " . $condition . " ORDER BY jntm_id DESC";
        $result = DB::select($sql);
		return $result;
	}
    public static function get_primary_in_journal($id, $type=NULL, $article_id = NULL, $jnlid = NULL,$count = FALSE,$limit = NULL,$start = NULL)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $Terms_table= (new \App\Models\Terms())->getTable();
        $Article_classification_table= (new \App\Models\Article_classification())->getTable();
        if($count == TRUE)
		{
            $select='count(term_id) as cnt';
        }
        else{
            $select='term_id,term_name,jntm_id,jntm_primary_id,jntm_term_id';
        }
        $result=DB::table($table);
        $result->selectRaw($select);
        $result->join($Terms_table,'jntm_term_id','=','term_id');
        if (!empty($type) && $type == 'artp')
		{  //article type
        $result->whereRaw("jntm_artp_id={$id}");
        if (!empty($article_id))
			{//user article edit time
                $select.='atp_tpc_id';
                $result->selectRaw($select);  
                $result->leftJoin($Article_classification_table,'atp_tpc_id','=','jntm_id');
                $result->whereRaw("atp_art_id={$article_id}");
                // $result->leftJoin($Article_classification_table, function ($join) {
                //     $join->on('jntm_id', '=', 'atp_tpc_id')
                //          ->whereRaw($Article_classification_table.'.atp_art_id', '=', $article_id);
                // });
            }
            // var_dump($jnl_id);
            //     if ($jnlid != NULL)
            //    { $result->whereRaw("jntm_jnl_id={$jnlid}");}
            }
            else{
                //journal time
                $result->whereRaw("jntm_jnl_id={$id}");
		    	$result->whereRaw('jntm_artp_id IS NULL');
            }
            $result->whereRaw("jntm_type='p'");
            $result->orderBy('term_name');
            if ($start !== NULL && $limit !== NULL)
            {
                $result->limit($limit,$start);
            }
            $query = $result->get();
            if($count == TRUE)
            return $query->first();
            else
            return $query;
    }

}
