<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use Mpdf\Tag\Article;
use App\Models\Keywords; /* Task #1180 Reduce the load time of manage keywords section*/
use App\Models\Keyword_relationship; /* Task #1180 Reduce the load time of manage keywords section*/

class Journals extends BaseModel
{
    use HasFactory;
    public $table='rvw_journals';
    public static $column_prefix='jnl_';
    protected $primaryKey = 'jnl_id';

    public static function get_journal_by_article_type($include_journals = NULL, $order = 'jnl_journal_name asc',$exclude_journals = NULL,$standalone_condition = NULL, $current_user = NULL) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
		$article_type = (new \App\Models\Article_types())->getTable();
		$genenricflows = (new \App\Models\Generic_flows())->getTable();

    $select="jnl_id,jnl_journal_code, jnl_logo, jnl_journal_name,jnl_journal_description,jnl_standalone, jnl_standalone_group, count(artp_jnl_id) AS jnl_count";
    $excludecondition='';
    $order_by='';
    $include_codition='';
    $standcondition='';
    if(!empty($exclude_journals))
    {
        $excludecondition=' WHERE jnl_id NOT IN (' . implode(",", $exclude_journals) . ')';
    }
    $group_by="GROUP BY jnl_id,jnl_journal_code, jnl_journal_name HAVING jnl_count >0";
    if(!empty($include_journals))
    {
        $include_codition=' OR jnl_id  IN (' . implode(",", $include_journals) . ')';
    }
    if($standalone_condition == 'y')
    {
    if (!in_array('super_admin', $current_user['roles']) || !in_array('sudo', $current_user['roles'])){
    $standcondition="AND jnl_standalone='y' AND jnl_id = {$current_user['usr_jnl_standalone']}";
        }
        else{
        $standcondition=" AND jnl_standalone='y'";
        }
    }
    if($order!=NULL)
    {
       $order_by="ORDER BY {$order}" ;
    }
$sql="SELECT {$select} FROM {$table} LEFT JOIN  {$article_type} ON jnl_id = artp_jnl_id AND jnl_journal_status = 'y' {$standcondition} {$excludecondition} {$group_by}  {$include_codition}  {$order_by}";
$result = DB::select($sql);
return $result;


	}
	public static function get_journal_data($jnl_code) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $select = "jnl_id,jnl_journal_code,jnl_journal_name,jnl_fwm_id,jset_login_user_type,jset_proxy_login,jset_date_format";
		$journalSettings = (new \App\Models\Journal_settings())->getTable();

        $result=DB::table($table);
        $result->selectRaw($select);
        $result->join($journalSettings,'jnl_id','=','jset_jnl_id');
        // $result->whereRaw("jnl_journal_code='{$jnl_code}'");
        $result->whereRaw("jnl_journal_code=?",[$jnl_code]);
        $query = $result->get();
        return $query->first();
    }

    public static function validateJournal($jnl_id){
        $status = false;
        $journal = Journals::get_single_record_with_bind_cond('jnl_id', ['jnl_id' => $jnl_id]);
        if($journal){
            $status = true;
        }
        
    return $status;
    }

    public function article_types(){
        return $this->hasMany(Article_types::class, 'artp_jnl_id');
    }

    public function articles()
    {
        return $this->hasManyThrough(Articles::class, Article_types::class, 'artp_jnl_id', 'art_artp_id');
    }
       /* Task #1180 Reduce the load time of manage keywords section*/
       public function keywordRelationships()
       {
           return $this->hasMany(Keyword_relationship::class, 'kwdrl_kwd_id', 'kwd_id');
       }
   
       public function keywords()
       {
           return $this->belongsToMany(Keywords::class, 'rvw_keyword_relationship', 'kwdrl_jnl_id', 'kwdrl_kwd_id');
       }
       /*end Task #1180 Reduce the load time of manage keywords section*/

}
