<?php

namespace App\Models;

use App\Models\Keywords;  /* Task #1295 Reduce the load time of profile keyword search */
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use App\Models\Journals; /* Task #1180 Reduce the load time of manage keywords section*/
class Keyword_relationship extends BaseModel
{
    use HasFactory;
    public $table='rvw_keyword_relationship';
    public static $column_prefix='kwdrl_';
    protected $primaryKey = 'kwdrl_kwd_id';
    public static function copy_journal_relationship($oldJnlId, $newJnlid, $userid)
	{
		$classname = get_called_class();
		$tbl_name  = (new $classname)->getTable();
        $column_prefix = (new $classname)::$column_prefix;
		$sql = 'INSERT INTO ' . $tbl_name . ' (kwdrl_jnl_id,	kwdrl_kwd_id,	kwdrl_posted_by,kwdrl_posted_date)' .
			' SELECT ' . $newJnlid . ',kwdrl_kwd_id,' . $userid . ',"' . date('Y-m-d H:i:s') . '" FROM ' . $tbl_name . ' WHERE ' . $column_prefix . 'jnl_id=' . $oldJnlId;
            $result = DB::select($sql);
            if ($result)
            {
                return TRUE;
            }
            else
            {
                return FALSE;
            }
	}
    /* Task #1295 Reduce the load time of profile keyword search */
    public function keyword()
    {
        return $this->belongsTo(Keywords::class, 'kwdrl_kwd_id','kwd_id');
    }
     /* end Task #1295 Reduce the load time of profile keyword search */
    /* Task #1180 Reduce the load time of manage keywords section*/
    public function journal()
    {
        return $this->belongsTo(Journals::class, 'kwdrl_jnl_id');
    }
    /*end Task #1180 Reduce the load time of manage keywords section*/
}
