<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use App\Models\Userkeywords; /* Task #1295 Reduce the load time of profile keyword search */
use PhpParser\Node\Stmt\Else_;
use App\Models\Articles; /* Task #1180 Reduce the load time of manage keywords section*/
use App\Models\Journals; /* Task #1180 Reduce the load time of manage keywords section*/
use App\Models\Article_Keywords; /* Task #1180 Reduce the load time of manage keywords section*/
use App\Models\Keyword_relationship; /* Task #1180 Reduce the load time of manage keywords section*/

class Keywords extends BaseModel
{
	use HasFactory;
	public $table = 'rvw_keywords';
	public static $column_prefix = 'kwd_';
	protected $primaryKey = 'kwd_id';

	public static function get_jnl_keywords($select = '*', $single = FALSE, $condition = NULL, $limit = NULL, $group_by = NULL, $sort_field = NULL, $sort_order = NULL, $having = NULL)
	{
		//$keyword_table = (new \App\Models\Keywords())->getTable();
		$keyword_relationship_table = (new \App\Models\Keyword_relationship())->getTable();
		$article_keyword_table = (new \App\Models\Article_keywords())->getTable();
		$journal_table = (new \App\Models\Journals())->getTable();
		$articles_table = (new \App\Models\Articles())->getTable();
		$article_type_table = (new \App\Models\Article_types())->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();

		//DB::enableQueryLog();
		$main_sql = DB::table($table)
			->selectRaw(DB::raw($select))
			->leftjoin(DB::raw($keyword_relationship_table), 'kwdrl_kwd_id', '=', 'kwd_id')
			->leftjoin(DB::raw($article_keyword_table), 'ak_keyword_id', '=', 'kwd_id')
			->leftjoin(DB::raw($journal_table), 'kwdrl_jnl_id', '=', 'jnl_id')
			->leftjoin(DB::raw($articles_table), 'art_id', '=', 'ak_art_id')
			->leftjoin(DB::raw($article_type_table), 'artp_id', '=', 'art_artp_id');

		if ($condition != NULL)
			$main_sql->whereRaw($condition);
		if ($group_by != NULL) {
			$main_sql->groupBy($group_by);
		}
		if ($having != NULL) {
			$main_sql->havingRaw($having);
		}

		if ($sort_field != NULL && $sort_order != NULL) {
			$main_sql->orderBy($sort_field, $sort_order);
		}

		if ($single == TRUE) {
			$sql = $main_sql->first();
		} else {
			if ($limit !=	NULL)
				$sql = $main_sql->paginate($limit);
			else
				$sql = $main_sql->get();
		}
		//$main_sql->get();
		$queries = DB::getQueryLog();
		//dd($queries); 
		return $sql;
	}

	public static function get_cat_keywords($select = '*', $single = FALSE, $condition = NULL, $limit = NULL, $group_by = NULL, $sort_field = NULL, $sort_order = NULL, $having = NULL)
	{
		//$keyword_table = (new \App\Models\Keywords())->getTable();
		$keyword_relationship_table = (new \App\Models\Keyword_relationship())->getTable();
		$article_keyword_table = (new \App\Models\Article_keywords())->getTable();
		$category_table = (new \App\Models\Keyword_category())->getTable();
		$articles_table = (new \App\Models\Articles())->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		DB::enableQueryLog();
		$main_sql = DB::table($table)
			->selectRaw(DB::raw($select))
			->leftjoin(DB::raw($keyword_relationship_table), 'kwdrl_kwd_id', '=', 'kwd_id')
			->leftjoin(DB::raw($article_keyword_table), 'ak_keyword_id', '=', 'kwd_id')
			->rightjoin(DB::raw($category_table), 'kwdrl_category_id', '=', 'kwc_id')
			->leftjoin(DB::raw($articles_table), 'art_id', '=', 'ak_art_id');

		if ($condition != NULL)
			$main_sql->whereRaw($condition);
		if ($group_by != NULL) {
			$main_sql->groupBy($group_by);
		}
		if ($having != NULL) {
			$main_sql->havingRaw($having);
		}

		if ($sort_field != NULL && $sort_order != NULL) {
			$main_sql->orderBy($sort_field, $sort_order);
		}

		if ($single == TRUE) {
			$sql = $main_sql->first();
		} else {
			if ($limit !=	NULL)
				$sql = $main_sql->paginate($limit);
			else
				$sql = $main_sql->get();
		}
		//$main_sql->get();
		$queries = DB::getQueryLog();
		//dd($queries); 
		return $sql;
	}

	public static function check_keyword_exists($condition = array(), $select = '*',$binding_arr = [])
	{

		$keyword_relationship_table = (new \App\Models\Keyword_relationship())->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		DB::enableQueryLog();
		$main_sql = DB::table($table)
			->selectRaw(DB::raw($select))
			->leftjoin(DB::raw($keyword_relationship_table), 'kwdrl_kwd_id', '=', 'kwd_id');

		if ($condition != NULL)
			$main_sql->whereRaw($condition);
		if (count($binding_arr) > 0)
			$main_sql->setBindings($binding_arr);
		$sql = $main_sql->first();

		//$sql = $main_sql->get();
		//$main_sql->get();
		$queries = DB::getQueryLog();
		//dd($queries); 
		return $sql;
	}

	public static function  get_keywords($where = array(), $select = '*', $limit = NULL, $start = NULL, $group = NULL, $hierachy = NULL, $where_in = NULL, $sub_qry = NULL, $jnl_id = NULL, $category = NULL, $order = NULL, $return_cnt = FALSE, $check_inact_in_art = FALSE,$binding_arr=[])
	{

		//$db_handler->simple_query('SET SESSION group_concat_max_len=5000000');
		$keyword_relationship_table = (new \App\Models\Keyword_relationship())->getTable();
		$journals_table = (new \App\Models\Journals())->getTable();
		$keywordcategory_table = (new \App\Models\Keyword_category())->getTable();
		$articlekeyword_table = (new \App\Models\Article_keywords())->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$main_sql = DB::table($table);
		$main_sql->selectRaw($select);
		$main_sql->join($keyword_relationship_table, 'kwdrl_kwd_id','=','kwd_id');
		if ($hierachy == "c") {
			$main_sql->join($keywordcategory_table, 'kwdrl_category_id', '=', 'kwc_id');
			$main_sql->where('kwc_is_default',"n");
		} else if ($hierachy == "j") {
			$main_sql->join($journals_table, 'kwdrl_jnl_id', '=', 'jnl_id');
		} else {
			$main_sql->leftjoin($keywordcategory_table, 'kwdrl_category_id', '=', 'kwc_id');
			$main_sql->leftjoin($journals_table, 'kwdrl_jnl_id', '=', 'jnl_id');
			$main_sql->where('(`kwc_is_default` = "n" or `kwc_is_default` IS NULL)');
		}
		if ($check_inact_in_art == TRUE) {
			$main_sql->leftjoin($articlekeyword_table, 'ak_keyword_id', '=', 'kwd_id');
		}
		if ($jnl_id != NULL) {
			$main_sql->where('(
					IF(
					  FIND_IN_SET(
						kwd_id,
					  (SELECT
						GROUP_CONCAT(kwdrl_kwd_id)
					  FROM 
					  "' . $keyword_relationship_table . '" AS sub
					  WHERE
						sub.kwdrl_jnl_id = ' . $jnl_id . ')
					  )
					 > 0,
					FALSE,
					TRUE)
				  )');
		}
		if ($category != NULL) {
			$main_sql->where('(
					IF(
					  FIND_IN_SET(
						kwd_id,
					  (SELECT
						GROUP_CONCAT(kwdrl_kwd_id)
					  FROM
					  "' . $keyword_relationship_table . '" AS sub
					  WHERE
						sub.kwdrl_category_id = ' . $category . ')
					  )
					 > 0,
					FALSE,
					TRUE)
				  )');
		}

		if ($where != NULL)
			$main_sql->whereRaw($where);
		if ($where_in != NULL)
			$main_sql->where_in("kwd_id", $where_in);
		if ($group != NULL)
			$main_sql->groupBy($group);
		if($order!=NULL)
			$main_sql->orderBy($order);
		if ($sub_qry != NULL) {
			$main_sql->whereRaw($sub_qry);
		}
		if (count($binding_arr) >0)
			$main_sql->setBindings($binding_arr);
		if ($start !== NULL && $limit !== NULL)
			$main_sql->limit($limit, $start);

		if ($return_cnt == TRUE) {
			return $main_sql->count();
		} else {
			$res = $main_sql->get();
			return $res;
		}
	}

	public static function get_keywords_by_category($jnl_id, $where)
	{
		$excludejournaltable = (new \App\Models\Excluded_journal_keywords())->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$main_sql = DB::table($table);
		$main_sql->selectRaw('kwd_id,kwd_name');
		if(!empty($where)){
			$where .= ' and ';
		}
		$main_sql->whereRaw($where . ' kwd_category_id NOT IN(select ejk_keyword_category from ' . $excludejournaltable . ' WHERE ejk_jnl_id = ' . $jnl_id . ')');
		$main_sql->limit(25);
		$res = $main_sql->get();
		return $res;
	}
	public static function get_keyword_browse($select, $where,$group_by,$limit,$sort_field='kwd_name',$sort_order='ASC',$jnl_id=NULL,$hierachy='j',$binding_arr = array())
    {
        $keyword_relationship_table = (new \App\Models\Keyword_relationship())->getTable();
		$journals_table = (new \App\Models\Journals())->getTable();
		$keywordcategory_table = (new \App\Models\Keyword_category())->getTable();
		$articlekeyword_table = (new \App\Models\Article_keywords())->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$main_sql = DB::table($table);
		$main_sql->selectRaw($select);
		$main_sql->join($keyword_relationship_table, 'kwdrl_kwd_id','=','kwd_id');
		if($jnl_id !=NULL && $hierachy=='j')
		{
		$main_sql->join($journals_table, 'kwdrl_jnl_id', '=', 'jnl_id');
		}
		$main_sql->leftjoin($articlekeyword_table, 'ak_keyword_id', '=', 'kwd_id');
		// $main_sql->whereRaw($where);
		$main_sql->whereRaw($where,$binding_arr);
		if ($group_by != NULL) {
			$main_sql->groupBy($group_by);
		}
		if ($sort_field != NULL && $sort_order != NULL) {
			$main_sql->orderBy($sort_field,$sort_order);
		}
		$result= $main_sql->paginate($limit);
		 return $result;
    }


	public static function get_jnlsettings_keywords($select = '*', $single = FALSE, $condition = NULL, $limit = NULL, $group_by = NULL, $sort_field = NULL, $sort_order = NULL, $having = NULL, $journal_id= NULL,$binding_arr=[])
{
$keyword_table = (new \App\Models\Keywords())->getTable();
$keyword_relationship_table = (new \App\Models\Keyword_relationship())->getTable();
$article_keyword_table = (new \App\Models\Article_keywords())->getTable();
$journal_table = (new \App\Models\Journals())->getTable();
$articles_table = (new \App\Models\Articles())->getTable();
$article_type_table = (new \App\Models\Article_types())->getTable();
DB::enableQueryLog();
$classname = get_called_class();
$table = (new $classname)->getTable();
$select .= ' , IF(tb1.cnt IS NOT NULL,tb1.cnt,0) as cnt,tb1.jnl_id ';
// $subquery= ' (SELECT ak_keyword_id,jnl_id,COUNT(ak_id) as cnt from '.$article_keyword_table.' JOIN '.$articles_table.' ON art_id = ak_art_id JOIN '.$article_type_table.' ON artp_id = art_artp_id JOIN '.$journal_table.' ON jnl_id = artp_jnl_id WHERE jnl_id = '.$journal_id.' AND IF(art_transfer_article = "y",art_pre_all_ids IS NOT NULL,art_pre_all_ids IS NULL) group by ak_keyword_id,jnl_id) as tb1 ';
$subquery= ' (SELECT ak_keyword_id,jnl_id,COUNT(ak_id) as cnt from '.$article_keyword_table.' JOIN '.$articles_table.' ON art_id = ak_art_id JOIN '.$article_type_table.' ON artp_id = art_artp_id JOIN '.$journal_table.' ON jnl_id = artp_jnl_id WHERE jnl_id = ? AND IF(art_transfer_article = "y",art_pre_all_ids IS NOT NULL,art_pre_all_ids IS NULL) group by ak_keyword_id,jnl_id) as tb1 ';
$main_sql = DB::table($keyword_table.' AS base_tb');
               $main_sql->selectRaw($select);
			   $main_sql->join($keyword_relationship_table,'base_tb.kwd_id','=','kwdrl_kwd_id');
				$main_sql->leftjoin(DB::raw($subquery),'ak_keyword_id','=','base_tb.kwd_id')->addBinding([$journal_id]);

    if ($condition != NULL)
        $main_sql->whereRaw($condition);
    if ($group_by != NULL) {
        $main_sql->groupBy($group_by);
    }
    if ($having != NULL) {
        $main_sql->havingRaw($having);
    }
	if (count($binding_arr) > 0) {
		$main_sql->addBinding($binding_arr);
	}

    if ($sort_field != NULL && $sort_order != NULL) {
        $main_sql->orderBy($sort_field, $sort_order);
    }

    if ($single == TRUE) {
        $sql = $main_sql->first();
    } else {
        if ($limit !=   NULL)
            $sql = $main_sql->paginate($limit);
        else
            $sql = $main_sql->get();
    }
    $main_sql->get();
    $queries = DB::getQueryLog();
   // dd($queries); 
    return $sql;
}

public static function search_journal_keywords($jnlid, $searchKey = '', $hierachy=NULL,$search = TRUE,$limit=NULL,$start=NULL,$is_count=FALSE,$where =array())
{
	$classname = get_called_class();
	$table = (new $classname)->getTable();
	$keywords = DB::table($table);
	//$classname = get_called_class();
	//$table = (new $classname)->getTable();
	//$excludekeywords = DB::table($table);
	$excludekeywords = (new \App\Models\Excluded_journal_keywords())->getTable();
	$keywords_relationship = (new \App\Models\Keyword_relationship())->getTable();
	if($is_count == TRUE){
		$keywords->selectRaw('count(Distinct kwd_id) as cnt');
	}else{
		$keywords->distinct();
		$keywords->selectRaw('kwd_id,kwd_name,kwd_user_keyword');
	}
	
	//$db_handler->from(Keywords::$tbl_name);
	$keywords->join($keywords_relationship, 'kwdrl_kwd_id', '=', 'kwd_id');
	if($hierachy=="j")
	{
		$keywords->whereRaw('kwdrl_jnl_id=' . $jnlid);
	}
	else if($hierachy=="c")
	{
		$keywords->whereRaw('kwdrl_category_id NOT IN (SELECT `ejk_keyword_category` FROM ' .$excludekeywords . ' where ejk_jnl_id=' . $jnlid . ')', NULL, FALSE);
	}
	//$db_handler->join(Keyword_category::$tbl_name, 'kwd_category_id = kwc_id AND kwc_is_default="n"');
	//$db_handler->join(Excluded_journal_keywords::$tbl_name, 'ejk_keyword_category != kwc_id AND ejk_jnl_id=' . $jnlid);
	if($search == TRUE)
	{
		$keywords->whereRaw('kwd_name LIKE "%' . $searchKey . '%"');
		//$db_handler->where('kwd_name LIKE "' . $searchKey . '%"');
		
	}
	if(!empty($where))
		$keywords->whereRaw($where);
	if ($start !== NULL && $limit !== NULL){
		$keywords->limit($limit, $start);
	}elseif($is_count != TRUE){
		$keywords->limit(25);
	}

	
	if($is_count != TRUE){
		//$db_handler->order_by('kwd_name','LOCATE('.$searchKey.')');
		if($searchKey != ""){
			$keywords->orderBy('LOCATE(\''.$searchKey.'\', kwd_name) asc');
		}else{
			$keywords->orderBy('kwd_name','asc');
		}
	}
	$result = $keywords->get();
	//$queries = DB::getQueryLog();
	//dd($queries);
	//print_r($db_handler->last_query()); echo '<br/>';
	return $result;
}
public static function get_jnlsettings_catkeywords($select = '*', $single = FALSE, $condition = NULL, $limit = NULL, $group_by = NULL, $sort_field = NULL, $sort_order = NULL, $having = NULL, $journal_id= NULL)
{
$keyword_table = (new \App\Models\Keywords())->getTable();
$keyword_relationship_table = (new \App\Models\Keyword_relationship())->getTable();
$article_keyword_table = (new \App\Models\Article_keywords())->getTable();
$journal_table = (new \App\Models\Journals())->getTable();
$articles_table = (new \App\Models\Articles())->getTable();
$article_type_table = (new \App\Models\Article_types())->getTable();
$category_table = (new \App\Models\Keyword_category())->getTable();
DB::enableQueryLog();
$classname = get_called_class();
$table = (new $classname)->getTable();
$select .= ' , IF(tb1.cnt IS NOT NULL,tb1.cnt,0) as cnt,tb1.jnl_id ';
$subquery= ' (SELECT ak_keyword_id,jnl_id,COUNT(ak_id) as cnt from '.$article_keyword_table.' JOIN '.$articles_table.' ON art_id = ak_art_id JOIN '.$article_type_table.' ON artp_id = art_artp_id JOIN '.$journal_table.' ON jnl_id = artp_jnl_id WHERE jnl_id = '.$journal_id.' AND IF(art_transfer_article = "y",art_pre_all_ids IS NOT NULL,art_pre_all_ids IS NULL) group by ak_keyword_id,jnl_id) as tb1 ';
$main_sql = DB::table($keyword_table.' AS base_tb');
               $main_sql->selectRaw($select);
			   $main_sql->join($keyword_relationship_table,'kwdrl_kwd_id','=','base_tb.kwd_id');
			   $main_sql->join($category_table,'kwc_id','=','kwdrl_category_id');
				$main_sql->leftjoin(DB::raw($subquery),'ak_keyword_id','=','base_tb.kwd_id');

    if ($condition != NULL)
        $main_sql->whereRaw($condition);
    if ($group_by != NULL) {
        $main_sql->groupBy($group_by);
    }
    if ($having != NULL) {
        $main_sql->havingRaw($having);
    }

    if ($sort_field != NULL && $sort_order != NULL) {
        $main_sql->orderBy($sort_field, $sort_order);
    }

    if ($single == TRUE) {
        $sql = $main_sql->first();
    } else {
        if ($limit !=   NULL)
            $sql = $main_sql->paginate($limit);
        else
            $sql = $main_sql->get();
    }
    $main_sql->get();
    $queries = DB::getQueryLog();
   // dd($queries); 
    return $sql;
}
public static function get_user_keywords($user_id = NULL,$hierachy=NULL)
{
	$userKeyword_table = (new \App\Models\Userkeywords())->getTable();
	$keyword_relationship_table = (new \App\Models\Keyword_relationship())->getTable();
	$category_table = (new \App\Models\Keyword_category())->getTable();
	$journals_table = (new \App\Models\Journals())->getTable();
	$classname = get_called_class();
	$table = (new $classname)->getTable();
	$users = DB::table($table);
	$users->selectRaw('*');
	$users->join(DB::raw($userKeyword_table ), 'ukwd_kwd_id', '=', 'kwd_id');
	$users->join(DB::raw($keyword_relationship_table), 'kwdrl_kwd_id', '=', 'kwd_id');

	// $db_handler->join(User_keywords::$tbl_name, 'ukwd_kwd_id = kwd_id and ukwd_usr_id=' . $user_id);
	if ($hierachy == "c")
	{
		$users->join(DB::raw($category_table), 'kwdrl_category_id', '=', 'kwc_id');
	}
	else if ($hierachy == "j")
	{
		$users->join(DB::raw($journals_table), 'kwdrl_jnl_id', '=', 'jnl_id');
	}
	$users->whereRaw('ukwd_usr_id=' . $user_id);
	$users->groupBy('kwd_id');
	/* if ($user_id != NULL) {
	  $db_handler->join(User_keywords::$tbl_name, 'ukwd_kwd_id = kwd_id and ukwd_usr_id=' . $user_id, 'left', FALSE);
	  } */
	$data = $users->get();
	return $data;
}
/* Task #1295 Reduce the load time of profile keyword search */
public function userKeywords()
{
	return $this->hasMany(Userkeywords::class, 'ukwd_kwd_id', 'kwd_id');
}

public function keywordRelationships()
{
	return $this->hasMany(Keyword_relationship::class, 'kwdrl_kwd_id', 'kwd_id');
}
/* end Task #1295 Reduce the load time of profile keyword search */
/* Task #1180 Reduce the load time of manage keywords section*/
public function articleKeywords()
{
	return $this->hasMany(Article_keywords::class, 'ak_keyword_id', 'kwd_id'); //Added explicit foreign and local keys.
}

public function articles()
{
	return $this->belongsToMany(Articles::class, 'rvw_article_keywords', 'ak_keyword_id', 'ak_art_id');
}

public function journals()
{
	return $this->belongsToMany(Journals::class, 'rvw_keyword_relationship', 'kwdrl_kwd_id', 'kwdrl_jnl_id');
}
/*end Task #1180 Reduce the load time of manage keywords section*/
}
