<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Login_tracking extends BaseModel
{
use HasFactory;
public $table='rvw_login_tracking';
protected $primaryKey = 'ltk_id';
public static $colmn_prefix='ltk_';
public static $column_prefix = 'ltk_';
protected $fillable = [
'ltk_ip',
'ltk_posted_date',
'ltk_posted_by',
'ltk_action_type',
'ltk_id',
];

public static function get_last_login_info($user_id,$action_type="in")
{

    $classname = get_called_class();
    $table = (new $classname)->getTable();
    $result = DB::table($table);
    $result->selectRaw('ltk_ip,ltk_posted_date');
    $result->whereRaw("ltk_posted_by={$user_id}");
    $result->orderBy('ltk_id', 'DESC');
    $result->take(2);
    return $result->get();

}

public static function get_last_login_sus_ip($user_id)
{

    $classname = get_called_class();
    $table = (new $classname)->getTable();
    $result = DB::table($table);
    $result->selectRaw('ltk_ip,ltk_posted_date,ltk_id');
    $result->where("ltk_posted_by",$user_id);
    $result->orderBy('ltk_id', 'DESC');
    $result->take(1);
    return $result->get();

}
public static function fetch_login_tracks_data($select = '*',$condition = NULL, $bind_ar = array(),$limit =NULL)
{
   DB::enableQueryLog();
   $user_table = (new \App\Models\User())->getTable();
   $classname = get_called_class();
   $table = (new $classname)->getTable();
   $subquery  = '(SELECT MAX(ltk_id) ltk_id FROM '.$table.' GROUP BY ltk_posted_by) as t2';
   $result = DB::table($table, 't1');
   $result->selectRaw($select);
   $result->join(DB::raw($subquery), 't1.ltk_id','=' ,'t2.ltk_id');
   $result->join($user_table, 't1.ltk_posted_by','=','usr_id');
   $result->whereRaw($condition);
   if(!empty($bind_ar))
   {
    $result->setBindings($bind_ar);  
   }
   $result->orderBy('t1.ltk_id','DESC');
  return $result->paginate($limit);
}

public static function fetch_login_tracks_history($select,$condition, $bind_arr=array(),$limit=NULL)
  {
    DB::enableQueryLog();
    $classname = get_called_class();
    $table = (new $classname)->getTable();
    $result = DB::table($table);
    $result->selectRaw($select);
    $result->whereRaw($condition);
    if(!empty($bind_arr))
    {
    $result->setBindings($bind_arr);  
    }
    $result->orderBy('ltk_id','DESC');
   return $result->paginate($limit);
    //$res = $result->get();    
  }


}


