<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Payment_order extends BaseModel
{
    use HasFactory;
    public $table='rvw_payment_order';
    public static $column_prefix='pmt_ord_';
    protected $primaryKey ='pmt_ord_id';

    public static function get_payment_failed_records($select = '*', $condition='') 
    {
        $articles = (new \App\Models\Articles())->getTable();
        $article_type = (new \App\Models\Article_types())->getTable();
        $journals = (new \App\Models\Journals())->getTable();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $generic_table = (new \App\Models\Generic_flows())->getTable();

        $classname = get_called_class();
		$table = (new $classname)->getTable();

		$query = DB::table($table)
                ->selectRaw(DB::raw($select))
                ->join($articles,'art_id','=','pmt_ord_art_id')
                ->join($article_type,'artp_id','=','art_artp_id')
                ->join($journals,'artp_jnl_id','=','jnl_id')
                ->join($article_flow_table,'aflw_art_id','=','pmt_ord_art_id')
                ->join($generic_table,'aflw_jwf_id','=','jwf_id')
                ->where('art_delete_status', 'n')
                ->whereRaw($condition);
            return $query->get();
	}
}
