<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Reports_model extends BaseModel
{
    use HasFactory;
    public $table = 'rvw_reports_v3';
    public static $tbk_table = 'tbk_reports_v3';
    public static $column_prefix = 'rep_';
    protected $primaryKey = 'rep_id';

    protected $guarded = [];

    public static function get_report_list($report_columns = '', $folder_columns = '', $report_criteria = '', $folder_criteria = '', $common_having_criteria = '', $sort_field = NULL, $sort_order = NULL, $limit = NULL)
    {
        $main_sql = array();
        $classname = get_called_class();
        $report_table = (new $classname)->getTable();
        $usersTable = (new \App\Models\User)->getTable();
        $folder_table = (new \App\Models\Reports_folder_model())->getTable();

        $report_sql = DB::table($report_table . ' AS rep')
            ->selectRaw(DB::raw($report_columns))
            ->leftjoin($usersTable, 'rep_posted_by', '=', 'usr_id')
            ->whereRaw($report_criteria);

        $folder_sql = DB::table($folder_table . ' AS fol')
            ->selectRaw(DB::raw($folder_columns))
            ->leftjoin($usersTable, 'rfld_posted_by', '=', 'usr_id')
            ->whereRaw($folder_criteria);

        if($common_having_criteria != ''){
            $report_sql->havingRaw($common_having_criteria);
            $folder_sql->havingRaw($common_having_criteria);
        }

        $main_sql = $folder_sql->unionALL($report_sql);
        $main_sql->orderBy('type', 'DESC');
        if ($sort_field != NULL && $sort_order != NULL) {
            $main_sql->orderBy(DB::raw($sort_field), $sort_order);
        }

        if ($limit != NULL) {
        $result = $main_sql->paginate($limit);
        } else {
            $result = $main_sql->paginate(1000);
        }
        // $result = $main_sql->get();
        // print_r($result);die;
        return $result;
    }
    public static function get_posted_by(){
        $main_sql = array();
        $classname = get_called_class();
        $report_table = (new $classname)->getTable();
        $usersTable = (new \App\Models\User)->getTable();
        $folder_table = (new \App\Models\Reports_folder_model())->getTable();
        $select_fields = 'DISTINCT(usr_id) as usr_id,CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as usr_full_name';

        $report_sql = DB::table($report_table . ' AS rep')
            ->selectRaw(DB::raw( $select_fields ))
            ->leftjoin($usersTable, 'rep_posted_by', '=', 'usr_id')
            ->whereRaw('rep_parent is NULL');

        $folder_sql = DB::table($folder_table . ' AS fol')
            ->selectRaw(DB::raw($select_fields))
            ->leftjoin($usersTable, 'rfld_posted_by', '=', 'usr_id');
        
        $main_sql = $folder_sql->union($report_sql);
        $result = $main_sql->get();
        return $result;
    }
}
