<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Required_file_type extends BaseModel
{
    use HasFactory;
    public  $table = "rvw_required_file_types";
	public static $column_prefix = 'rft_';
    protected $primaryKey ='rft_id';

    public static function get_file_description($select='*', $where=array(),$where_str=null)
	{
		
        try{
			// DB::enableQueryLog();
				$classname = get_called_class();
				$table = (new $classname)->getTable();
				$result = DB::table($table);
				$attachmentfiledesc = (new \App\Models\Attachment_file_description())->getTable();
				$result->selectRaw("DISTINCT {$select}");
				$result->join($attachmentfiledesc, 'afdec_id', '=' ,'rft_file_desp_id');
				if(is_array($where))
				{
					$result->where($where);	
				}
				else
				{
					$result->whereRaw($where);
				}
				if($where_str != null)
				{
					$result->whereRaw($where_str);
				}
				return $result->get();	
        }
		catch (\Exception $e) {
            return  $this->failure('Failed',500,$e);
        }
	}
	public static function copy_journal_description($insert_fields, $select_fields, $jnlSettingsData)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$column_prefix = (new $classname)::$column_prefix;
		$sql = 'INSERT INTO ' . $table . ' (' . $insert_fields . ')' .
			' SELECT ' . $select_fields . ' FROM ' . $table . ' WHERE  ' . $column_prefix . 'artp_id is null and  '. $column_prefix . 'jnl_id=' . $jnlSettingsData['old_jnl_id'] ;
		$result = DB::select($sql);
		$id = DB::connection()->getPdo()->lastInsertId();		
		return $id;
		
	}
	public static function copy_article_type_description($insert_fields, $select_fields, $oldArticle_id)
	{
		$classname = get_called_class();
		$tbl_name = (new $classname)->getTable();
		$column_prefix = (new $classname)::$column_prefix;

		$sql = 'INSERT INTO ' . $tbl_name . ' (' . $insert_fields . ')' .
			' SELECT ' . $select_fields . ' FROM ' . $tbl_name . ' WHERE  ' . $column_prefix . 'artp_id=' . $oldArticle_id ;
			$result = DB::select($sql);
		$id = DB::connection()->getPdo()->lastInsertId();		
		return $id;
	}

}