<?php

/*
* Task #925 model for Manage Research Integrity Api 
*/

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Research_integrity_reports extends BaseModel
{
    use HasFactory;

    public $table = 'rvw_research_integrity_reports';
    public static $column_prefix='rri_';
    protected $primaryKey ='rri_id';

    public static function get_latest_research_integrity_report(int $art_id)
	{
        $classname      =   get_called_class();
        $table          =   (new $classname)->getTable();
        $attachments    =   (new \App\Models\Attachment_files())->getTable();
        $attach_desc    =   (new \App\Models\Attachment_file_description)->getTable();

        //atmnt_file_name
        $rri = DB::table($table);
        $rri->selectRaw($table.".*, atmnt_file_name, afdec_description");
        $rri->leftjoin($attachments, 'atmnt_id', '=' ,'rri_atmnt_id');
        $rri->leftjoin($attach_desc, 'afdec_id', '=' ,'atmnt_label');

        if($art_id){
            $rri->where('rri_art_id', '=', $art_id);
        }
        $rri->orderBy('rri_id', 'desc');
        $rri = $rri->first();
        return $rri;
	}

    public static function get_research_integrity_report_history($art_id, $recent_rri_id)
    {
        $table          =   'tbk_research_integrity_reports';

        // $rri = DB::table($table);
        // $rri->selectRaw($table.".*");
        // if($art_id){
        //     $rri->where('rrri_art_id', '=', $art_id);
        //     $rri->where('rri_id', '!=', $recent_rri_id);
        //     $rri->where('rri_status', '=', 'y');
        //     $rri->where('rri_new_report', '=', 'y');
        // }
        // $rri->orderBy('rri_id', 'desc');
        // $rri = $rri->get();
        // return $rri;

        //below changes by rebin
        return Research_integrity_reports::get_records_by_raw_query("SELECT tbk_research_integrity_reports.*
                                    FROM `tbk_research_integrity_reports`
                                    WHERE `rri_art_id` = $art_id
                                    AND `rri_status` = 'y'
                                    AND `rri_new_report` = 'y'
                                    AND `rri_operation` = 'u'
                                    AND `tbk_id` < (
                                        SELECT MAX(`tbk_id`)
                                        FROM `tbk_research_integrity_reports`
                                        WHERE `rri_art_id` = $art_id
                                        AND `rri_status` = 'y'
                                        AND `rri_new_report` = 'y'
                                        AND `rri_operation` = 'u'
                                    )
                                    ORDER BY `tbk_id` DESC;
                                    ");
        //  AND rri_id != $recent_rri_id
    }
}
