<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Config;
use DB;
class Roles extends BaseModel
{
    function __construct()
	{
		parent::__construct();
	}
    public $table='rvw_roles';
    protected $primaryKey = 'role_id';
    public static $column_prefix='role_';
    protected $fillable = [
        'role_name',
        'role_assigned_role',
        'role_used_in',
        'role_oa_discount_enabled',
        'role_adhoc_role_status'
    ];
    use HasFactory;

    public static function get_role_ids($condition)
	{
        $classname=get_called_class();
        $table=(new $classname)->getTable();
        $result = DB::table($table);
        $result->selectRaw("GROUP_CONCAT(role_id SEPARATOR';')role_ids");
        $result->whereRaw($condition);  
        return $result->first();     
       
    }

    public static function get_roles_data($condition = array())
	{


        $classname=get_called_class();
        $table=(new $classname)->getTable();
        $result = DB::table($table);
        $result->selectRaw("role_id");
        $result->whereIn('role_assigned_role', $condition); 
       return $result->get();
    }
    public static function get_oa_discount_enabled_roles($fields, $condition = array('role_oa_discount_enabled' => 'y'))
	{
        $classname=get_called_class();
        $table=(new $classname)->getTable();
        $result = DB::table($table);
        $user_to_journal_table=(new \App\Models\User_to_journals())->getTable();
        $result->distinct();
		$result->selectRaw($fields);
		$result->join($user_to_journal_table, 'usrj_role_id', '=','role_id');
        $result->whereRaw($condition);
		$result = $result->get();
		return $result;
	}

    public static function get_role_name($id)
    {
        $classname=get_called_class();
        $table=(new $classname)->getTable();
        $result = DB::table($table);
        $result->selectRaw('role_name');
        $result->whereRaw('role_id IN ('.$id.')');
        return $result->get()->first();
        
        
    }
    //Function to check roles are used in email templates
    //TASK #8773 Please add a warning message to delete a role if the role already used in a email template
    public static function isRoleInUse($roleName)
    {
        // Tables, fields, and template name fields to check
        $tablesToCheck = [
            [
                'table' => (new \App\Models\Email_templates())->getTable(),
                'fields' => ['etmp_notification', 'etmp_cc', 'etmp_bcc'],
                'template_name_field' => 'etmp_name',
                'stage_name_function' => true, // Indicate this table requires stage name function
            ],
            [
                'table' => (new \App\Models\Stage_email_templates())->getTable(),
                'fields' => ['stage_etmp_to', 'stage_etmp_cc', 'stage_etmp_bcc'],
                'template_name_field' => 'stage_etmp_name',
                'stage_name_function' => false,
            ],
            [
                'table' => (new \App\Models\Article_notification_emails())->getTable(),
                'fields' => ['ane_to', 'ane_cc', 'ane_bcc'],
                'template_name_field' => 'ane_template_name',
                'stage_name_function' => false,
            ],
            [
                'table' => (new \App\Models\Adhoc_notification_emails())->getTable(),
                'fields' => ['ade_to', 'ade_cc', 'ade_bcc'],
                'template_name_id' => 'ade_template_id',
            ],
            [
                'table' => (new \App\Models\Article_autoinvitation_emails())->getTable(),
                'fields' => ['aae_to', 'aae_cc', 'aae_bcc'],
                'template_name_field' => 'aae_template_name',
                'stage_name_function' => false,
            ],
        ];
    
        $classname = get_called_class();
        $table = (new $classname)->getTable();
    
        // Check if the role exists in the main roles table
        $roleExists = DB::table($table)
                        ->where('role_name', $roleName)
                        ->exists();
    
        if (!$roleExists) {
            return false; // Role does not exist
        }
    
        $templatesInUse = [];
    
        // Check each table for the role name
        foreach ($tablesToCheck as $tableInfo) {
            $table = $tableInfo['table'];
            $fields = $tableInfo['fields'];

            if (isset($tableInfo['template_name_field'])) {
                $templateNameField = $tableInfo['template_name_field'];
                $requiresStageName = $tableInfo['stage_name_function'] ?? false;
                $query = DB::table($table)->select($templateNameField);

                foreach ($fields as $field) {
                    $query->orWhere($field, '=', $roleName)
                          ->orWhere($field, 'LIKE', '%"'.$roleName.'"%');
                }

                $results = $query->distinct()->pluck($templateNameField);

                if ($results->isNotEmpty()) {
                    foreach ($results as $templateName) {
                        if ($requiresStageName) {
                            $controller = new \App\Http\Controllers\Manage_Staged_Emails_Api();
                            $templatesInUse[] = $controller->get_stage_name($templateName);
                        } else {
                            $templatesInUse[] = $templateName;
                        }
                    }
                }

            } elseif (isset($tableInfo['template_name_id']) && $table === (new \App\Models\Adhoc_notification_emails())->getTable()) {
                $templateIdField = $tableInfo['template_name_id'];

                $query = DB::table($table)
                    ->join('rvw_email_tmpls', "$table.$templateIdField", '=', 'rvw_email_tmpls.etmp_id')
                    ->select('rvw_email_tmpls.etmp_templete_name');

                foreach ($fields as $field) {
                    $query->orWhere("$table.$field", '=', $roleName)
                          ->orWhere("$table.$field", 'LIKE', '%"'.$roleName.'"%');
                }

                $results = $query->distinct()->pluck('rvw_email_tmpls.etmp_templete_name');

                if ($results->isNotEmpty()) {
                    foreach ($results as $templateName) {
                        $templatesInUse[] = $templateName;
                    }
                }
            }
        }
        return !empty($templatesInUse) ? $templatesInUse : false; // Return templates or false if none
    }

    
}
