<?php

namespace App\Models;

use App\Http\Traits\JournalUserfunctionTrait;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use \stdClass;

class Stage_email_templates extends BaseModel
{
    use JournalUserfunctionTrait;
    use HasFactory;

    public $table = 'rvw_stage_email_tmpls';
    public static $column_prefix = 'stage_etmp_';
    protected $primaryKey = 'stage_etmp_id';

//get journal setting date format based article id
    public static function get_journal_settings_date_format($article_id = null)
    {
        $result = new stdClass();
        $article_table = (new \App\Models\Articles())->getTable();
        $article_types_table = (new \App\Models\Article_types())->getTable();
        $journal_settings_table = (new \App\Models\Journal_settings())->getTable();
        if ($article_id != null) {
            $query = 'select jset_date_format FROM ' . $article_table . ' INNER JOIN ' . $article_types_table . ' ON ' . $article_table . '.art_artp_id = ' . $article_types_table . '.artp_id INNER JOIN ' . $journal_settings_table . ' ON ' . $journal_settings_table . '.jset_jnl_id = ' . $article_types_table . '.artp_jnl_id WHERE ' . $article_table . '.art_id = ' . $article_id;
            $result = Articles::get_records_by_raw_query($query);
        }
        return $result;

    }

    public static function get_stagewise_generic_form_data($stage_name, $article_id, $journal_code,$jnl_id ,$date_format = 'd-m-y')
    {
        /*get table names  start*/
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $user_table = (new \App\Models\User())->getTable();
        $roles_table = (new \App\Models\Roles())->getTable();
        $article_generic_form_data_table = (new \App\Models\Article_generic_form_data())->getTable();
        /*get table names end */

        $where = '(((aflw_status = "c" OR aflw_status = "a") AND jwf_assignment != "invitation") OR (aflw_status = "c" AND jwf_assignment = "invitation")) AND `gdata_artflw_stage_repeat_count` = `aflw_stage_repeat_count` AND jwf_stage_name = "' . $stage_name . '" AND aflw_art_id = ' . $article_id . ' AND gdata_unique_identifier IS NOT NULL AND aflw_level = (SELECT max(aflw_level) from ' . $article_flow_table . ' INNER JOIN ' . $generic_flow_table . ' ON aflw_jwf_id = jwf_id where aflw_art_id = ' . $article_id . ' AND jwf_stage_name = "' . $stage_name . '")';
        $query = DB::table($article_generic_form_data_table . '_'.$journal_code)
            ->selectRaw('DATE_FORMAT(gdata_posted_date, "' . $date_format . ' %h:%i") as gdata_posted_date,gdata_label,gdata_id, gdata_data,gdata_display_data, gdata_element_type,gdata_unique_identifier,(select CONCAT(usr_first_name," ",usr_last_name) as posted_user FROM ' . $user_table . ' WHERE usr_id = aflw_usr_id) as posted_user,(select role_name as user_role FROM ' . $roles_table . ' WHERE role_id = jwf_role_id) as user_role')
            ->join($article_flow_table, 'aflw_id', '=', 'gdata_artflw_id')
            ->join($generic_flow_table, 'jwf_id', '=', 'aflw_jwf_id')
            ->whereRaw($where)
            ->orderBy(DB::raw("aflw_posted_date,gdata_posted_date,gdata_id"), "asc")
            ->get();
        $queries = DB::getQueryLog();
        //  dd($queries);
        return $query;
    }

    public static function get_stage_email_tmpl_to_trigger($select = '*', $criteria = NULL)
	{
        DB::enableQueryLog();
        $email_reference_table = (new \App\Models\Stage_email_tmpl_reference())->getTable();
        $classname = get_called_class();
		$table = (new $classname)->getTable();
		$stage_type = DB::table($table);
        $stage_type->selectRaw($select);
		$stage_type->join($email_reference_table, 'stage_etmp_id', '=', 'setr_stage_etmp_id');
        if(!empty($criteria))
			$stage_type->whereRaw($criteria);
		$stage_type->whereRaw('stage_etmp_to IS NOT NULL');
		$stage_type->groupBy('stage_etmp_id');
		$result = $stage_type->get();
		$queries = DB::getQueryLog();
		    //  dd($queries); die;
		return $result;
	}

    public static function get_generic_form_data_files($article_id, $journal_code,$jwf_id) {

        //DB::enableQueryLog();
        $classname = get_called_class();
		$table = (new $classname)->getTable();
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
		$user_table = (new \App\Models\User())->getTable();
		$roles_table = (new \App\Models\Roles())->getTable();
        $article_generic_form_data_table = (new \App\Models\Article_generic_form_data())->getTable();
        $stageemail =DB::table($article_generic_form_data_table . '_'.$journal_code);
        $stageemail->selectRaw('gdata_id,gdata_label,gdata_element_type, gdata_data, gdata_unique_identifier,(select CONCAT(usr_first_name," ",usr_last_name) as posted_user FROM '.$user_table.' WHERE usr_id = aflw_usr_id) as posted_user,(select role_name as user_role FROM '.$roles_table.' WHERE role_id = jwf_role_id) as user_role');
        $stageemail->join($article_flow_table, 'aflw_id','=', 'gdata_artflw_id');
		$stageemail->join($generic_flow_table, 'jwf_id', '=', 'aflw_jwf_id');
		$where = 'gdata_artflw_stage_repeat_count = aflw_stage_repeat_count AND jwf_id = "'. $jwf_id . '" AND aflw_art_id = ' . $article_id . ' AND gdata_unique_identifier IS NOT NULL AND aflw_level = (SELECT max(aflw_level) from rvw_article_flow INNER JOIN rvw_journal_workflows ON aflw_jwf_id = jwf_id where aflw_art_id = ' . $article_id . ' AND jwf_id = "'. $jwf_id . '") AND gdata_element_type = \'file\' AND gdata_unique_identifier LIKE "RV_ATTACHMENT_TO_AUTHOR_%" and aflw_status="c" ';
		$stageemail->whereRaw($where);
        $result = $stageemail->get();
		//$queries = DB::getQueryLog();
       //  dd($queries);
		return $result;
	}
	public static function get_generic_form_data_files_allcustoms($article_id, $journal_code,$jwf_id) {

        DB::enableQueryLog();
        $classname = get_called_class();
		$table = (new $classname)->getTable();
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $article_generic_form_data_table = (new \App\Models\Article_generic_form_data())->getTable();
        $stageemail =DB::table($article_generic_form_data_table . '_'.$journal_code);
		$stageemail->selectRaw('gdata_id,gdata_label,gdata_element_type,gdata_user_roles,gdata_data,gdata_dynamic_status,gdata_unique_identifier');// Task #260 Files Uploaded via Custom Form Not Appearing in File Inventory
        $stageemail->join($article_flow_table, 'aflw_id','=', 'gdata_artflw_id');
		$stageemail->join($generic_flow_table, 'jwf_id', '=', 'aflw_jwf_id');
		//$where = 'gdata_artflw_stage_repeat_count = aflw_stage_repeat_count AND jwf_id = "'. $jwf_id . '" AND aflw_art_id = ' . $article_id . '  AND gdata_element_type = \'file\' ';

		$where = array(
			'gdata_artflw_stage_repeat_count' => 'aflw_stage_repeat_count',
			'jwf_id' => $jwf_id,
			'aflw_art_id' => $article_id,
			'gdata_element_type' => 'file'
		);
		$stageemail->where($where);
        $result = $stageemail->get();
	 //$queries = DB::getQueryLog();
        // dd($queries);
		return $result;
	}
    public static function get_author_data($author_config, $article_id, $join_condition, $join_dependencies, $auth_id = 0) {
		// if (self::$db_trans !== NULL) {
		// 	$db_handler = &self::$db_trans;
		// } else {
		// 	$db_handler = &$this->db;
		// }
		$select = '';
		$join = '';
		$join_criteria = '';
		$group_by_flag = 0;
		$group_by_str = '';
		$join_arr = array();
		$group_by_criteria = '';
		foreach ($author_config as $aukey => $auval) {
			foreach ($auval['select'] as $akey => $aval) {
				$select .= $aval . ' as ' . $aukey . ',';
				if (isset($auval['group_by']) && $auval['group_by'] == true) {
					$group_by_flag = 1;
				} else {
					$group_by_str .= '`' . $aukey . '`,';
				}
			}
			if (isset($em_val['join'])) {

			}
			if (isset($auval['join'])) {
				foreach ($join_condition[$auval['join']] as $joins) {
					$join_arr[] = $joins;
				}

			}
		}
		$select = rtrim($select, ',');
		if (count($join_arr) > 0) {
			$join_keys = array_intersect(array_keys($join_dependencies), $join_arr);

			foreach ($join_keys as $join_value) {
				$join = $join_dependencies[$join_value];
				$join_criteria .= ' ' . $join['type'] . ' JOIN ' . $join['table'] . ' ON ' . $join['on'] . ' ';
			}
		}
		if ($group_by_str != '' && $group_by_flag == 1) {
			$group_by_str = rtrim($group_by_str, ',');
			$group_by_arr = explode(',', $group_by_str);
			$org_group_by_arr = array_unique($group_by_arr);
			$group_by = implode(',', $org_group_by_arr);
			$group_by_criteria = ' GROUP BY ' . $group_by;
		}
		$sql = 'SELECT ' . $select . ' FROM rvw_article_authors ' . $join_criteria . ' WHERE auth_art_id=' . $article_id;
		if ($auth_id > 0) {
			$sql .= ' AND auth_id = ' . $auth_id;
		} else {
			$sql .= ' AND auth_corr_author = "y"';
		}
		$sql .= $group_by_criteria;
		return DB::select($sql);
	}
    public  static function get_recipient_data($user_config, $user_id, $additional_condi = NULL, $core_role = NULL,$core_role_name= NULL, $current_user_role_data = NULL) {
		// if (self::$db_trans !== NULL) {
		// 	$db_handler = &self::$db_trans;
		// } else {
		// 	$db_handler = &$this->db;
		// }
		$master_table =  (new \App\Models\User)->getTable();
		$select = '';
		$where = "usr_id ='{$user_id}'";
		$join_criteria = '';
		$group_by_str = '';
		$group_by_criteria = '';
		$group_by_flag = 0;
		$join_arr =array();
		foreach ($user_config as $usr_key => $usr_val) {
			if (isset($usr_val['select'])) {
				$select .= $usr_val['select'] . ' as ' . $usr_key . ',';
				if (isset($usr_val['group_by']) && $usr_val['group_by'] == true) {
					$group_by_flag = 1;
				} else {
					$group_by_str .= '`' . $usr_key . '`,';
				}
			}
			if (isset($usr_val['join']) && $usr_key != 'RECIPIENT_NAME_WITH_FLAG') {

				if(!in_array($usr_val['join'],$join_arr))
				{
					array_push($join_arr,$usr_val['join']);
					$join_criteria .= $usr_val['join'];
				}
			}
			if (isset($additional_condi) && $additional_condi != NULL && $usr_key == 'CURRENT_USER_ROLE') {
				if(isset($current_user_role_data['assigned_role'])&&isset($current_user_role_data['role_id']))
				{
					$additional_condi['role_assigned_role'] = $current_user_role_data['assigned_role'];
					$additional_condi['current_role_id'] = $current_user_role_data['role_id'];
				}
				// else
				// {
				// 	$role_assigned_role = $additional_condi['role_assigned_role'];
				// 	$usrj_role_id = $additional_condi['current_role_id'];
				// }
				if(!empty($core_role) && $core_role != $additional_condi['role_assigned_role'])
				{
					$where .= ' AND usrj_artp_id = ' . $additional_condi['artp_id'] . ' AND role_name = \'' . $core_role_name. '\'';
				}
				else
				{
					$where .= ' AND usrj_artp_id = ' . $additional_condi['artp_id'] . ' AND role_assigned_role = \'' . $additional_condi['role_assigned_role'] . '\' AND  usrj_role_id='.$additional_condi['current_role_id'];
				// $where .= ' AND usrj_artp_id = ' . $additional_condi['artp_id'] . ' AND role_assigned_role = \'' . $role_assigned_role . '\' AND  usrj_role_id='.$usrj_role_id;

				}
			}
			if (isset($usr_val['group_by'])) {
				$group_by_str .= $usr_val['group_by'] . ',';
			}
		}
		if(array_key_exists('RECIPIENT_COUNTRY', $user_config) || array_key_exists('CURRENT_USER_COUNTRY', $user_config)||array_key_exists('MERGED_USER_COUNTRY', $user_config))
			$join_criteria.= ' LEFT JOIN rvw_country ON rvw_country.cnt_id = rvw_user_affiliation.usaff_cnt_id ';
		if(array_key_exists('RECIPIENT_NAME_WITH_FLAG', $user_config))
			$join_criteria .= $user_config['RECIPIENT_NAME_WITH_FLAG']['join'];
		if($select == ''){
			return;
		}
		$select = rtrim($select, ',');
		if ($group_by_str != '' && $group_by_flag == 1) {
			$group_by_str = rtrim($group_by_str, ',');
			$group_by_arr = explode(',', $group_by_str);
			$org_group_by_arr = array_unique($group_by_arr);
			$group_by = implode(',', $org_group_by_arr);
			$group_by_criteria = ' GROUP BY ' . $group_by;
		}
		$sql = 'SELECT usr_id, ' . $select . ' FROM ' . $master_table . ' ' . $join_criteria . ' WHERE ' . $where . $group_by_criteria;
		return DB::select($sql);
	}
    public static function get_usr_jnl_data($usr_id, $jnl_id, $usr_jnl_config, $join_condition, $join_dependencies) {

		// if (self::$db_trans !== NULL) {
		// 	$db_handler = &self::$db_trans;
		// } else {
		// 	$db_handler = &$this->db;
		// }
        $userjournal_table = (new \App\Models\User_to_journals())->getTable();

		$select = '';
		$join = '';
		$join_criteria = '';
		$group_by_flag = 0;
		$group_by_str = '';
		$join_arr = array();
		$group_by_criteria = '';
		foreach ($usr_jnl_config as $tag_key => $tag_val) {
			if (isset($tag_val['select'])) {
				$select .= $tag_val['select'] . ' as ' . $tag_key . ',';
				if (isset($tag_val['group_by']) && $tag_val['group_by'] == true) {
					$group_by_flag = 1;
				} else {
					$group_by_str .= '`' . $tag_key . '`,';
				}
			}
			if (isset($tag_val['join'])) {
				foreach ($join_condition[$tag_val['join']] as $joins) {
					$join_arr[] = $joins;
				}
			}
		}
		$select = rtrim($select, ',');
		if (count($join_arr) > 0) {
			$join_keys = array_intersect(array_keys($join_dependencies), $join_arr);

			foreach ($join_keys as $join_value) {
				$join = $join_dependencies[$join_value];
				$join_criteria .= ' ' . $join['type'] . ' JOIN ' . $join['table'] . ' ON ' . $join['on'] . ' ';
			}
		}
		if ($group_by_str != '' && $group_by_flag == 1) {
			$group_by_str = rtrim($group_by_str, ',');
			$group_by_arr = explode(',', $group_by_str);
			$org_group_by_arr = array_unique($group_by_arr);
			$group_by = implode(',', $org_group_by_arr);
			$group_by_criteria = ' GROUP BY ' . $group_by;
		}
		$where_condition='';
		if(isset($usr_id)&&$usr_id!=NULL)
		{
			//TASK #8600
		$where_condition.='usrj_usr_id='.$usr_id . ' AND ';
		}
		// $where_condition.='usrj_jnl_id=' . $jnl_id . ' AND usrj_artp_id IS NULL ' . $group_by_criteria;
		$where_condition.='usrj_jnl_id= ? AND usrj_artp_id IS NULL ' . $group_by_criteria;
		$sql = 'SELECT ' . $select . ' FROM '. $userjournal_table . $join_criteria . ' WHERE '.$where_condition; 
     
		// return DB::select($sql);
		return DB::select($sql,[$jnl_id]);
	}
    public static function get_usr_artp_data($usr_id, $artp_id, $usr_jnl_artp_config, $join_condition, $join_dependencies) {
		// if (self::$db_trans !== NULL) {
		// 	$db_handler = &self::$db_trans;
		// } else {
		// 	$db_handler = &$this->db;
		// }
        $userjournal_table = (new \App\Models\User_to_journals())->getTable();
		$select = '';
		$join = '';
		$join_criteria = '';
		$group_by_flag = 0;
		$group_by_str = '';
		$join_arr = array();
		$group_by_criteria = '';
		foreach ($usr_jnl_artp_config as $tag_key => $tag_val) {
			if (isset($tag_val['select'])) {
				$select .= $tag_val['select'] . ' as `' . $tag_key . '`,';
				if (isset($tag_val['group_by']) && $tag_val['group_by'] == true) {
					$group_by_flag = 1;
				} else {
					$group_by_str .= '`' . $tag_key . '`,';
				}
			}
			if (isset($tag_val['join'])) {
				foreach ($join_condition[$tag_val['join']] as $joins) {
					$join_arr[] = $joins;
				}
			}
		}
		$select = rtrim($select, ',');
		if (count($join_arr) > 0) {
			$join_keys = array_intersect(array_keys($join_dependencies), $join_arr);

			foreach ($join_keys as $join_value) {
				$join = $join_dependencies[$join_value];
				$join_criteria .= ' ' . $join['type'] . ' JOIN ' . $join['table'] . ' ON ' . $join['on'] . ' ';
			}
		}
		if ($group_by_str != '' && $group_by_flag == 1) {
			$group_by_str = rtrim($group_by_str, ',');
			$group_by_arr = explode(',', $group_by_str);
			$org_group_by_arr = array_unique($group_by_arr);
			$group_by = implode(',', $org_group_by_arr);
			$group_by_criteria = ' GROUP BY ' . $group_by;
		}
		$sql = 'SELECT ' . $select . ' FROM '.$userjournal_table . $join_criteria . ' WHERE usrj_usr_id=' . $usr_id . ' AND usrj_artp_id=' . $artp_id . $group_by_criteria;

        return DB::select($sql);
	}
    public static function get_user_role_data($userrole_tags, $user_role_config, $jnl_id, $artp_id,$art_id=NULL) {
		// if (self::$db_trans !== NULL) {
		// 	$db_handler = &self::$db_trans;
		// } else {
		// 	$db_handler = &$this->db;
		// }
        $role_table = (new \App\Models\Roles())->getTable();
        $country_table=(new \App\Models\Country())->getTable();
        $affiliation_table = (new \App\Models\User_affiliations())->getTable();
        $users_table = (new \App\Models\User())->getTable();
        $user_articles_table = (new \App\Models\User_articles())->getTable();
        $user_journal_table= (new \App\Models\User_to_journals())->getTable();

		$select = ' count(*) as cnt,';
		$join = '';
		$org_userrole = '';
		$condition = '';
		$group_by_str = '';
		$group_by_criteria = '';
		$group_by_flag = 0;
		$join_country_table = 0;
		foreach ($userrole_tags as $role_key => $role_value) {
			$user_role_tag = explode('_', $role_value);
			$last_tag_value = $user_role_tag[count($user_role_tag) - 1];
			if(isset($user_role_config[$last_tag_value])) {
				$userrole_data = $user_role_config[$last_tag_value];
				if($last_tag_value == 'COUNTRY')
					$join_country_table = 1;
				foreach ($userrole_data['select'] as $role) {
					$select .= $role . ' AS `' . $role_value . '`,';
					if (isset($userrole_data['group_by']) && $userrole_data['group_by'] == true) {
						$group_by_flag = 1;
					} else {
						$group_by_str .= '`' . $role_value . '`,';
					}
				}
				if (isset($userrole_data['join'])) {
					$join = $userrole_data['join'];
				}
			}
			array_shift($user_role_tag);
			array_pop($user_role_tag);
			$org_userrole = implode('_', $user_role_tag);
			$condition .= $role_table.'.role_name ="' . $org_userrole . '" OR ';
		}
		if($join_country_table == 1)
			$join .= ' LEFT JOIN '.$country_table.' ON '.$country_table.'.cnt_id = '. $affiliation_table .'.usaff_cnt_id ';
		$select = rtrim($select, ',');
		$condition = rtrim($condition, ' OR');
		if ($group_by_str != '' && $group_by_flag == 1) {
			$group_by_str = rtrim($group_by_str, ',');
			$group_by_arr = explode(',', $group_by_str);
			$org_group_by_arr = array_unique($group_by_arr);
			$group_by = implode(',', $org_group_by_arr);
			$group_by_criteria = ' GROUP BY ' . $group_by;
		}
		$result = new stdClass();
		if($art_id != NULL){
			$end = ($condition == '') ? '' : ' ) ';
			$and = ($condition == '') ? '' : ' AND ( ';
			$sql = 'SELECT ' . $select . ' FROM  '.$users_table.' INNER JOIN '.$user_articles_table.' ON '.$user_articles_table.'.usra_usr_id='.$users_table.'.usr_id
INNER JOIN '. $role_table.' ON '. $role_table.'.role_id='.$user_articles_table.'.usra_role_id   '. $join . ' WHERE '.$user_articles_table.'.usra_art_id=' . $art_id.$and. $condition . $end.$group_by_criteria;

			$result = DB::select($sql);
		}
		if(empty($result) || (isset($result[0]->cnt) && $result[0]->cnt == 0) ){
			$sql = 'SELECT ' . $select . ' FROM  '. $users_table.' INNER JOIN '.$user_journal_table.' ON '.$user_journal_table.'.usrj_usr_id='.$users_table.'.usr_id
INNER JOIN '. $role_table.' ON '. $role_table.'.role_id='.$user_journal_table.'.usrj_role_id AND '.$user_journal_table.'.usrj_jnl_id=' . $jnl_id . ' AND '.$user_journal_table.'.usrj_artp_id=' . $artp_id . $join . ' WHERE usrj_role_retired=\'n\' AND ' . $condition . $group_by_criteria;

$result = DB::select($sql);

		}

		return $result;
	}
    public static function get_epa_user_data($jnl_epa_tags, $jnl_id) {
		// if (self::$db_trans !== NULL) {
		// 	$db_handler = &self::$db_trans;
		// } else {
		// 	$db_handler = &$this->db;
		// }
        $country_table=(new \App\Models\Country())->getTable();
        $affiliation_table = (new \App\Models\User_affiliations())->getTable();
        $journal_settings_table = (new \App\Models\Journal_settings())->getTable();

		$master_table =(new \App\Models\User)->getTable();

		$select = '';
		$join_criteria = '';
		$group_by_str = '';
		$group_by_criteria = '';
		$group_by_flag = 0;
		foreach ($jnl_epa_tags as $epa_key => $epa_val) {
			if (isset($epa_val['select'])) {
				$select .= $epa_val['select'] . ' as ' . $epa_key . ',';
				if (isset($epa_val['group_by']) && $epa_val['group_by'] == true) {
					$group_by_flag = 1;
				} else {
					$group_by_str .= '`' . $epa_key . '`,';
				}
			}
			if (isset($epa_val['join'])) {
				$join_criteria = $epa_val['join'];
			}
			if (isset($epa_val['group_by'])) {
				$group_by_str .= $epa_val['group_by'] . ',';
			}
		}
		if(array_key_exists('JOURNAL_EPA_COUNTRY', $jnl_epa_tags))
			$join_criteria.= ' LEFT JOIN '.$country_table.' ON '.$country_table.'.cnt_id = '.$affiliation_table.'.usaff_cnt_id ';
		if($select == ''){
			return;
		}
		$select = rtrim($select, ',');
		if ($group_by_str != '' && $group_by_flag == 1) {
			$group_by_str = rtrim($group_by_str, ',');
			$group_by_arr = explode(',', $group_by_str);
			$org_group_by_arr = array_unique($group_by_arr);
			$group_by = implode(',', $org_group_by_arr);
			$group_by_criteria = ' GROUP BY ' . $group_by;
		}
		$where = 'jset_jnl_id =' . $jnl_id;
		$sql = 'SELECT usr_id, ' . $select . ' FROM ' . $master_table . ' INNER JOIN '.$journal_settings_table.' ON usr_id = jset_editorial_production_assistant ' . $join_criteria . ' WHERE ' . $where . $group_by_criteria;
		return DB::select($sql);
}
public static function format_email_content($email_keys, $art_id, $join_condition, $join_dependencies, $prev_article_id = NULL) {
    // if (self::$db_trans !== NULL) {
    //     $db_handler = &self::$db_trans;
    // } else {
    //     $db_handler = &$this->db;
    // }
    $article_table = (new \App\Models\Articles())->getTable();
    $select = '';
    $join_criteria = '';
    $select_arr = array();
    $master_table = $article_table;
    $join_arr = array();
    $group_by_str = '';
    $group_by_criteria = '';
    $group_by_flag = 0;
    $cndtn_val =  is_array($art_id) ? 'in ("'. implode('", "', $art_id) . '") ' : " = ". $art_id;
    $where = $article_table .'.art_id '.$cndtn_val;
    $transfer_section = FALSE;
    $article_section = FALSE;

    if (array_key_exists('transfer_article_tags', $email_keys) && !is_array($art_id)) {
        $article_transfer_suggestion_table = (new \App\Models\Article_transfer_suggestion())->getTable();
        $master_table =  $article_transfer_suggestion_table;
        if ($prev_article_id != NULL) {
            $ats_flw_id = '';
			$rslt =  DB::table($article_transfer_suggestion_table)->select(DB::raw('max(ats_aflw_id) as max_id'))->where('ats_art_id', '=', $prev_article_id)->get();
            if(!empty($rslt) && !empty($rslt[0]) && $rslt[0]->max_id > 0)
                $ats_flw_id = ' AND ats_aflw_id = ' . $rslt[0]->max_id;
            $where =  $article_transfer_suggestion_table.'.ats_art_id =' . $prev_article_id . $ats_flw_id;
        } else {
            $where = $article_transfer_suggestion_table.'.ats_art_id =' . $art_id;
        }
        $join_criteria .= " INNER JOIN {$article_table} ON  ats_art_id = art_id ";
    }

    foreach ($email_keys as $email_key => $em_value) {
        foreach ($em_value as $em_key => $em_val) {
            if (isset($em_val['select'])) {
                foreach ($em_val['select'] as $skey => $sval) {
                    $select .= $sval . ' as ' . $em_key . ',';
                    if (isset($em_val['group_by']) && $em_val['group_by'] == true) {
                        $group_by_flag = 1;
                    } else {
                        $group_by_str .= '`' . $em_key . '`,';
                    }
                }
            }
            if (isset($em_val['join'])) {
                foreach ($join_condition[$em_val['join']] as $joins) {
                    $join_arr[] = $joins;
                }
            }

            if (isset($em_val['where'])) {
                $where .= $em_val['where'];
            }
        }
    }

    if (count($join_arr) > 0) {
        $join_keys = array_intersect(array_keys($join_dependencies), $join_arr);

        foreach ($join_keys as $join_value) {
            $join = $join_dependencies[$join_value];
            $join_criteria .= ' ' . $join['type'] . ' JOIN ' . $join['table'] . ' ON ' . $join['on'] . ' ';
        }
    }
    $select = rtrim($select, ',');
    if ($group_by_str != '' && $group_by_flag == 1) {
        $group_by_str = rtrim($group_by_str, ',');
        $group_by_arr = explode(',', $group_by_str);
        $org_group_by_arr = array_unique($group_by_arr);
        $group_by = implode(',', $org_group_by_arr);
        $group_by_criteria = ' GROUP BY ' . $group_by;
    }
	$select = !empty($select) ? $select : '*'; //TASK #6401 Create a new tag for informing Reviewers about the final decision
    $sql = 'SELECT ' . $select . ' FROM ' . $master_table . ' ' . $join_criteria . ' WHERE ' . $where . $group_by_criteria;
    return DB::select($sql);
}
	public static function copy_email_templates($journal_id, $current_user, $new_jrnl = array())
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();

		$stage_etmp_journal_id = 'stage_etmp_journal_id';
		if (count($new_jrnl) > 0) {
			$stage_etmp_journal_id = $new_jrnl['new_jrnl_id'];
		}
		$sql = "INSERT INTO {$table}
(stage_etmp_name, stage_etmp_stage_type, stage_etmp_action, stage_etmp_reminder_format, stage_etmp_remind_days, stage_etmp_to, stage_etmp_cust_to, stage_etmp_cc, stage_etmp_cust_cc, stage_etmp_bcc, stage_etmp_cust_bcc, stage_etmp_subject, stage_etmp_content, stage_etmp_journal_id, stage_etmp_posted_date, stage_etmp_posted_by, stage_old_etmp_id)
(
SELECT stage_etmp_name, stage_etmp_stage_type, stage_etmp_action, stage_etmp_reminder_format, stage_etmp_remind_days, stage_etmp_to, stage_etmp_cust_to, stage_etmp_cc, stage_etmp_cust_cc, stage_etmp_bcc, stage_etmp_cust_bcc, stage_etmp_subject, stage_etmp_content, {$stage_etmp_journal_id}, '" . date('Y-m-d H:i:s') . "', {$current_user}, stage_etmp_id
FROM {$table}
WHERE stage_etmp_journal_id = {$journal_id}
)";
		$result = DB::select($sql);
		if ($result) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	public static function stage_email_paginated_records($select = NULL,  $criteria = array(), $binding_arr=array(), $having = NULL, $sort_field = NULL, $sort_order = NULL, $limit = NULL)
	{
		$data = array();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		DB::enableQueryLog();
		$main_sql = DB::table($table .' AS setmp')
		->selectRaw(DB::raw($select))
		->whereRaw($criteria);
		if (count($binding_arr)>0){
			$main_sql->setBindings($binding_arr);
		}
		if ($having != NULL){
			$main_sql->havingRaw($having);
		}
		if ($sort_field != NULL && $sort_order != NULL){
			$main_sql->orderBy($sort_field, $sort_order);
		}
		$data =$main_sql->paginate($limit);
		return  $data;
	}
	public static function alljournalsearchemailpaginated($select_first = NULL, $select_first_condition = NULL, $select_first_binding_arr=array(), $select_second = array(), $select_second_condition = NULL, $select_second_binding_arr=array(), $where_condition = NULL, $sort_field = NULL, $sort_order = NULL, $limit = NULL)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$email_table = (new \App\Models\Email_templates())->getTable();
		DB::enableQueryLog();

		$sql1 = DB::table($table .' AS setmp')
		->selectRaw(DB::raw($select_second))
		->whereRaw($select_second_condition);
		if (count($select_second_binding_arr)>0){
			$sql1->setBindings($select_second_binding_arr);
		}
		if($where_condition != NULL)
		$sql1->whereRaw($where_condition);

		if (count($select_first_binding_arr)>0){
			$main_sql = DB::table($email_table .' AS etmp')
			->selectRaw(DB::raw($select_first))
			->union($sql1)
			->whereRaw($select_first_condition)
			->setBindings($select_first_binding_arr)
			->orderBy($sort_field, $sort_order)
			->paginate($limit);
		}
		else{
			$main_sql = DB::table($email_table .' AS etmp')
			->selectRaw(DB::raw($select_first))
			->union($sql1)
			->whereRaw($select_first_condition)
			->orderBy($sort_field, $sort_order)
			->paginate($limit);
		}
		$data = $main_sql;
		return $data;
	}

	public static function geteventsearchemailpaginated($select = NULL, $condition = array(), $binding_arr=array(), $sort_field = NULL, $sort_order = NULL, $limit = NULL)
	{
		$classname = get_called_class();
		$email_table = (new \App\Models\Email_templates())->getTable();
		DB::enableQueryLog();
		$main_sql =  DB::table($email_table .' AS etmp')
		->selectRaw(DB::raw($select));
		if($condition)
		$main_sql->whereRaw($condition);
		if (count($binding_arr)>0){
			$main_sql->setBindings($binding_arr);
		}
		if ($sort_field != NULL && $sort_order != NULL)
		$main_sql->orderBy($sort_field, $sort_order);
		$data = $main_sql->paginate($limit);
		return $data;
	}
	public static function getstagesearchemailpaginated($select = NULL, $condition = array(), $binding_arr=array(), $sort_field = NULL, $sort_order = NULL, $limit = NULL)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		DB::enableQueryLog();
		$main_sql =  DB::table($table .' AS setmp')
		->selectRaw(DB::raw($select))
		->whereRaw($condition);
		if (count($binding_arr)>0){
			$main_sql->setBindings($binding_arr);
		}
		if ($sort_field != NULL && $sort_order != NULL)
		$main_sql->orderBy($sort_field, $sort_order);
		$data = $main_sql->paginate($limit);
		return $data;
	}
	public static function get_reminder_recieve_article_data($select = '*', $criteria = array()) {
		$Stage_email_tmpl_reference_table = (new \App\Models\Stage_email_tmpl_reference())->getTable();
		$Article_flow_table = (new \App\Models\Article_flow())->getTable();
		$Generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $Article_table = (new \App\Models\Articles())->getTable();
        $Article_type_table = (new \App\Models\Article_types())->getTable();
        $Journals_table = (new \App\Models\Journals())->getTable();

		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$result=DB::table($table);
        $result->selectRaw($select);
        $result->join($Stage_email_tmpl_reference_table,'setr_stage_etmp_id','=','stage_etmp_id');
        $result->join($Article_flow_table,'setr_jwf_id','=','aflw_jwf_id');
        $result->leftjoin($Generic_flow_table,'jwf_id','=','aflw_jwf_id');
		$result->join($Article_table,'aflw_art_id','=','art_id');
        $result->leftjoin($Article_type_table,'art_artp_id','=','artp_id');
        $result->leftjoin($Journals_table,'artp_jnl_id','=','jnl_id');
		$result->whereRaw("jnl_journal_status = 'y'");
        $result->whereRaw($criteria);
		return $result->get();
	}
	public static function get_article_status_data($aflw_id,$client_email_date_format=NULL,$mail_type=null,$intermediate_stage=false) {
		$Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
        $article_flow_table = (new \App\Models\Article_flow)->getTable();
        $Journal_settings_table = (new \App\Models\Journal_settings())->getTable();
		$journal = (new Journals());
        $Articles_table  =(new \App\Models\Articles())->getTable();
        $Article_types_table = (new \App\Models\Article_types())->getTable();
			$sql = 'SELECT aflw_art_id,jwf_stage_name AS ARTICLE_STAGE_NAME,jwf_status_name AS ARTICLE_STATUS_NAME,aflw_accepted_date as TASK_ASSIGNED_DATE,aflw_accepted_date as REVIEW_ACCEPT_DATE,aflw_due_date AS TASK_DUE_DATE FROM '.$Generic_flows_table.' LEFT JOIN '.$article_flow_table.' ON '.$Generic_flows_table.'.jwf_id = '.$article_flow_table.'.aflw_jwf_id WHERE '.$article_flow_table.'.aflw_id =' . $aflw_id;
			$qry_result =  DB::select($sql);
			foreach($qry_result as $result)
			{
				$art_id = $result->aflw_art_id;
				$result->jnl_code = (new Articles())->with('journals')->find($art_id)->journals->jnl_journal_code;
                                if($client_email_date_format == NULL)
                                {
				$query = 'select jset_date_format FROM '.$Articles_table.' INNER JOIN '.$Article_types_table.' ON '.$Articles_table.'.art_artp_id = '.$Article_types_table.'.artp_id INNER JOIN '.$Journal_settings_table.' ON '.$Journal_settings_table.'.jset_jnl_id = '.$Article_types_table.'.artp_jnl_id WHERE '.$Articles_table.'.art_id = '.$art_id;
				$date_format =  DB::select($sql);
                                $date_format = $date_format[0]->jset_date_format;
                                }
                                else
                                {
                                    $date_format = $client_email_date_format;
                                }
				if((isset($result->TASK_DUE_DATE) && $result->TASK_DUE_DATE !='') && !in_array($mail_type, ['edit', 'preview']) && !$intermediate_stage)
				{
					$result->TASK_DUE_DATE = date($date_format,strtotime($result->TASK_DUE_DATE));
				}
                                else
                                {
                                        $result->TASK_DUE_DATE = '##TASK_DUE_DATE##';
                                }
				if((isset($result->TASK_ASSIGNED_DATE) && $result->TASK_ASSIGNED_DATE != '') && $mail_type != 'edit')
				{
					$result->TASK_ASSIGNED_DATE = date($date_format,strtotime($result->TASK_ASSIGNED_DATE));
					$result->REVIEW_ACCEPT_DATE = date($date_format,strtotime($result->REVIEW_ACCEPT_DATE));
				}
                                else
                                {
                                        $result->TASK_ASSIGNED_DATE = '##TASK_ASSIGNED_DATE##';
                                        $result->REVIEW_ACCEPT_DATE = '##REVIEW_ACCEPT_DATE##';
                                }
				if (isset($result->TASK_REMAINING_DAYS) && in_array($mail_type, ['edit', 'preview'])) {
					$result->TASK_REMAINING_DAYS = '##TASK_REMAINING_DAYS##';
				}
			}
		return $qry_result;
	}
}
