<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Tours_master extends BaseModel
{
    use HasFactory;
    public $table='rvw_tours';
    public static $column_prefix='tour_';
    protected $primaryKey ='tour_id';

    public static function is_tour_record_exists($path, $userid) {
        $classname      =   get_called_class();
        $table          =   (new $classname)->getTable();
        $tour_tbl       =   DB::table($table);
        $tour_dtls_tbl  =   (new \App\Models\Tour_details())->getTable();

        $tour_tbl->selectRaw('tour_id, COUNT(tourdt_id) as tour_cnt, tour_steps_cnt');
        $tour_tbl->join($tour_dtls_tbl , 'tourdt_tour_id', '=', 'tour_id', 'left');
        $tour_tbl->whereRaw("tour_posted_by={$userid} AND tour_page_path='{$path}'");
		return $tour_tbl->first();     
    }

    public static function get_tour_data($path, $userid) {
        $classname      =   get_called_class();
        $table          =   (new $classname)->getTable();
        $tour_tbl       =   DB::table($table);
        $tour_dtls_tbl  =   (new \App\Models\Tour_details())->getTable();

        $tour_tbl->selectRaw('tour_id, tour_page_path, tourdt_id, tourdt_tour_key');
        $tour_tbl->join($tour_dtls_tbl , 'tourdt_tour_id', '=', 'tour_id', 'left');
        $tour_tbl->whereRaw("tour_posted_by={$userid} AND tour_page_path='{$path}'");
		return $tour_tbl->get();        
    }
}
