<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use DB;
use App\Libraries\SearchQuery;
class User extends BaseModel
{
    use HasFactory;
    public $table = 'rvw_users';
	public static $tbk_table= 'tbk_users';
    protected $primaryKey = 'usr_id';
    public static $column_prefix = 'usr_';
    protected $fillable = [
        'usr_username',
        'usr_pwd',
        'usr_title',
        'usr_first_name',
        'usr_middle_name',
        'usr_last_name',
        'usr_email',
        'usr_image'
    ];
    protected $appends = ['image_url'];
    protected $casts = [
        'email_verified_at' => 'datetime',
        // 'image' => ImageCast::class,
    ];
    public function getAvatarAttribute($value)
    {
        if (empty($value)) {
            return asset('images/avatar.png');
        } else {
            return asset('storage/users/' . $value);
            //return Storage::url('app/public/avatar/'.$value);
        }
    }
    public function getImageUrlAttribute($value)
    {
        return env('APP_URL') . '/images_ravs/' . $this->image;
    }

    public static function check_anonymised_user($select, $user_id,$where)
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $users = DB::table($table);
        $users->selectRaw($select);
        $users->where('usr_id', $user_id);
        $users->whereRaw($where);
        $result = $users->get();
        return $result;
    }
	public static function get_user_profile_modification_history($user_id, $date_format)
	{

		$classname = get_called_class();
		$table = (new $classname)->getTable();
        $final_sql = DB::table('tbk_users AS bkp');
        $final_sql->selectRaw('UNIX_TIMESTAMP(bkp.usr_posted_date) as unx_posted_date, CONCAT(r.usr_first_name," ",r.usr_last_name) as ae_full_name, bkp.usr_first_name,'
		. 'bkp.usr_middle_name,bkp.usr_last_name,bkp.usr_email , DATE_FORMAT(bkp.usr_posted_date, "' . $date_format . ' %h:%i:%s %p"  )  as usr_posted_date');
        $final_sql->join($table.' AS r','bkp.usr_posted_by','=','r.usr_id');
		$condition='bkp.usr_id=' . $user_id . ' and bkp.usr_status=\'w\' and bkp.usr_posted_by!=bkp.usr_id';
        $final_sql->whereRaw($condition);
		//$final_sql->orderBy('unx_posted_date DESC');
		return $final_sql->get();
	}
    public static function get_user_by_email_journal($criteria, $jnl_id = null, $check_type = 'AND', $extra_conditn = null,$binding_arr = array())
    {
		// try{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        DB::enableQueryLog();
        $result = DB::table($table);
        $result->select("*");
        if ($jnl_id != NULL) {		
            $result->whereRaw("usr_jnl_standalone={$jnl_id}");
        } else {
            $result->whereNull('usr_jnl_standalone');
        }

        if (!empty($extra_conditn)) {
            $result->whereRaw($extra_conditn);
        }
        if ($check_type == 'AND') {
            $result->whereRaw($criteria);
        } else {
            $result->orWhere($criteria);
        }
		if (count($binding_arr)>0)
		$result->setBindings($binding_arr);
        // if ($check_type == 'AND')
        // {
        // 	$query = $db_handler->get_where($this::$tbl_name, $criteria);
        // }
        // else
        // {
        // 	$db_handler->from($this::$tbl_name);
        // 	// Added  group_start() and group_end() for Bug #1153 Bug in Reviewer on Fly
        // 	$db_handler->group_start()->or_where($criteria)->group_end();
        // 	$query = $db_handler->get();
        // }
        $query = DB::getQueryLog();
        // dd($query);
        return $result->get();
		// }
		// catch (\Exception $e) {
		// 			   return  $this->failure('Failed',500,$e);
		// 			}
    }
    public static function get_user_search_result($select, $where = NULL, $order_by = '', $ordering_column = '', $journal_id = NULL, $sortby='asc',$user_keyword='')
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $userjournals_table = (new \App\Models\User_to_journals())->getTable();
        //DB::enableQueryLog();
        $result = DB::table($table);
        $result->selectRaw($select);
		if ($ordering_column == 'name') {
            $result->selectRaw('concat_ws(" ",usr_first_name,IF(usr_middle_name = "",\'null\',usr_middle_name),usr_last_name) as name');
        } elseif ($ordering_column == 'articleassigned') {
            if ($journal_id != NULL) {
                $excluded_curjnl = ' and artp_jnl_id!=' . $journal_id;
                $only_curjnl = ' and artp_jnl_id=' . $journal_id;;
            }
           // $result->selectRaw("(select count(usra_art_id) as cnt from rvw_user_articles left join rvw_articles on art_id = usra_art_id  left join rvw_article_types on artp_id = art_artp_id where usra_usr_id=usr_id and art_status='y'" . $excluded_curjnl . ") as assign_exclude_curjnl");
            $result->selectRaw("(select count(usra_art_id) as cnt from rvw_user_articles left join rvw_articles on art_id = usra_art_id  left join rvw_article_types on artp_id = art_artp_id where usra_usr_id=usr_id and art_status='y'" . $only_curjnl . ") as articleassigned");
			
        } elseif ($ordering_column == 'taskhand') {
            if ($journal_id != NULL) {
                $excluded_curjnl = ' and artp_jnl_id!=' . $journal_id;
                $only_curjnl = ' and artp_jnl_id=' . $journal_id;;
            }
            //$result->selectRaw("(select count(aflw_id) as cnt from rvw_article_flow left join rvw_articles  on art_id = aflw_art_id left join rvw_journal_workflows on aflw_jwf_id = jwf_id left join rvw_article_types on artp_id = art_artp_id where aflw_usr_id =usr_id AND aflw_status = 'a' AND art_delete_status  = 'n' and art_status='y' AND jwf_stage_type NOT IN ('author_submission','transit','authors_declaration','revision','resubmission','copyright')" . $excluded_curjnl . ") as task_exclud_curjnl");
            $result->selectRaw("(select count(aflw_id) as cnt from rvw_article_flow left join rvw_articles  on art_id = aflw_art_id left join rvw_journal_workflows on aflw_jwf_id = jwf_id left join rvw_article_types on artp_id = art_artp_id where aflw_usr_id =usr_id AND aflw_status = 'a' AND art_delete_status  = 'n' and art_status='y' AND jwf_stage_type NOT IN ('author_submission','transit','authors_declaration','revision','resubmission','copyright')" . $only_curjnl . ") as taskhand");
        }
        $result->join($userjournals_table, 'usrj_usr_id', '=', 'usr_id');
		if($user_keyword== 'ID')
		{
			$userkeyword_table = (new \App\Models\Userkeywords())->getTable();
			$result->leftjoin($userkeyword_table, 'ukwd_usr_id', '=', 'usr_id');
		}
		elseif($user_keyword== 'WORD')
		{
			$userkeyword_table = (new \App\Models\Userkeywords())->getTable();
			$result->leftjoin($userkeyword_table, 'ukwd_usr_id', '=', 'usr_id');
			$keyword_table = (new \App\Models\Keywords())->getTable();
			$result->leftjoin($keyword_table, 'ukwd_kwd_id', '=', 'kwd_id');
		}
        if ($where != NULL) {
            $result->whereRaw($where);
        }

        if ($order_by != '')
            $result->orderBy($order_by,$sortby);
			if($user_keyword !='')
			{
				$result->groupBy('usr_id');
			}
		$query = $result->paginate(10);	
        //$query = $result->get();
        //print $db_handler->last_query(); die;
        return $query;
    }
    public static function get_profile_keywords_assignment($user_id, $order_kwd = NULL, $kwd_title = NULL)
    {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        //$user = DB::table($table);
        $userkeyword_table = (new \App\Models\Userkeywords())->getTable();
        $keywords_table = (new \App\Models\Keywords())->getTable();

        $keyword_result_set = 'SELECT kwd_id,kwd_name,kwd_user_keyword FROM ' . $userkeyword_table . ',' . $keywords_table . ' WHERE ukwd_kwd_id = kwd_id AND ukwd_usr_id = ' . $user_id; /*TASK #9419 Add new feature to add custom keyword in user profile section*/
        $temp = array();
        if ($order_kwd != NULL) {
            $temp[] = ' FIELD (kwd_id,' . $order_kwd . ') desc ';
        }
        if ($kwd_title != NULL) {
            $temp[] = ' INSTR(kwd_name,"' . $kwd_title . '") desc ';
        }
        if ($order_kwd != NULL || $kwd_title != NULL) {
            $keyword_result_set .= ' ORDER BY ';
            $keyword_result_set .= implode(', ', $temp);
        }
		$result = DB::select($keyword_result_set);
         return $result;
    }
	public static function user_review_rating($user_id,$search_filters,$five_star=null)
	{

		$articletable=(new \App\Models\Articles())->getTable();
		$articletypetable=(new \App\Models\Article_types())->getTable();
		$journaltable=(new \App\Models\Journals())->getTable();
		$articleflowtable=(new \App\Models\Article_flow())->getTable();
		$genericflowtable=(new \App\Models\Generic_flows())->getTable();
		$reviewratingtable=(new \App\Models\Review_rating())->getTable();
		$userjournaltable=(new \App\Models\User_to_journals())->getTable();
		$articlelegacytable=(new \App\Models\Article_legacydata())->getTable();
		$reviewer_legacy_table=(new \App\Models\Article_reviewer_legacydata())->getTable();
		$review_rating_level_result_set = '';

		$baseRating = 4;
		// TASK #6273 start	 change true to y
		if($five_star == 'y')
			$baseRating = 5;
		// TASK #6273 end	
		$legacyRatingStr = ' IF('.$baseRating.' < arev_reviewer_rating,(('.$baseRating.'*arev_reviewer_rating)/100),arev_reviewer_rating) ';
		
		if(isset($search_filters['journal_filter']))
		{
			$journal_condition = '';
			if(isset($search_filters['journal_filter']['any']))
				$journal_condition .= ' AND  FIND_array_intersect("'.$search_filters['journal_filter']['any'].'",user_journal_table.user_journal_list) = 1';
			if(isset($search_filters['journal_filter']['not_in']))
				$journal_condition .= ' AND  FIND_array_not_in("'.$search_filters['journal_filter']['not_in'].'",user_journal_table.user_journal_list) = 1 ';
			if(isset($search_filters['journal_filter']['in']))
				$journal_condition .= ' AND FIND_array_in_all("'.$search_filters['journal_filter']['in'].'",user_journal_table.user_journal_list) = 1 ';
  
			// TASK #6273 start	
			/*Task #1893 ReView: Reviewer filtering and sorting (basecamp issue)*/
			$journal_condition_for_rating = '';
				if(isset($search_filters['journal_filter']['any']))
				{
					$journal_condition_for_rating .= ' AND artp_jnl_id IN ('.$search_filters['journal_filter']['any'].')';
				}
				if(isset($search_filters['journal_filter']['not_in']))
				{
					$journal_condition_for_rating .=  ' AND artp_jnl_id NOT IN ('.$search_filters['journal_filter']['not_in'].')';
				}
				$review_rating_level_temp_live = ' ,(SELECT rvr_reviewer_id,artp_jnl_id,rvr_rating FROM '.$articletypetable.','.$articletable.','.$articleflowtable.','.$reviewratingtable.' WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND rvr_aflw_id = aflw_id AND aflw_parent_flow_id IS NOT NULL AND aflw_usr_id = '.$user_id.$journal_condition_for_rating.' )  AS review_rating_level_temp_live WHERE  TRUE ';
				if(isset($search_filters['journal_filter']['in']))
				{	
					$journal_ids = [];
					$journal_ids[] = $search_filters['journal_filter']['in'];
					$merged_ids = implode(',', $journal_ids);
					$journal_condition_for_rating .=  ' AND FIND_array_in_all("'.$merged_ids.'", journals.jnl_ids) = 1';
					$review_rating_level_temp_live = ' ,(SELECT rvr_reviewer_id,artp_jnl_id,rvr_rating FROM '.$articletypetable.','.$articletable.','.$articleflowtable.','.$reviewratingtable.' JOIN ( SELECT GROUP_CONCAT(DISTINCT artp.artp_jnl_id) AS jnl_ids FROM rvw_review_rating rvr2 JOIN rvw_article_flow aflw2 ON rvr2.rvr_aflw_id = aflw2.aflw_id JOIN rvw_articles art2 ON aflw2.aflw_art_id = art2.art_id JOIN rvw_article_types artp ON art2.art_artp_id = artp.artp_id WHERE aflw2.aflw_parent_flow_id IS NOT NULL AND artp.artp_jnl_id IN (' . $merged_ids . ') ) AS journals WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND rvr_aflw_id = aflw_id AND aflw_parent_flow_id IS NOT NULL AND aflw_usr_id = '.$user_id.$journal_condition_for_rating.'  ) AS review_rating_level_temp_live WHERE artp_jnl_id IN( '.$merged_ids.')';
				}

			$live_artcile = ' (SELECT (review_rating_level_temp_live.rvr_rating) as rating FROM (SELECT usrj_usr_id,GROUP_CONCAT(DISTINCT `usrj_jnl_id`) as user_journal_list FROM '.$userjournaltable.' where usrj_artp_id is NULL AND usrj_usr_id = '.$user_id.' group by usrj_usr_id) as user_journal_table '.$review_rating_level_temp_live.$journal_condition.')   ';
			// TASK #6273 end	

			//AS review_rating_level_sm_table ON review_rating_level_sm_table.rvr_reviewer_id = usr_id

			$review_rating_level_temp_legacy = ' ,(SELECT arev_user_id as rvr_reviewer_id,arld_jnl_id,'.$legacyRatingStr.' AS rvr_rating FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE  arld_id = arev_arld_id AND arev_reviewer_rating > 0 AND arev_user_id = '.$user_id.' )  AS review_rating_level_temp_legacy WHERE  review_rating_level_temp_legacy.arld_jnl_id IN (user_journal_table.user_journal_list) ';
			// TASK #6273 start	
			$legacy_artcile = ' (SELECT (review_rating_level_temp_legacy.rvr_rating) as rating FROM (SELECT GROUP_CONCAT(DISTINCT arld_jnl_id) as user_journal_list FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE  arld_id = arev_arld_id AND arev_reviewer_rating > 0 AND arev_user_id = '.$user_id.') as user_journal_table '.$review_rating_level_temp_legacy.$journal_condition.') ';
			// TASK #6273 end	
			//AS review_rating_level_legacy_table ON review_rating_level_legacy_table.rvr_reviewer_id = usr_id  

		}
		else
		{
			$live_artcile = ' (SELECT rvr_rating as rating FROM '.$reviewratingtable.' WHERE rvr_five_star=\'n\' AND rvr_reviewer_id = '.$user_id.') '; 
			$legacy_artcile = ' (SELECT '.$legacyRatingStr.' as rating FROM '.$reviewer_legacy_table.' WHERE arev_reviewer_rating > 0 AND arev_user_id = '.$user_id.')';
			
		}

		$review_rating_level_result_set = ' SELECT avg(temp1.rating) as rating FROM ( '.$live_artcile.' UNION ALL '.$legacy_artcile.' ) as temp1 ';

		
		//  echo $review_rating_level_result_set ." LIMIT 1";exit;
		
		$result = DB::select($review_rating_level_result_set ." LIMIT 1")[0];
 
		return $result;
	}
	public static function get_article_submitted_keywords($user_id,$search_filters)
	{
		$articletable=(new \App\Models\Articles())->getTable();
		$articletypetable=(new \App\Models\Article_types())->getTable();
		$journaltable=(new \App\Models\Journals())->getTable();
		$articleflowtable=(new \App\Models\Article_flow())->getTable();
		$genericflowtable=(new \App\Models\Generic_flows())->getTable();
		$reviewratingtable=(new \App\Models\Review_rating())->getTable();
		$userjournaltable=(new \App\Models\User_to_journals())->getTable();
		$articlelegacytable=(new \App\Models\Article_legacydata())->getTable();
		$reviewer_legacy_table=(new \App\Models\Article_reviewer_legacydata())->getTable();
		$article_keyword_table=(new \App\Models\Article_keywords())->getTable();
		$keyword_table=(new \App\Models\Keywords())->getTable();
		$keyword_result_set = '';
		$journal_flag=FALSE;
		if(isset($search_filters['journal_filter']))
		{
			$journal_flag = TRUE;
		}
	
			if(isset($search_filters['keyword_filter']['has_keywords_in_submitted_articles']))
			{
				$live_artcile = '';
				$legacy_artcile = '';
				$keyword_condition='';
				$keyword_condition_self = array();
				$keyword_condition_self_legacy = array();
				$temp_data = $search_filters['keyword_filter']['has_keywords_in_submitted_articles'];
				if(isset($temp_data['AND']))
				{
					$keyword_condition_self[] = ' FIND_array_in_all("'.$temp_data['AND'].'",temp_live_key.art_keyword_id) = 1 ';
					$keyword_condition_self_legacy[] = ' FIND_array_in_all("'.$temp_data['AND'].'",arld_keyword_ids) = 1 ';
					
				}
				
				if(isset($temp_data['OR']))
				{
					$keyword_condition_self[] = ' FIND_array_intersect("'.$temp_data['OR'].'",temp_live_key.art_keyword_id) = 1 ';
					$keyword_condition_self_legacy[] = ' FIND_array_intersect("'.$temp_data['OR'].'",arld_keyword_ids) = 1 ';
				}
				
				if(isset($temp_data['LIKE']))
				{
					$keyword_condition_self[] = ' temp_live_key.art_keywords LIKE "%'.$temp_data['LIKE'].'%" ';
					$keyword_condition_self_legacy[] = ' arld_keywords LIKE "%'.$temp_data['LIKE'].'%" ';
				}
			
				$keyword_condition_internal = implode(' AND ', $keyword_condition_self);
				$keyword_condition_internal_legacy = implode(' AND ', $keyword_condition_self_legacy);
				if($journal_flag == TRUE)
				{
					$live_artcile = ' SELECT COUNT(temp_live_key.Article_id) AS article_id FROM (SELECT art_submitted_by AS art_user,GROUP_CONCAT(DISTINCT ak_keyword_id) AS art_keyword_id,GROUP_CONCAT( DISTINCT kwd_name SEPARATOR ", ") AS art_keywords,artp_jnl_id,art_id AS Article_id  FROM '.$articletable.','.$article_keyword_table.','.$keyword_table.','.$articletypetable.'  WHERE ak_art_id = art_id AND ak_keyword_id = kwd_id AND artp_id = art_artp_id AND art_submitted_by='.$user_id.' GROUP by art_id) AS temp_live_key WHERE '.$keyword_condition_internal.' GROUP BY temp_live_key.art_user';
					
					$legacy_artcile = ' (SELECT COUNT(arld_id) AS article_id FROM '.$articlelegacytable.' WHERE '.$keyword_condition_internal_legacy.' AND arld_submitted_by='.$user_id.' GROUP BY arld_submitted_by ) ';
						
					if(isset($search_filters['journal_filter']['any']))
						$keyword_condition .= ' AND FIND_array_intersect("'.$search_filters['journal_filter']['any'].'",article_keyword_table.art_jnl_list) = 1';
					if(isset($search_filters['journal_filter']['not_in']))
						$keyword_condition .= ' AND FIND_array_not_in("'.$search_filters['journal_filter']['not_in'].'",article_keyword_table.art_jnl_list) = 1 ';
					if(isset($search_filters['journal_filter']['in']))
						$keyword_condition .= ' AND FIND_array_in_all("'.$search_filters['journal_filter']['in'].'",article_keyword_table.art_jnl_list) = 1 ';
					
					//$user_journal_result_set = '';
				
				}
				else
				{
					$live_artcile = ' SELECT COUNT(temp_live_key.Article_id) AS article_id FROM (SELECT art_submitted_by AS art_user,GROUP_CONCAT(DISTINCT ak_keyword_id) AS art_keyword_id,GROUP_CONCAT( DISTINCT kwd_name SEPARATOR ", ") AS art_keywords,  art_id AS Article_id  FROM '.$articletable.','.$article_keyword_table.','.$keyword_table.' WHERE ak_art_id = art_id AND ak_keyword_id = kwd_id  AND art_submitted_by='.$user_id.' GROUP by art_id) AS temp_live_key WHERE '.$keyword_condition_internal;
					
					$legacy_artcile = ' (SELECT  COUNT(arld_id) AS article_id FROM '.$articlelegacytable.' WHERE '.$keyword_condition_internal_legacy.' AND arld_submitted_by='.$user_id.' ) ';
				}
				
				$keyword_result_set .= 'SELECT SUM(article_id) AS artcount  FROM ('.$live_artcile.' UNION ALL '.$legacy_artcile.'  )AS  artcount';
			}
			//echo $keyword_result_set;exit;
			$result = DB::select($keyword_result_set ." LIMIT 1")[0];
			return $result;
	  
	}

	public static function getreviwed_article_keyword($user_id,$search_filters)
	{
		$articletable=(new \App\Models\Articles())->getTable();
		$articletypetable=(new \App\Models\Article_types())->getTable();
		$journaltable=(new \App\Models\Journals())->getTable();
		$articleflowtable=(new \App\Models\Article_flow())->getTable();
		$genericflowtable=(new \App\Models\Generic_flows())->getTable();
		$reviewratingtable=(new \App\Models\Review_rating())->getTable();
		$userjournaltable=(new \App\Models\User_to_journals())->getTable();
		$articlelegacytable=(new \App\Models\Article_legacydata())->getTable();
		$reviewer_legacy_table=(new \App\Models\Article_reviewer_legacydata())->getTable();
		$article_keyword_table=(new \App\Models\Article_keywords())->getTable();
		$keyword_table=(new \App\Models\Keywords())->getTable();

		$keyword_result_set = '';
		$journal_flag=FALSE;
		if(isset($search_filters['journal_filter']))
		{
			$journal_flag = TRUE;
		}
	
		if(isset($search_filters['keyword_filter']['has_keywords_in_reviewed_articles']))
		{
			$live_artcile = '';
			$legacy_artcile = '';
			$keyword_condition_self = array();
			$keyword_condition_self_legacy = '';
			$keyword_condition='';
			$temp_data = $search_filters['keyword_filter']['has_keywords_in_reviewed_articles'];
			if(isset($temp_data['AND']))
			{
				$keyword_condition_self[] = ' FIND_array_in_all("'.$temp_data['AND'].'",temp_art_review_live_key.art_keyword_id) = 1 ';
				$keyword_condition_self_legacy .= ' AND FIND_array_in_all("'.$temp_data['AND'].'",arld_keyword_ids) = 1 ';					
			}
		
			if(isset($temp_data['OR']))
			{
				$keyword_condition_self[] = ' FIND_array_intersect("'.$temp_data['OR'].'",temp_art_review_live_key.art_keyword_id) = 1 ';
				$keyword_condition_self_legacy .= ' AND FIND_array_intersect("'.$temp_data['OR'].'",arld_keyword_ids) = 1 ';
			}
				
			if(isset($temp_data['LIKE']))
			{
				$keyword_condition_self[] = ' temp_art_review_live_key.art_keywords LIKE "%'.$temp_data['LIKE'].'%" ';
				$keyword_condition_self_legacy .= ' AND arld_keywords LIKE "%'.$temp_data['LIKE'].'%" ';
			}

			$keyword_condition_internal = implode(' AND ', $keyword_condition_self);				
			if($journal_flag == TRUE)
			{			
				$live_artcile = ' SELECT  COUNT(temp_art_review_live_key.Article_id) AS article_id FROM (SELECT aflw_usr_id AS art_rv_user,GROUP_CONCAT(DISTINCT ak_keyword_id) AS art_keyword_id,GROUP_CONCAT( DISTINCT kwd_name SEPARATOR ", ") AS art_keywords,artp_jnl_id,aflw_art_id AS Article_id  FROM '.$article_keyword_table.','.$keyword_table.','.$articleflowtable.','.$genericflowtable.','.$articletable.','.$articletypetable.'  WHERE aflw_jwf_id = jwf_id  AND aflw_art_id = ak_art_id AND aflw_art_id = art_id  AND  art_artp_id = artp_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND jwf_stage_type = \'review\' AND ak_keyword_id = kwd_id AND aflw_usr_id='.$user_id.'  GROUP by aflw_art_id) AS temp_art_review_live_key WHERE '.$keyword_condition_internal;	
				$legacy_artcile = ' (SELECT COUNT(arld_id) AS article_id FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE  arev_arld_id = arld_id AND arev_status IN ("ac","ag") AND arev_user_id IS NOT NULL '.$keyword_condition_self_legacy.' AND arev_user_id='.$user_id.' ) ';		
					
				if(isset($search_filters['journal_filter']['any']))
					$keyword_condition .= ' AND FIND_array_intersect("'.$search_filters['journal_filter']['any'].'",article_review_keyword_table.art_rev_jnl_list) = 1';
				if(isset($search_filters['journal_filter']['not_in']))
					$keyword_condition .= ' AND FIND_array_not_in("'.$search_filters['journal_filter']['not_in'].'",article_review_keyword_table.art_rev_jnl_list) = 1 ';
				if(isset($search_filters['journal_filter']['in']))
					$keyword_condition .= ' AND FIND_array_in_all("'.$search_filters['journal_filter']['in'].'",article_review_keyword_table.art_rev_jnl_list) = 1 ';				
				}
				else
				{
					$live_artcile = ' SELECT COUNT(temp_art_review_live_key.Article_id) AS article_id  FROM (SELECT aflw_usr_id AS art_rv_user,GROUP_CONCAT(DISTINCT ak_keyword_id) AS art_keyword_id,GROUP_CONCAT( DISTINCT kwd_name SEPARATOR ", ") AS art_keywords,aflw_art_id AS Article_id   FROM '.$article_keyword_table.','.$keyword_table.','.$articleflowtable.','.$genericflowtable.' WHERE aflw_jwf_id = jwf_id  AND aflw_art_id = ak_art_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND jwf_stage_type = \'review\' AND ak_keyword_id = kwd_id  AND aflw_usr_id='.$user_id.' GROUP by aflw_art_id) AS temp_art_review_live_key WHERE '.$keyword_condition_internal;					
					$legacy_artcile = ' (SELECT  COUNT(arld_id) AS article_id FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE  arev_arld_id = arld_id AND arev_status IN ("ac","ag") AND arev_user_id IS NOT NULL '.$keyword_condition_self_legacy.' AND arev_user_id='.$user_id.'  GROUP BY arev_user_id ) ';
				}
				
				$keyword_result_set .= 'SELECT SUM(article_id) AS artcount  FROM ('.$live_artcile.' UNION ALL '.$legacy_artcile.'  )AS  artcount ';
				$result = DB::select($keyword_result_set ." LIMIT 1")[0];
			 	return $result;
			}
	}

	public static function user_last_invitation_date($user_id,$search_filters,$date_format = NULL)
	{
		$articletable=(new \App\Models\Articles())->getTable();
		$articletypetable=(new \App\Models\Article_types())->getTable();
		$journaltable=(new \App\Models\Journals())->getTable();
		$articleflowtable=(new \App\Models\Article_flow())->getTable();
		$genericflowtable=(new \App\Models\Generic_flows())->getTable();
		$reviewratingtable=(new \App\Models\Review_rating())->getTable();
		$userjournaltable=(new \App\Models\User_to_journals())->getTable();
		$articlelegacytable=(new \App\Models\Article_legacydata())->getTable();
		$reviewer_legacy_table=(new \App\Models\Article_reviewer_legacydata())->getTable();
		$article_keyword_table=(new \App\Models\Article_keywords())->getTable();
		$keyword_table=(new \App\Models\Keywords())->getTable();
		
		$article_last_review_condition = '';
		$temp_arr = array();
		$live_artcile = '';
		$legacy_artcile = '';
		if(isset($search_filters['journal_filter']))
		{
			$live_artcile = ' (SELECT GROUP_CONCAT(DISTINCT artp_jnl_id) as art_review_invite_jnl,MAX(aflw_assigned_date) AS temp_last_invite  FROM '.$articleflowtable.','.$genericflowtable.','. $articletable.','.$articletypetable.' WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_jwf_id = jwf_id AND aflw_status != "u" AND jwf_stage_type = \'review\' AND aflw_usr_id = '.$user_id.') ';

			$legacy_artcile = ' (SELECT GROUP_CONCAT(DISTINCT arld_jnl_id) as art_review_invite_jnl,MAX(arev_stage_start_date) AS temp_last_invite  FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE arld_id= arev_arld_id AND arev_user_id = '.$user_id.' ) ';

			if(isset($search_filters['journal_filter']['any']))
				$temp_arr[] = '  FIND_array_intersect("'.$search_filters['journal_filter']['any'].'",temp_last_invite_tb.art_review_invite_jnl) = 1';
			if(isset($search_filters['journal_filter']['not_in']))
				$temp_arr[] = ' FIND_array_not_in("'.$search_filters['journal_filter']['not_in'].'",temp_last_invite_tb.art_review_invite_jnl) = 1 ';
			if(isset($search_filters['journal_filter']['in']))
				$temp_arr[] = ' FIND_array_in_all("'.$search_filters['journal_filter']['in'].'",temp_last_invite_tb.art_review_invite_jnl) = 1 ';
	
			$article_last_review_condition = ' WHERE '. implode(' AND ', $temp_arr);
		}
		else
		{
			$live_artcile = ' (SELECT MAX(aflw_assigned_date) AS temp_last_invite  FROM '.$articleflowtable.','.$genericflowtable.' WHERE  aflw_jwf_id = jwf_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status != "u" AND jwf_stage_type = \'review\'  AND aflw_usr_id = '.$user_id.' )';
			
			$legacy_artcile = ' (SELECT MAX(arev_stage_start_date) AS temp_last_invite FROM '.$reviewer_legacy_table.' WHERE arev_user_id = '.$user_id.' ) ';
		}

		/*$article_review_last_invite_result_set = ' (SELECT DISTINCT temp_last_invite_tb.*,MAX(temp_last_invite_tb.temp_last_invite) AS last_invitation_date FROM ( '.$live_artcile.' UNION ALL '.$legacy_artcile.') AS temp_last_invite_tb GROUP BY art_review_invite_usr) AS review_last_invite_table ON usr_id = review_last_invite_table.art_review_invite_usr ';*/
		

		$select = 'DATE_FORMAT(MAX(temp_last_invite_tb.temp_last_invite), "' . $date_format . '") AS last_invitation_date';
		
		$article_review_last_invite_result_set = 'SELECT '.$select.' FROM ( '.$live_artcile.' UNION ALL '.$legacy_artcile.') AS temp_last_invite_tb '.$article_last_review_condition;



		$result = DB::select($article_review_last_invite_result_set." LIMIT 1")[0];
		return $result;
		

	}

	public static function user_current_assignmets($user_id,$search_filters,$journal_id = NULL)
	{
		
		$articletable=(new \App\Models\Articles())->getTable();
		$articletypetable=(new \App\Models\Article_types())->getTable();
		$journaltable=(new \App\Models\Journals())->getTable();
		$articleflowtable=(new \App\Models\Article_flow())->getTable();
		$genericflowtable=(new \App\Models\Generic_flows())->getTable();
		if(isset($search_filters['journal_filter']))
		{
			$temp_arr = array();
			if(isset($search_filters['journal_filter']['any']))
					$temp_arr[] = ' FIND_array_intersect("'.$search_filters['journal_filter']['any'].'",inhand_reviewed_art_table.art_inhand_reviewed_jnl) = 1 ';
				if(isset($search_filters['journal_filter']['not_in']))
					$temp_arr[] = ' FIND_array_not_in("'.$search_filters['journal_filter']['not_in'].'",inhand_reviewed_art_table.art_inhand_reviewed_jnl) = 1 ';
				if(isset($search_filters['journal_filter']['in']))
					$temp_arr[] = ' FIND_array_in_all("'.$search_filters['journal_filter']['in'].'",inhand_reviewed_art_table.art_inhand_reviewed_jnl) = 1 ';
			
			$inhand_article_review_condition = ' WHERE '.implode(' AND ', $temp_arr);
			
			if($journal_id != NULL)
			{
				$inhand_article_review_result_set =  ' SELECT sum(inhand_reviewed_art_table.art_inhand_reviewed_by) AS current_assignmets FROM (SELECT count(aflw_usr_id) AS art_inhand_reviewed_by,GROUP_CONCAT(DISTINCT artp_jnl_id) AS art_inhand_reviewed_jnl  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id WHERE aflw_parent_flow_id IS NOT NULL AND aflw_status = \'a\' AND art_status =\'y\' AND art_delete_status = \'n\' AND jwf_stage_type = \'review\' AND aflw_usr_id = '.$user_id.' AND jnl_id = '.$journal_id.') AS inhand_reviewed_art_table '.$inhand_article_review_condition;
			}
			else
			{

			$inhand_article_review_result_set =  ' SELECT sum(inhand_reviewed_art_table.art_inhand_reviewed_by) AS current_assignmets FROM (SELECT count(aflw_usr_id) AS art_inhand_reviewed_by,GROUP_CONCAT(DISTINCT artp_jnl_id) AS art_inhand_reviewed_jnl  FROM '.$articleflowtable.','.$genericflowtable.','. $articletable.','.$articletypetable.' WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND aflw_parent_flow_id IS NOT NULL AND aflw_jwf_id = jwf_id  AND art_delete_status = \'n\' AND aflw_status = \'a\' AND art_status =\'y\' AND jwf_stage_type = \'review\' AND aflw_usr_id = '.$user_id.') AS inhand_reviewed_art_table '.$inhand_article_review_condition;
			}
			//,GROUP_CONCAT(DISTINCT inhand_reviewed_art_table.artp_jnl_id) as art_inhand_reviewed_jnl
			//,'.Journals::$tbl_name.'
		}
		else
		{
			if($journal_id != NULL)
			{
				$inhand_article_review_result_set = 'SELECT COUNT(aflw_usr_id) AS current_assignmets FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id WHERE aflw_parent_flow_id IS NOT NULL AND aflw_status = \'a\' AND art_status =\'y\' AND art_delete_status = \'n\' AND jwf_stage_type = \'review\' AND aflw_usr_id = '.$user_id.' AND jnl_id = '.$journal_id;
			}
			else
			{
				$inhand_article_review_result_set = ' SELECT count(aflw_usr_id) AS current_assignmets  FROM '. $articletable.','.$articleflowtable.','.$genericflowtable.' WHERE aflw_jwf_id = jwf_id  AND aflw_art_id = art_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'a\' AND art_status =\'y\' AND art_delete_status = \'n\' AND jwf_stage_type = \'review\' AND  aflw_usr_id = '.$user_id;		   }
		}
		$result = DB::select($inhand_article_review_result_set." LIMIT 1")[0];
		return $result;

		
	}

	public static function user_date_count($user_id,$search_filters,$journal_id=NULL)
	{

		$articletable=(new \App\Models\Articles())->getTable();
		$articletypetable=(new \App\Models\Article_types())->getTable();
		$journaltable=(new \App\Models\Journals())->getTable();
		$articleflowtable=(new \App\Models\Article_flow())->getTable();
		$genericflowtable=(new \App\Models\Generic_flows())->getTable();
		$articlelegacytable=(new \App\Models\Article_legacydata())->getTable();
		$reviewer_legacy_table=(new \App\Models\Article_reviewer_legacydata())->getTable();
		$has_reviewed_articles_live_having = ' ,MIN(DATEDIFF(now(), `aflw_returned_date`)) AS date_count_temp ';
		$has_reviewed_articles_legacy_having = ' ,MIN(DATEDIFF(now(), `arev_stage_end_date`)) AS date_count_temp';
		//$sub_condition = ',min(date_count_temp) AS date_count';
		//$select .= ',reviewed_art_table.date_count';
		
		$article_review_condition = '';
		
		//$has_reviewed_articles_live = '';
		//$has_reviewed_articles_legacy = '';
		$temp_arr = array();	
		
		if(isset($search_filters['journal_filter']))
		{
			if($journal_id == NULL)
			{
				$live_artcile = ' (SELECT aflw_usr_id AS art_reviewed_by,GROUP_CONCAT(DISTINCT artp_jnl_id) as art_reviewed_jnl'.$has_reviewed_articles_live_having.'  FROM '.$articleflowtable.','.$genericflowtable.','. $articletable.','.$articletypetable.' WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_jwf_id = jwf_id AND aflw_status = \'c\' AND jwf_stage_type = \'review\' AND  aflw_usr_id = '.$user_id.'  GROUP BY aflw_usr_id) ';
			//,'.Journals::$tbl_name.'
			}
			else
			{
				$live_artcile = ' (SELECT aflw_usr_id AS art_reviewed_by,GROUP_CONCAT(DISTINCT artp_jnl_id) as art_reviewed_jnl'.$has_reviewed_articles_live_having.'  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id  WHERE jnl_id='.$journal_id.' AND aflw_parent_flow_id IS NOT NULL AND aflw_status = \'c\' AND jwf_stage_type = \'review\' AND  aflw_usr_id = '.$user_id.'  GROUP BY aflw_usr_id) ';
			}
			
			$legacy_artcile = ' (SELECT DISTINCT arev_user_id AS art_reviewed_by,GROUP_CONCAT(DISTINCT arld_jnl_id) as art_reviewed_jnl'.$has_reviewed_articles_legacy_having.'  FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE arld_id= arev_arld_id AND arev_status IN ("ac","ag") AND arev_user_id = '.$user_id.'  GROUP BY arev_user_id ) ';

			if(isset($search_filters['journal_filter']['any']))
					$temp_arr[] = ' FIND_array_intersect("'.$search_filters['journal_filter']['any'].'",temp_tb.art_reviewed_jnl) = 1';
			if(isset($search_filters['journal_filter']['not_in']))
					$temp_arr[] .= ' FIND_array_not_in("'.$search_filters['journal_filter']['not_in'].'",temp_tb.art_reviewed_jnl) = 1 ';
			if(isset($search_filters['journal_filter']['in']))
					$temp_arr[] .= ' FIND_array_in_all("'.$search_filters['journal_filter']['in'].'",temp_tb.art_reviewed_jnl) = 1 ';
			
			$article_review_condition = ' WHERE '.implode(' AND ', $temp_arr);
		}
		else
		{
			if($journal_id == NULL)
			{
				$live_artcile = ' (SELECT  aflw_usr_id AS art_reviewed_by'.$has_reviewed_articles_live_having.'  FROM '. $articletable.','.$articleflowtable.','.$genericflowtable.' WHERE  aflw_art_id = art_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND jwf_stage_type = \'review\' AND aflw_jwf_id = jwf_id AND aflw_usr_id = '.$user_id.' GROUP BY aflw_usr_id)';
			}
			else
			{
				$live_artcile = ' (SELECT  aflw_usr_id AS art_reviewed_by'.$has_reviewed_articles_live_having.'  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id WHERE jnl_id='.$journal_id.' AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND jwf_stage_type = \'review\' AND aflw_jwf_id = jwf_id AND aflw_usr_id = '.$user_id.' GROUP BY aflw_usr_id)';
			}

			$legacy_artcile = ' (SELECT  arev_user_id AS art_reviewed_by'.$has_reviewed_articles_legacy_having.' FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE arld_id = arev_arld_id AND  arev_status IN ("ac","ag") AND arev_user_id = '.$user_id.'  GROUP BY arev_user_id ) ';

		}
		DB::enableQueryLog();
		/*$article_review_result_set = ' (SELECT DISTINCT temp_tb.*'.$sub_condition.' FROM ( '.$live_artcile.' UNION ALL '.$legacy_artcile.') AS temp_tb GROUP BY art_reviewed_by) AS reviewed_art_table ON usr_id = reviewed_art_table.art_reviewed_by ';*/
		$article_review_result_set = ' SELECT min(date_count_temp) AS date_count FROM ( '.$live_artcile.' UNION ALL '.$legacy_artcile.') AS temp_tb '.$article_review_condition.' GROUP BY art_reviewed_by ';
	     
		$result = DB::select($article_review_result_set ." LIMIT 1");
		if(isset($result[0]))
		return $result[0];
		else
		$result;
	
		
	}

	
	public  static function user_past_oneyr_assignments($user_id,$search_filters,$journal_id=NULL)
	{
		$articletable=(new \App\Models\Articles())->getTable();
		$articletypetable=(new \App\Models\Article_types())->getTable();
		$journaltable=(new \App\Models\Journals())->getTable();
		$articleflowtable=(new \App\Models\Article_flow())->getTable();
		$genericflowtable=(new \App\Models\Generic_flows())->getTable();
		$articlelegacytable=(new \App\Models\Article_legacydata())->getTable();
		$reviewer_legacy_table=(new \App\Models\Article_reviewer_legacydata())->getTable();
		//$past_oneyr_assignments_result_set = '';
		//$article_review_condition = '';
		$live_artcile = '';
		$legacy_artcile = '';
		if(isset($search_filters['journal_filter']))
		{
			$temp_oneyear_condition = array();

			if(isset($search_filters['journal_filter']['any']))
				$temp_oneyear_condition[] = ' FIND_array_intersect("'.$search_filters['journal_filter']['any'].'",temp_oneyear_tb.art_reviewed_oneyear_jnl) = 1';
			if(isset($search_filters['journal_filter']['not_in']))
				$temp_oneyear_condition[] = ' FIND_array_not_in("'.$search_filters['journal_filter']['not_in'].'",temp_oneyear_tb.art_reviewed_oneyear_jnl) = 1 ';
			if(isset($search_filters['journal_filter']['in']))
				$temp_oneyear_condition[] = ' FIND_array_in_all("'.$search_filters['journal_filter']['in'].'",temp_oneyear_tb.art_reviewed_oneyear_jnl) = 1 ';

			$article_review_oneyear_condition = implode(' AND ', $temp_oneyear_condition);
			$article_review_oneyear_condition_legacy = str_replace('temp_oneyear_tb', 'temp_oneyear_tb_legacy', $article_review_oneyear_condition);
			if($journal_id == NULL)
			{
			$live_artcile = '  (SELECT temp_oneyear_tb.* FROM (SELECT GROUP_CONCAT(DISTINCT jnl_id) as art_reviewed_oneyear_jnl,count(aflw_usr_id) AS past_oneyr_assignments  FROM '.$articleflowtable.','.$genericflowtable.','.$articletable.','.$articletypetable.','.$journaltable.' WHERE  aflw_jwf_id = jwf_id AND aflw_art_id = art_id AND art_artp_id = artp_id AND artp_jnl_id = jnl_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND art_delete_status = \'n\' AND jwf_stage_type = \'review\' AND aflw_returned_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH)  AND aflw_usr_id = '.$user_id.'  GROUP BY aflw_usr_id) AS temp_oneyear_tb  WHERE '.$article_review_oneyear_condition.') ';
			}
			else
			{
				$live_artcile = '  (SELECT temp_oneyear_tb.* FROM (SELECT GROUP_CONCAT(DISTINCT jnl_id) as art_reviewed_oneyear_jnl,count(aflw_usr_id) AS past_oneyr_assignments  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id  WHERE jnl_id='.$journal_id.' AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND art_delete_status = \'n\' AND jwf_stage_type = \'review\' AND aflw_returned_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH)  AND aflw_usr_id = '.$user_id.'  GROUP BY aflw_usr_id) AS temp_oneyear_tb  WHERE '.$article_review_oneyear_condition.') ';
			}
			//$past_oneyr_assignments_result_set = '';
			//AS past_oneyr_assignments_table ON  usr_id = past_oneyr_assignments_table.art_reviewed_by_oneyear 

			$legacy_artcile = ' SELECT temp_oneyear_tb_legacy.* FROM (SELECT COUNT(arev_user_id) AS past_oneyr_assignments,GROUP_CONCAT(DISTINCT arld_jnl_id) as art_reviewed_oneyear_jnl FROM '.$reviewer_legacy_table.','.$articlelegacytable.'  WHERE arev_arld_id = arld_id AND  arev_stage_end_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH) AND arev_user_id = '.$user_id.' )  AS temp_oneyear_tb_legacy WHERE '.$article_review_oneyear_condition_legacy;	
			$select = 'sum(temp_tb.past_oneyr_assignments) AS past_oneyr_assignments';
		}
		else
		{
			if($journal_id == NULL)
			{
				$live_artcile = ' (SELECT count(aflw_usr_id) AS past_oneyr_assignments  FROM '.$articleflowtable.','.$genericflowtable.' WHERE  aflw_jwf_id = jwf_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\'  AND jwf_stage_type = \'review\' AND aflw_returned_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH) AND aflw_usr_id = '.$user_id.')';
			}
			else
			{
				$live_artcile = ' (SELECT count(aflw_usr_id) AS past_oneyr_assignments  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id WHERE jnl_id = '.$journal_id.' AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND art_delete_status = \'n\' AND jwf_stage_type = \'review\' AND aflw_returned_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH) AND aflw_usr_id = '.$user_id.')';
			}
			$legacy_artcile = ' (SELECT COUNT(arev_user_id) AS past_oneyr_assignments FROM '.$reviewer_legacy_table.' WHERE arev_stage_end_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH) AND arev_user_id = '.$user_id.') ';
			$select = 'sum(temp_tb.past_oneyr_assignments) AS past_oneyr_assignments';
		}
			
		$past_oneyr_assignments_result_set = ' SELECT '.$select.' FROM ( '.$live_artcile.' UNION ALL '.$legacy_artcile.') AS temp_tb ';
			//$select .= ',past_oneyr_assignments_table.past_oneyr_assignments';
			//echo $past_oneyr_assignments_result_set;die;
			DB::enableQueryLog();
			$result = DB::select($past_oneyr_assignments_result_set." LIMIT 1")[0];

			$queries = DB::getQueryLog();
		
		return $result;
	
		
	}


	public static function get_user_data_global($array_data)
	{

		$return_count =isset($array_data['return_count']) ? $array_data['return_count'] :FALSE;
        $exclude_users=isset($array_data['exclude_users']) ? $array_data['exclude_users'] :array();
		$select=isset($array_data['select']) ? $array_data['select'] :'*';
		$standalone_jnl=isset($array_data['standalone_jnl']) ? $array_data['standalone_jnl'] :NULL;
		$search_filters=isset($array_data['search_filters']) ? $array_data['search_filters'] :array();
        $start=isset($array_data['start']) ? $array_data['start'] :NULL;   
		$limit=isset($array_data['limit']) ? $array_data['limit'] :NULL;   
		$order_by_condition=isset($array_data['order_by_condition']) ? $array_data['order_by_condition'] :NULL;
		$date_format=isset($array_data['date_format']) ? $array_data['date_format'] :NULL;
		$ordering_column=isset($array_data['ordering_column']) ? $array_data['ordering_column'] :NULL;
		$jnl_id=isset($array_data['jnl_id']) ? $array_data['jnl_id'] :NULL;
		$page_limit = isset($array_data['page_limit']) ? $array_data['page_limit'] : 10;
        $default_user_status = isset($array_data['user_status']) ? "('".implode("','",$array_data['user_status'])."')" : "('a')" ;


	
        $user_table=(new \App\Models\User())->getTable();
        $user_to_journals_table=(new \App\Models\User_to_journals())->getTable();
        $articlelegacytable=(new \App\Models\Article_legacydata())->getTable();
        $articletable=(new \App\Models\Articles())->getTable();
		$articletypetable=(new \App\Models\Article_types())->getTable();
		$journaltable=(new \App\Models\Journals())->getTable();
		$articleflowtable=(new \App\Models\Article_flow())->getTable();
		$genericflowtable=(new \App\Models\Generic_flows())->getTable();
		$reviewer_legacy_table=(new \App\Models\Article_reviewer_legacydata())->getTable();
		$article_legacy_table=(new \App\Models\Article_legacydata())->getTable();
		$review_rating_table=(new \App\Models\Review_rating())->getTable();
		$article_keyword_table=(new \App\Models\Article_keywords())->getTable();
		$keyword_table=(new \App\Models\Keywords())->getTable();
		$user_affiliation_table=(new \App\Models\User_affiliations())->getTable();
		$keywordtable=(new \App\Models\Keywords())->getTable();
		$userkeyword_table=(new \App\Models\Userkeywords())->getTable();
		$termstable=(new \App\Models\Terms())->getTable();
		$classificationtable=(new \App\Models\Classifications())->getTable();
		$userclassification_table=(new \App\Models\User_classification())->getTable();
		$articleclassification_table=(new \App\Models\Article_classification())->getTable();
		$flagtable=(new \App\Models\Flags())->getTable();
		$userflag_table=(new \App\Models\User_flags())->getTable();
		$userglobalflag_table=(new \App\Models\User_global_flags())->getTable();
		$roles_table=(new \App\Models\Roles())->getTable();
		$country_table=(new \App\Models\Country())->getTable();
		$five_star_rating = $array_data['five_star'];
		$must_jnl_condition_check = FALSE;
	
		$bind_arr = array();
		if(isset($search_filters['journal_filter']) )
		{
			$must_jnl_condition_check = TRUE;
		}

		if($return_count == TRUE)
			$select = 'count(*) as cnt';
		
			$main_sql=DB::table($user_table);
			$main_sql->selectRaw(DB::raw($select));
	
		//**********BUILD USER JOURNAL RESULT SET  -- START***********************//(Journal filter)journal_condition
		$user_journal_result_set = '';
		$journal_condition = '';
		$journal_condition_duplicate = '';
		$journal_flag = FALSE;

		$bsearchJnl_flag = $bsearchkeyword_flag = $bsearchrole_flag = $bsearchcountry_flag = $bsearchretiredrole_flag = $bs_reviewunassigned = $bs_reviewdeclined = FALSE;
		$bsjnl_select = '';
		$bsjnl_join = '';
		if(isset($search_filters['booleanseach_tables']))
		{
			if(in_array('bs_journals',$search_filters['booleanseach_tables']))
			{
				$bsjnl_select = ',GROUP_CONCAT(DISTINCT `jnl_journal_name`) as jnl_journal_name_list ';
				$bsjnl_join = ' JOIN '.$journaltable.' ON  usrj_jnl_id = jnl_id ';
				$bsearchJnl_flag = TRUE;
			}
			if(in_array('bs_keywords',$search_filters['booleanseach_tables']))
			{
				$bsearchkeyword_flag = TRUE;
			}
			if(in_array('bs_roles',$search_filters['booleanseach_tables']))
			{
				$bsearchrole_flag = TRUE;
			}
			if(in_array('bs_retiredroles',$search_filters['booleanseach_tables']))
			{
				$bsearchretiredrole_flag = TRUE;
			}
			if(in_array('bs_country',$search_filters['booleanseach_tables']))
			{
				$bsearchcountry_flag = TRUE;
			}
			if(in_array('bs_reviewunassigned',$search_filters['booleanseach_tables']))
			{
				$bs_reviewunassigned = TRUE;
			}
			if(in_array('bs_reviewdeclined',$search_filters['booleanseach_tables']))
			{
				$bs_reviewdeclined = TRUE;
			}
		}

		if(isset($search_filters['journal_filter']) || $bsearchJnl_flag == TRUE)
		{
			$journal_flag = TRUE;
			$user_journal_result_set = '(SELECT usrj_usr_id,GROUP_CONCAT(DISTINCT `usrj_jnl_id`) as user_journal_list'.$bsjnl_select.' FROM '.$user_to_journals_table.$bsjnl_join.' where usrj_artp_id is NULL group by usrj_usr_id ) AS user_journal_table  ';
// TASK #6273 start	
			// $main_sql->join(DB::raw($user_journal_result_set),'usr_id','=','user_journal_table.usrj_usr_id');
			// TASK #6273 end	
			/*
			if($return_count == FALSE)
				$select .= ',user_journal_table.user_journal_list';
			*/
			//echo '<pre>';print_r($search_filters);exit;
			if(isset($search_filters['journal_filter']['any']))
			{
				$journal_condition .= ' AND FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',user_journal_table.user_journal_list) = 1';
				//$journal_condition_duplicate .= ' AND FIND_array_intersect(:journal_filter_any_NUM,user_journal_table.user_journal_list) = 1';
				//$bind_arr['journal_filter_any'] = $search_filters['journal_filter']['any'];
			}
				
			if(isset($search_filters['journal_filter']['not_in']))
			{
				$journal_condition .= ' AND FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',user_journal_table.user_journal_list) = 1 ';
				//$journal_condition_duplicate .= ' AND FIND_array_not_in(:journal_filter_not_in_NUM,user_journal_table.user_journal_list) = 1 ';
				//$bind_arr['journal_filter_not_in'] = $search_filters['journal_filter']['not_in'];
			}
				
			if(isset($search_filters['journal_filter']['in']))
			{
				$journal_condition .= ' AND FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',user_journal_table.user_journal_list) = 1 ';
				//$journal_condition_duplicate .= ' AND FIND_array_in_all(:journal_filter_in_NUM,user_journal_table.user_journal_list) = 1 ';
				//$bind_arr['journal_filter_in'] = $search_filters['journal_filter']['in'];
			}
			// TASK #6273 start	
			$journal_condition .=' AND user_journal_table.user_journal_list IS NOT NULL';
			// TASK #6273 end	
		}
		//**********BUILD USER JOURNAL RESULT SET  -- STOP***********************//
		
		//**********BUILD ARTICLE RESULT SET  -- START***********************//(Article title --submitted filter)
		$article_result_set = '';
		$article_condition = '';
		if(isset($search_filters['articletitle_filter']['has_submitted_article']))
		{
			if($journal_flag == TRUE)
			{
				$live_artcile = ' (SELECT  DISTINCT art_submitted_by,GROUP_CONCAT(DISTINCT jnl_id) as art_submit_jnl FROM '. $articletable.','.$articletypetable.','.$journaltable.' WHERE art_artp_id = artp_id AND artp_jnl_id = jnl_id AND art_status != "n" AND  art_title LIKE "%'.$search_filters['articletitle_filter']['has_submitted_article'].'%" GROUP BY art_submitted_by) ';
				//$bind_arr['journal_filter_in'] = $search_filters['journal_filter']['in'];
				
				$legacy_artcile = ' (SELECT DISTINCT arld_submitted_by AS art_submitted_by,GROUP_CONCAT(DISTINCT arld_jnl_id) as art_submit_jnl FROM '.$articlelegacytable.'  WHERE `arld_submitted_by` IS NOT NULL AND arld_article_title LIKE "%'.$search_filters['articletitle_filter']['has_submitted_article'].'%" GROUP  BY arld_submitted_by) ';
				
				if(isset($search_filters['journal_filter']['any']))
				{
					$article_condition .= ' AND FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',submit_art_table.art_submit_jnl) = 1';
					//$bind_arr['journal_filter_any1'] = $search_filters['journal_filter']['any'];
				}
					
				if(isset($search_filters['journal_filter']['not_in']))
				{
					$article_condition .= ' AND FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',submit_art_table.art_submit_jnl) = 1 ';
					//$bind_arr['journal_filter_not_in1'] = $search_filters['journal_filter']['not_in'];
				}
					
				if(isset($search_filters['journal_filter']['in']))
				{
					$article_condition .= ' AND FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',submit_art_table.art_submit_jnl) = 1 ';
					//$bind_arr['journal_filter_in1'] = $search_filters['journal_filter']['in'];
				}
					
			}
			else
			{
				$live_artcile = ' (SELECT  DISTINCT art_submitted_by FROM '. $articletable.' where art_status != "n" AND  art_title LIKE "%'.$search_filters['articletitle_filter']['has_submitted_article'].'%") ';
				
				$legacy_artcile = ' (SELECT DISTINCT arld_submitted_by AS art_submitted_by FROM '.$articlelegacytable.'  WHERE `arld_submitted_by` IS NOT NULL AND arld_article_title LIKE "%'.$search_filters['articletitle_filter']['has_submitted_article'].'%") ';
			}

			//$bind_arr['articletitle_filter_has_submitted_article1'] = "%".$search_filters['articletitle_filter']['has_submitted_article']."%";
			//$bind_arr['articletitle_filter_has_submitted_article2'] = "%".$search_filters['articletitle_filter']['has_submitted_article']."%";
			
			$article_result_set = '  ( '.$live_artcile.' UNION ALL '.$legacy_artcile.' ) AS submit_art_table  ';
			$main_sql->join(DB::raw($article_result_set),'usr_id','=','submit_art_table.art_submitted_by');
			
		}
		//**********BUILD ARTICLE RESULT SET  -- STOP***********************//
		
		//**********BUILD ARTICLE FLOW RESULT SET  -- START***********************//(Article title --article reviewed filter)
		$article_review_result_set = '';
		$article_review_condition = '';
		if(isset($search_filters['articletitle_filter']['has_reviewed_articles']) || ($return_count == FALSE && $ordering_column == "date_count" ))
		{
			$has_reviewed_articles_live = '';
			$has_reviewed_articles_legacy = '';
			$filter_type = ' LEFT ';
			if(isset($search_filters['articletitle_filter']['has_reviewed_articles']))
			{
				$filter_type = ' ';
				$has_reviewed_articles_live = 'AND  art_title LIKE "%'.$search_filters['articletitle_filter']['has_reviewed_articles'].'%" ';
				$has_reviewed_articles_legacy = 'AND  arld_article_title LIKE "%'.$search_filters['articletitle_filter']['has_reviewed_articles'].'%" ';

				//$bind_arr['articletitle_filter_has_reviewed_articles1'] = "%".$search_filters['articletitle_filter']['has_reviewed_articles']."%";
				//$bind_arr['articletitle_filter_has_reviewed_articles2'] = "%".$search_filters['articletitle_filter']['has_reviewed_articles']."%";

			}
			
			$has_reviewed_articles_live_having = '';
			$has_reviewed_articles_legacy_having = '';
			$sub_condition = '';
			if($return_count == FALSE && $ordering_column == "date_count")
			{
				$has_reviewed_articles_live_having = ' ,MIN(DATEDIFF(now(), `aflw_returned_date`)) AS date_count_temp ';
				$has_reviewed_articles_legacy_having = ' ,MIN(DATEDIFF(now(), `arev_stage_end_date`)) AS date_count_temp';
				$sub_condition = ',min(date_count_temp) AS date_count';
				$select .= ',reviewed_art_table.date_count';
			}
			
			if($journal_flag == TRUE)
			{
	
			 
				$live_artcile = ' (SELECT aflw_usr_id AS art_reviewed_by,GROUP_CONCAT(DISTINCT jnl_id) as art_reviewed_jnl'.$has_reviewed_articles_live_having.'  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id WHERE aflw_parent_flow_id IS NOT NULL  AND aflw_jwf_id = jwf_id AND aflw_status = \'c\' AND jwf_stage_type = \'review\' '.$has_reviewed_articles_live.'  GROUP BY aflw_usr_id) ';
				
				$legacy_artcile = ' (SELECT DISTINCT arev_user_id AS art_reviewed_by,GROUP_CONCAT(DISTINCT arld_jnl_id) as art_reviewed_jnl'.$has_reviewed_articles_legacy_having.'  FROM '.$reviewer_legacy_table.','.$article_legacy_table.' WHERE arld_id= arev_arld_id AND arev_status IN ("ac","ag") '.$has_reviewed_articles_legacy.'  GROUP BY arev_user_id ) ';
				
				if(isset($search_filters['articletitle_filter']['has_reviewed_articles']))
				{
					if(isset($search_filters['journal_filter']['any']))
					{
						$article_review_condition .= ' AND FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',reviewed_art_table.art_reviewed_jnl) = 1';
						//$bind_arr['journal_filter_any2'] = $search_filters['journal_filter']['any'];
					}
						
					if(isset($search_filters['journal_filter']['not_in']))
					{
						$article_review_condition .= ' AND FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',reviewed_art_table.art_reviewed_jnl) = 1 ';
						//$bind_arr['journal_filter_not_in2'] = $search_filters['journal_filter']['not_in'];
					}
						
					if(isset($search_filters['journal_filter']['in']))
					{
						$article_review_condition .= ' AND FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',reviewed_art_table.art_reviewed_jnl) = 1 ';
						//$bind_arr['journal_filter_in2'] = $search_filters['journal_filter']['in'];
					}
						
				}
			}
			else
			{
				$live_artcile = ' (SELECT DISTINCT aflw_usr_id AS art_reviewed_by'.$has_reviewed_articles_live_having.'  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id  WHERE  aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND jwf_stage_type = \'review\' AND aflw_jwf_id = jwf_id '.$has_reviewed_articles_live.'  GROUP BY aflw_usr_id)';
				
				$legacy_artcile = ' (SELECT DISTINCT arev_user_id AS art_reviewed_by'.$has_reviewed_articles_legacy_having.' FROM '.$article_legacy_table.','.$reviewer_legacy_table.' WHERE arld_id = arev_arld_id AND  arev_status IN ("ac","ag") '.$has_reviewed_articles_legacy.' GROUP BY arev_user_id ) ';
				
			}
			// TASK #6273 start	
			if($filter_type == ' LEFT '){
               $join_filter_type='leftjoin';
			}else{
				$join_filter_type='join';
			}
			// TASK #6273 end
			$article_review_result_set = ' (SELECT DISTINCT temp_tb.*'.$sub_condition.' FROM ( '.$live_artcile.' UNION ALL '.$legacy_artcile.') AS temp_tb GROUP BY art_reviewed_by) AS reviewed_art_table';
			// TASK #6273 start	
			$main_sql->$join_filter_type(DB::raw($article_review_result_set),'reviewed_art_table.art_reviewed_by','=','usr_id');
			// TASK #6273 end	
		}
		//**********BUILD ARTICLE RESULT SET  -- STOP***********************//
		
		//**********BUILD ARTICLE LAST INVITE RESULT SET  -- START***********************//
		$article_review_last_invite_result_set = '';
		$article_last_review_condition = '';
		if($return_count == FALSE && $ordering_column == 'last_invitation_date')
		{
			$live_artcile = '';
			$legacy_artcile = '';
			if($journal_flag == TRUE)
			{
				$live_artcile = ' (SELECT aflw_usr_id AS art_review_invite_usr,GROUP_CONCAT(DISTINCT jnl_id) as art_review_invite_jnl,MAX(aflw_assigned_date) AS temp_last_invite  FROM '. $articleflowtable.','.$genericflowtable.','. $articletable.','.$articletypetable.','.$journaltable.' WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND artp_jnl_id = jnl_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_jwf_id = jwf_id AND aflw_status != "u" AND jwf_stage_type = \'review\' GROUP BY aflw_usr_id) ';
				
				$legacy_artcile = ' (SELECT DISTINCT arev_user_id AS art_review_invite_usr,GROUP_CONCAT(DISTINCT arld_jnl_id) as art_review_invite_jnl,MAX(arev_stage_start_date) AS temp_last_invite  FROM '.$reviewer_legacy_table.','.$article_legacy_table.' WHERE arld_id= arev_arld_id  GROUP BY arev_user_id ) ';
				
				if(isset($search_filters['journal_filter']['any']))
				{
					$article_last_review_condition .= ' AND FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',review_last_invite_table.art_review_invite_jnl) = 1';
					//$bind_arr['journal_filter_any3'] = $search_filters['journal_filter']['any'];
				}
					
				if(isset($search_filters['journal_filter']['not_in']))
				{
					$article_last_review_condition .= ' AND FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',review_last_invite_table.art_review_invite_jnl) = 1 ';
					//$bind_arr['journal_filter_not_in3'] = $search_filters['journal_filter']['not_in'];
				}
					
				if(isset($search_filters['journal_filter']['in']))
				{
					$article_last_review_condition .= ' AND FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',review_last_invite_table.art_review_invite_jnl) = 1 ';
					//$bind_arr['journal_filter_in3'] = $search_filters['journal_filter']['in'];
				}
					
			}
			else
			{
				$live_artcile = ' (SELECT DISTINCT aflw_usr_id AS art_review_invite_usr,MAX(aflw_assigned_date) AS temp_last_invite  FROM '. $articleflowtable.','.$genericflowtable.' WHERE  aflw_jwf_id = jwf_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status != "u" AND jwf_stage_type = \'review\'   GROUP BY aflw_usr_id)';
				
				$legacy_artcile = ' (SELECT DISTINCT arev_user_id AS art_review_invite_usr,MAX(arev_stage_start_date) AS temp_last_invite FROM '.$reviewer_legacy_table.'  GROUP BY arev_user_id ) ';
				
			}
			
			$article_review_last_invite_result_set = ' (SELECT DISTINCT temp_last_invite_tb.*,MAX(temp_last_invite_tb.temp_last_invite) AS last_invitation_date FROM ( '.$live_artcile.' UNION ALL '.$legacy_artcile.') AS temp_last_invite_tb GROUP BY art_review_invite_usr) AS review_last_invite_table ';
			
			$main_sql->leftjoin(DB::raw($article_review_last_invite_result_set),'review_last_invite_table.art_review_invite_usr','=','usr_id');

			if ($date_format != NULL)
				$date_format = self::$date_format_map[$date_format];
			else
				$date_format = '%d-%m-%y';
			
			$select .= ',DATE_FORMAT(review_last_invite_table.last_invitation_date, "' . $date_format . '") AS last_invitation_date';
			//$select .= ',review_last_invite_table.last_invitation_date';
		}
		//**********BUILD ARTICLE LAST INVITE RESULT SET  -- STOP***********************//
		
		//**********BUILD REVIEW RATING RESULT SET  -- START***********************//
		$baseRating = 5;
		if($five_star_rating == FALSE)
			$baseRating = 4;
		$legacyRatingStr = ' IF('.$baseRating.' < arev_reviewer_rating,(('.$baseRating.'*arev_reviewer_rating)/100),arev_reviewer_rating) ';
		//$legacyRatingStr = ' arev_reviewer_rating ';
		$review_rating_order_level_result_set = '';
		if($return_count == FALSE && $ordering_column == 'rating' && !isset($search_filters['review_rating_filter']['sm_rating_above']) && !isset($search_filters['review_rating_filter']['ld_rating_above']))
		{
			$join_type = ' LEFT ';			
			if($journal_flag == TRUE)
			{				
			
				// $journal_condition_str = str_replace('_NUM', '5', $journal_condition_duplicate);
				// $bind_arr = Self::set_bind_arr($search_filters,$bind_arr,5);
				// TASK #6273 start	
				$review_rating_level_temp_live = ' ,(SELECT rvr_reviewer_id,artp_jnl_id,rvr_rating FROM '.$articletypetable.','.$articletable.','.$articleflowtable.','.$review_rating_table.' WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND rvr_aflw_id = aflw_id AND aflw_parent_flow_id IS NOT NULL )  AS review_rating_level_temp_live WHERE 
				FIND_array_in_all(review_rating_level_temp_live.artp_jnl_id,user_journal_table.user_journal_list) = 1';
				
	
				$live_artcile = ' (SELECT review_rating_level_temp_live.rvr_reviewer_id,(review_rating_level_temp_live.rvr_rating) as rating FROM (SELECT usrj_usr_id,GROUP_CONCAT(DISTINCT `usrj_jnl_id`) as user_journal_list FROM '.$user_to_journals_table.' where usrj_artp_id is NULL group by usrj_usr_id) as user_journal_table '.$review_rating_level_temp_live.$journal_condition.')   ';
				// TASK #6273 end	

				//AS review_rating_level_sm_table ON review_rating_level_sm_table.rvr_reviewer_id = usr_id
				// $journal_condition_str = str_replace('_NUM', '6', $journal_condition_duplicate);
				// $bind_arr = Self::set_bind_arr($search_filters,$bind_arr,6);
				// TASK #6273 start	
				$review_rating_level_temp_legacy = ' ,(SELECT arev_user_id as rvr_reviewer_id,arld_jnl_id,'.$legacyRatingStr.' AS rvr_rating FROM '.$reviewer_legacy_table.','.$article_legacy_table.' WHERE  arld_id = arev_arld_id AND arev_reviewer_rating > 0 )  AS review_rating_level_temp_legacy WHERE  FIND_array_in_all(review_rating_level_temp_legacy.arld_jnl_id,user_journal_table.user_journal_list) = 1  ';
				$jnl_condition='';
				$dip_array=array();
				if(isset($search_filters['journal_filter']['any']))
				{
					array_push($dip_array,$search_filters['journal_filter']['any']);
					$jnl_condition .='AND arld_jnl_id IN ('.join(',',$dip_array).')';
				}
				if(isset($search_filters['journal_filter']['not_in']))
				{
					$jnl_condition .='AND arld_jnl_id not IN ('.$search_filters['journal_filter']['not_in'].')';
				}
				if(isset($search_filters['journal_filter']['in']))
				{
					array_push($dip_array,$search_filters['journal_filter']['in']);
					$jnl_condition .='AND arld_jnl_id IN ('.join(',',$dip_array).')';
				}
				$legacy_artcile = ' (SELECT review_rating_level_temp_legacy.rvr_reviewer_id,(review_rating_level_temp_legacy.rvr_rating) as rating FROM (SELECT arev_user_id as rvr_reviewer_id,GROUP_CONCAT(DISTINCT arld_jnl_id) as user_journal_list FROM '.$reviewer_legacy_table.','.$article_legacy_table.' WHERE  arld_id = arev_arld_id AND arev_reviewer_rating > 0 '.$jnl_condition .') as user_journal_table '.$review_rating_level_temp_legacy.$journal_condition.') ';
				// TASK #6273 end	
			}
			else
			{
				$live_artcile = ' (SELECT rvr_reviewer_id,rvr_rating as rating FROM '.$review_rating_table.') '; 
				if($five_star_rating == FALSE)
				{
					$live_artcile = ' (SELECT rvr_reviewer_id,rvr_rating as rating FROM '.$review_rating_table.' WHERE rvr_five_star = \'n\') '; 
				}
				$legacy_artcile = ' (SELECT arev_user_id as rvr_reviewer_id,'.$legacyRatingStr.' as rating FROM '.$reviewer_legacy_table.' WHERE arev_reviewer_rating > 0)';		
			}
			if(!isset($search_filters['review_rating_filter']))
			{
			$review_rating_order_level_result_set = ' ( SELECT  temp1.rvr_reviewer_id,avg(temp1.rating) as rating FROM ( '.$live_artcile.' UNION ALL '.$legacy_artcile.' ) as temp1 GROUP BY rvr_reviewer_id) AS review_rating_table  ';
			$main_sql->leftjoin(DB::raw($review_rating_order_level_result_set),'usr_id','=','review_rating_table.rvr_reviewer_id');
			}
			if($five_star_rating == TRUE)
			{
				$five_star_order_result_set = ' (SELECT temp2.rvr_reviewer_id,AVG(temp2.five_star_rating) AS five_star FROM ((SELECT rate_temp_2.rvr_reviewer_id,rate_temp_2.rvr_rating AS five_star_rating FROM rvw_review_rating as rate_temp_2 WHERE rate_temp_2.rvr_five_star = \'y\')) AS temp2 GROUP BY rate_temp_2.rvr_reviewer_id) AS review_rating_table1';
				$main_sql->leftjoin(DB::raw($five_star_order_result_set),'usr_id','=','review_rating_table1.rvr_reviewer_id');
			}
		
			
			/*if($return_count == FALSE)
			{
				if($five_star_rating == TRUE)
				{
					$select .= ',IF(review_rating_table1.five_star IS NULL,review_rating_table.rating,review_rating_table1.five_star) AS rating';
				}
				else
				{
					$select .= ',review_rating_table.rating as rating';
				}
			}*/
		}
		//**********BUILD REVIEW RATING RESULT SET  -- END***********************//
			
		//**********BUILD ARTICLE 12 MONTH REVIEW RESULT SET  -- START***********************//
		$past_oneyr_assignments_result_set = '';
		if($return_count == FALSE && $ordering_column == 'past_oneyr_assignments')
		{
			if($journal_flag == TRUE)
			{
				$temp_oneyear_condition = array();
				
				if(isset($search_filters['journal_filter']['any']))
				{
					$temp_oneyear_condition[] = ' FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',temp_oneyear_tb.art_reviewed_oneyear_jnl) = 1';
					//$bind_arr['journal_filter_any7'] = $search_filters['journal_filter']['any'];
					//$bind_arr['journal_filter_any8'] = $search_filters['journal_filter']['any'];
				}
					
				if(isset($search_filters['journal_filter']['not_in']))
				{
					$temp_oneyear_condition[] = ' FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',temp_oneyear_tb.art_reviewed_oneyear_jnl) = 1 ';
					// $bind_arr['journal_filter_not_in7'] = $search_filters['journal_filter']['not_in'];
					// $bind_arr['journal_filter_not_in8'] = $search_filters['journal_filter']['not_in'];
				}
					
				if(isset($search_filters['journal_filter']['in']))
				{
					$temp_oneyear_condition[] = ' FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',temp_oneyear_tb.art_reviewed_oneyear_jnl) = 1 ';
					// $bind_arr['journal_filter_in7'] = $search_filters['journal_filter']['in'];
					// $bind_arr['journal_filter_in8'] = $search_filters['journal_filter']['in'];
				}
					
				$article_review_oneyear_condition = implode(' AND ', $temp_oneyear_condition);
				$article_review_oneyear_condition_legacy = str_replace('temp_oneyear_tb', 'temp_oneyear_tb_legacy', $article_review_oneyear_condition);
				//$article_review_oneyear_condition_legacy = str_replace('7', '8', $article_review_oneyear_condition_legacy);

					
				$live_artcile = '  (SELECT temp_oneyear_tb.* FROM (SELECT aflw_usr_id AS art_reviewed_by_oneyear,GROUP_CONCAT(DISTINCT jnl_id) as art_reviewed_oneyear_jnl,count(aflw_usr_id) AS past_oneyr_assignments  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id  WHERE jnl_id='.$jnl_id.' AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND art_delete_status = \'n\' AND jwf_stage_type = \'review\' AND aflw_returned_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH) GROUP BY aflw_usr_id) AS temp_oneyear_tb  WHERE '.$article_review_oneyear_condition.') ';
				
				$legacy_artcile = ' SELECT temp_oneyear_tb_legacy.* FROM (SELECT arev_user_id AS art_reviewed_by_oneyear,GROUP_CONCAT(DISTINCT arld_jnl_id) as art_reviewed_oneyear_jnl,COUNT(arev_user_id) AS past_oneyr_assignments FROM '.$reviewer_legacy_table.','.$articlelegacytable.'  WHERE arev_arld_id = arld_id AND  arev_stage_end_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH) GROUP BY arev_user_id)  AS temp_oneyear_tb_legacy WHERE '.$article_review_oneyear_condition_legacy;	
				$select_assignment = 'temp_tb.art_reviewed_by_oneyear,sum(temp_tb.past_oneyr_assignments) AS past_oneyr_assignments';
			}
			else
			{
			
				$live_artcile = ' (SELECT aflw_usr_id AS art_reviewed_by_oneyear,count(aflw_usr_id) AS past_oneyr_assignments  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id WHERE jnl_id = '.$jnl_id.' AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND art_delete_status = \'n\' AND jwf_stage_type = \'review\' AND aflw_returned_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH)  GROUP BY aflw_usr_id)';
				
			// AS past_oneyr_assignments_table 
			$legacy_artcile = ' (SELECT arev_user_id AS art_reviewed_by_oneyear,COUNT(arev_user_id) AS past_oneyr_assignments FROM '.$reviewer_legacy_table.' WHERE arev_stage_end_date >= DATE_SUB(NOW(), INTERVAL 12 MONTH)  GROUP BY arev_user_id) ';
			$select_assignment = 'temp_tb.art_reviewed_by_oneyear,sum(temp_tb.past_oneyr_assignments) AS past_oneyr_assignments';
			}
			
			$past_oneyr_assignments_result_set = '   (SELECT '.$select_assignment.' FROM ( '.$live_artcile.' UNION ALL '.$legacy_artcile.') AS temp_tb GROUP BY temp_tb.art_reviewed_by_oneyear) AS past_oneyr_assignments_table  ';
			$main_sql->leftjoin(DB::raw($past_oneyr_assignments_result_set),'usr_id','=','past_oneyr_assignments_table.art_reviewed_by_oneyear');
			$select .= ',past_oneyr_assignments_table.past_oneyr_assignments';
			//echo $past_oneyr_assignments_result_set;die;
		}
		//**********BUILD ARTICLE 12 MONTH REVIEW RESULT SET  -- STOP***********************//
		
		//**********BUILD JOURNAL ROLES RESULT SET  -- START***********************//
		$role_result_set = '';
		$role_condition = '';
		$role_condition_arr = array();
		if(isset($search_filters['role_filter']) || $bsearchrole_flag == TRUE)
		{
			$jnl_group = '';
			$jnl_select = '';
			if($journal_flag == TRUE)
			{
				$jnl_group = $jnl_select = ',`usrj_jnl_id` ';
			}
           // TASK #6273 start	
			$search_journal_condition='';
			if(isset($search_filters['journal_filter'])&&isset($search_filters['role_filter']))
			{	
				$dip_array=array();
				if(isset($search_filters['journal_filter']['not_in']))
				{
				$search_journal_condition .='AND usrj_jnl_id NOT IN ('.$search_filters['journal_filter']['not_in'].') ';
				}
				if(isset($search_filters['journal_filter']['in']) || isset($search_filters['journal_filter']['any']))
				{
					if(isset($search_filters['journal_filter']['any']))
					{
					array_push($dip_array,$search_filters['journal_filter']['any']);
					}
					if(isset($search_filters['journal_filter']['in']))
					{
					array_push($dip_array,$search_filters['journal_filter']['in']);
					}
				$search_journal_condition .='AND usrj_jnl_id IN ('.join(',',$dip_array).')';
				}
			}
			// TASK #6273 end	

			$roletb_join = '';
			if($bsearchrole_flag == TRUE)
			{
				$jnl_select .= ',role_name';
				$roletb_join = ' join rvw_roles '.$roles_table.' on usrj_role_id = role_id '; 
			}
				
			/* Feature #2063 - JPR-214 Retiring an AE/Editor -- View article section */
			$retire_condition = '';
			if(isset($client_functionality->cfty_retire_role) && $client_functionality->cfty_retire_role == 'y')
			{
				$retire_condition = ' AND usrj_role_retired = "n" ';
			}
			// TASK #6273 start	
			$role_result_set_temp = ' (SELECT usrj_usr_id'.$jnl_select.',GROUP_CONCAT(DISTINCT usrj_role_id) AS jnl_user_roles,usrj_role_retired FROM '.$user_to_journals_table.$roletb_join.' WHERE  `usrj_artp_id` IS NULL '.$search_journal_condition.' GROUP BY `usrj_usr_id`'.$jnl_group.') AS jnl_role_table ';
			// TASK #6273 end	

			if(isset($search_filters['role_filter']['have']))
			{
				$role_condition_arr[] = ' FIND_array_intersect(\''.$search_filters['role_filter']['have'].'\',jnl_role_table.jnl_user_roles) = 1';
				//$bind_arr['role_filter_have'] = $search_filters['role_filter']['have'];
			}
				
			if(isset($search_filters['role_filter']['not_have']))
			{
				$role_condition_arr[] = ' FIND_array_not_in(\''.$search_filters['role_filter']['not_have'].'\',jnl_role_table.jnl_user_roles) = 1 ';
				//$bind_arr['role_filter_not_have'] = $search_filters['role_filter']['not_have'];
			}
				
			if(isset($search_filters['role_filter']['have_all']))
			{
				$role_condition_arr[] = ' FIND_array_in_all(\''.$search_filters['role_filter']['have_all'].'\',jnl_role_table.jnl_user_roles) = 1 ';
				//$bind_arr['role_filter_have_all'] = $search_filters['role_filter']['have_all'];
			}
				
			
			$role_condition = implode(' AND ', $role_condition_arr);
			if($journal_flag == TRUE)
			{
				$user_journal_result_set = '';
				if(isset($client_functionality->cfty_retire_role) && $client_functionality->cfty_retire_role == 'y')
				{
					$role_condition .= ' AND usrj_role_retired = "n" ';
				}
			/*	// TASK #6273 start	
			$journal_role_conditions = '';
				if(isset($search_filters['journal_filter']['any']))
				{
					$journal_role_conditions .= ' AND FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',jnl_role_table.usrj_jnl_id) = 1';
					//$bind_arr['journal_filter_any9'] = $search_filters['journal_filter']['any'];
				}
				if(isset($search_filters['journal_filter']['not_in']))
				{
					$journal_role_conditions .= ' AND FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',jnl_role_table.usrj_jnl_id) = 1 ';
					//$bind_arr['journal_filter_not_in9'] = $search_filters['journal_filter']['not_in'];
				}
				if(isset($search_filters['journal_filter']['in']))
				{
					$journal_role_conditions .= ' AND FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',jnl_role_table.usrj_jnl_id) = 1 ';
					//$bind_arr['journal_filter_in9'] = $search_filters['journal_filter']['in'];
				}
				// TASK #6273 end	
				*/

				$bscond_str = '';
				if($role_condition!= '')
				{
					$bscond_str = ' WHERE '.$role_condition;
				}
					
              // TASK #6273 start
				$role_result_set_temp = ' (SELECT *,GROUP_CONCAT(DISTINCT `usrj_jnl_id`) as user_journal_list FROM '.$role_result_set_temp.$bscond_str.'  group by usrj_usr_id) AS user_journal_table ';
				$role_condition = '';

			}
			elseif($role_condition!= '')
				$role_condition = ' AND '.$role_condition;
			$role_result_set = $role_result_set_temp.'';
		
		$attch_table = 'jnl_role_table';
			if($journal_flag == TRUE)
			{
				$attch_table = 'user_journal_table';
			}
		/*	
			$main_sql->join(DB::raw($role_result_set_temp),$attch_table.'.usrj_usr_id','=','usr_id');
			// TASK #6273 end*/
			
		}
		// TASK #6273 start
		if($user_journal_result_set==''&&isset($search_filters['role_filter'])){
			$main_sql->join(DB::raw($role_result_set_temp),$attch_table.'.usrj_usr_id','=','usr_id');
		}elseif(isset($search_filters['journal_filter'])){ 
			$main_sql->leftjoin(DB::raw($user_journal_result_set),'usr_id','=','user_journal_table.usrj_usr_id');
		}
		// TASK #6273 end
		//**********BUILD JOURNAL ROLES RESULT SET  -- STOP***********************//
		
			/**** Retired role ******/
		/* Feature #2063 - JPR-214 Retiring an AE/Editor -- View article section */
		$retired_role_result_set = '';
		$retired_role_condition = '';
		$retired_jnl_condition = '';
		$retired_role_condition_arr = array();
		if(isset($search_filters['retired_role_filter']) || $bsearchretiredrole_flag == TRUE)
		{
			$jnl_group = '';
			$jnl_select = '';
			if($journal_flag == TRUE)
			{
				$jnl_group = $jnl_select = ',`usrj_jnl_id` ';
				
			}
			$roletb_join = '';
			if($bsearchretiredrole_flag == TRUE)
			{
				$jnl_select .= ',role_name';
				$roletb_join = ' join rvw_roles '.$roles_table.' on usrj_role_id = role_id '; 
			}

			
			$retired_role_result_set_temp = ' (SELECT usrj_usr_id'.$jnl_select.',GROUP_CONCAT(DISTINCT usrj_role_id) AS jnl_user_roles,usrj_role_retired FROM '.$user_to_journals_table.$roletb_join.' WHERE  `usrj_artp_id` IS NULL AND usrj_role_retired = "y"  GROUP BY `usrj_usr_id`'.$jnl_group.') AS jnl_retired_role_table ';

			if(isset($search_filters['retired_role_filter']['have']))
			{
				$retired_role_condition_arr[] = ' FIND_array_intersect(\''.$search_filters['retired_role_filter']['have'].'\',jnl_retired_role_table.jnl_user_roles) = 1';
				//$bind_arr['retired_role_filter_have'] = $search_filters['retired_role_filter']['have'];
			}
				
			if(isset($search_filters['retired_role_filter']['not_have']))
			{
				$retired_role_condition_arr[] = ' FIND_array_not_in(\''.$search_filters['retired_role_filter']['not_have'].'\',jnl_retired_role_table.jnl_user_roles) = 1 ';
				//$bind_arr['retired_role_filter_not_have'] = $search_filters['retired_role_filter']['not_have'];
			}
				
			if(isset($search_filters['retired_role_filter']['have_all']))
			{
				$retired_role_condition_arr[] = ' FIND_array_in_all(\''.$search_filters['retired_role_filter']['have_all'].'\',jnl_retired_role_table.jnl_user_roles) = 1 ';
				//$bind_arr['retired_role_filter_have_all'] = $search_filters['retired_role_filter']['have_all'];
			}
				
			if(!empty($retired_role_condition_arr))
			{
				$retired_role_condition = implode(' AND ', $retired_role_condition_arr);
			}
			
			$retire_tb_name = 'jnl_retired_role_table';
			if($journal_flag == TRUE)
			{
				//$user_journal_result_set = '';
				if(!empty($retired_role_condition))
				{
					$retired_role_condition .= ' AND ';
				}
				$retired_role_condition .= '  usrj_role_retired = "y" ';
				
				$retired_role_result_set_temp = ' (SELECT *,GROUP_CONCAT(DISTINCT `usrj_jnl_id`) as user_journal_list FROM '.$retired_role_result_set_temp.' WHERE '.$retired_role_condition.'  group by usrj_usr_id) AS user_journal_table_retired ';
				$retired_role_condition = '';
				$retire_tb_name = 'user_journal_table_retired';
				$retired_jnl_condition = str_replace('user_journal_table', 'user_journal_table_retired', $journal_condition);
				
				// $retired_jnl_condition = str_replace('_NUM', '4', $retired_jnl_condition);
				// $bind_arr = Self::set_bind_arr($search_filters,$bind_arr,4);
				
			}
			elseif($retired_role_condition!= '')
			{
				$retired_role_condition = ' AND '.$retired_role_condition;
			}
			$retired_role_result_set = ''.$retired_role_result_set_temp;
			$main_sql->join(DB::raw($retired_role_result_set),''.$retire_tb_name.'.usrj_usr_id','=','usr_id');
			
		}
		
		/**** Retired role ******/
		
		//**********BUILD REVIEW RATING SET  -- START***********************// (level of details)
		$review_rating_ld_level_result_set = '';
		$review_rating_ld_level_condition = '';
		if(isset($search_filters['review_rating_filter']['ld_rating_above']))
		{
			if($journal_flag == TRUE)
			{				
				// $journal_condition_str = str_replace('_NUM', '7', $journal_condition_duplicate);
				// $bind_arr = Self::set_bind_arr($search_filters,$bind_arr,7);
				$journal_condition_after_trim = Str::replaceFirst('AND ', '', ltrim($journal_condition));
				$journal_condition_for_rating = '';
				if(isset($search_filters['journal_filter']['any']))
				{
					$journal_condition_for_rating .= ' AND artp_jnl_id IN ('.$search_filters['journal_filter']['any'].')';
				}
				if(isset($search_filters['journal_filter']['not_in']))
				{
					$journal_condition_for_rating .=  ' AND artp_jnl_id NOT IN ('.$search_filters['journal_filter']['not_in'].')';
				}
				$review_rating_level_temp = ' ,(SELECT rvr_reviewer_id,artp_jnl_id,rvr_rating FROM '.$articletypetable.','.$articletable.','.$articleflowtable.','.$review_rating_table.' WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND rvr_aflw_id = aflw_id AND aflw_parent_flow_id IS NOT NULL AND  rvr_rating_type = \'ld\' AND rvr_five_star = \'n\' )  AS review_rating_level_temp WHERE ';
				if(isset($search_filters['journal_filter']['in']))
				{	
					$journal_ids = [];
					$journal_ids[] = $search_filters['journal_filter']['in'];
					$merged_ids = implode(',', $journal_ids);
					$journal_condition_for_rating .=  ' AND FIND_array_in_all("'.$merged_ids.'", journals.jnl_ids) = 1';
					$review_rating_level_temp = ' ,(SELECT rvr_reviewer_id,artp_jnl_id,rvr_rating FROM '.$articletypetable.','.$articletable.','.$articleflowtable.','.$review_rating_table.' JOIN ( SELECT GROUP_CONCAT(DISTINCT artp.artp_jnl_id) AS jnl_ids FROM rvw_review_rating rvr2 JOIN rvw_article_flow aflw2 ON rvr2.rvr_aflw_id = aflw2.aflw_id JOIN rvw_articles art2 ON aflw2.aflw_art_id = art2.art_id JOIN rvw_article_types artp ON art2.art_artp_id = artp.artp_id WHERE aflw2.aflw_parent_flow_id IS NOT NULL AND artp.artp_jnl_id IN (' . $merged_ids . ') ) AS journals WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND rvr_aflw_id = aflw_id AND aflw_parent_flow_id IS NOT NULL '.$journal_condition_for_rating.' AND  rvr_rating_type = \'ld\' AND rvr_five_star = \'n\' )  AS review_rating_level_temp WHERE artp_jnl_id IN( '.$merged_ids.') AND ';
				}
				
				$review_rating_ld_level_result_set = '  (SELECT review_rating_level_temp.rvr_reviewer_id,avg(review_rating_level_temp.rvr_rating) as rating FROM (SELECT usrj_usr_id,GROUP_CONCAT(DISTINCT `usrj_jnl_id`) as user_journal_list FROM '.$user_to_journals_table.' where usrj_artp_id is NULL group by usrj_usr_id) as user_journal_table '.$review_rating_level_temp.$journal_condition_after_trim.' GROUP BY rvr_reviewer_id) AS review_rating_ld_level_table   ';
				$main_sql->join(DB::raw($review_rating_ld_level_result_set),'review_rating_ld_level_table.rvr_reviewer_id','=','usr_id');
				//$user_journal_result_set = '';
				if($must_jnl_condition_check == FALSE)
				{
					$journal_condition = '';
					//$bind_arr = self::pop_bind_arr($search_filters,$bind_arr);
				}
			}
			else
			{
	
				$review_rating_ld_level_result_set = '   (SELECT rvr_reviewer_id,avg(rvr_rating) as rating FROM '.$review_rating_table.' WHERE rvr_rating_type = \'ld\'  GROUP BY rvr_reviewer_id) AS review_rating_ld_level_table  ';
				$main_sql->join(DB::raw($review_rating_ld_level_result_set),'review_rating_ld_level_table.rvr_reviewer_id','=','usr_id');
			}
			$review_rating_ld_level_condition = ' AND review_rating_table.rating >= '.$search_filters['review_rating_filter']['ld_rating_above'].' ';
			//$bind_arr['review_rating_filter_ld_rating_above'] = $search_filters['review_rating_filter']['ld_rating_above'];
		}
		//**********BUILD REVIEW RATING SET  -- STOP***********************//
		
		//**********BUILD REVIEW RATING SET  -- START***********************// (scientific merit )
		$review_rating_sm_level_result_set = '';
		$review_rating_sm_level_condition = '';
		if(isset($search_filters['review_rating_filter']['sm_rating_above']))
		{
			if($journal_flag == TRUE)
			{
/*Task #1893 ReView: Reviewer filtering and sorting (basecamp issue)*/
				$journal_condition_after_trim = Str::replaceFirst('AND ', '', ltrim($journal_condition));
				$journal_condition_for_rating = '';
				if(isset($search_filters['journal_filter']['any']))
				{
					$journal_condition_for_rating .= ' AND artp_jnl_id IN ('.$search_filters['journal_filter']['any'].')';
				}
				if(isset($search_filters['journal_filter']['not_in']))
				{
					$journal_condition_for_rating .=  ' AND artp_jnl_id NOT IN ('.$search_filters['journal_filter']['not_in'].')';
				}
				$review_rating_level_temp = ' ,(SELECT rvr_reviewer_id,artp_jnl_id,rvr_rating FROM '.$articletypetable.','.$articletable.','.$articleflowtable.','.$review_rating_table.' WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND rvr_aflw_id = aflw_id AND aflw_parent_flow_id IS NOT NULL AND  rvr_rating_type = \'sm\' AND rvr_five_star = \'n\')  AS review_rating_level_temp WHERE ';
				if(isset($search_filters['journal_filter']['in']))
				{	
					$journal_ids = [];
					$journal_ids[] = $search_filters['journal_filter']['in'];
					$merged_ids = implode(',', $journal_ids);
					$journal_condition_for_rating .=  ' AND FIND_array_in_all("'.$merged_ids.'", journals.jnl_ids) = 1';
					$review_rating_level_temp = ' ,(SELECT rvr_reviewer_id,artp_jnl_id,rvr_rating FROM '.$articletypetable.','.$articletable.','.$articleflowtable.','.$review_rating_table.' JOIN ( SELECT GROUP_CONCAT(DISTINCT artp.artp_jnl_id) AS jnl_ids FROM rvw_review_rating rvr2 JOIN rvw_article_flow aflw2 ON rvr2.rvr_aflw_id = aflw2.aflw_id JOIN rvw_articles art2 ON aflw2.aflw_art_id = art2.art_id JOIN rvw_article_types artp ON art2.art_artp_id = artp.artp_id WHERE aflw2.aflw_parent_flow_id IS NOT NULL AND artp.artp_jnl_id IN (' . $merged_ids . ') ) AS journals WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND rvr_aflw_id = aflw_id AND aflw_parent_flow_id IS NOT NULL '.$journal_condition_for_rating.' AND  rvr_rating_type = \'sm\' AND rvr_five_star = \'n\')  AS review_rating_level_temp WHERE artp_jnl_id IN( '.$merged_ids.') AND ';
				}
				
				$review_rating_sm_level_result_set = '  (SELECT review_rating_level_temp.rvr_reviewer_id,avg(review_rating_level_temp.rvr_rating) as rating FROM (SELECT usrj_usr_id,GROUP_CONCAT(DISTINCT `usrj_jnl_id`) as user_journal_list FROM '.$user_to_journals_table.' where usrj_artp_id is NULL group by usrj_usr_id) as user_journal_table '.$review_rating_level_temp.$journal_condition_after_trim.' GROUP BY rvr_reviewer_id) AS review_rating_level_sm_table ';
				$main_sql->join(DB::raw($review_rating_sm_level_result_set),'review_rating_level_sm_table.rvr_reviewer_id','=','usr_id');
				//$user_journal_result_set = '';
				if($must_jnl_condition_check == FALSE)
				{
					$journal_condition = '';
					//$bind_arr = self::pop_bind_arr($search_filters,$bind_arr);
				}
			}
			else
			{
		
				$review_rating_sm_level_result_set = '  (SELECT rvr_reviewer_id,avg(rvr_rating) as rating FROM '.$review_rating_table.' WHERE rvr_rating_type = \'sm\' AND rvr_five_star = \'n\'  GROUP BY rvr_reviewer_id) AS review_rating_level_sm_table  ';
				$main_sql->join(DB::raw($review_rating_sm_level_result_set),'review_rating_level_sm_table.rvr_reviewer_id','=','usr_id');
			}
			$review_rating_sm_level_condition = ' AND review_rating_table.rating >= '.$search_filters['review_rating_filter']['sm_rating_above'].' ';
			//$bind_arr['review_rating_filter_sm_rating_above'] = $search_filters['review_rating_filter']['sm_rating_above'];
		}
		//**********BUILD REVIEW RATING SET  -- STOP***********************//
		
		//**********BUILD REVIEW RATING SET  -- START***********************// 
		$review_rating_level_result_set = '';
		$review_rating_level_condition = '';
		if(isset($search_filters['review_rating_filter']['avg_rating_above']) || isset($search_filters['review_rating_filter']))
		{
			$join_type = ' LEFT ';
			if(isset($search_filters['review_rating_filter']['avg_rating_above']))
			{
				if($five_star_rating == FALSE)
				{
					$review_rating_level_condition .= ' AND review_rating_table.rating >= "'.$search_filters['review_rating_filter']['avg_rating_above'].'"';
					//$bind_arr['review_rating_filter_avg_rating_above'] = $search_filters['review_rating_filter']['avg_rating_above'];
				}
				else
				{
					$review_rating_level_condition .= ' AND (CASE WHEN(SELECT COUNT(rvr_id) FROM '.$review_rating_table.' AS review_rate WHERE review_rate.rvr_rating_type = \'sm\' AND review_rate.rvr_five_star = \'y\' AND review_rate.rvr_reviewer_id = usr_id) > 0 THEN (SELECT AVG(rvr_rating) FROM '.$review_rating_table.' WHERE rvr_rating_type = \'sm\' AND rvr_five_star = \'y\' AND rvr_reviewer_id = usr_id) >= '.$search_filters['review_rating_filter']['avg_rating_above'].' ELSE review_rating_table.rating >= "'.$search_filters['review_rating_filter']['avg_rating_above'].'" END ) ';
					// $bind_arr['review_rating_filter_avg_rating_above1'] = $search_filters['review_rating_filter']['avg_rating_above'];
					// $bind_arr['review_rating_filter_avg_rating_above2'] = $search_filters['review_rating_filter']['avg_rating_above'];
				}
				$join_type = ' ';
			}

			if(isset($search_filters['review_rating_filter']['has_at_least']))
			{
				if($five_star_rating == FALSE)
				{
					$review_rating_level_condition .= ' AND review_rating_table.rating >= '.$search_filters['review_rating_filter']['has_at_least'].' ';
					//$bind_arr['review_rating_filter_has_at_least'] = $search_filters['review_rating_filter']['has_at_least'];
				}
				else
				{
					$review_rating_level_condition .= ' AND (CASE WHEN(SELECT COUNT(rvr_id) FROM '.$review_rating_table.' AS review_rate WHERE review_rate.rvr_rating_type = \'sm\' AND review_rate.rvr_five_star = \'y\' AND review_rate.rvr_reviewer_id = usr_id) > 0 THEN (SELECT AVG(rvr_rating) FROM '.$review_rating_table.' WHERE rvr_rating_type = \'sm\' AND rvr_five_star = \'y\' AND rvr_reviewer_id = usr_id) >= '.$search_filters['review_rating_filter']['has_at_least'].' ELSE review_rating_table.rating >= '.$search_filters['review_rating_filter']['has_at_least'].' END ) ';
					// $bind_arr['review_rating_filter_has_at_least1'] = $search_filters['review_rating_filter']['has_at_least'];
					// $bind_arr['review_rating_filter_has_at_least2'] = $search_filters['review_rating_filter']['has_at_least'];
				}
				$join_type = ' ';
			}

			if(isset($search_filters['review_rating_filter']['has_a_maximum']))
			{
				if($five_star_rating == FALSE)
				{
					$review_rating_level_condition .= ' AND review_rating_table.rating <= '.$search_filters['review_rating_filter']['has_a_maximum'].' ';
					//$bind_arr['review_rating_filter_has_a_maximum'] = $search_filters['review_rating_filter']['has_a_maximum'];
				}
				else
				{
					$review_rating_level_condition .= ' AND (CASE WHEN(SELECT COUNT(rvr_id) FROM '.$review_rating_table.' AS review_rate WHERE review_rate.rvr_rating_type = \'sm\' AND review_rate.rvr_five_star = \'y\' AND review_rate.rvr_reviewer_id = usr_id) > 0 THEN (SELECT AVG(rvr_rating) FROM '.$review_rating_table.' WHERE rvr_rating_type = \'sm\' AND rvr_five_star = \'y\' AND rvr_reviewer_id = usr_id) <= '.$search_filters['review_rating_filter']['has_a_maximum'].' ELSE review_rating_table.rating <= '.$search_filters['review_rating_filter']['has_a_maximum'].' END ) ';
					// $bind_arr['review_rating_filter_has_a_maximum1'] = $search_filters['review_rating_filter']['has_a_maximum'];
					// $bind_arr['review_rating_filter_has_a_maximum2'] = $search_filters['review_rating_filter']['has_a_maximum'];
				}
					$join_type = ' ';
			}
			
			if($journal_flag == TRUE)
			{				
				
				// $journal_condition_str = str_replace('_NUM', '11', $journal_condition_duplicate);
				// $bind_arr = Self::set_bind_arr($search_filters,$bind_arr,11);
				/*Task #1893 ReView: Reviewer filtering and sorting (basecamp issue)*/
				$journal_condition_after_trim = Str::replaceFirst('AND ', '', ltrim($journal_condition));
				$journal_condition_for_rating = '';
				if(isset($search_filters['journal_filter']['any']))
				{
					$journal_condition_for_rating .= ' AND artp_jnl_id IN ('.$search_filters['journal_filter']['any'].')';
				}
				if(isset($search_filters['journal_filter']['not_in']))
				{
					$journal_condition_for_rating .=  ' AND artp_jnl_id NOT IN ('.$search_filters['journal_filter']['not_in'].')';
				}
				$review_rating_level_temp_live = ' ,(SELECT rvr_reviewer_id,artp_jnl_id,rvr_rating FROM '.$articletypetable.','.$articletable.','.$articleflowtable.','.$review_rating_table.' WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND rvr_aflw_id = aflw_id AND aflw_parent_flow_id IS NOT NULL'.$journal_condition_for_rating.' ) AS review_rating_level_temp_live WHERE ';
				if(isset($search_filters['journal_filter']['in']))
				{	
					$journal_ids = [];
					$journal_ids[] = $search_filters['journal_filter']['in'];
					$merged_ids = implode(',', $journal_ids);
					$journal_condition_for_rating .=  ' AND FIND_array_in_all("'.$merged_ids.'", journals.jnl_ids) = 1';
					$review_rating_level_temp_live = ' ,(SELECT rvr_reviewer_id,artp_jnl_id,rvr_rating FROM '.$articletypetable.','.$articletable.','.$articleflowtable.','.$review_rating_table.' JOIN ( SELECT GROUP_CONCAT(DISTINCT artp.artp_jnl_id) AS jnl_ids FROM rvw_review_rating rvr2 JOIN rvw_article_flow aflw2 ON rvr2.rvr_aflw_id = aflw2.aflw_id JOIN rvw_articles art2 ON aflw2.aflw_art_id = art2.art_id JOIN rvw_article_types artp ON art2.art_artp_id = artp.artp_id WHERE aflw2.aflw_parent_flow_id IS NOT NULL AND artp.artp_jnl_id IN (' . $merged_ids . ') ) AS journals WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND rvr_aflw_id = aflw_id AND aflw_parent_flow_id IS NOT NULL'.$journal_condition_for_rating.' ) AS review_rating_level_temp_live WHERE artp_jnl_id IN( '.$merged_ids.') AND ';
				}
				// $review_rating_level_temp_live = ' ,(SELECT rvr_reviewer_id,artp_jnl_id,rvr_rating FROM '.$articletypetable.','.$articletable.','.$articleflowtable.','.$review_rating_table.' WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND rvr_aflw_id = aflw_id AND aflw_parent_flow_id IS NOT NULL'.$journal_condition_for_rating.' ) AS review_rating_level_temp_live WHERE TRUE ';
				
				$live_artcile = ' (SELECT review_rating_level_temp_live.rvr_reviewer_id,avg(review_rating_level_temp_live.rvr_rating) as rating FROM (SELECT usrj_usr_id,GROUP_CONCAT(DISTINCT `usrj_jnl_id`) as user_journal_list FROM '.$user_to_journals_table.' where usrj_artp_id is NULL group by usrj_usr_id) as user_journal_table '.$review_rating_level_temp_live.$journal_condition_after_trim.' GROUP BY rvr_reviewer_id )   ';
				//AS review_rating_level_sm_table ON review_rating_level_sm_table.rvr_reviewer_id = usr_id
				// $journal_condition_str = str_replace('_NUM', '12', $journal_condition_duplicate);
				// $bind_arr = Self::set_bind_arr($search_filters,$bind_arr,12);
				
				$review_rating_level_temp_legacy = ' ,(SELECT arev_user_id as rvr_reviewer_id,arld_jnl_id,'.$legacyRatingStr.' AS rvr_rating FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE  arld_id = arev_arld_id AND arev_reviewer_rating > 0 )  AS review_rating_level_temp_legacy WHERE ';
				
				$legacy_artcile = ' (SELECT review_rating_level_temp_legacy.rvr_reviewer_id,avg(review_rating_level_temp_legacy.rvr_rating) as rating FROM (SELECT arev_user_id as rvr_reviewer_id,GROUP_CONCAT(DISTINCT arld_jnl_id) as user_journal_list FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE  arld_id = arev_arld_id AND arev_reviewer_rating > 0 ) as user_journal_table '.$review_rating_level_temp_legacy.$journal_condition_after_trim.' GROUP BY rvr_reviewer_id ) ';
				
				//AS review_rating_level_legacy_table ON review_rating_level_legacy_table.rvr_reviewer_id = usr_id  
				
				//$user_journal_result_set = '';
				if($must_jnl_condition_check == FALSE && isset($search_filters['review_rating_filter']['avg_rating_above']))
				{
					$journal_condition = '';
					//$bind_arr = self::pop_bind_arr($search_filters,$bind_arr);					
				}
					
			}
			else
			{
				$live_artcile = ' (SELECT rvr_reviewer_id,rvr_rating as rating FROM '.$review_rating_table.') '; 
				if($five_star_rating == FALSE)
				{
					$live_artcile = ' (SELECT rvr_reviewer_id,rvr_rating as rating FROM '.$review_rating_table.' WHERE rvr_five_star=\'n\') '; 
				}
				$legacy_artcile = ' (SELECT arev_user_id as rvr_reviewer_id,'.$legacyRatingStr.' as rating FROM '.$reviewer_legacy_table.' WHERE arev_reviewer_rating > 0)';
				
				
				
			}
			// TASK #6273 start	
			$review_rating_level_result_set = ' ( SELECT  temp1.rvr_reviewer_id,avg(temp1.rating) as rating FROM ( '.$live_artcile.' UNION ALL '.$legacy_artcile.' ) as temp1 GROUP BY rvr_reviewer_id) AS review_rating_table ';$main_sql->leftjoin(DB::raw($review_rating_level_result_set),'review_rating_table.rvr_reviewer_id','=','usr_id');
			// TASK #6273 end	
			
			// if($return_count == FALSE)
			// 	$select .= ',review_rating_table.rating';
		}
		//**********BUILD REVIEW RATING SET  -- STOP***********************//
		
		//**********BUILD ARTICLE FLOW COMPLETED REVIEW RESULT SET  -- START***********************//(Article reviewed --article reviewed filter)
		$completed_article_review_result_set = '';
		$completed_article_review_condition = '';
		if(isset($search_filters['completed_review_count_filter']) || isset($search_filters['review_date_filter']))
		{
			
			$has_at_least_live = $has_at_least_legacy= array();
			if(isset($search_filters['completed_review_count_filter']['has_at_least']))
			{
				
				$has_at_least_live[] = ' count(art_cmpt_reviewed_by) >= '.$search_filters['completed_review_count_filter']['has_at_least'].' ';
				$has_at_least_legacy[] = ' count(art_cmpt_reviewed_by) >= '.$search_filters['completed_review_count_filter']['has_at_least'].' ';
				// $bind_arr['completed_review_count_filter_has_at_least1'] = $search_filters['completed_review_count_filter']['has_at_least'];
				// $bind_arr['completed_review_count_filter_has_at_least2'] = $search_filters['completed_review_count_filter']['has_at_least'];
				

			}

			if(isset($search_filters['completed_review_count_filter']['has_a_maximum']))
			{
				
				$has_at_least_live[] = ' count(art_cmpt_reviewed_by) <= '.$search_filters['completed_review_count_filter']['has_a_maximum'].'';
				$has_at_least_legacy[] = '  count(art_cmpt_reviewed_by) <= '.$search_filters['completed_review_count_filter']['has_a_maximum'].'';
				// $bind_arr['completed_review_count_filter_has_a_maximum1'] = $search_filters['completed_review_count_filter']['has_a_maximum'];
				// $bind_arr['completed_review_count_filter_has_a_maximum2'] = $search_filters['completed_review_count_filter']['has_a_maximum'];

			}

			$having_live_condition = $having_legacy_condition = '';
			if(isset($search_filters['completed_review_count_filter']))
			{
				$having_live_condition = ' HAVING '. implode(' AND ', $has_at_least_live); 
				$having_legacy_condition = ' HAVING '. implode(' AND ', $has_at_least_legacy);
			}
			
			$review_date_condition_live = '';
			$review_date_condition_legacy = '';
			$live_return_date = '';
			$legacy_return_date = '';
			if(isset($search_filters['review_date_filter']))
			{
				$live_return_date = ',aflw_returned_date AS review_cmpt_date';
				$legacy_return_date = ',arev_stage_end_date AS review_cmpt_date';
			
				if($search_filters['review_date_filter'] == 'current_year')
				{
					$review_date_condition_live = ' AND DATE_FORMAT(`aflw_returned_date`,\'%Y\') = '.date('Y').' ';
					$review_date_condition_legacy = ' AND DATE_FORMAT(`arev_stage_end_date`,\'%Y\') = '.date('Y').' ';
				}
				elseif($search_filters['review_date_filter'] == 'last_year')
				{
					$review_date_condition_live = ' AND DATE_FORMAT(`aflw_returned_date`,\'%Y\') = '.(date('Y')- 1).' ';
					$review_date_condition_legacy = ' AND DATE_FORMAT(`arev_stage_end_date`,\'%Y\') = '.(date('Y')- 1).' ';
				}
				elseif($search_filters['review_date_filter'] == 'custom_date')
				{
					$date_format = date_format_map($search_filters['jnl_date']);
					$start_date = date('Y-m-d' , strtotime($search_filters['review_date_start']));
					$end_date = date('Y-m-d' , strtotime($search_filters['review_date_end']));
					
					/*$start_date = date('Y-m-d' , strtotime('01-02-2018'));
					$end_date = date('Y-m-d' , strtotime('28-06-2018'));*/
					/*
					$review_date_condition_live = ' AND DATE_FORMAT(`aflw_returned_date`,"%Y-%m-%d") >= "'.$start_date.'" AND DATE_FORMAT(`aflw_returned_date`,"%Y-%m-%d") <= "'.$end_date.'" ';
					
					$review_date_condition_legacy = ' AND DATE_FORMAT(`arev_stage_end_date`,"%Y-%m-%d") >= "'.$start_date.'" AND DATE_FORMAT(`arev_stage_end_date`,"%Y-%m-%d") <= "'.$end_date.'" ';
			*/
					$review_date_condition_live = ' AND DATE_FORMAT(`aflw_returned_date`,"%Y-%m-%d") >= \''.$start_date.'\' AND DATE_FORMAT(`aflw_returned_date`,"%Y-%m-%d") <= \''.$end_date.'\' ';
										
					$review_date_condition_legacy = ' AND DATE_FORMAT(`arev_stage_end_date`,"%Y-%m-%d") >= \''.$start_date.'\' AND DATE_FORMAT(`arev_stage_end_date`,"%Y-%m-%d") <= '.$end_date.' ';

					// $bind_arr['review_date_filter_review_date_start1'] = $start_date;
					// $bind_arr['review_date_filter_review_date_end1'] = $end_date;
					// $bind_arr['review_date_filter_review_date_start2'] = $start_date;
					// $bind_arr['review_date_filter_review_date_end2'] = $end_date;


				}
				
			}
				
			if($journal_flag == TRUE)
			{



				$live_artcile = ' (SELECT aflw_usr_id AS art_cmpt_reviewed_by'.$live_return_date.',GROUP_CONCAT(DISTINCT jnl_id) as art_compt_reviewed_jnl  FROM '.$articleflowtable.','.$genericflowtable.','. $articletable.','.$articletypetable.','.$journaltable.' WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND artp_jnl_id = jnl_id AND aflw_parent_flow_id IS NOT NULL AND aflw_jwf_id = jwf_id  AND aflw_status = \'c\' AND jwf_stage_type = \'review\' '.$review_date_condition_live.' GROUP BY aflw_usr_id  '.$having_live_condition.') ';
				
				$legacy_artcile = ' (SELECT DISTINCT arev_user_id AS art_cmpt_reviewed_by'.$legacy_return_date.',GROUP_CONCAT(DISTINCT arld_jnl_id) as art_reviewed_jnl  FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE arld_id= arev_arld_id AND arev_status IN ("ac","ag") '.$review_date_condition_legacy.' GROUP BY arev_user_id '.$having_legacy_condition.' ) ';
				
				if(isset($search_filters['journal_filter']['any']))
				{
					$completed_article_review_condition .= ' AND FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',compt_reviewed_art_table.art_compt_reviewed_jnl) = 1';
					//$bind_arr['journal_filter_any13'] = $search_filters['journal_filter']['any'];

				}
					
				if(isset($search_filters['journal_filter']['not_in']))
				{
					$completed_article_review_condition .= ' AND FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',compt_reviewed_art_table.art_compt_reviewed_jnl) = 1 ';
					//$bind_arr['journal_filter_not_in_13'] = $search_filters['journal_filter']['not_in'];
				}
					
				if(isset($search_filters['journal_filter']['in']))
				{
					$completed_article_review_condition .= ' AND FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',compt_reviewed_art_table.art_compt_reviewed_jnl) = 1 ';
					//$bind_arr['journal_filter_in13'] = $search_filters['journal_filter']['in'];
				}
					
				
				$user_journal_result_set = '';
				if($must_jnl_condition_check == FALSE)
				{
					$journal_condition = '';
					//$bind_arr = self::pop_bind_arr($search_filters,$bind_arr);					
				}
					
			}
			else
			{
			
				
				$live_artcile = ' (SELECT aflw_usr_id AS art_cmpt_reviewed_by'.$live_return_date.'  FROM '. $articletable.','.$articleflowtable.','.$genericflowtable.' WHERE aflw_jwf_id = jwf_id  AND aflw_art_id = art_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND jwf_stage_type = \'review\' '.$review_date_condition_live.' GROUP BY aflw_usr_id  '.$having_live_condition.')';
				
				$legacy_artcile = ' (SELECT DISTINCT arev_user_id AS art_cmpt_reviewed_by'.$legacy_return_date.' FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE arld_id = arev_arld_id AND  arev_status IN ("ac","ag") '.$review_date_condition_legacy.' GROUP BY arev_user_id  '.$having_legacy_condition.') ';
				
			}
			
			$join_result_set = $live_artcile.' UNION ALL '.$legacy_artcile;
			/*if(!isset($search_filters['completed_review_count_filter']))
				$join_result_set = $live_artcile;*/
			
			$completed_article_review_result_set = '  ( '.$join_result_set.' ) AS compt_reviewed_art_table  ';
			$main_sql->join(DB::raw($completed_article_review_result_set),'compt_reviewed_art_table.art_cmpt_reviewed_by','=','usr_id');
			
		}
		//**********BUILD ARTICLE FLOW COMPLETED REVIEW RESULT SET  -- STOP***********************
		
		//**********BUILD ARTICLE FLOW AUTODECLINED / UNASSIGNED REVIEW RESULT SET  -- START***********************//(Article reviewed --article reviewed filter)
		$decline_review_result_set = '';
		$decline_review_condition = '';
		$decline_review_condition_arr = array();
		if(isset($search_filters['autodeclined_unassigned_review_count_filter']) || $bs_reviewunassigned == TRUE || $bs_reviewdeclined == TRUE)
		{
			$having_cnt = 'COUNT';
			if($journal_flag == TRUE)
				$having_cnt = 'SUM';
				
			$has_at_least_temp = $has_at_least_live = $has_at_least_legacy= array();
			if(isset($search_filters['autodeclined_unassigned_review_count_filter']['has_at_least']))
			{
				$has_at_least_temp[] = ' '.$having_cnt.'(art_decline_review_cnt) >= '.$search_filters['autodeclined_unassigned_review_count_filter']['has_at_least'].'';
				//$bind_arr['autodeclined_unassigned_review_count_filter_has_at_least'] = $search_filters['autodeclined_unassigned_review_count_filter']['has_at_least'];
			}

			if(isset($search_filters['autodeclined_unassigned_review_count_filter']['has_a_maximum']))
			{
				$has_at_least_temp[] = ' '.$having_cnt.'(art_decline_review_cnt) <= '.$search_filters['autodeclined_unassigned_review_count_filter']['has_a_maximum'].'';
				//$bind_arr['autodeclined_unassigned_review_count_filter_has_a_maximum'] = $search_filters['autodeclined_unassigned_review_count_filter']['has_a_maximum'];
			}
			
			$tem_decl_condition = '';
			if(count($has_at_least_temp) > 0)
				$tem_decl_condition = ' HAVING '. implode(' AND ', $has_at_least_temp); 
			
			$review_assign_str = ' IF(aflw_status = \'g\',TRUE,(aflw_status = \'d\' AND aflw_usr_id != aflw_posted_by AND aflw_remarks=\'ondecision\')) ';
			if($bs_reviewunassigned == TRUE)
			{
				$review_assign_str = ' aflw_status = \'g\' ';
			}
			elseif($bs_reviewdeclined == TRUE)
			{
				$review_assign_str = ' (aflw_status = \'d\' AND aflw_usr_id != aflw_posted_by AND aflw_remarks=\'ondecision\') ';
			}
			
			if($journal_flag == TRUE)
			{

				$live_artcile = ' (SELECT aflw_usr_id AS art_decline_reviewer,COUNT(aflw_id) AS art_decline_review_cnt,artp_jnl_id as art_decline_review_jnl  FROM '.$articleflowtable.','.$genericflowtable.','. $articletable.','.$articletypetable.'  WHERE  aflw_art_id = art_id AND art_artp_id = artp_id AND aflw_parent_flow_id IS NOT NULL AND aflw_jwf_id = jwf_id  AND '.$review_assign_str.'  AND jwf_stage_type = \'review\' GROUP BY aflw_usr_id,artp_jnl_id) ';
				
				$legacy_artcile = ' (SELECT arev_user_id AS art_decline_reviewer,COUNT(arev_id) AS art_decline_review_cnt,arld_jnl_id as art_decline_review_jnl  FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE arld_id= arev_arld_id AND arev_status = "ad" AND arev_user_id IS NOT NULL GROUP BY arev_user_id,arld_jnl_id) ';
				
				if(isset($search_filters['journal_filter']['any']))
				{
					$decline_review_condition_arr[] = ' FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',temp_decl_tb.art_decline_review_jnl) = 1';
					//$bind_arr['journal_filter_any14'] = $search_filters['journal_filter']['any'];
				}
					
				if(isset($search_filters['journal_filter']['not_in']))
				{
					$decline_review_condition_arr[] = ' FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',temp_decl_tb.art_decline_review_jnl) = 1 ';
					//$bind_arr['journal_filter_not_in14'] = $search_filters['journal_filter']['not_in'];
				}
					
				if(isset($search_filters['journal_filter']['in']))
				{
					$decline_review_condition_arr[] = ' FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',temp_decl_tb.art_decline_review_jnl) = 1 ';
					//$bind_arr['journal_filter_in14'] = $search_filters['journal_filter']['in'];
				}
					
				
				$user_journal_result_set = '';
				if($must_jnl_condition_check == FALSE)
				{
					$journal_condition = '';
					//$bind_arr = self::pop_bind_arr($search_filters,$bind_arr);					
				}
					
				
				//$dec_jnl = ',art_decline_review_jnl';
				$dec_jnl = ',GROUP_CONCAT(DISTINCT art_decline_review_jnl) as art_decline_review_jnl';
				$count_column = 'SUM(art_decline_review_cnt)';
				
				if(count($decline_review_condition_arr) > 0)
					$decline_review_condition = ' WHERE '.implode(' AND ', $decline_review_condition_arr);
			}
			else
			{

				$live_artcile = ' (SELECT aflw_usr_id AS art_decline_reviewer,aflw_id AS art_decline_review_cnt  FROM '.$articleflowtable.','.$genericflowtable.' WHERE aflw_jwf_id = jwf_id  AND aflw_parent_flow_id IS NOT NULL  AND '.$review_assign_str.' AND jwf_stage_type = \'review\'  )';
				
				$legacy_artcile = ' (SELECT arev_user_id AS art_decline_reviewer,arev_id AS art_decline_review_cnt  FROM '.$reviewer_legacy_table.' WHERE arev_status = "ad" ) ';
				//arev_status IN ("ad","ua")
				$dec_jnl = '';
				$count_column = 'COUNT(art_decline_review_cnt)';
			}
			
			//$join_result_set = $live_artcile.' UNION ALL '.$legacy_artcile;
			$join_result_set = ' (SELECT art_decline_reviewer,'.$count_column.' AS art_decline_review_cnt'.$dec_jnl.' FROM ('.$live_artcile.' UNION ALL '.$legacy_artcile.') as temp_decl_tb '.$decline_review_condition.' GROUP BY art_decline_reviewer '.$tem_decl_condition.') ';
			
			$decline_review_result_set = ' ('.$join_result_set.' ) AS autodecl_unassign_review_table  ';
			$main_sql->join(DB::raw($decline_review_result_set),'autodecl_unassign_review_table.art_decline_reviewer','=','usr_id');
			
		}
		//**********BUILD ARTICLE FLOW AUTODECLINED / UNASSIGNED REVIEW RESULT SET  -- STOP***********************
		
		
		//**********BUILD IN HAND REVIEW RESULT SET  -- START***********************//
		$inhand_article_review_result_set = '';
		$inhand_article_review_condition = '';
		$present_review_count_filter = FALSE;
		$having_live_condition = '';
		$inhand_article_review_result_sets = '';
		$present_filter_condition = '';
		if(isset($search_filters['present_review_count_filter']))
		{
		
			$present_review_count_filter = TRUE;
			$has_at_least_live = array();
			if(isset($search_filters['present_review_count_filter']['has_at_least']))
			{
				$has_at_least_live[] = ' count(art_inhand_reviewed_by) >=  '.$search_filters['present_review_count_filter']['has_at_least'].'';
				//$bind_arr['present_review_count_filter_has_at_least1'] = $search_filters['present_review_count_filter']['has_at_least'];
			}

			if(isset($search_filters['present_review_count_filter']['has_a_maximum']))
			{
				$has_at_least_live[] = ' count(art_inhand_reviewed_by) <= '.$search_filters['present_review_count_filter']['has_a_maximum'].'';
				//$bind_arr['present_review_count_filter_has_a_maximum1'] = $search_filters['present_review_count_filter']['has_a_maximum'];
			}
			if(isset($array_data['advance_search']))
			{
				if(isset($search_filters['present_review_count_filter']['has_at_least']))
				{
					$present_filter_condition .= ' AND inhand_reviewed_art_table.current_assignmets >= '.$search_filters['present_review_count_filter']['has_at_least'].' ';
					//$bind_arr['present_review_count_filter_has_at_least2'] = $search_filters['present_review_count_filter']['has_at_least'];
				}
				if(isset($search_filters['present_review_count_filter']['has_a_maximum']))
				{
					$present_filter_condition .= ' AND inhand_reviewed_art_table.current_assignmets <= '.$search_filters['present_review_count_filter']['has_a_maximum'].' ';
					//$bind_arr['present_review_count_filter_has_a_maximum2'] = $search_filters['present_review_count_filter']['has_a_maximum'];
				} 
			}

			$having_live_condition = ' HAVING '. implode(' AND ', $has_at_least_live); 
			
		}
		
		if($present_review_count_filter == TRUE && $ordering_column == 'current_assignmets')
		{
			$has_at_least_live = array();
			if(isset($search_filters['present_review_count_filter']['has_at_least']))
			{
				$has_at_least_live[] = ' count(art_inhands_reviewed_by) >= '.$search_filters['present_review_count_filter']['has_at_least'].'';
				//$bind_arr['present_review_count_filter_has_at_least'] = $search_filters['present_review_count_filter']['has_at_least'];
			}

			if(isset($search_filters['present_review_count_filter']['has_a_maximum']))
			{
				$has_at_least_live[] = ' count(art_inhands_reviewed_by) <= '.$search_filters['present_review_count_filter']['has_a_maximum'].' ';
				//$bind_arr['present_review_count_filter_has_a_maximum'] = $search_filters['present_review_count_filter']['has_a_maximum'];
			}

			$having_live_condition_1 = ' HAVING '. implode(' AND ', $has_at_least_live); 
			
			$join_type = ' LEFT ';
			if($present_review_count_filter == TRUE)
				$join_type = 'LEFT';
			
			if($journal_flag == TRUE)
			{
				$count_query = '';
				if($return_count == FALSE)
				{
					$count_query = 'jnl_id = '.$jnl_id.' AND ';
				}

	
				$inhand_article_review_result_sets =  ' (SELECT aflw_usr_id AS art_inhands_reviewed_by,GROUP_CONCAT(DISTINCT jnl_id) as art_inhands_reviewed_jnl,count(aflw_usr_id) AS current_assignments  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id WHERE '.$count_query.' aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'a\' AND art_status =\'y\' AND art_delete_status = \'n\' AND jwf_stage_type = \'review\' GROUP BY aflw_usr_id  '.$having_live_condition_1.') AS inhands_reviewed_art_table  ';
		
				if($present_review_count_filter == TRUE)
				{
				
					if(isset($search_filters['journal_filter']['any']))
					{
						$inhand_article_review_condition .= ' AND FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',inhands_reviewed_art_table.art_inhands_reviewed_jnl) = 1 ';
						//$bind_arr['journal_filter_any15'] = $search_filters['journal_filter']['any'];
					}
						
					if(isset($search_filters['journal_filter']['not_in']))
					{
						$inhand_article_review_condition .= ' AND FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',inhands_reviewed_art_table.art_inhands_reviewed_jnl) = 1 ';
						//$bind_arr['journal_filter_not_in15'] = $search_filters['journal_filter']['not_in'];
					}
						
					if(isset($search_filters['journal_filter']['in']))
					{
						$inhand_article_review_condition .= ' AND FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',inhand_reviewed_art_table.art_inhand_reviewed_jnl) = 1 ';
						//$bind_arr['journal_filter_in15'] = $search_filters['journal_filter']['in'];
					}
						

					$user_journal_result_set = '';
					if($must_jnl_condition_check == FALSE)
					{
						$journal_condition = '';
						$bind_arr = self::pop_bind_arr($search_filters,$bind_arr);
					}
						
				}
			}
			else
			{
			
		
				$inhand_article_review_result_sets = ' ( SELECT aflw_usr_id AS art_inhands_reviewed_by,count(aflw_usr_id) AS current_assignments  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id  WHERE aflw_parent_flow_id IS NOT NULL  AND art_delete_status = \'n\' AND aflw_status = \'a\' AND art_status =\'y\' AND jwf_stage_type = \'review\' GROUP BY aflw_usr_id  '.$having_live_condition_1.') AS inhands_reviewed_art_table ';
			
			}
			$main_sql->leftjoin(DB::raw($inhand_article_review_result_sets),'inhands_reviewed_art_table.art_inhands_reviewed_by','=','usr_id');
			
			//if($return_count == FALSE)
			//	$select .= ',inhands_reviewed_art_table.current_assignments';
		}
		else if($present_review_count_filter == TRUE)
		{
			
			$join_type = ' LEFT ';
			if($present_review_count_filter == TRUE)
				$join_type = ' ';
			
			if($journal_flag == TRUE)
			{
				$count_query = '';
				if($return_count == FALSE)
				{
					$count_query = 'jnl_id = '.$jnl_id.' AND ';
				}


				$inhand_article_review_result_set =  ' (SELECT aflw_usr_id AS art_inhand_reviewed_by,GROUP_CONCAT(DISTINCT jnl_id) as art_inhand_reviewed_jnl,count(aflw_usr_id) AS current_assignmets  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id WHERE '.$count_query.' aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'a\' AND art_status =\'y\' AND art_delete_status = \'n\' AND jwf_stage_type = \'review\' GROUP BY aflw_usr_id  '.$having_live_condition.') AS inhand_reviewed_art_table  ';
				
				if($present_review_count_filter == TRUE)
				{
					if(isset($search_filters['journal_filter']['any']))
					{
						$inhand_article_review_condition .= ' AND FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',inhand_reviewed_art_table.art_inhand_reviewed_jnl) = 1 ';
						//$bind_arr['journal_filter_any16'] = $search_filters['journal_filter']['any'];
					}
						
					if(isset($search_filters['journal_filter']['not_in']))
					{
						$inhand_article_review_condition .= ' AND FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',inhand_reviewed_art_table.art_inhand_reviewed_jnl) = 1 ';
						$bind_arr['journal_filter_not_in16'] = $search_filters['journal_filter']['not_in'];
					}
						
					if(isset($search_filters['journal_filter']['in']))
					{
						$inhand_article_review_condition .= ' AND FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',inhand_reviewed_art_table.art_inhand_reviewed_jnl) = 1 ';
						//$bind_arr['journal_filter_in16'] = $search_filters['journal_filter']['in'];
					}
						
					$user_journal_result_set = '';
					if($must_jnl_condition_check == FALSE)
					{
						$journal_condition = '';
						//$bind_arr = self::pop_bind_arr($search_filters,$bind_arr);
					}
				}
			}
			else
			{
			// TASK #6273 start	
				$count_query = '';
				if($return_count == FALSE)
				{
					$count_query = 'jnl_id ='.$jnl_id.' AND ';
				} 
				$inhand_article_review_result_set = ' ( SELECT aflw_usr_id AS art_inhand_reviewed_by,count(aflw_usr_id) AS current_assignmets  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id  WHERE '.$count_query.'aflw_parent_flow_id IS NOT NULL  AND art_delete_status = \'n\' AND aflw_status = \'a\' AND art_status =\'y\' AND jwf_stage_type = \'review\' GROUP BY aflw_usr_id  '.$having_live_condition.') AS inhand_reviewed_art_table  ';
			// TASK #6273 end
			}
			$main_sql->join(DB::raw($inhand_article_review_result_set),'inhand_reviewed_art_table.art_inhand_reviewed_by','=','usr_id');
			if($return_count == FALSE)
				$select .= ',inhand_reviewed_art_table.current_assignmets';
		}
		
		if($return_count == FALSE && $ordering_column == 'current_assignmets')
		{
			$join_type = ' LEFT ';
			if($present_review_count_filter == TRUE)
				$join_type = ' LEFT ';
			
			if($journal_flag == TRUE)
			{
		

				$inhand_article_review_result_set = ' (SELECT aflw_usr_id AS art_inhand_reviewed_by,GROUP_CONCAT(DISTINCT jnl_id) as art_inhand_reviewed_jnl,count(aflw_usr_id) AS current_assignmets  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '.$journaltable.' on jnl_id = artp_jnl_id WHERE jnl_id = '.$jnl_id.' AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'a\' AND art_status =\'y\' AND art_delete_status = \'n\' AND jwf_stage_type = \'review\' GROUP BY aflw_usr_id  '.$having_live_condition.') AS inhand_reviewed_art_table  ';
			
				if($present_review_count_filter == TRUE)
				{
					if(isset($search_filters['journal_filter']['any']))
					{
						$inhand_article_review_condition .= ' AND FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',inhand_reviewed_art_table.art_inhand_reviewed_jnl) = 1 ';
						//$bind_arr['journal_filter_any17'] = $search_filters['journal_filter']['any'];
					}
						
					if(isset($search_filters['journal_filter']['not_in']))
					{
						$inhand_article_review_condition .= ' AND FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',inhand_reviewed_art_table.art_inhand_reviewed_jnl) = 1 ';
						//$bind_arr['journal_filter_not_in17'] = $search_filters['journal_filter']['not_in'];
					}
						
					if(isset($search_filters['journal_filter']['in']))
					{
						$inhand_article_review_condition .= ' AND FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',inhand_reviewed_art_table.art_inhand_reviewed_jnl) = 1 ';
						//$bind_arr['journal_filter_in17'] = $search_filters['journal_filter']['in'];
					}
						

					$user_journal_result_set = '';
					if($must_jnl_condition_check == FALSE)
					{
						$journal_condition = '';
						//$bind_arr = self::pop_bind_arr($search_filters,$bind_arr);
					}
						
				}
			}
			else
			{
	
	
				$count_query = '';
				if($return_count == FALSE)
				{
					$count_query = 'jnl_id ='.$jnl_id.' AND ';
				} 
				$inhand_article_review_result_set = '( SELECT aflw_usr_id AS art_inhand_reviewed_by,count(aflw_usr_id) AS current_assignmets  FROM '.$articleflowtable.' INNER JOIN '. $articletable.' on aflw_art_id = art_id INNER JOIN '.$genericflowtable.' on aflw_jwf_id = jwf_id INNER JOIN '.$articletypetable.' on artp_id = art_artp_id INNER JOIN '. $journaltable.' on jnl_id = artp_jnl_id  WHERE '.$count_query.' aflw_parent_flow_id IS NOT NULL  AND art_delete_status = \'n\' AND aflw_status = \'a\' AND art_status =\'y\' AND jwf_stage_type = \'review\' GROUP BY aflw_usr_id  '.$having_live_condition.') AS inhand_reviewed_art_table ';
		
			}
			$main_sql->leftjoin(DB::raw($inhand_article_review_result_set),'inhand_reviewed_art_table.art_inhand_reviewed_by','=','usr_id');
			if($return_count == FALSE)
				$select .= ',inhand_reviewed_art_table.current_assignmets';
		}
				
		//**********BUILD IN HAND REVIEW RESULT SET  -- STOP***********************//
		
		//**********BUILD KEYWORD RESULT SET  -- START***********************//
		$keyword_result_set = '';
		$keyword_condition = '';
		$profile_filter = FALSE;
		$select_keykword_field='';
        //
		if(isset($search_filters['keyword_filter']))
		{
			if(isset($search_filters['keyword_filter']['has_profile_keywords']))
			{
				$profile_filter = TRUE;
				$temp_data = $search_filters['keyword_filter']['has_profile_keywords'];
				if(isset($temp_data['AND']))
				{
					$keyword_condition .= ' AND FIND_array_in_all(\''.$temp_data['AND'].'\',keyword_table.user_keyword_id) = 1 ';
					//$bind_arr['keyword_filter_has_profile_keywords_and'] = $temp_data['AND'];
				}
				
				if(isset($temp_data['OR']))
				{
					$keyword_condition .= ' AND FIND_array_intersect(\''.$temp_data['OR'].'\',keyword_table.user_keyword_id) = 1 ';
					//$bind_arr['keyword_filter_has_profile_keywords_or'] = $temp_data['OR'];
					//$keyword_condition .= ' AND keyword_table.user_keyword_id IN('.$temp_data['OR'].')';
					if(!empty($temp_data['OR']))
					{
						$select_keykword_field .='SUM(IF(ukwd_kwd_id IN('.$temp_data['OR'].') = 1,1,0)) AS keyword_order,';
						//$bind_arr['keyword_filter_has_profile_keywords_or_sel'] = $temp_data['OR'];
					}
						
				}
				
				if(isset($temp_data['LIKE']))
				{
					$keyword_condition .= ' AND keyword_table.user_keywords LIKE "%'.$temp_data['LIKE'].'%" ';
					//$bind_arr['keyword_filter_has_profile_keywords_like'] = "%".$temp_data['LIKE']."%";
				}
			
			}
			
			if(isset($search_filters['keyword_filter']['has_keywords_in_submitted_articles']))
			{
				$live_artcile = '';
				$legacy_artcile = '';
				$keyword_condition_self = array();
				$keyword_condition_self_legacy = array();
				$temp_data = $search_filters['keyword_filter']['has_keywords_in_submitted_articles'];
				if(isset($temp_data['AND']))
				{
					$keyword_condition_self[] = ' FIND_array_in_all(\''.$temp_data['AND'].'\',temp_live_key.art_keyword_id) = 1 ';
					$keyword_condition_self_legacy[] = ' FIND_array_in_all(\''.$temp_data['AND'].'\',arld_keyword_ids) = 1 ';

					// $bind_arr['keyword_filter_has_keywords_in_submitted_articles_AND1'] = $temp_data['AND'];
					// $bind_arr['keyword_filter_has_keywords_in_submitted_articles_AND2'] = $temp_data['AND'];
					
				}
				
				if(isset($temp_data['OR']))
				{
					$keyword_condition_self[] = ' FIND_array_intersect(\''.$temp_data['OR'].'\',temp_live_key.art_keyword_id) = 1 ';
					$keyword_condition_self_legacy[] = ' FIND_array_intersect(\''.$temp_data['OR'].'\',arld_keyword_ids) = 1 ';

					// $bind_arr['keyword_filter_has_keywords_in_submitted_articles_or1'] = $temp_data['OR'];
					// $bind_arr['keyword_filter_has_keywords_in_submitted_articles_or2'] = $temp_data['OR'];
				}
				
				if(isset($temp_data['LIKE']))
				{
					$keyword_condition_self[] = ' temp_live_key.art_keywords LIKE "%'.$temp_data['LIKE'].'%" ';
					$keyword_condition_self_legacy[] = ' arld_keywords LIKE "%'.$temp_data['LIKE'].'%" ';

					// $bind_arr['keyword_filter_has_keywords_in_submitted_articles_LIKE1'] = "%".$temp_data['LIKE']."%";
					// $bind_arr['keyword_filter_has_keywords_in_submitted_articles_LIKE2'] = "%".$temp_data['LIKE']."%";
				}
			
				$keyword_condition_internal = implode(' AND ', $keyword_condition_self);
				$keyword_condition_internal_legacy = implode(' AND ', $keyword_condition_self_legacy);
				if($journal_flag == TRUE)
				{
		
				
					$live_artcile = ' SELECT temp_live_key.art_user,GROUP_CONCAT(DISTINCT temp_live_key.artp_jnl_id) AS art_jnl_list FROM (SELECT art_submitted_by AS art_user,GROUP_CONCAT(DISTINCT ak_keyword_id) AS art_keyword_id,GROUP_CONCAT( DISTINCT kwd_name SEPARATOR ", ") AS art_keywords,artp_jnl_id  FROM '.$articletable.','.$article_keyword_table.','.$keyword_table.','.$articletypetable.'  WHERE ak_art_id = art_id AND ak_keyword_id = kwd_id AND artp_id = art_artp_id GROUP by art_submitted_by) AS temp_live_key WHERE '.$keyword_condition_internal.' GROUP BY temp_live_key.art_user';
					
					$legacy_artcile = ' (SELECT arld_submitted_by AS art_user,GROUP_CONCAT(DISTINCT arld_jnl_id) AS art_jnl_list FROM '.$article_legacy_table.' WHERE '.$keyword_condition_internal_legacy.' GROUP BY arld_submitted_by ) ';
						
					if(isset($search_filters['journal_filter']['any']))
					{
						$keyword_condition .= ' AND FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',article_keyword_table.art_jnl_list) = 1';
						//$bind_arr['journal_filter_any18'] = $search_filters['journal_filter']['any'];
					}
						
					if(isset($search_filters['journal_filter']['not_in']))
					{
						$keyword_condition .= ' AND FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',article_keyword_table.art_jnl_list) = 1 ';
						//$bind_arr['journal_filter_not_in18'] = $search_filters['journal_filter']['not_in'];
					}
						
					if(isset($search_filters['journal_filter']['in']))
					{
						$keyword_condition .= ' AND FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',article_keyword_table.art_jnl_list) = 1 ';
						//$bind_arr['journal_filter_in18'] = $search_filters['journal_filter']['in'];
					}
						
					
					//$user_journal_result_set = '';
					if($must_jnl_condition_check == FALSE)
					{
						$journal_condition = '';
						//$bind_arr = self::pop_bind_arr($search_filters,$bind_arr);
					}
						
				}
				else
				{
				
					$live_artcile = ' SELECT temp_live_key.art_user FROM (SELECT art_submitted_by AS art_user,GROUP_CONCAT(DISTINCT ak_keyword_id) AS art_keyword_id,GROUP_CONCAT( DISTINCT kwd_name SEPARATOR ", ") AS art_keywords  FROM '.$articletable.','.$article_keyword_table.','.$keyword_table.' WHERE ak_art_id = art_id AND ak_keyword_id = kwd_id  GROUP by art_submitted_by) AS temp_live_key WHERE '.$keyword_condition_internal;
					
					$legacy_artcile = ' (SELECT arld_submitted_by AS art_user FROM '.$article_legacy_table.' WHERE '.$keyword_condition_internal_legacy.' ) ';
				}
				
				$keyword_result_set = ' ('.$live_artcile.' UNION ALL '.$legacy_artcile.' )  as article_keyword_table  ';

				$main_sql->join(DB::raw($keyword_result_set),'article_keyword_table.art_user','=','usr_id');
			}
			
			if(isset($search_filters['keyword_filter']['has_keywords_in_reviewed_articles']))
			{
				$live_artcile = '';
				$legacy_artcile = '';
				$keyword_condition_self = array();
				$keyword_condition_self_legacy = '';
				$temp_data = $search_filters['keyword_filter']['has_keywords_in_reviewed_articles'];
				if(isset($temp_data['AND']))
				{
					$keyword_condition_self[] = ' FIND_array_in_all(\''.$temp_data['AND'].'\',temp_art_review_live_key.art_keyword_id) = 1 ';
					$keyword_condition_self_legacy .= ' AND FIND_array_in_all(\''.$temp_data['AND'].'\',arld_keyword_ids) = 1 ';

					// $bind_arr['keyword_filter_has_keywords_in_reviewed_articles_AND1'] = $temp_data['AND'];
					// $bind_arr['keyword_filter_has_keywords_in_reviewed_articles_AND2'] = $temp_data['AND'];
					
				}
				
				if(isset($temp_data['OR']))
				{
					$keyword_condition_self[] = ' FIND_array_intersect(\''.$temp_data['OR'].'\',temp_art_review_live_key.art_keyword_id) = 1 ';
					$keyword_condition_self_legacy .= ' AND FIND_array_intersect(\''.$temp_data['OR'].'\',arld_keyword_ids) = 1 ';

					// $bind_arr['keyword_filter_has_keywords_in_reviewed_articles_OR1'] = $temp_data['OR'];
					// $bind_arr['keyword_filter_has_keywords_in_reviewed_articles_OR2'] = $temp_data['OR'];
				}
				
				if(isset($temp_data['LIKE']))
				{
					$keyword_condition_self[] = ' temp_art_review_live_key.art_keywords LIKE "%'.$temp_data['LIKE'].'%" ';
					$keyword_condition_self_legacy .= ' AND arld_keywords LIKE "%'.$temp_data['LIKE'].'%" ';

					// $bind_arr['keyword_filter_has_keywords_in_reviewed_articles_LIKE1'] = "%".$temp_data['LIKE']."%";
					// $bind_arr['keyword_filter_has_keywords_in_reviewed_articles_LIKE2'] = "%".$temp_data['LIKE']."%";

				}
				
				$keyword_condition_internal = implode(' AND ', $keyword_condition_self);
				//$keyword_condition_internal_legacy = implode(' AND ', $keyword_condition_self_legacy);
				
				if($journal_flag == TRUE)
				{
				

					$live_artcile = ' SELECT temp_art_review_live_key.art_rv_user,GROUP_CONCAT(DISTINCT temp_art_review_live_key.artp_jnl_id) AS art_rev_jnl_list FROM (SELECT aflw_usr_id AS art_rv_user,GROUP_CONCAT(DISTINCT ak_keyword_id) AS art_keyword_id,GROUP_CONCAT( DISTINCT kwd_name SEPARATOR ", ") AS art_keywords,artp_jnl_id  FROM '.$article_keyword_table.','.$keyword_table.','.$articleflowtable.','.$genericflowtable.','.$articletable.','.$articletypetable.'  WHERE aflw_jwf_id = jwf_id  AND aflw_art_id = ak_art_id AND aflw_art_id = art_id  AND  art_artp_id = artp_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND jwf_stage_type = \'review\' AND ak_keyword_id = kwd_id  GROUP by aflw_usr_id) AS temp_art_review_live_key WHERE '.$keyword_condition_internal.' GROUP BY temp_art_review_live_key.art_rv_user';
					
					$legacy_artcile = ' (SELECT arev_user_id AS art_rv_user,GROUP_CONCAT(arld_jnl_id) AS art_rev_jnl_list FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE  arev_arld_id = arld_id AND arev_status IN ("ac","ag") AND arev_user_id IS NOT NULL '.$keyword_condition_self_legacy.' GROUP BY arev_user_id ) ';
						
					if(isset($search_filters['journal_filter']['any']))
					{
						$keyword_condition .= ' AND FIND_array_intersect(\''.$search_filters['journal_filter']['any'].'\',article_review_keyword_table.art_rev_jnl_list) = 1';
						//$bind_arr['journal_filter_any19'] = $search_filters['journal_filter']['any'];
					}
						
					if(isset($search_filters['journal_filter']['not_in']))
					{
						$keyword_condition .= ' AND FIND_array_not_in(\''.$search_filters['journal_filter']['not_in'].'\',article_review_keyword_table.art_rev_jnl_list) = 1 ';
						//$bind_arr['journal_filter_not_in19'] = $search_filters['journal_filter']['not_in'];
					}
						
					if(isset($search_filters['journal_filter']['in']))
					{
						$keyword_condition .= ' AND FIND_array_in_all(\''.$search_filters['journal_filter']['in'].'\',article_review_keyword_table.art_rev_jnl_list) = 1 ';
						//$bind_arr['journal_filter_in19'] = $search_filters['journal_filter']['in'];
					}
						
					
					//$user_journal_result_set = '';
					if($must_jnl_condition_check == FALSE)
					{
						$journal_condition = '';
						//$bind_arr = self::pop_bind_arr($search_filters,$bind_arr);
					}
						
				}
				else
				{
	

					$live_artcile = ' SELECT temp_art_review_live_key.art_rv_user FROM (SELECT aflw_usr_id AS art_rv_user,GROUP_CONCAT(DISTINCT ak_keyword_id) AS art_keyword_id,GROUP_CONCAT( DISTINCT kwd_name SEPARATOR ", ") AS art_keywords  FROM '.$article_keyword_table.','.$keyword_table.','.$articleflowtable.','.$genericflowtable.' WHERE aflw_jwf_id = jwf_id  AND aflw_art_id = ak_art_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND jwf_stage_type = \'review\' AND ak_keyword_id = kwd_id  GROUP by aflw_usr_id) AS temp_art_review_live_key WHERE '.$keyword_condition_internal;
					
					
					$legacy_artcile = ' (SELECT arev_user_id AS art_rv_user FROM '.$reviewer_legacy_table.','.$articlelegacytable.' WHERE  arev_arld_id = arld_id AND arev_status IN ("ac","ag") AND arev_user_id IS NOT NULL '.$keyword_condition_self_legacy.' GROUP BY arev_user_id ) ';
				}
	
				$keyword_result_set = '  ('.$live_artcile.' UNION ALL '.$legacy_artcile.' )  as article_review_keyword_table  ';

				$main_sql->join(DB::raw($keyword_result_set),'article_review_keyword_table.art_rv_user','=','usr_id');
				
			}
			
			
		}
		
		if($profile_filter == TRUE || isset($array_data['advance_search']) || $bsearchkeyword_flag == TRUE)
		{

			
       
			$select_keykword_field .='ukwd_usr_id AS keyword_user, GROUP_CONCAT(DISTINCT ukwd_kwd_id) AS user_keyword_id,GROUP_CONCAT( DISTINCT kwd_name SEPARATOR ", ") AS user_keywords';
			$keyword_result_set = ' (SELECT '.$select_keykword_field.'  FROM '.$userkeyword_table.','.$keywordtable.' WHERE ukwd_kwd_id = kwd_id GROUP BY ukwd_usr_id) AS keyword_table ';
			if(isset($array_data['advance_search']))
			{
				$main_sql->join(DB::raw($keyword_result_set),'keyword_table.keyword_user','=','usr_id','left');
			}
			else
			{
				$main_sql->join(DB::raw($keyword_result_set),'keyword_table.keyword_user','=','usr_id');
			}
			if($return_count == FALSE)
				$select .= ',keyword_table.user_keywords';
		}
		
		//**********BUILD KEYWORD RESULT SET  -- START***********************//
		
		//**********BUILD CLASSCIFICATION RESULT SET  -- START***********************//
		$user_profile_filter = FALSE;
		$select_classification_field = '';
		$classification_condition = '';
		if(isset($search_filters['classification_filter'])){
			if(isset($search_filters['classification_filter']['has_profile_classifications'])){
				$user_profile_filter = TRUE;
				$temp_data = $search_filters['classification_filter']['has_profile_classifications'];
				if(isset($temp_data['AND']))
				{
					$classification_condition .= ' AND FIND_array_in_all(\''.$temp_data['AND'].'\',classification_table.user_classification_id) = 1 ';
				}
				if(isset($temp_data['OR']))
				{
					$classification_condition .= ' AND FIND_array_intersect(\''.$temp_data['OR'].'\',classification_table.user_classification_id) = 1 ';
 					/*if(!empty($temp_data['OR']))
					{
						$select_classification_field .='SUM(IF(usrcls_cls_id IN('.$temp_data['OR'].') = 1,1,0)) AS classification_order,';
					} */
				}
				if(isset($temp_data['LIKE']))
				{
					$classification_condition .= ' AND classification_table.user_classification LIKE "%'.$temp_data['LIKE'].'%" ';
				}
			}

			if(isset($search_filters['classification_filter']['has_classifications_in_submitted_articles'])){
				$temp_data = $search_filters['classification_filter']['has_classifications_in_submitted_articles'];
				if(isset($temp_data['AND'])){
					$classification_condition .= ' AND FIND_array_in_all(\''.$temp_data['AND'].'\',article_classification_table.art_classification_id) = 1 ';
				}
				if(isset($temp_data['OR'])){
					$classification_condition .= ' AND FIND_array_intersect(\''.$temp_data['OR'].'\',article_classification_table.art_classification_id) = 1 ';
				}
				if(isset($temp_data['LIKE'])){
					$classification_condition .= ' AND article_classification_table.art_classifications LIKE "%'.$temp_data['LIKE'].'%" ';
				}
				$selected_submitted_articles = ' SELECT art_submitted_by AS art_user,GROUP_CONCAT(DISTINCT arcls_cls_id) AS art_classification_id,GROUP_CONCAT( DISTINCT term_name SEPARATOR ", ") AS art_classifications  FROM '.$articleclassification_table.','.$classificationtable.','.$termstable.','.$articletable.' WHERE arcls_art_id = art_id AND arcls_cls_id = cls_id AND cls_term_id = term_id GROUP by art_submitted_by ';
				$classification_result_set = ' ('.$selected_submitted_articles.' )  as article_classification_table  ';
				$main_sql->join(DB::raw($classification_result_set),'article_classification_table.art_user','=','usr_id');

			}

			if(isset($search_filters['classification_filter']['has_classifications_in_reviewed_articles'])){
				$temp_data = $search_filters['classification_filter']['has_classifications_in_reviewed_articles'];
				if(isset($temp_data['AND'])){
					$classification_condition .= ' AND FIND_array_in_all(\''.$temp_data['AND'].'\',article_review_classification_table.art_classification_id) = 1 ';
				}
				if(isset($temp_data['OR'])){
					$classification_condition .= ' AND FIND_array_intersect(\''.$temp_data['OR'].'\',article_review_classification_table.art_classification_id) = 1 ';
				}
				if(isset($temp_data['LIKE'])){
					$classification_condition .= ' AND article_review_classification_table.art_classifications LIKE "%'.$temp_data['LIKE'].'%" ';
				}
				$selected_reviewed_articles = ' SELECT temp_art_review_live_cls.art_rv_user,temp_art_review_live_cls.art_classification_id,temp_art_review_live_cls.art_classifications,GROUP_CONCAT(DISTINCT temp_art_review_live_cls.artp_jnl_id) AS art_rev_jnl_list FROM (SELECT aflw_usr_id AS art_rv_user,GROUP_CONCAT(DISTINCT arcls_cls_id) AS art_classification_id,GROUP_CONCAT( DISTINCT term_name SEPARATOR ", ") AS art_classifications,artp_jnl_id  FROM '.$articleclassification_table.','.$classificationtable.','.$termstable.','.$articleflowtable.','.$genericflowtable.','.$articletable.','.$articletypetable.'  WHERE aflw_jwf_id = jwf_id  AND aflw_art_id = arcls_art_id AND aflw_art_id = art_id  AND  art_artp_id = artp_id AND aflw_parent_flow_id IS NOT NULL  AND aflw_status = \'c\' AND jwf_stage_type = \'review\' AND arcls_cls_id = cls_id AND cls_term_id = term_id GROUP by aflw_usr_id) AS temp_art_review_live_cls GROUP BY temp_art_review_live_cls.art_rv_user';
				$classification_result_set = ' ('.$selected_reviewed_articles.' )  as article_review_classification_table  ';
				$main_sql->join(DB::raw($classification_result_set),'article_review_classification_table.art_rv_user','=','usr_id');

			}
		}
		if($user_profile_filter == TRUE || isset($array_data['advance_search'])){
			$select_classification_field .='usrcls_usr_id AS classification_user, GROUP_CONCAT(DISTINCT usrcls_cls_id) AS user_classification_id,GROUP_CONCAT( DISTINCT term_name SEPARATOR ", ") AS user_classification';
			$classification_result_set = ' (SELECT '.$select_classification_field.'  FROM '.$userclassification_table.','.$classificationtable.','.$termstable.' WHERE usrcls_cls_id = cls_id AND cls_term_id = term_id GROUP BY usrcls_usr_id) AS classification_table ';
			if(isset($array_data['advance_search']))
			{
				$main_sql->join(DB::raw($classification_result_set),'classification_table.classification_user','=','usr_id','left');
			}
			else
			{
				$main_sql->join(DB::raw($classification_result_set),'classification_table.classification_user','=','usr_id');
			}
			if($return_count == FALSE)
				$select .= ',classification_table.user_classification';
		}
		//**********BUILD CLASSIFICATION RESULT SET  -- Stop***********************//
		
		//**********BUILD INSTITUTION RESULT SET  -- START***********************//
		$institution_result_set = '';
		$institution_condition = '';
		if(isset($search_filters['institution_filter']) || $bsearchcountry_flag == TRUE || isset($search_filters['country_filter']) || isset($search_filters['post_code_filter']) && !isset($array_data['advance_search']))
		{
			$institution_title = array();
			$institution_base_condition = array();
			$affiliation_select = array();

			$country_str = '';
			if($bsearchcountry_flag == TRUE)
			{
				$affiliation_select[] = 'GROUP_CONCAT(cnt_country) AS country_GP';
				$country_str = ' join '.$country_table.' on usaff_cnt_id = cnt_id ';
			}
			
			//COUNTRY CAN BE AMONG FILTER
			if(isset($search_filters['country_filter']['from']))
			{
				$affiliation_select[] = 'GROUP_CONCAT(usaff_cnt_id) AS usaff_cnt_id_GP';
				$institution_base_condition[] = 'FIND_array_intersect(\''.$search_filters['country_filter']['from'].'\',user_institution_table.usaff_cnt_id_GP) = 1';
				//$bind_arr['country_filter_from'] = $search_filters['country_filter']['from'];
					
				//$institution_title[] = ' usaff_cnt_id IN ("'. implode('","',explode(',', $search_filters['country_filter']['from'])).'")';
			}
			//COUNTRY CAN'T BE AMONG FILTER
			if(isset($search_filters['country_filter']['not_from']))
			{
				$affiliation_select[] = 'GROUP_CONCAT(usaff_cnt_id) AS usaff_cnt_id_GP';
				$institution_base_condition[] = 'FIND_array_not_in(\''.$search_filters['country_filter']['not_from'].'\',user_institution_table.usaff_cnt_id_GP) = 1';
				//$bind_arr['country_filter_not_from'] = $search_filters['country_filter']['not_from'];
				//$institution_title[] = ' usaff_cnt_id NOT IN ("'. implode('","',explode(',', $search_filters['country_filter']['not_from'])).'")';
			}
			
			
			if(isset($search_filters['institution_filter']['from']))
			{
				$affiliation_select[] = 'GROUP_CONCAT(usaff_company) AS usaff_company_GP';
				$institution_base_condition[] = 'user_institution_table.usaff_company_GP LIKE "%'.$search_filters['institution_filter']['from'].'%" ';
				//$bind_arr['institution_filter_from'] = "%".$search_filters['institution_filter']['from']."%";
				//$institution_title[] = ' usaff_company LIKE "%'.$search_filters['institution_filter']['from'].'%"';
			}

			if(isset($search_filters['institution_filter']['not_from']))
			{
				$affiliation_select[] = 'GROUP_CONCAT(usaff_company) AS usaff_company_GP';
				$institution_base_condition[] = 'user_institution_table.usaff_company_GP NOT LIKE "%'.$search_filters['institution_filter']['not_from'].'%" ';
				//$bind_arr['institution_filter_not_from'] = "%".$search_filters['institution_filter']['not_from']."%";
				//$institution_title[] = ' usaff_company NOT LIKE "%'.$search_filters['institution_filter']['not_from'].'%"';
			}
			
			if(isset($search_filters['post_code_filter']['from']))
			{
				$affiliation_select[] = 'GROUP_CONCAT(usaff_postal_code) AS usaff_postal_code_GP';
				$institution_base_condition[] = 'user_institution_table.usaff_postal_code_GP LIKE "%'.$search_filters['post_code_filter']['from'].'%"';
				//$bind_arr['post_code_filter_from'] = "%".$search_filters['post_code_filter']['from']."%";
				//$institution_title[] = ' usaff_postal_code LIKE "%'.$search_filters['post_code_filter']['from'].'%"';
			}

			if(isset($search_filters['post_code_filter']['not_from']))
			{
				$affiliation_select[] = 'GROUP_CONCAT(usaff_postal_code) AS usaff_postal_code_GP';
				$institution_base_condition[] = 'user_institution_table.usaff_postal_code_GP NOT LIKE "%'.$search_filters['post_code_filter']['not_from'].'%" ';
				//$bind_arr['post_code_filter_not_from'] = "%".$search_filters['post_code_filter']['not_from']."%";
				//$institution_title[] = ' usaff_postal_code NOT LIKE "%'.$search_filters['post_code_filter']['not_from'].'%"';
			}
			
			$affiliation_select_str = '';
			$like_condition = '';
			if(count($affiliation_select) > 0)
			{
				$affiliation_select_str = ','. implode(',', array_unique($affiliation_select));
			}
			if(count($institution_title) > 0)
			{
				$like_condition = ' WHERE '. implode(' AND ', $institution_title);
			}
			if(count($institution_base_condition) > 0)
			{
				$institution_condition = ' AND '. implode(' AND ', $institution_base_condition);
			}
			
		
			
			$institution_result_set = '  ( SELECT DISTINCT usaff_user_id AS usr_institution'.$affiliation_select_str.' FROM '.$user_affiliation_table.$country_str.' '.$like_condition.' GROUP BY usaff_user_id) AS user_institution_table  '; 

			$main_sql->join(DB::raw($institution_result_set),'user_institution_table.usr_institution','=','usr_id');
			
		}
		//**********BUILD INSTITUTION RESULT SET  -- STOP***********************//
  
		//**********BUILD USERNAME CONDITION  -- START***********************//
		$username_condition = '';
		if(isset($search_filters['username_filter']['exactly']))
		{
			$username_condition .= ' AND concat_ws(" ",`usr_first_name`,IF(`usr_middle_name` = "",null,`usr_middle_name`),`usr_last_name`) = \''.$search_filters['username_filter']['exactly'].'\' ';
			//$bind_arr['username_filter_exactly'] = $search_filters['username_filter']['exactly'];
		}
		if(isset($search_filters['username_filter']['contains']))
		{
			$username_condition .= ' AND concat_ws(" ",`usr_first_name`,IF(`usr_middle_name` = "",null,`usr_middle_name`),`usr_last_name`) LIKE "%'.$search_filters['username_filter']['contains'].'%" ';
			//$bind_arr['username_filter_contains'] = "%".$search_filters['username_filter']['contains']."%";
		}
		if(isset($search_filters['username_filter']['starts']))
		{
			$username_condition .= ' AND concat_ws(" ",`usr_first_name`,IF(`usr_middle_name` = "",null,`usr_middle_name`),`usr_last_name`) LIKE "'.$search_filters['username_filter']['starts'].'%" ';
			//$bind_arr['username_filter_starts'] = $search_filters['username_filter']['starts']."%";
		}
		if(isset($search_filters['username_filter']['ends']))
		{
			$username_condition .= ' AND concat_ws(" ",`usr_first_name`,IF(`usr_middle_name` = "",null,`usr_middle_name`),`usr_last_name`) LIKE "%'.$search_filters['username_filter']['ends'].'" ';
			//$bind_arr['username_filter_ends'] = "%".$search_filters['username_filter']['ends'];
		}
		//**********BUILD USERNAME CONDITION  -- STOP***********************//
		
		//**********BUILD USEREMAIL CONDITION  -- START***********************//
		$useremail_condition = '';
		if(isset($search_filters['user_email_filter']['exactly']))
		{
			$useremail_condition .= ' AND usr_email = \''.$search_filters['user_email_filter']['exactly'].'\' ';
			// $bind_arr['user_email_filter_exactly'] = $search_filters['user_email_filter']['exactly'];
		}
		if(isset($search_filters['user_email_filter']['contains']))
		{
			$useremail_condition .= ' AND usr_email LIKE "%'.$search_filters['user_email_filter']['contains'].'%" ';
			//$bind_arr['user_email_filter_contains'] = "%".$search_filters['user_email_filter']['contains']."%";
		}
		if(isset($search_filters['user_email_filter']['not_contains']))
		{
			$useremail_condition .= ' AND usr_email NOT LIKE "%'.$search_filters['user_email_filter']['not_contains'].'%" ';
			//$bind_arr['user_email_filter_not_contains'] = "%".$search_filters['user_email_filter']['not_contains']."%";
		}
		if(isset($search_filters['user_email_filter']['starts']))
		{
			$useremail_condition .= ' AND usr_email LIKE "'.$search_filters['user_email_filter']['starts'].'%" ';
			//$bind_arr['user_email_filter_starts'] = $search_filters['user_email_filter']['starts']."%";
		}
		if(isset($search_filters['user_email_filter']['ends']))
		{
			$useremail_condition .= ' AND usr_email LIKE "%'.$search_filters['user_email_filter']['ends'].'" ';
			//$bind_arr['user_email_filter_ends'] = "%".$search_filters['user_email_filter']['ends'];
		}
		//**********BUILD USEREMAIL CONDITION  -- STOP***********************//
		
		$user_fname_condition = '';
		if(isset($search_filters['user_fname_filter']['exactly']))
		{
			$user_fname_condition .= ' AND usr_first_name = \''.$search_filters['user_fname_filter']['exactly'].'\' ';
			//$bind_arr['user_fname_filter_exactly'] = $search_filters['user_fname_filter']['exactly'];
		}
		if(isset($search_filters['user_fname_filter']['contains']))
		{
			$user_fname_condition .= ' AND usr_first_name LIKE "%'.$search_filters['user_fname_filter']['contains'].'%" ';
			//$bind_arr['user_fname_filter_contains'] = "%".$search_filters['user_fname_filter']['contains']."%";
		}
		if(isset($search_filters['user_fname_filter']['not_contains']))
		{
			$user_fname_condition .= ' AND usr_first_name NOT LIKE "%'.$search_filters['user_fname_filter']['not_contains'].'%" ';
			//$bind_arr['user_fname_filter_not_contains'] = "%".$search_filters['user_fname_filter']['not_contains']."%";
		}
		if(isset($search_filters['user_fname_filter']['starts']))
		{
			$user_fname_condition .= ' AND usr_first_name LIKE "'.$search_filters['user_fname_filter']['starts'].'%" ';
			//$bind_arr['user_fname_filter_starts'] = $search_filters['user_fname_filter']['starts']."%";
		}
		if(isset($search_filters['user_fname_filter']['ends']))
		{
			$user_fname_condition .= ' AND usr_first_name LIKE "%'.$search_filters['user_fname_filter']['ends'].'" ';
			//$bind_arr['user_fname_filter_ends'] = "%".$search_filters['user_fname_filter']['ends'];
		}

		$user_lname_condition = '';
		if(isset($search_filters['user_lname_filter']['exactly']))
		{
			$user_lname_condition .= ' AND usr_last_name = \''.$search_filters['user_lname_filter']['exactly'].'\' ';
			//$bind_arr['user_lname_filter_exactly'] = $search_filters['user_lname_filter']['exactly'];
		}
		if(isset($search_filters['user_lname_filter']['contains']))
		{
			$user_lname_condition .= ' AND usr_last_name LIKE "%'.$search_filters['user_lname_filter']['contains'].'%" ';
			//$bind_arr['user_lname_filter_contains'] = "%".$search_filters['user_lname_filter']['contains']."%";
		}
		if(isset($search_filters['user_lname_filter']['not_contains']))
		{
			$user_lname_condition .= ' AND usr_last_name NOT LIKE "%'.$search_filters['user_lname_filter']['not_contains'].'%" ';
			//$bind_arr['user_lname_filter_not_contains'] = "%".$search_filters['user_lname_filter']['not_contains']."%";
		}
		if(isset($search_filters['user_lname_filter']['starts']))
		{
			$user_lname_condition .= ' AND usr_last_name LIKE "'.$search_filters['user_lname_filter']['starts'].'%" ';
			//$bind_arr['user_lname_filter_starts'] = $search_filters['user_lname_filter']['starts']."%";
		}
		if(isset($search_filters['user_lname_filter']['ends']))
		{
			$user_lname_condition .= ' AND usr_last_name LIKE "%'.$search_filters['user_lname_filter']['ends'].'" ';
			//$bind_arr['user_lname_filter_ends'] = "%".$search_filters['user_lname_filter']['ends'];
		}


		$post_code_condition = '';
		$searchLibrary = app(SearchQuery::class);
		if(isset($search_filters['post_code_filter']['exactly']))
		{
			$post_code_con = '= \''.$search_filters['post_code_filter']['exactly'].'\' ';
			//$bind_arr['post_code_filter_exactly'] = $search_filters['post_code_filter']['exactly'];
			$fetch_query =  $searchLibrary->user_post_code($post_code_con);
			$post_code_condition .= " AND ".$fetch_query ;
		}
		if(isset($search_filters['post_code_filter']['contains']))
		{
			$post_code_con = ' LIKE "%'.$search_filters['post_code_filter']['contains'].'%" ';
			//$bind_arr['post_code_filter_contains'] = "%".$search_filters['post_code_filter']['contains']."%";
			$fetch_query =  $searchLibrary->user_post_code($post_code_con);
			$post_code_condition .= " AND ".$fetch_query ;
		}
		if(isset($search_filters['post_code_filter']['not_contains']))
		{
			$post_code_con = ' LIKE "%'.$search_filters['post_code_filter']['not_contains'].'%" ';
			//$bind_arr['post_code_filter_not_contains'] = "%".$search_filters['post_code_filter']['not_contains']."%";
			$fetch_query =  $searchLibrary->user_post_code_not_like($post_code_con);
			$post_code_condition .= " AND ".$fetch_query ;
		}
		if(isset($search_filters['post_code_filter']['starts']))
		{
			$post_code_con = ' LIKE "'.$search_filters['post_code_filter']['starts'].'%" ';
			//$bind_arr['post_code_filter_starts'] = $search_filters['post_code_filter']['starts']."%";
			$fetch_query =  $searchLibrary->user_post_code($post_code_con);
			$post_code_condition .= " AND ".$fetch_query ;
		}
		if(isset($search_filters['post_code_filter']['ends']))
		{
			$post_code_con = ' LIKE "%'.$search_filters['post_code_filter']['ends'].'" ';
			//$bind_arr['post_code_filter_ends'] = "%".$search_filters['post_code_filter']['ends'];
			$fetch_query =  $searchLibrary->user_post_code($post_code_con);
			$post_code_condition .= " AND ".$fetch_query ;
		}
		$search_title_condition = '';
		if(isset($search_filters['user_title_filter']))
		{
			if(isset($search_filters['user_title_filter']['IN']))
			{
				$search_title_condition .= ' AND usr_title = \''.$search_filters['user_title_filter']['IN'].'\' ';
				//$bind_arr['user_title_filter_IN'] = $search_filters['user_title_filter']['IN'];
			}
			if(isset($search_filters['user_title_filter']['NOT IN']))
			{
				$search_title_condition .= ' AND usr_title != \''.$search_filters['user_title_filter']['NOT IN'].'\' ';
				//$bind_arr['user_title_filter_NOT_IN'] = $search_filters['user_title_filter']['NOT IN'];
			}
		}
		$search_default_condition = ' usr_jnl_standalone is null ';
		if($standalone_jnl != NULL)
			$search_default_condition = ' usr_jnl_standalone = '.$standalone_jnl;
		
		/*$search_default_condition .= ' AND IF(usr_roles IS NOT NULL,("sudo" NOT IN(REPLACE(REPLACE(REPLACE(usr_roles,\'"\',""),"]",""),"[",""))),TRUE) AND usr_status = "a" ';*/
		$search_status_condition = '';
		if(isset($search_filters['user_status_filter']))
		{
			if(isset($search_filters['user_status_filter']['is']))
			{
				$search_status_condition .= ' AND usr_status = \''.$search_filters['user_status_filter']['is'].'\' ';
				//$bind_arr['user_status_filter_is'] = $search_filters['user_status_filter']['is'];
			}
			if(isset($search_filters['user_status_filter']['is_not']))
			{
				$search_status_condition .= ' AND usr_status != \''.$search_filters['user_status_filter']['is_not'].'\' ';
				//$bind_arr['user_status_filter_is_not'] = $search_filters['user_status_filter']['is_not'];
			}
		}
		else
		{

			$search_default_condition .= " AND usr_status in $default_user_status";
		}

		$user_keyword_condition = '';
		if(isset($search_filters['user_keyword_filter']))
		{
			if(isset($search_filters['user_keyword_filter']['contain']))
			{
				$user_keyword_condition .= ' AND  FIND_array_intersect(\''.$search_filters['user_keyword_filter']['contain'].'\',keyword_table.user_keyword_id) = 1';
				//$bind_arr['user_keyword_filter_contain'] = $search_filters['user_keyword_filter']['contain'];
			}
			if(isset($search_filters['user_keyword_filter']['not_contain']))
			{
				$user_keyword_condition .= ' AND  FIND_array_intersect(\''.$search_filters['user_keyword_filter']['not_contain'].'\',keyword_table.user_keyword_id) = 0';
				//$bind_arr['user_keyword_filter_not_contain'] = $search_filters['user_keyword_filter']['not_contain'];
			}
		}
		$user_classification_condition = '';
		if(isset($search_filters['user_classification_filter']))
		{
			if(isset($search_filters['user_classification_filter']['contain']))
			{
				$user_classification_condition .= ' AND  FIND_array_intersect(\''.$search_filters['user_classification_filter']['contain'].'\',classification_table.user_classification_id) = 1';
				//$bind_arr['user_keyword_filter_contain'] = $search_filters['user_keyword_filter']['contain'];
			}
			if(isset($search_filters['user_classification_filter']['not_contain']))
			{
				$user_classification_condition .= ' AND  FIND_array_intersect(\''.$search_filters['user_classification_filter']['not_contain'].'\',classification_table.user_classification_id) = 0';
				//$bind_arr['user_keyword_filter_not_contain'] = $search_filters['user_keyword_filter']['not_contain'];
			}
		}

		$search_role_condition = '';
		if(isset($search_filters['user_role_filter']))
		{
			if(isset($search_filters['user_role_filter']['is']))
			{
				$search_role_condition .= ' AND dir_role_tb.role_id = '.$search_filters['user_role_filter']['is'].' ';
				//$bind_arr['user_role_filter_is'] = $search_filters['user_role_filter']['is'];
			}
			if(isset($search_filters['user_role_filter']['is_not']))
			{
				$search_role_condition .= ' AND dir_role_tb.role_id != '.$search_filters['user_role_filter']['is_not'].' ';
				//$bind_arr['user_role_filter_is_not'] = $search_filters['user_role_filter']['is_not'];
			}
		}
		$usr_artp_condition = '';
		if(isset($search_filters['user_artp_filter']))
		{
			if(isset($search_filters['user_artp_filter']['is']))
			{
				$usr_artp_condition .= ' AND dir_artp_tb.artp_id = '.$search_filters['user_artp_filter']['is'].' ';
				//$bind_arr['user_artp_filter_is'] = $search_filters['user_artp_filter']['is'];
			}
			if(isset($search_filters['user_artp_filter']['is_not']))
			{
				$usr_artp_condition .= ' AND dir_artp_tb.artp_id != '.$search_filters['user_artp_filter']['is_not'].' ';
				//$bind_arr['user_artp_filter_is_not'] = $search_filters['user_artp_filter']['is_not'];
			}
		}

		$user_flag_condition = '';
		if(isset($search_filters['user_flag_filter']))
		{
			if(isset($search_filters['user_flag_filter']['is']))
			{
				$flag_temp_condition = ' IN(\''.$search_filters['user_flag_filter']['is'].'\') ';
				//$bind_arr['user_flag_filter_is'] = $search_filters['user_flag_filter']['is'];
				$fetch_query =  $searchLibrary->usr_flags($flag_temp_condition,'usr_flag');
				$user_flag_condition .= ' AND '.$fetch_query;
			}
			if(isset($search_filters['user_flag_filter']['is_not']))
			{
				$flag_temp_condition = ' NOT IN(\''.$search_filters['user_flag_filter']['is_not'].'\') ';
				//$bind_arr['user_flag_filter_is_not'] = $search_filters['user_flag_filter']['is_not'];
				$fetch_query =  $searchLibrary->usr_flags($flag_temp_condition,'usr_flag');
				$user_flag_condition .= ' AND '.$fetch_query;			
			}
			if(isset($search_filters['user_flag_filter']['AND']) || isset($search_filters['user_flag_filter']['OR']))
			{
			$select_flag_field ='uf_usr_id AS flag_user,GROUP_CONCAT(DISTINCT uf_flag_id) AS uf_flag_id,GROUP_CONCAT(DISTINCT flag_name) AS user_flag';
			$flag_result_set = ' (SELECT '.$select_flag_field.' FROM '.$userflag_table.','.$flagtable.' WHERE uf_flag_id = flag_id GROUP BY uf_usr_id) AS flag_table ';

			$main_sql->join(DB::raw($flag_result_set),'flag_table.flag_user','=','usr_id','inner');

			if(isset($search_filters['user_flag_filter']['AND']))
			{
				$flag_temp_condition = ' FIND_array_in_all("'.$search_filters['user_flag_filter']['AND'].'",flag_table.user_flag) = 1 ';
				$user_flag_condition .= ' AND '.$flag_temp_condition;
			}

			if(isset($search_filters['user_flag_filter']['OR']))
			{
				$flag_temp_condition = ' FIND_array_intersect("'.$search_filters['user_flag_filter']['OR'].'",flag_table.user_flag) = 1 ';
				$user_flag_condition .= ' AND '.$flag_temp_condition;
			}
			}
		}

		$user_global_flag_condition = '';
		if(isset($search_filters['user_global_flag_filter']))
		{
			if(isset($search_filters['user_global_flag_filter']['is']))
			{
				$flag_temp_condition = ' IN(\''.$search_filters['user_global_flag_filter']['is'].'\') ';
				//$bind_arr['user_global_flag_filter_is'] = $search_filters['user_global_flag_filter']['is'];
				$fetch_query =  $searchLibrary->usr_flags($flag_temp_condition,'usr_g_flag');
				$user_global_flag_condition .= ' AND '.$fetch_query;
			}
			if(isset($search_filters['user_global_flag_filter']['is_not']))
			{
				$flag_temp_condition = ' NOT IN(\''.$search_filters['user_global_flag_filter']['is_not'].'\') ';
				//$bind_arr['user_global_flag_filter_is_not'] = $search_filters['user_global_flag_filter']['is_not'];
				$fetch_query =  $searchLibrary->usr_flags($flag_temp_condition,'usr_g_flag');
				$user_global_flag_condition .= ' AND '.$fetch_query;			
			}
			if(isset($search_filters['user_global_flag_filter']['AND']) || isset($search_filters['user_global_flag_filter']['OR']))
			{
			$select_global_flag_field ='ugf_user_id AS global_flag_user,GROUP_CONCAT(DISTINCT ugf_flag_id) AS ugf_flag_id,GROUP_CONCAT(DISTINCT flag_name) AS global_user_flag';
			$global_flag_result_set = ' (SELECT '.$select_global_flag_field.' FROM '.$userglobalflag_table.','.$flagtable.' WHERE ugf_flag_id = flag_id GROUP BY ugf_user_id) AS global_flag_table ';

			$main_sql->join(DB::raw($global_flag_result_set),'global_flag_table.global_flag_user','=','usr_id','inner');

			if(isset($search_filters['user_global_flag_filter']['AND']))
			{
				$global_flag_temp_condition = ' FIND_array_in_all("'.$search_filters['user_global_flag_filter']['AND'].'",global_flag_table.global_user_flag) = 1 ';
				$user_global_flag_condition .= ' AND '.$global_flag_temp_condition;
			}

			if(isset($search_filters['user_global_flag_filter']['OR']))
			{
				$global_flag_temp_condition = ' FIND_array_intersect("'.$search_filters['user_global_flag_filter']['OR'].'",global_flag_table.global_user_flag) = 1 ';
				$user_global_flag_condition .= ' AND '.$global_flag_temp_condition;
			}
			}
		}		
	
		//**********BUILD ORCID CONDITION -- STOP***********************//
		$userorcid_condition = '';

		if(isset($search_filters['article_orcid_filter']['contains']))
		{
			$userorcid_condition .= ' AND usr_orcid_id LIKE "%'.$search_filters['article_orcid_filter']['contains'].'%" ';
		}
		if(isset($search_filters['article_orcid_filter']['not_contains']))
		{
			$userorcid_condition .= ' AND usr_orcid_id NOT LIKE "%'.$search_filters['article_orcid_filter']['not_contains'].'%" ';
		}
		//**********BUILD ORCID CONDITION  -- START***********************//
		if(count($exclude_users) > 0)
			$search_default_condition .= ' AND usr_id NOT IN ('. implode(',', $exclude_users).')';
			if(isset($array_data['advance_search']))
			{
				//TASK #9336 SEARCH AND ADVANCE SEARCH RETIRE ROLE BUG FIX
				$main_sql->join(DB::raw(
					'(SELECT 
						usrj_usr_id, 
						dir_artp_tb.artp_article_type AS article_type_concat,
						GROUP_CONCAT(
							DISTINCT 
							IF(
								dir_usr_jnl.usrj_role_retired = "y", 
								CONCAT(
									"<span class=\"badge badge-primary\" style=\"text-decoration: line-through; color:#FFFF00;\">",
									dir_role_tb.role_name,
									"</span>"
								), 
								CONCAT(
									"<span class=\"badge badge-primary\">",
									dir_role_tb.role_name,
									"</span>"
								)
							) SEPARATOR " "
						) AS role_name_concat
					FROM rvw_user_journals AS dir_usr_jnl
					INNER JOIN rvw_article_types AS dir_artp_tb 
						ON dir_usr_jnl.usrj_artp_id = dir_artp_tb.artp_id
					INNER JOIN rvw_roles AS dir_role_tb 
						ON dir_usr_jnl.usrj_role_id = dir_role_tb.role_id
					   WHERE dir_usr_jnl.usrj_jnl_id = '.$jnl_id.'
                    ' . $search_role_condition . '
                     ' . $usr_artp_condition . ' 
					GROUP BY dir_usr_jnl.usrj_usr_id, dir_artp_tb.artp_article_type
					) AS article_role_concat'
				), 'article_role_concat.usrj_usr_id', '=', 'rvw_users.usr_id');
			}
			// TASK #6273 remove 	$article_last_review_condition
			// TASK #6273 start	

			if(isset($search_filters['journal_filter'])&&isset($search_filters['role_filter']))
			{	
				$dip_array=array();
				if(isset($search_filters['journal_filter']['not_in']))
				{
				$search_default_condition .='AND user_journal_table.usrj_jnl_id NOT IN ('.$search_filters['journal_filter']['not_in'].') ';
				}
				if(isset($search_filters['journal_filter']['in'])||isset($search_filters['journal_filter']['any']))
				{
					if(isset($search_filters['journal_filter']['any']))
					{
					array_push($dip_array,$search_filters['journal_filter']['any']);
					}
					if(isset($search_filters['journal_filter']['in']))
					{
					array_push($dip_array,$search_filters['journal_filter']['in']);
					}
				$search_default_condition .='AND user_journal_table.usrj_jnl_id IN ('.join(',',$dip_array).')';
				}
			}
			// TASK #6273 end	
			$sql_where =$search_default_condition.$journal_condition.$retired_jnl_condition.$article_condition.$article_review_condition.$role_condition.$retired_role_condition.$review_rating_ld_level_condition.$review_rating_sm_level_condition.$review_rating_level_condition.$completed_article_review_condition.$inhand_article_review_condition.$keyword_condition.$institution_condition;
			$sql_where .= $username_condition.$useremail_condition.$user_fname_condition.$user_lname_condition.$search_title_condition.$search_status_condition.$post_code_condition.$user_keyword_condition.$user_classification_condition.$present_filter_condition.$user_flag_condition.$user_global_flag_condition.$userorcid_condition.$classification_condition;
			$main_sql->whereRaw($sql_where);
			if(isset($search_filters['booleanseach_condition']) && $search_filters['booleanseach_condition']!= '')
			{
				$main_sql->whereRaw($search_filters['booleanseach_condition']);
			}
			/*if(count($bind_arr)>0)
			{
				$main_sql->setBindings($bind_arr);  
			}*/
			$main_sql->groupBy('usr_id');
			if(isset($array_data['advance_search']))
			{
				$main_sql->groupBy('usr_id');			
			}
			if(isset($array_data['advance_cnt']) && $array_data['advance_cnt'] == TRUE)
			{
				return	$main_sql->get()->count();
			}
			// TASK #6273 start	
			DB::statement("SET SESSION group_concat_max_len = 1000000");
			$main_sql->orderByRaw($order_by_condition);
			// $main_sql->orderByRaw($order_by_condition.' ,usr_id asc');
			// TASK #6273 end	
			if(isset($array_data['export_flag']) && $array_data['export_flag'] == TRUE)
			{
				return 	$main_sql->get();
			}
			else
			{
				return	$main_sql->paginate($page_limit);
			}


		/*$sql_select = 'SELECT '.$select.' FROM '.$user_table.$user_journal_result_set.$article_result_set.$article_review_result_set.$role_result_set.$retired_role_result_set.$review_rating_ld_level_result_set.$review_rating_sm_level_result_set.$review_rating_level_result_set.$completed_article_review_result_set.$inhand_article_review_result_set.$institution_result_set.$keyword_result_set.$past_oneyr_assignments_result_set.$article_review_last_invite_result_set.$review_rating_order_level_result_set.$decline_review_result_set;
		
      
        $join_sql=$user_journal_result_set.$article_result_set.$article_review_result_set.$role_result_set.$retired_role_result_set.$review_rating_ld_level_result_set.$review_rating_sm_level_result_set.$review_rating_level_result_set.$completed_article_review_result_set.$inhand_article_review_result_set.$institution_result_set.$keyword_result_set.$past_oneyr_assignments_result_set.$article_review_last_invite_result_set.$review_rating_order_level_result_set.$decline_review_result_set;
		$sql_where = $search_default_condition.$journal_condition.$retired_jnl_condition.$article_condition.$article_review_condition.$role_condition.$retired_role_condition.$review_rating_ld_level_condition.$review_rating_sm_level_condition.$review_rating_level_condition.$completed_article_review_condition.$inhand_article_review_condition.$keyword_condition.$institution_condition;

		
		
		$sql_pagination = '';
		if ($start !== NULL && $limit !== NULL && $return_count == FALSE)
			$sql_pagination = ' LIMIT '.$start.','.$limit;
		
		
		$sql = $sql_select.$sql_where.$order_by_condition.$sql_pagination;
		*/


	

	
	}
	public static function get_user_last_invite_list($art_id = NULL, $user_ids = array())
	{
		$articleflowtable=(new \App\Models\Article_flow())->getTable();
		$reviewer_legacy_table=(new \App\Models\Article_reviewer_legacydata())->getTable();
		
		$selectwhere = '';
		if ($art_id != NULL) {
			$selectwhere = ' AND aflw_art_id !=' . $art_id;
		}
		$select = 'usr.usr_id, 
			@date1:= (SELECT max(aflw_assigned_date) FROM ' . $articleflowtable . ' WHERE aflw_parent_flow_id IS NOT NULL AND aflw_usr_id = `usr`.`usr_id` ' . $selectwhere . '),
			@date2:= (SELECT max(arev_stage_start_date)  from ' . $reviewer_legacy_table . ' WHERE arev_user_id = `usr`.`usr_id` and arev_user_id IS NOT NULL),
			IF((@date1 > @date2) OR @date2 IS NULL,@date1,@date2) as last_invitation_date';

		$classname = get_called_class();
        $table = (new $classname)->getTable();
        $users = DB::table($table . ' AS usr');
        $users->selectRaw($select);
		if (!empty($user_ids)) {
			$where = 'usr_id IN (' . implode(',',$user_ids) . ')';
			$users->whereRaw($where);
		}

        $result = $users->get();
		return $result;
	}

	public static function user_review_rating_five_star($user_id,$search_filters)
	{
		$reviewratingtable=(new \App\Models\Review_rating())->getTable();
		$rating_result = DB::table($reviewratingtable)->where('rvr_reviewer_id', $user_id)->where('rvr_five_star','y')->avg('rvr_rating');
		return $rating_result;
	}
	public static function insert_batch($data, $user_data = NULL)
    {
      
        DB::enableQueryLog();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
		$id ='';
        // $id = DB::table($table)->insertOrIgnore($data);
		$primaryKey = 'usr_id';
		// DB::table($table)->orderBy($primaryKey)->chunk('100', function ($data)  {
			foreach ($data as $row) {
				$id =DB::table($table)->insert(json_decode(json_encode($row), true));
			}
			// });
        $queries = DB::getQueryLog();
         //dd($queries);
        return $id;
    }

	public static function set_bind_arr($search_filters,$bind_arr,$number)
	{
		if(isset($search_filters['journal_filter']['any']))
		{
			$bind_arr['journal_filter_any'.$number] = $search_filters['journal_filter']['any'];
		}
			
		if(isset($search_filters['journal_filter']['not_in']))
		{
			$bind_arr['journal_filter_not_in'.$number] = $search_filters['journal_filter']['not_in'];
		}
			
		if(isset($search_filters['journal_filter']['in']))
		{
			$bind_arr['journal_filter_in'.$number] = $search_filters['journal_filter']['in'];
		}
		return $bind_arr;
	}

	public static function pop_bind_arr($search_filters,$bind_arr,$number = '')
	{
		if(isset($search_filters['journal_filter']['any']))
		{
			unset($bind_arr['journal_filter_any'.$number]);
		}
			

		if(isset($search_filters['journal_filter']['not_in']))
		{
			unset($bind_arr['journal_filter_not_in'.$number]);
		}
			

		if(isset($search_filters['journal_filter']['in']))
		{
			unset($bind_arr['journal_filter_in'.$number]);
		}
		return $bind_arr;
	}

    public static function get_user_id_by_email($email)
    {
        $user_id = DB::selectOne("select usr_id from rvw_users where usr_email = ? ", [$email])?->usr_id;

        return $user_id;
    }
}
