<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class User_articles extends BaseModel
{
    
    public  $table='rvw_user_articles';
    protected $primaryKey = 'usra_id';
    public static $column_prefix='usra_';
    public static $tbk_table = 'tbk_user_articles';
    use HasFactory;
    
    public static function get_allocate_user_with_role($select = '*',$where = NULL,$order_by = NULL,$user_tb = FALSE)
	{


        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $article_table = (new \App\Models\Articles())->getTable();
        $roles = (new \App\Models\Roles())->getTable();
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $user_table=(new \App\Models\User())->getTable();
        $role_data = DB::table($table);
        $role_data->selectRaw($select);
        $role_data->join($roles,'role_id', '=', 'usra_role_id');
        if ($user_tb == TRUE)
        {
            $role_data->join($user_table, 'usra_usr_id', '=', 'usr_id');
        }
        $role_data->whereRaw($where);
        return $role_data->get();
	}


    public static function get_assigned_users($select = '*', $where = '', $group_by = '')
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $user_table=(new \App\Models\User())->getTable();
        $assigned_usr = DB::table($table);
		$assigned_usr->selectRaw($select);
        $assigned_usr->join($user_table,'usr_id', '=', 'usra_usr_id');
        if(is_array($where))
        {
            $assigned_usr->where($where);
        }
        elseif($where != '')
        { 
		$assigned_usr->whereRaw($where);
        }
        if($group_by)
        {
            $assigned_usr->groupBy($group_by);
        }
        return $assigned_usr->get();
	
	}

    public static function copy_article_users($article_id, $new_article_id, $current_user)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();

		if ($current_user['user_id'] == $current_user['proxy_user_id'])
			$proxy_id = '0';
		else
			$proxy_id = $current_user['proxy_user_id'];

		$sql = "insert into " .$table . " (usra_art_id,usra_usr_id,usra_role_id,usra_posted_date,usra_posted_by,usra_proxy_id) "
			. "select  " . $new_article_id . ",usra_usr_id,usra_role_id,'" . date('Y-m-d H:i:s') . "'," . $current_user['user_id'] . "," . $proxy_id . "  from " . $table. " where usra_art_id=" . $article_id;
		$result = DB::select($sql);
		if ($result)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
           //check whether the user is in user_article table or not
       public static function check_role_assigned_article($type, $id, $usr_id,$role_id)
       {
          $articles = (new \App\Models\Articles())->getTable();
          $article_type = (new \App\Models\Article_types())->getTable();
          $author_table= (new \App\Models\Authors())->getTable();
          $classname = get_called_class();
          $table = (new $classname)->getTable();
          $query = DB::table($table)
              ->selectRaw('COUNT(usra_usr_id) AS row_count, SUM(CASE WHEN art_delete_status = "y" THEN 1 ELSE 0 END) AS deleted_article_count')
              ->join($articles,'art_id','=','usra_art_id');
             
          if ($type === 'a')
          { // article_type level
              $query->where('art_artp_id',  $id);
          }
          else
          { // 'j'
              $query->join($article_type,'artp_id','=','art_artp_id');
              $query->where('artp_jnl_id', $id);
          }
          if($role_id)
          {
            $query->where('usra_role_id', $role_id);
          }
          $query->where('usra_usr_id', $usr_id);
          $result = $query->first();

		// Get the total count of articles linked to the user
		$total_articles_count = $result->row_count ?? 0;
		$deleted_article_count = $result->deleted_article_count ?? 0;

		if ($deleted_article_count > 0 && $deleted_article_count == $total_articles_count) {
			return [
				'status' => true,
				'reason' => customTrans('platform_settings.role_required_marked_delete'),
			];
		}
	
		if ($total_articles_count > 0) {
			return [
				'status' => true,
				'reason' => customTrans('platform_settings.user_required_flow'),
			];
		}
         }
    


}
