<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class User_flags extends BaseModel
{
    use HasFactory;
    public  $table='rvw_user_flags';
    public static $column_prefix='uf_';
	public static $tbk_table= 'tbk_user_flags';
    protected $primaryKey = 'uf_id';


    public static function get_user_flags($jnl_id, $usr_id,$specifyjournal='',$in_notin='')
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $flag_table = (new \App\Models\Flags())->getTable();
        $user_flag = DB::table($table);
        $user_flag->selectRaw("{$flag_table}.*");
        $user_flag->join($flag_table , 'flag_id', '=', 'uf_flag_id');
        //$user_flag->whereRaw("uf_jnl_id= ? AND uf_usr_id= ?",[$jnl_id,$usr_id]);
        if($specifyjournal=='')
        {
            $user_flag->whereRaw("uf_jnl_id= ? AND uf_usr_id= ?",[$jnl_id,$usr_id]);
        }
        else
        {
            $user_flag->whereRaw("uf_jnl_id ".$in_notin." (".$specifyjournal.")  AND uf_usr_id=".$usr_id);
        }
       return $user_flag->get();
	
	}
    public static function check_flag_exists($jnl_id, $flg_id, $usr_id)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $user_flag = DB::table($table);
        $user_flag->selectRaw("*");
        $user_flag->whereRaw("uf_jnl_id={$jnl_id} AND uf_usr_id={$usr_id} AND uf_flag_id={$flg_id}");
		return $user_flag->get();
	}

    public static function check_glb_flag_exists($flg_id, $usr_id) {
        $table = (new \App\Models\User_global_flags())->getTable();
        $user_flag = DB::table($table);
        $user_flag->selectRaw("ugf_id");
        $user_flag->whereRaw("ugf_flag_id={$flg_id} AND ugf_user_id={$usr_id}");
       return $user_flag->get();
    }

    public static function fetch_all_usr_jnl_flags($flags, $usr_id, $platform) {
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $user_flag = DB::table($table);      
        $flag_table = (new \App\Models\Flags())->getTable();
        $jnl_table = (new \App\Models\Journals())->getTable();

        $user_flag->selectRaw("jnl_id, jnl_journal_name, flag_name");
        $user_flag->join($flag_table , 'flag_id', '=', 'uf_flag_id');
        $user_flag->join($jnl_table , 'jnl_id', '=', 'uf_jnl_id');       
        $user_flag->whereRaw("uf_usr_id={$usr_id} AND uf_flag_id IN ({$flags}) AND flag_platform = '".$platform."'");
		return $user_flag->get();
    }
}
