<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class User_global_flags extends BaseModel
{
    use HasFactory;
    public $table='rvw_user_global_flags';
    public static $column_prefix='ugf_';
    protected $primaryKey = 'ugf_id';
	public static $tbk_table= 'tbk_user_global_flags';


    public static function get_user_global_flags($condition,$binding_arr=array())
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $flag_table = (new \App\Models\Flags())->getTable();
        $user_flag = DB::table($table);
        $user_flag->selectRaw("ugf_id,ugf_flag_id,flag_color,flag_prefix,flag_icon,flag_name,flag_role,flag_id");
        $user_flag->join($flag_table , 'flag_id', '=', 'ugf_flag_id');
        $user_flag->whereRaw($condition);
        if(count($binding_arr) > 0) {
            $user_flag->setBindings($binding_arr);
        }
       return $user_flag->get();
		
	}
}
