<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User;
//use DB;
use Illuminate\Support\Facades\DB;
use stdClass;

class User_to_journals extends BaseModel
{
	use HasFactory;

	public  $table = 'rvw_user_journals';
	protected $primaryKey = 'usrj_id';
	public static $column_prefix = 'usrj_';
	public static $tbk_table= 'tbk_user_journals';
	public $timestamps = false;


	public static function get_journal_user_roles($user_id, $jnl_code = NULL, $article_type_id = NULL, $core_roles = array()) //either $jnl_code or  $id must needed . otherwise it create error
	{
		$role_table = (new \App\Models\Roles())->getTable();
		$journal_table = (new \App\Models\Journals())->getTable();

		$classname = get_called_class();
		$table = (new $classname)->getTable();
		DB::enableQueryLog();
		$result = DB::table($table)->join($role_table, 'usrj_role_id', '=', 'role_id')
			->selectRaw("group_concat(role_id SEPARATOR ';') role_ids, group_concat(role_name SEPARATOR ';') role_names, group_concat(role_assigned_role SEPARATOR ';') role_assigned_roles");
		if ($jnl_code != NULL)
		{
			$result->join($journal_table, 'jnl_id', '=', 'usrj_jnl_id');
			if($jnl_code == NULL)
				$result->whereRaw('jnl_journal_code IS NULL');
			else
				$result->where('jnl_journal_code', $jnl_code);

			if($article_type_id == NULL)
				$result->whereRaw('usrj_artp_id IS NULL');
			else
				$result->where('usrj_artp_id', $article_type_id);
		}
		$result->where('usrj_usr_id', $user_id)
			->orderBy(DB::raw("FIELD(role_assigned_role,'" . implode("','", $core_roles) . "' )"));

		return $result->get();
		$queries = DB::getQueryLog();
		//	dd ($queries);
	}

	public static function get_user_role_ids($jnl_id, $user_id, $staff_role_id = NULL)
	{

		$articletype_table = (new \App\Models\Article_types())->getTable();
		//$journal_table = (new \App\Models\Journals())->getTable();

		//LEFT JOIN rvw_article_types ON artp_id = usrj_artp_id

		$classname = get_called_class();
		$table = (new $classname)->getTable();

		$sql = 'SELECT usrj_artp_id,GROUP_CONCAT(usrj_role_id) as role_ids FROM ' . $table . ' LEFT JOIN ' . $articletype_table . ' ON artp_id = usrj_artp_id WHERE usrj_jnl_id = ' . $jnl_id . ' AND artp_jnl_id = ' . $jnl_id . ' AND usrj_usr_id = ' . $user_id;

		if ($staff_role_id != NULL) {
			$sql .= ' AND usrj_role_id = ' . $staff_role_id . '';
		}

		$sql .= ' AND usrj_artp_id IS NOT NULL GROUP BY usrj_artp_id';

		$result = DB::select($sql);
		return $result;
	}

	public static function get_all_roles($condition, $with_user = TRUE, $type = NULL, array $binding_arr = [])
	{

		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$usertable = (new \App\Models\User())->getTable();
		$articletype_table = (new \App\Models\Article_types())->getTable();
		$journal_table = (new \App\Models\Journals())->getTable();
		$roles_table = (new \App\Models\Roles())->getTable();
		$result = DB::table($table)->distinct();
		$result->selectRaw("role_name,role_id,role_assigned_role");
		//$db_handler->distinct();
		//$db_handler->select('role_name,role_id,role_assigned_role');

		//$db_handler->from(self::$tbl_name);
		if ($with_user == TRUE) {
			$result->selectRaw('usr_username,usrj_usr_id ,usrj_jnl_id,usr_id,usrj_invite, usrj_role_retired ');
			$result->join($usertable, 'usr_id', '=', 'usrj_usr_id');
			if (!empty($type) && $type == 'a') {
				$result->selectRaw('artp_article_type,artp_id');
				$result->join($articletype_table, 'artp_id', '=', 'usrj_artp_id');
			} else {
				$result->selectRaw('jnl_journal_name,jnl_id');
				$result->join($journal_table, 'jnl_id', '=', 'usrj_jnl_id');
				$result->whereRaw('usrj_artp_id IS NULL');
			}
		}
		$result->join($roles_table, 'role_id', '=', 'usrj_role_id');
		//	$db_handler->join(Roles::$tbl_name, 'role_id = usrj_role_id');
		$result->whereRaw($condition, $binding_arr);
		return $result->get();
	}
	/* end TASK #4943 proxyauthorize sql injection */
	public static function get_journal_user_list($select, $condition, $limit,$binding_arr=[])
	{

		$user_table = (new \App\Models\User())->getTable();
		$remainig_users = DB::table($user_table)
			->selectRaw(DB::raw($select))
			// ->groupBy('usr_id','usr_email')
			->orderBy('full_name')
			->whereRaw($condition);
			if (count($binding_arr) > 0)
				$remainig_users->setBindings($binding_arr);
			$remainig_users = $remainig_users->paginate($limit);
		return $remainig_users;
	}

	public static function get_user_assigned_role_based_platform($select, $condition, $limit,$sort_field,$sort_order,$join_sub_table_query = '',$add_con ='',$binding_arr = [])
	{
		$role_table = (new \App\Models\Roles())->getTable();
		$user_table = (new \App\Models\User())->getTable();
		$user_to_journal_table = (new \App\Models\User_to_journals())->getTable();
        $journal_table = (new Journals())->getTable();

		if($join_sub_table_query != '' && $add_con ==''){
			$journal_user = DB::table($user_to_journal_table . ' as tb1')
			->selectRaw(DB::raw($select))
			->join($role_table, 'tb1.usrj_role_id', '=', 'role_id')
			->join($user_table, 'tb1.usrj_usr_id', '=', 'usr_id')
            ->join($journal_table, 'tb1.usrj_jnl_id', '=', 'jnl_id')
			->joinSub($join_sub_table_query,'tb2','tb1.usrj_usr_id','=','tb2.usrj_usr_id','inner')
			->groupBy('user_id', 'user_email', 'jnl_id')
			->whereRaw($condition);
			if (count($binding_arr) > 0) {
				$journal_user->setBindings($binding_arr);
			}
			$journal_user->orderBy($sort_field,$sort_order);
			$journal_user = $journal_user->paginate($limit);
		}
		else if($join_sub_table_query != '' && $add_con !=''){
			$journal_user = DB::table($user_to_journal_table . ' as tb1')
			->selectRaw(DB::raw($select))
			->join($role_table, 'tb1.usrj_role_id', '=', 'role_id')
			->join($user_table, 'tb1.usrj_usr_id', '=', 'usr_id')
            ->join($journal_table, 'tb1.usrj_jnl_id', '=', 'jnl_id')
			->joinSub($join_sub_table_query,'tb2',function ($join) {
				$join->on('tb1.usrj_usr_id', '=', 'tb2.usrj_usr_id')->on('tb2.usrjrnl_id', '=', 'tb1.usrj_jnl_id');
				})

			->groupBy('user_id', 'user_email', 'jnl_id')
			->whereRaw($condition);
			if (count($binding_arr) > 0) {
				$journal_user->setBindings($binding_arr);
			}
			$journal_user->orderBy($sort_field,$sort_order);
			$journal_user = $journal_user->paginate($limit);
		}
		else{
			$journal_user = DB::table($user_to_journal_table . ' as tb1')
			->selectRaw(DB::raw($select))
			->join($role_table, 'tb1.usrj_role_id', '=', 'role_id')
			->join($user_table, 'tb1.usrj_usr_id', '=', 'usr_id')
            ->join($journal_table, 'tb1.usrj_jnl_id', '=', 'jnl_id')
			->groupBy('user_id', 'user_email', 'jnl_id')
			->whereRaw($condition);
			if (count($binding_arr) > 0) {
				$journal_user->setBindings($binding_arr);
			}
			$journal_user->orderBy($sort_field,$sort_order);
			$journal_user = $journal_user->paginate($limit);
			}
		return $journal_user;
	}
	public static function del_user_roles($condition, $roles)
	{
		$user_to_journal_table = (new \App\Models\User_to_journals())->getTable();
		$result = DB::table($user_to_journal_table)->whereIn('usrj_role_id', $roles)->where($condition)->delete();
		return $result;
		/*$db_handler->where_IN('usrj_role_id', $roles);
		$db_handler->delete(self::$tbl_name, $condition);
		return $db_handler->affected_rows();*/
	}
	public static function get_proxy_journal_users($jnl_code, $srch_text, $proxy_user, $enable_terms = FALSE)
	{
		DB::enableQueryLog();
		$proxy_bind_arr = array();

		$role_table = (new \App\Models\Roles())->getTable();
		$user_table = (new \App\Models\User())->getTable();
		$user_to_journal_table = (new \App\Models\User_to_journals())->getTable();
		$journal_table = (new \App\Models\Journals())->getTable();

		$journal_user = DB::table($user_to_journal_table);
		$journal_user->selectRaw('usr_id,CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as user,GROUP_CONCAT(DISTINCT role_name SEPARATOR \', \')  as roles');
		$journal_user->join($journal_table, 'usrj_jnl_id', '=', 'jnl_id');
		$journal_user->join($role_table, 'usrj_role_id', '=', 'role_id');
		$journal_user->join($user_table, 'usrj_usr_id', '=', 'usr_id');
		$journal_user->whereRaw("jnl_journal_code = '". $jnl_code ."'");
		$journal_user->whereRaw('usr_id !=' . $proxy_user['user_id']);
		if($proxy_user['proxy_user_id']!=0){
			$journal_user->whereRaw('usr_id !=' . $proxy_user['proxy_user_id']);
		}
		$journal_user->whereRaw(' usrj_artp_id IS NULL');
		/* TASK #3056 When a user tries to proxy as a Statistician user, they are failed to acquire the Statistician role. */
		// $journal_user->whereRaw('(`role_name` LIKE  "%' . $srch_text . '%"  or CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) LIKE "%' . $srch_text . '%" )');
		$journal_user->whereRaw('usr_status = "a"');
		// $journal_user->whereRaw('(LOWER(role_name) LIKE  :role_name  or CONCAT(LOWER(usr_first_name), IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ", LOWER(usr_middle_name), " ")), LOWER(usr_last_name)) LIKE :user_name  )');
		$journal_user->whereRaw('
    (LOWER(role_name) LIKE :role_name OR 
    CONCAT(LOWER(usr_first_name), IF(usr_middle_name IS NULL or usr_middle_name = "", " ", CONCAT(" ", LOWER(usr_middle_name), " ")), LOWER(usr_last_name)) LIKE :user_name)
')
->orderByRaw("
    CASE 
        WHEN LOWER(role_name) LIKE :role_name_exact THEN 1 
        WHEN CONCAT(LOWER(usr_first_name), IF(usr_middle_name IS NULL or usr_middle_name = '', ' ', CONCAT(' ', LOWER(usr_middle_name), ' ')), LOWER(usr_last_name)) LIKE :user_name_exact THEN 1
        ELSE 2 
    END, role_name ASC
");

		$proxy_bind_arr['role_name']= "%".strtolower($srch_text)."%";
		$proxy_bind_arr['user_name']= "%".strtolower($srch_text)."%";
		$proxy_bind_arr['role_name_exact'] = strtolower($srch_text) . '%';
		$proxy_bind_arr['user_name_exact'] = strtolower($srch_text) . '%';

		$journal_user->orderByRaw("CASE
				WHEN LOWER(role_name) LIKE :role_name_like THEN 1
				WHEN LOWER(usr_first_name) LIKE :first_name_like THEN 1
				WHEN CONCAT(LOWER(usr_first_name), ' ', LOWER(usr_middle_name), ' ', LOWER(usr_last_name)) LIKE :full_name_like THEN 1
				ELSE 2
				END");
				
				$proxy_bind_arr['role_name_like']= '"'.strtolower($srch_text).'%"';
				$proxy_bind_arr['first_name_like']= '"'.strtolower($srch_text).'%"';
				$proxy_bind_arr['full_name_like']= '"'.strtolower($srch_text).'%"';
		
		/* end TASK #3056 When a user tries to proxy as a Statistician user, they are failed to acquire the Statistician role. */
		// $journal_user->whereRaw("( CASE WHEN usr_roles IS NULL THEN TRUE ELSE FIND_IN_SET( 'super_admin',( REPLACE ( REPLACE ( REPLACE (usr_roles, '\"', ''),'[', '' ), ']', '' ) ) ) = 0 END ) ");
		if ($enable_terms == TRUE) {
			$journal_user->whereRaw('usr_terms_condition = "y"');
		}
		if (count($proxy_bind_arr)>0){
			$journal_user->setBindings($proxy_bind_arr);
		}
		$journal_user->distinct();
		$journal_user->groupBy('usr_id');
		return $journal_user->skip(0)->take(25)->get();
		$queries = DB::getQueryLog();
		//dd($queries);
	}
	//article type copy time
	public static function move_user_roles($jnl_id, $id, $current_user, $usrj_artp_id = NULL, $retire_status = FALSE)
	{

		$user_to_journal_table = (new \App\Models\User_to_journals())->getTable();
		$role_retire_condition = '';

		if ($retire_status == TRUE) {
			$role_retire_condition =  ' AND usrj_role_retired= \'n\' ';
		}
		$proxy_id = session('proxy_user_id') ?? 0;
		$sql = "insert into " . $user_to_journal_table . "(usrj_jnl_id,usrj_usr_id,usrj_role_id,usrj_artp_id,usrj_posted_by,usrj_posted_date, usrj_proxy_id) select usrj_jnl_id,usrj_usr_id,usrj_role_id," . $id . "," . $current_user . ",'" . date('Y-m-d H:i:s') . "', $proxy_id from " . $user_to_journal_table . " where  usrj_jnl_id =" . $jnl_id;
		if ($usrj_artp_id != NULL) {
			$sql .= " AND usrj_artp_id =" . $usrj_artp_id;
		} else {
			$sql .= " AND usrj_artp_id IS NULL";
		}
		$sql .= $role_retire_condition;
		$sql .= "  GROUP BY usrj_jnl_id,usrj_usr_id,usrj_role_id";
		$result = DB::select($sql);
		$queries = DB::getQueryLog();
		$id = DB::connection()->getPdo()->lastInsertId();
		return $id;
	}

	public static function get_user_from_jnl($select = '*', $condition = '')
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$user_table = (new \App\Models\User)->getTable();
		$journals_table = (new \App\Models\Journals)->getTable();
		$roles_table = (new \App\Models\Roles)->getTable();
		$articletype_table = (new \App\Models\Article_types)->getTable();
		$user_jnl = DB::table($table);
		$user_jnl->selectRaw($select);
		$user_jnl->join($journals_table, 'jnl_id', '=', 'usrj_jnl_id');
		$user_jnl->join($user_table, 'usr_id', '=', 'usrj_usr_id');
		$user_jnl->join($roles_table, 'role_id', '=', 'usrj_role_id');
		$user_jnl->leftjoin($articletype_table, 'artp_id', '=', 'usrj_artp_id');
		if ($condition)
			$user_jnl->whereRaw($condition);
		return $user_jnl->get();
	}
	public static function get_users_for_jrnal_epa($jnl_id, $srch_text, $is_standalone)
	{
		DB::enableQueryLog();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$user_table = (new \App\Models\User)->getTable();
		$journals_table = (new \App\Models\Journals)->getTable();
		$roles_table = (new \App\Models\Roles)->getTable();
		$result = DB::table($table);
		$result->selectRaw('usr_id,
CONCAT(usr_first_name,	IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as user,
     group_concat(DISTINCT role_name SEPARATOR \',\')  as roles');
		$result->join($journals_table, 'usrj_jnl_id','=','jnl_id');
		$result->join($user_table, 'usrj_usr_id','=','usr_id');
		$result->join($roles_table, 'usrj_role_id','=','role_id');
		$result->whereRaw("jnl_id='". $jnl_id."'");
		$result->whereRaw('usrj_artp_id IS NULL');
		$result->whereRaw('(`role_name` LIKE  "%' . $srch_text . '%"  or CONCAT(usr_first_name,IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) LIKE "%' . $srch_text . '%" )');
		$result->whereRaw('usr_status = "a"');
		$result->whereRaw("(`usr_roles` NOT LIKE '%sudo%' OR `usr_roles` IS NULL)");
		if($is_standalone == 'y')
			$result->whereRaw("usr_jnl_standalone='".$jnl_id."'");
		else
			$result->whereRaw('usr_jnl_standalone IS NULL');

			$result->distinct();
			$result->groupBy('usr_id');
			return $result->skip(0)->take(50)->get();
			$queries = DB::getQueryLog();
	}
	//master query
	public static function get_user_role_classification($id, $type, $users = array(), $limit = NULL, $start = NULL, $search_condition = '', $return_count = FALSE, $orderby = NULL)
	{
		$user_table = (new \App\Models\User)->getTable();

		$roles_table = (new \App\Models\Roles)->getTable();
		$articletype_table = (new \App\Models\Article_types)->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$result = new stdClass();
		if ($type === 'a') {
			$select_condition_first = 'and usrj_artp_id = ' . $id;
			$select_condition_second = 'and b.jntm_artp_id = ' . $id;
		} else //journal
		{
			$select_condition_first = 'and `usrj_jnl_id` = ' . $id . '  and `usrj_artp_id` is null';
			$select_condition_second = 'and b.jntm_jnl_id = ' . $id . ' and b.jntm_artp_id is null';
		}

		if (!empty($users)) {
			$user_condition_first = " and usr_id IN ('" . implode("','", $users) . "' )";
		} else {
			$user_condition_first = '';
		}

		$select_count_sql = "SELECT usrj_usr_id user_id,usr_email as  user_email,usrj_jnl_id as jnl_id,usrj_artp_id as artp_id";  //only for fetching row count and avoid max. inner select

		$select_sql = "SELECT
					usrj_usr_id user_id,
					GROUP_CONCAT(DISTINCT usrj_role_id SEPARATOR ';') role_ids,
					GROUP_CONCAT(DISTINCT role_name SEPARATOR ';') role_names,
					GROUP_CONCAT(DISTINCT role_assigned_role SEPARATOR ';') role_assigned_role,
									GROUP_CONCAT(DISTINCT CONCAT(role_name,',',usrj_role_retired) SEPARATOR ';' ) role_retire_status,
					CONCAT(
					usr_first_name,
					' ',
					usr_last_name
					) AS user_name,
					usr_email AS user_email,
					usrj_jnl_id jnl_id,
					usrj_artp_id artp_id,
					(SELECT
					COUNT(*)
					FROM
					rvw_user_journal_classifications a
					JOIN rvw_journal_terms b
						ON a.jucl_jntm_id = b.jntm_id
						{$select_condition_second}
					WHERE a.jucl_usr_id = usrj_usr_id) classification_count ";

		$from_tb_sql = " FROM
					{$table},
					{$roles_table},
					{$user_table}
				WHERE usrj_role_id = role_id
					AND usrj_usr_id = usr_id
					{$select_condition_first}
					{$user_condition_first}
					{$search_condition}
				GROUP BY
					user_id, user_email, jnl_id, artp_id";
		$sql_order_by = '';
		if ($orderby != NULL)
			$sql_order_by = " ORDER BY " . $orderby;

		$sql = $select_sql . $from_tb_sql . $sql_order_by;

		if ($return_count == TRUE) //for getting count
		{
			$sql = "select count('tb1.user_id') as cnt from (" . $select_count_sql . $from_tb_sql . " ) as tb1";
		} elseif ($start !== NULL && $limit !== NULL)
			$sql = $sql . ' LIMIT ' . $start . ',' . $limit;
		$result = User_to_journals::get_records_by_raw_query($sql,$return_count);
		return $result;
	}
	public static function get_journals_by_role($user_id, $role_array)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$roles_table = (new \App\Models\Roles)->getTable();
		$role_jnl = DB::table($table);
		$role_jnl->selectRaw('usrj_jnl_id');
		$role_jnl->whereRaw("usrj_usr_id={$user_id}");
		$role_jnl->whereRaw("usrj_artp_id  IS NULL");
		$role_jnl->whereRaw("usrj_role_id IN (SELECT role_id FROM {$roles_table} WHERE `role_assigned_role` in ('" . implode("','", $role_array) . "'))");
		return $role_jnl->get();
	}
	public static function get_usrs_count($arttp_id, $role_id,$article_id,$short_list=false)
    {
		//DB::enableQueryLog();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $article_table = (new \App\Models\Articles())->getTable();
        $roles = (new \App\Models\Roles())->getTable();
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $user_table=(new \App\Models\User())->getTable();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$Article_reviewers=(new \App\Models\Article_reviewers())->getTable();
        $role_data = DB::table($table);
        $role_data->selectRaw('usrj_usr_id, role_name, role_assigned_role');
        $role_data->leftJoin($roles,'role_id', '=', 'usrj_role_id');
		if($short_list==true)
		{
			$role_data->whereRaw("usrj_artp_id={$arttp_id} AND usrj_role_id={$role_id} AND role_assigned_role IN('editor_in_chief','associate_editor','staff')  and usrj_role_retired='n'");
		}
		else
		{
			$role_data->whereRaw("usrj_artp_id={$arttp_id} AND usrj_role_id={$role_id} AND role_assigned_role IN('editor_in_chief','associate_editor','staff')  and usrj_role_retired='n' and usrj_usr_id not in (select sorw_suggested_reviewer_id from {$Article_reviewers} where sorw_suggested_reviewer_id=usrj_usr_id and sorw_art_id={$article_id})");
		}
		$result= $role_data->get();
		//$data=DB::getQueryLog();
		//dd($data);
	   	return $result;

    }
	public static function get_user_roles($user_id, $id, $type, $roles = NULL)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$roles_table = (new \App\Models\Roles)->getTable();
		$user_jnl = DB::table($table);
		$user_jnl->selectRaw('role_id,role_name,role_assigned_role');
		$user_jnl->join($roles_table, 'role_id', '=', 'usrj_role_id');
		$user_jnl->whereRaw("usrj_usr_id= {$user_id}");
		if (!empty($type) && $type === 'a' && !empty($id)) {
			$user_jnl->whereRaw("usrj_artp_id={$id}");
		} else {
			if (!empty($id))
				$user_jnl->whereRaw("usrj_jnl_id={$id}");
			$user_jnl->whereRaw('usrj_artp_id IS NULL');
		}
		if (!empty($roles))
			$user_jnl->whereRaw("role_id IN ('" . implode("','", $roles) . " ')");
		$user_jnl->groupBy('role_id');
		return $user_jnl->get();
	}

	public static function get_user_with_keyword($search_filters, $role_id, $artp_id, $jnl_id)
	{
		$userkeyword_table = (new \App\Models\Userkeywords)->getTable();
		$keywords_table = (new \App\Models\Keywords)->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$user_jnl = DB::table($table);
		$join = 'JOIN (SELECT ukwd_usr_id, GROUP_CONCAT(ukwd_kwd_id) as ukwd_kwd_ids ,GROUP_CONCAT(kwd_name) AS user_keywords FROM ' .$userkeyword_table . ',' . $keywords_table . ' WHERE ukwd_kwd_id = kwd_id GROUP BY ukwd_usr_id) as tb_user_keyword ON tb_user_keyword.ukwd_usr_id = usrj_usr_id';
		if (isset($search_filters['keyword_operator'.$role_id])) {
			$temp_data = $search_filters['keyword_operator'.$role_id];
			if ($temp_data == 'OR') {
				$where_condition = 'FIND_array_intersect("' . $search_filters['kwd_id'] . '",tb_user_keyword.ukwd_kwd_ids) = 1 ';
			} elseif ($temp_data == 'AND') {
				$where_condition = 'FIND_array_in_all("' . $search_filters['kwd_id'] . '",tb_user_keyword.ukwd_kwd_ids) = 1 ';
			} elseif ($temp_data == 'LIKE') {
				$where_condition = 'tb_user_keyword.user_keywords LIKE "%' . $search_filters['keyword_like'.$role_id] . '%" ';
			}
		} else {
			$where_condition = 'FIND_array_intersect("' . $search_filters['kwd_id'] . '",tb_user_keyword.ukwd_kwd_ids) = 1 ';
		}
		$sql = 'SELECT `usrj_usr_id` FROM ' .$table . ' ' . $join . ' WHERE ' . $where_condition . ' AND usrj_jnl_id = ' . $jnl_id . ' AND usrj_role_id = ' . $role_id . ' AND usrj_artp_id = ' . $artp_id;
		//echo $sql; die;
		$query =User_to_journals::get_records_by_raw_query($sql);
		return $query;
	}

	public static function find_user_in_journal($jnl_id, $user_id, $role,$artp_id,$role_id=NULL)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$Roles = (new \App\Models\Roles)->getTable();
		$sql = "SELECT sum(IF(`usrj_artp_id`IS NULL OR `usrj_artp_id`=0,1,0)) as user_in_jnl,sum(IF(`usrj_artp_id` IS NOT NULL AND `usrj_artp_id`=" . $artp_id . ",1,0)) as user_in_artp FROM " .$table . "," . $Roles . " WHERE `usrj_jnl_id` = " . $jnl_id . " and `usrj_usr_id` = " . $user_id . " and `usrj_role_id` = role_id and role_assigned_role = '" . $role . "'";
		if($role_id !=NULL){
			$sql .= " AND role_id=".$role_id;
		}
		$result = DB::select($sql);
		return $result;
	}

	public static function get_user_jnl_roles($user_id, $jnl_id, $article_type_code = NULL, $role_retired = FALSE)
	{
		$user_to_journal_table = (new \App\Models\User_to_journals())->getTable();
		$Journals_table = (new \App\Models\Journals)->getTable();
		$Article_types_table = (new \App\Models\Article_types)->getTable();

		// $db_handler->select("group_concat(usrj_role_id SEPARATOR ';') role_ids");

		$criteria = '';

		//Added below code block, when called from stage details processing fn (get_article_flow_details), need to check the logged in user has the permitted role for the correspoinding article type.
		if ($article_type_code != NULL) {
			$tables = array(
				'main_table' => $user_to_journal_table,
				'join_table' => array(
					$Journals_table => array($Journals_table . '.jnl_id', $user_to_journal_table . '.usrj_jnl_id'),
					$Article_types_table => array($Article_types_table . '.artp_id', $user_to_journal_table . '.usrj_artp_id')
				)
			);
			$criteria = 'artp_abbr_article_type ="' . $article_type_code . '"';
		} else {
			$tables = array(
				'main_table' => $user_to_journal_table,
				'join_table' => array(
					$Journals_table => array($Journals_table . '.jnl_id', $user_to_journal_table . '.usrj_jnl_id')
				)
			);
			$criteria = 'usrj_artp_id IS NULL';
		}
		$criteria .= ' AND jnl_id ="' . $jnl_id . '" AND usrj_usr_id =' . $user_id;
		if ($role_retired == TRUE) {
			$criteria .= ' AND usrj_role_retired = "n"';
		}

		$query =  User_to_journals::get_results_using_joins($tables, "group_concat(usrj_role_id SEPARATOR ';') role_ids", $criteria);
		return $query;
	}



	/*
	Get user active(without retired roles) roles.
	$user_id,$jnl_id parameters must,
	$article_type_id optional
	*/
	public static function get_active_user_roles($user_id, $jnl_id, $article_type_id = NULL)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();

		$role_table = (new \App\Models\Roles())->getTable();
		//DB::enableQueryLog();
		$sql = DB::table($table)
					->selectRaw(DB::raw("group_concat(role_id SEPARATOR ';') role_ids, group_concat(role_name SEPARATOR ';') role_names, group_concat(role_assigned_role SEPARATOR ';') role_assigned_roles"))
					->join($role_table,'usrj_role_id','=','role_id')
					->where('usrj_role_retired','=','n')
					->where('usrj_jnl_id','=',$jnl_id)
					->where('usrj_usr_id','=',$user_id)
					->where('usrj_artp_id','=',$article_type_id);
			return $sql->get();
			/*
		$sql->get();
		$queries = DB::getQueryLog();
		dd($queries);
		*/
	}
	public static function copy_user_journal($insert_fields, $select_fields, $oldJnlId, $transfer_art = FALSE, $article_type = NULL, $user = NULL, $retire_status = NULL, $only_journal = FALSE)
	{
		$classname = get_called_class();
		$tbl_name = (new $classname)->getTable();
		$role_table = (new \App\Models\Roles())->getTable();
		$column_prefix = (new $classname)::$column_prefix;
		$sql = 'INSERT INTO ' .$tbl_name . ' (' . $insert_fields . ')' .
			' SELECT ' . $select_fields . ' FROM ' . $tbl_name;
		$transfer_condition = '';
                $role_retire_condition = '';
		if ($transfer_art == TRUE)
		{
			$sql .= ', ' . $role_table;
			$transfer_condition = ' and role_id= usrj_role_id and usrj_artp_id=' . $article_type . ' and usrj_usr_id=' . $user . ' and role_assigned_role="author"';
		}
                if($retire_status !== NULL)
                {
                    $role_retire_condition =  ' and '.$column_prefix.'role_retired= "'.$retire_status.'" ';
                }
		$only_journal_str = '';
		if($only_journal == TRUE)
		{
			$only_journal_str = ' and usrj_artp_id is NULL';
		}
		$sql .= ' WHERE ' . $column_prefix . 'jnl_id=' . $oldJnlId .$role_retire_condition. $transfer_condition . $only_journal_str. " GROUP BY usrj_jnl_id,usrj_usr_id,usrj_role_id,usrj_artp_id,usrj_invite,usrj_proxy_id,usrj_operation,usrj_posted_by";
		$result = DB::select($sql);
		if ($result)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}

	public static function get_journal_users($select=NULL, $criteria='', $sort_field='', $sort_order='', $limit=NULL,$authr_filter=NULL,$searchroleflag=false,$serch_array=NULL,$binding_arr = array(),$userNote=FALSE)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$role_table = (new \App\Models\Roles())->getTable();
		$users_table = (new \App\Models\User())->getTable();
		$Article_types_table = (new \App\Models\Article_types())->getTable();
		$Articles_table = (new \App\Models\Articles())->getTable();
		$Journals_table = (new \App\Models\Journals)->getTable();
		$Authors_table = (new \App\Models\Authors)->getTable();
		DB::enableQueryLog();
		$criteria.= 'AND ((`usr_roles` NOT LIKE "%super_admin%" && `usr_roles` NOT LIKE "%sudo%") OR `usr_roles` IS NULL  ) AND usr_status !="u" AND usrj_artp_id iS NULL';
		$userslist = DB::table($table);
		$userslist->selectRaw($select);
		$userslist->join($users_table,'usr_id','=','usrj_usr_id');
	    $userslist->join($role_table,'usrj_role_id','=','role_id');
		$userslist->join($Journals_table,'jnl_id', '=', 'usrj_jnl_id');
		if($searchroleflag==true)
		{
			$condition = ' (select `usrj_usr_id` as usrj_ur_id from '.$table.' where usrj_artp_id IS NULL AND usrj_jnl_id = "'.$serch_array['usrj_jnl_id'].'" and usrj_role_id="'.$serch_array['usrj_role_id'].'" ) as A1';
			$userslist->join(DB::raw($condition),'usrj_usr_id','=','A1.usrj_ur_id');
		}
		// if($userNote == TRUE){
		// 	$userslist->leftjoin('rvw_user_notes','rvw_user_notes.usnote_user_id','usrj_usr_id')
		// 			  ->where('rvw_user_notes.usnote_global','y')
		// 			  ->selectRaw('GROUP_CONCAT(rvw_user_notes.usnote_title SEPARATOR ", ") as usnote_title');
		// }
		//TASK #8006 Type of Authors filter in Users is not functioning.
		if ($authr_filter != NULL) {
			$filterClauses = []; // Store individual filter conditions
			
			// Filter for submitted_author
			if (in_array('submitted_author', $authr_filter)) {
				$filterClauses[] = 'usr_id IN (
					SELECT 
						art_submitted_by 
					FROM ' . $Articles_table . ' 
					INNER JOIN rvw_article_types 
					ON ' . $Articles_table . '.art_artp_id = rvw_article_types.artp_id 
					WHERE art_status != \'n\' 
					AND rvw_article_types.artp_jnl_id = "'.$serch_array['usrj_jnl_id'].'"
				)';
			}
			
			// Filter for co_author
			if (in_array('co_author', $authr_filter)) {
				$filterClauses[] = 'usr_id IN (
					SELECT auth_usr_id 
					FROM ' . $Authors_table . ' 
					INNER JOIN ' . $Articles_table . ' 
					ON auth_art_id = art_id 
					INNER JOIN rvw_article_types 
					ON ' . $Articles_table . '.art_artp_id = rvw_article_types.artp_id 
					WHERE auth_corr_author = \'n\' 
					AND rvw_article_types.artp_jnl_id = "' . $serch_array['usrj_jnl_id'] . '" 
					AND auth_usr_id NOT IN (
						SELECT art_submitted_by 
						FROM ' . $Articles_table . ' 
						WHERE art_submitted_by IS NOT NULL AND art_status != \'n\'
					) 
					AND art_status != \'n\'
				)';
			}
		
			// Filter for not_co_author
			if (in_array('not_co_author', $authr_filter)) {
				$filterClauses[] = 'usr_id NOT IN (
					SELECT auth_usr_id 
					FROM ' . $Authors_table . ' 
					INNER JOIN ' . $Articles_table . ' 
					ON auth_art_id = art_id 
					INNER JOIN rvw_article_types 
					ON ' . $Articles_table . '.art_artp_id = rvw_article_types.artp_id 
					WHERE auth_corr_author = \'n\' 
					AND rvw_article_types.artp_jnl_id = "' . $serch_array['usrj_jnl_id'] . '" 
					AND auth_usr_id NOT IN (
						SELECT art_submitted_by 
						FROM ' . $Articles_table . ' 
						WHERE art_submitted_by IS NOT NULL AND art_status != \'n\'
					) 
					AND art_status != \'n\'
				)';
			}
		
			// Filter for not_submitted_author
			if (in_array('not_submitted_author', $authr_filter)) {
				$filterClauses[] = 'usr_id NOT IN (
					SELECT art_submitted_by 
					FROM ' . $Articles_table . ' 
					INNER JOIN rvw_article_types 
					ON ' . $Articles_table . '.art_artp_id = rvw_article_types.artp_id 
					WHERE art_status != \'n\' 
					AND rvw_article_types.artp_jnl_id = "' . $serch_array['usrj_jnl_id'] . '"
				)';
			}
		
			// Combine all filter clauses with OR
			if (!empty($filterClauses)) {
				$filtrsql = implode(' OR ', $filterClauses);
				$userslist->whereRaw('(' . $filtrsql . ')');
			}
		}
		
		
		    $userslist->groupBy('usrj_jnl_id','usrj_usr_id');
			if(!empty($sort_field) && !empty($sort_order))
			$userslist->orderBy($sort_field, $sort_order);
			$userslist->whereRaw($criteria);
			if(count($binding_arr) > 0) {
				$userslist->setBindings($binding_arr);
			}

			return $userslist->paginate($limit);

	}

	public static function search_user_in_journal($jnl_id, $criteria = array(), $user_id = '')
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$role_table = (new \App\Models\Roles())->getTable();
		$users_table = (new \App\Models\User())->getTable();
		$users_to_journal_table = (new \App\Models\User_to_journals())->getTable();
		$select="usr_id,usr_status,usr_email,GROUP_CONCAT(DISTINCT rvw_roles.role_name) AS user_roles,GROUP_CONCAT(DISTINCT CONCAT(rvw_roles.role_name, ',', usrj_role_retired) SEPARATOR ',') AS role_retire_status";

		//DB::enableQueryLog();
		$where = '';
		$bind_arr = array();
		if (!empty($criteria))
		{
			foreach ($criteria as $key => $val)
			{
				$where .= ' AND '.$key.' LIKE LOWER(?)';
				$bind_arr[] = "%".trim($val)."%";
			}
		}

		$condition= " usrj_jnl_id ={$jnl_id} AND usrj_usr_id!={$user_id} ".$where;

		$userslist = DB::table($users_table)
		    ->selectRaw($select)
			->join($users_to_journal_table,'usr_id','=','usrj_usr_id')
			->join($role_table,'usrj_role_id','=','role_id')
			->groupBy('usrj_usr_id', 'usr_email')
			->whereRaw($condition);

			if(count($bind_arr)>0)
			{
				$userslist->setBindings($bind_arr);
			}
			return $userslist->paginate(10);

	}
	public static function update_retire_user_roles($retire_roles,$criteria,$status)
       {

    $classname = get_called_class();
    $table = (new $classname)->getTable();
    $author=DB::table($table);
    $author->whereIn("usrj_role_id", $retire_roles);
    $author->whereRaw($criteria);
	 $author->update($status);
	return $author->get();

	   }

  public static function get_users_based_role($criteria)
  {

	/*
	TASK #7987 , Users should be restricted from retiring a role if all other accounts with the same role are in inactive or suspended status
	Here join users table for check the condition users status = 'a'
	 */
	$classname = get_called_class();
    $table = (new $classname)->getTable();
	  $user_table = (new \App\Models\User())->getTable();
      $db_handler=DB::table($table);
	  $db_handler->selectRaw('*');
	  $db_handler->join($user_table, 'usrj_usr_id', '=', 'usr_id');
	  $db_handler->whereRaw($criteria);
	  return $db_handler->get()->count();

  }
  public static function get_blind_article_users($jnl_code, $proxy_user,$exclude_user_ids='',$blinded_usr_ids='',$srch_text='')
  {

		DB::enableQueryLog();
		$role_table = (new \App\Models\Roles())->getTable();
		$user_table = (new \App\Models\User())->getTable();
		$journal_table = (new \App\Models\Journals())->getTable();
		$User_to_journals_table = (new \App\Models\User_to_journals())->getTable();
		$db_handler = DB::table($User_to_journals_table);
		$db_handler->selectRaw('usr_id, usr_email, CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as user, group_concat(DISTINCT role_name SEPARATOR \',\')  as roles');
		$db_handler->join($journal_table, 'usrj_jnl_id', '=', 'jnl_id');
		$db_handler->join($user_table, 'usrj_usr_id', '=', 'usr_id');
		$db_handler->join($role_table, 'usrj_role_id', '=', 'role_id');
		$db_handler->where('jnl_journal_code', '=', $jnl_code);
		$db_handler->where('usr_id', '!=', $proxy_user);
		$db_handler->whereRaw('usrj_artp_id IS NULL');
		if($srch_text){
			$db_handler->whereRaw('(`role_name` LIKE  "%' . $srch_text . '%"  or CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) LIKE "%' . $srch_text . '%" )');
		}
		if($blinded_usr_ids){
			$db_handler->whereRaw('usr_id IN (' . $blinded_usr_ids . ')');
		}
		$db_handler->whereRaw('usr_status = "a"');
		if($exclude_user_ids){
			$db_handler->whereRaw('usr_id NOT IN  ( '.$exclude_user_ids.' )');
		}
		$db_handler->groupBy('usr_id');

		$db_handler->distinct();
		$db_handler->groupBy('usr_id');
		return $db_handler->skip(0)->take(25)->get();
		$queries = DB::getQueryLog();

  }
}
