<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Userkeywords extends BaseModel
{
    use HasFactory;
    public $table='rvw_user_keywords';
    public static $tbk_table = 'tbk_user_keywords';
    public static $column_prefix='ukwd_';
    protected $primaryKey = 'ukwd_id';

    public static function get_user_keywords($user_id,$list = FALSE,$hierachy=NULL,$id = NULL, $condition = array()) //if hierarchy = c then id means kwdrl_category_id else kwdrl_jnl_id
	{
        $keyword_table = (new \App\Models\Keywords())->getTable();
		$keyword_relationship_table = (new \App\Models\Keyword_relationship())->getTable();
        $category_table = (new \App\Models\Keyword_category())->getTable();
        $journals_table = (new \App\Models\Journals())->getTable();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $users = DB::table($table);
		if($list == TRUE)
        {
        $users->distinct();
        $users->selectRaw('*,REPLACE(REPLACE(kwd_name,\'&AMP;\',\'&\'),\'&amp;\',\'&\') as kwd_name');
        }
		else
        {
            $users->selectRaw('Group_concat(DISTINCT kwd_name  SEPARATOR ", ") as user_keywords');
        }
		$users->join(DB::raw($keyword_table ), 'ukwd_kwd_id', '=', 'kwd_id');
		$users->join(DB::raw($keyword_relationship_table), 'kwdrl_kwd_id', '=', 'kwd_id');
        if ($hierachy == "c")
		{
            $users->join(DB::raw($category_table), 'kwdrl_category_id', '=', 'kwc_id');
			if($id != NULL)//for avoid duplication
            {
            $users->whereRaw('kwdrl_category_id=' . $id);
            }
				
		}
		else if ($hierachy == "j")
		{
            $users->join(DB::raw($journals_table), 'kwdrl_jnl_id', '=', 'jnl_id');
			if($id != NULL)//for avoid duplication
            {
                $users->whereRaw('kwdrl_jnl_id=' . $id);
                $users->whereRaw("kwd_user_keyword = 'n'");
            }
            /* TASK #9433 inactive keyword is displaying in journal user info keyword section.
            if ($inactiveflag === true) 
            {
                $users->whereRaw("kwdrl_inactive = 'n'");
            }
            end TASK #9433 inactive keyword is displaying in journal user info keyword section.*/
		}
        $users->whereRaw('ukwd_usr_id=' . $user_id);
		
		if (!empty($condition) )
		{
            $users->whereRaw($condition);
		}
        $users->groupBy('kwdrl_kwd_id');
        if($list == TRUE)
            return $users->get();
		else
			return $users->get()->first();
	}
}
