<?php

namespace App\Providers;

use App\Http\Services\ConveyService;
use App\Http\Services\SuperSudoService;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Queue;
use Illuminate\Queue\Events\JobProcessed;
use Illuminate\Queue\Events\JobFailed;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Collection;
use Illuminate\Pagination\LengthAwarePaginator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(ConveyService::class, function ($app) {
            return new ConveyService();
        });
        $this->app->singleton(SuperSudoService::class, function ($app) {
            return new SuperSudoService();
        });
        
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // TaskBot #108 for report generation
        DB::statement("SET SESSION group_concat_max_len = 1000000");
        Queue::after(function (JobProcessed $event) {

        });
        Queue::failing(function (JobFailed $event) {
            
        });

        Collection::macro('paginate', function ($perPage, $page = null, $options = []) {
            $page = $page ?: (\Illuminate\Pagination\Paginator::resolveCurrentPage() ?: 1);
            return new LengthAwarePaginator(
                $this->forPage($page, $perPage)->values(),
                $this->count(),
                $perPage,
                $page,
                [
                    'path' => request()->url(), // Use the current request URL as the base path
                    'query' => request()->query() // Preserve query parameters
                ]
            );
        });

        Collection::macro('paginate', function ($perPage, $page = null, $options = []) {
            $page = $page ?: (\Illuminate\Pagination\Paginator::resolveCurrentPage() ?: 1);
            return new LengthAwarePaginator(
                $this->forPage($page, $perPage)->values(),
                $this->count(),
                $perPage,
                $page,
                [
                    'path' => request()->url(), // Use the current request URL as the base path
                    'query' => request()->query() // Preserve query parameters
                ]
            );
        });
    }
}
