<?php

namespace App\Providers;

use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;
use App\Listeners\QueueWorkerEventListener;
use Illuminate\Queue\Events\JobFailed;
use Illuminate\Queue\Events\JobProcessed;
use Illuminate\Queue\Events\JobProcessing;
use Illuminate\Database\Events\QueryExecuted;
use App\Events\MailQueueFailed;
use App\Listeners\LogQueries;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        JobProcessing::class => [
            QueueWorkerEventListener::class,
        ],
        JobProcessed::class => [
            QueueWorkerEventListener::class,
        ],
        JobFailed::class => [
            QueueWorkerEventListener::class,
        ],
        MailQueueFailed::class => [
            QueueWorkerEventListener::class
        ],
        QueryExecuted::class => [
            LogQueries::class,
        ]
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
