import pandas as pd
import pdfkit
import random
import sys
import os

def create_pdf_table(csv_file, output_dir, pdf_filename):
    # Read CSV
    df = pd.read_csv(csv_file).fillna('').astype(str)

    # Extract footer value (last row, first column)
    footer_value = df.iloc[-1, 0]

    # Remove last row from main table
    df = df.iloc[:-1]

    # Convert dataframe to HTML
    html_table = df.to_html(index=False, border=0, classes='dataframe')

    # CSS styling
    css = """
    <style>
    body {
        font-family: "DejaVu Sans", Arial, sans-serif;
        font-size: 10px;
        margin: 20px;
    }
    table.dataframe {
        border-collapse: collapse;
        width: 100%;
    }
    table.dataframe thead {
        background-color: #007bff;
        color: white;
        font-weight: bold;
    }
    table.dataframe tbody tr:nth-child(even) {
        background-color: #f2f2f2;
    }
    table.dataframe td, table.dataframe th {
        border: 0.5px solid #d0d0d0;
        padding: 4px;
        text-align: left;
        word-wrap: break-word;
    }
    .footer {
        text-align: right;
        font-size: 10px;
        margin-top: 20px;
    }
    </style>
    """

    # Build full HTML
    html_content = f"""
    <html>
    <head>
    <meta charset="UTF-8">
    {css}
    </head>
    <body>
        {html_table}
        <div class="footer">{footer_value}</div>
    </body>
    </html>
    """
    tmp_name = f"{random.randint(1000000, 99999999)}.pdf"
    tmp_filepath = os.path.join(output_dir, tmp_name)

    # Generate PDF
    pdfkit.from_string(html_content, tmp_filepath)

    pdf_filepath = os.path.join(output_dir, pdf_filename)

    os.rename(tmp_filepath, pdf_filepath)

    print(f"PDF successfully generated: {pdf_filename}")

if __name__ == "__main__":
    csv_file = sys.argv[1]
    output_dir = sys.argv[2]
    pdf_filename = sys.argv[3]
    create_pdf_table(csv_file, output_dir, pdf_filename)
