<?php
define("APP_DOC_PATH", "uploads/");
define("ABS_PATH",'storage/uploads/');
use Carbon\Carbon;
use Illuminate\Support\Facades\File;

function convert_dmy_to_ymd($strdate,$current_date_format)
{

$current_date_format="y-m-d";

	/* replacing '/' and '-' to get d,m,y positions */
	$tmp_date_format = str_replace(array(
		'-',
		'-'), '', $current_date_format);
	$tmp_date_format = strtolower($tmp_date_format);

	$d = strpos($tmp_date_format, "d");
	$m = strpos($tmp_date_format, "m");
	$y = strpos($tmp_date_format, "y");


	//$strdate = str_replace("/", "-", $strdate);

	//split by hyphen character
	$date_parts = explode("-", $strdate);

	// if 3 elements not found, then invalid date
	if (count($date_parts) != 3)
		return FALSE;

        return date("Y-m-d", mktime(0, 0, 0, $date_parts[$m], $date_parts[$d], $date_parts[$y]));
}
/* Custom function for json Encode when value is Null */

function custom_json_encode($data_array)
{
array_walk_recursive($data_array,function(&$item){$item=strval($item);});
return $data_array;
}

function platform_date_format()
{
$format_date=array(
"d-m-y" => "dd-MM-yy",
"m-d-y" => "MM-dd-yy",
"y-m-d" => "yy-MM-dd",
"d-m-Y" => "dd-MM-yyyy",
"m-d-Y" => "MM-dd-yyyy",
"Y-m-d" => "yyyy-MM-dd");
return $format_date;
}

 function date_format_map($dt_fmt)
{
	$db_date_format = array(
		'd-m-y' => '%d-%m-%y',
		'm-d-y' => '%m-%d-%y',
		'y-m-d' => '%y-%m-%d',
		'd-m-Y' => '%d-%m-%Y',
		'm-d-Y' => '%m-%d-%Y',
		'Y-m-d' => '%Y-%m-%d');
	$format = '';
	if(isset($db_date_format[$dt_fmt]))
	{
		$format = $db_date_format[$dt_fmt];
	}
	return $format;
}
function sort_items()
{
	$sortlist=array(
		'article_sort'  => array(
									"Article ID"      => "art_code",
									"Article Type"    => "artp_article_type" ,
									"Article Title"   => "art_title" ,
									"Submission Date" => "art_submission_date",
									"Date received in stage"   => "aflw_assigned_date",
									"Due Date"        => "aflw_due_date",
									"Decision Date"   => "art_decision_date"
								   ),
		'abstract_sort'  => array(
									"Abstract ID"      => "art_code",
									"Event"    => "artp_article_type" ,
									"Abstract title"   => "art_title" ,
									"Submission date" => "art_submission_date",
									"Date received in stage"   => "aflw_assigned_date",
									"Due date"        => "aflw_due_date",
									"Decision date"   => "art_decision_date"
								   ),
		'user_sort'	    =>  array(
							"First Name"      => "usr_first_name",
							"Email"		   => "usr_email"
							 )
);
return $sortlist;
}
function taskstatus()
{
	$status_array=array(0=>'All Tasks',1=>'My Tasks');
	return $status_array;
}
function helperData($select)
{
	switch($select)
	{
		case 'APP_DOC_PATH':
			$return =[
				'PATH' => 'uploads/',
			];
			break;
			case 'FCPATH':
			$return =[
				'FCPATH'=>'var/www/html/'

			];
			break;
			case 'APPPATH':
				$return =[
					'APPPATH'=>'application'

				];
			break;



	}
	return $return;
}
function timelineevents()
{
	$events_array=array(
		"all"=>"All events",
		"short_assign"=>"Shortlist / Assignment",
		"invite"=>"Invitations",
		"email"=>"Emails",
		"flag"=>"Flags",
		"note"=>"Notes",
		"generic_discussion"=>"Discussions"
	);
	return $events_array;

}
function emailevents(){
	$events_list=array(
    "all"=>"All",
	"system"=>"Reminders",
	"active"=>"Stage emails",
	"adhoc"=>"Ad-hoc emails",
	"discussion"=>"Discussion emails"
	);
	return $events_list;
}
function convert_to_user_id_array(&$item, $key)
{
	if (is_object($item))
		$item = $item->usr_id;
}

 function protect_email($email = NULL,$privileged_user = FALSE)
{
	if($email != NULL && $privileged_user == FALSE)
	{
		$temp_mail = explode('.',$email);
		$temp_domin = explode('@',$email);
		$first_part = substr($email,0,2);
		$second_part = substr($temp_domin[1],0,1);
		$process_mail = $first_part.'******@'.$second_part.'**.'.end($temp_mail);
	}
	elseif($privileged_user == TRUE)
		$process_mail = $email;
	else
		$process_mail = '--';
	return $process_mail;
}
 function protect_phoneno($phone = NULL,$privileged_user = FALSE)
{
	if($phone != NULL)
	{
		$process_phone = '******'. substr($phone, -3);
	}
	elseif($privileged_user == TRUE)
		$process_phone = $phone;
	else
		$process_phone = '--';
	return $process_phone;
}
function article_invitation_status()
{
	return array(
		"u" => array(
			'title' =>"Not invited",
			'class' =>""),
		"i" => array(
			'title' =>"Invited",
			'class' =>"text-orange"),
		"a" => array(
			'title' =>"in progress",
			'class' =>""),
		"d" => array(
			'title' =>"Declined",
			'class' =>"text-red"),
		"c" => array(
			'title' =>"completed",
			'class' =>""),
	);
}

function encrypt_link($value)
{

	$encrypt_val = base64_encode($value);
	return $encrypt_val;
}

/*
 * To decrypt URL query
 */

function decrypt_link($value)
{
    $decrypt_val = base64_decode($value);
        return $decrypt_val;
}

function overview_productionroles()
{
	return array('production_manager','tsp');
}
function invitation_status()
{
	return array(
		"u" => "Invite",
		"r" => "Re-invite", //show "Invite" for invitation allowed users, else - Unvited
		"i" => "Invited",//Invited
		"a" => "Confirmed",
		"c" => "Submitted",
		"d" => "Declined",
		"n" => "Not Active",
		"w" => "Waiting Confirmation",
		"g" => "Unassigned",
		"y" => "Re-opened"
	);
}
function user_status()
{
	return array(
		"a" => "Active",
		"w" => "Awaiting", //show "Invite" for invitation allowed users, else - Unvited
		"s" => "Suspended",//Invited
		"n" => "Inactive",
	);
}

/*
 * Function to get status code of different review status
 * $key - holds the filter value which specifies 'key_only' to get all common statuses and status value to get the child array of status codes.
 */
function review_status($key = NULL, $legac_data = false)
{
	$review_status_arr = array(
		'Shortlisted' => array(
			'legacy' => array(),
			'live' => array('u')
			),
		'Invited' => array(
			'legacy' => array('nr','ua'),
			'live' => array('i')
			),
		'Agreed/Assigned' => array(
			'legacy' => array('ra','ag'),
			'live' => array('a')
			),
		'Declined' => array(
			'legacy' => array('dc','dn','do','ad'),
			'live' => array('d')
			),
		'Completed' => array(
			'legacy' => array('ac','cm'),
			'live' => array('c')
			),
		'Unassigned' => array(
			'legacy' => array(),
			'live' => array('g')
			),
	);
	$status_arr = NULL;
	switch ($key)
	{
		case NULL: $status_arr = $review_status_arr;
			break;
		case 'key_only': $status_arr = array_keys($review_status_arr);
			break;
		default :
			if(isset($review_status_arr[$key]))
			{
				$temp_status_arr = $review_status_arr[$key];
				if($legac_data == TRUE)
				{
					$status_arr = array_unique(array_merge($temp_status_arr['live'],$temp_status_arr['legacy']));
				}
				else
				{
					$status_arr = $temp_status_arr['live'];
				}
			}
			else
			{
				$status_arr = NULL;
			}
			break;
	}
	return $status_arr;
}
function main_production_roles()
{
    return array('production_manager','tsp','journal_admin');
}
/* Encrypt And Decrypt  */
 function Rv_encrypt($text) {
	$password=Config::get('general_config.rv_password_crypt');
	// move text to base64
	$base64 = base64_encode( $text );

	// text string to array
	$arr = str_split($base64);

	// arr of password
	$arrPass = str_split($password);
	$lastPassLetter = 0;

	// encrypted string
	$encrypted = '';

	// encrypt
	for ($i=0; $i < sizeof( $arr ); $i++) {

		$letter = $arr[ $i ];

		$passwordLetter = $arrPass[ $lastPassLetter ];

		$temp = getLetterFromAlphabetForLetter(
			$passwordLetter, $letter );

		if ($temp != null) {
			// concat to the final response encrypted string
			$encrypted .= $temp;
		} else {
			// if any error, return null
			return null;
		}

		/*
			This is important: if we're out of letters in our
			password, we need to start from the begining.
		*/
		if ($lastPassLetter == ( sizeof( $arrPass ) - 1) ) {
			$lastPassLetter = 0;
		} else {
			$lastPassLetter ++;
		}
	}

	// We finally return the encrypted string
	return $encrypted;
}


function getLetterFromAlphabetForLetter( $letter, $letterToChange) {

	// this is the alphabet we know, plus numbers and the = sign
	$abc = 'abcdefghijklmnopqrstuvwxyz0123456789=ABCDEFGHIJKLMNOPQRSTUVWXYZ';

	// get the position of the given letter, according to our abc
	$posLetter = strpos( $abc, $letter );

	// if we cannot get it, then we can't continue
	if ($posLetter === false) {
	   // echo 'Password letter ' . $letter . ' not allowed.';
		return null;
	}

	// according to our abc, get the position of the letter to encrypt
	$posLetterToChange = strpos( $abc, $letterToChange );

	// again, if any error, we cannot continue...
	if ($posLetterToChange === false) {
		//echo 'Password letter ' . letter . ' not allowed.';
		return null;
	}

	// let's build the new abc. this is the important part
	$part1 = substr( $abc, $posLetter, strlen( $abc ) );
	$part2 = substr( $abc, 0, $posLetter);
	$newABC = '' . $part1 . '' . $part2;

	// we get the encrypted letter
	$temp = str_split($newABC);
	$letterAccordingToAbc = $temp[$posLetterToChange];

	// and return to the routine...
	return $letterAccordingToAbc;
}

 function Rv_decrypt($text) {
	$password=Config::get('general_config.rv_password_crypt');

	// convert the string to decrypt into an array
	 $arr = str_split($text);

	// let's also create an array from our password
	$arrPass = str_split($password);

	// keep control about which letter from the password we use
	 $lastPassLetter = 0;

	// this is the final decrypted string
	$decrypted = '';

	// let's start...
	for ($i=0; $i < count($arr); $i++) {

		// next letter from the string to decrypt
		$letter = $arr[$i];

		// get the next letter from the password
		$passwordLetter = $arrPass[$lastPassLetter];

		// get the decrypted letter according to the password
		$temp = getInvertedLetterFromAlphabetForLetter( $passwordLetter, $letter );

		if ($temp!=null) {
			// concat the response
			$decrypted .= $temp;
		} else {
			// if any error, return null
			return null;
		}

		// if our password is too short, let's start again from the first letter
		if ($lastPassLetter == (count($arrPass) - 1) ) {
			$lastPassLetter = 0;
		} else {
			$lastPassLetter ++;
		}
	}

	// return the decrypted string and converted from base64 to plain text
	return base64_decode( $decrypted );
}


function getInvertedLetterFromAlphabetForLetter($letter, $letterToChange) {

	$abc = 'abcdefghijklmnopqrstuvwxyz0123456789=ABCDEFGHIJKLMNOPQRSTUVWXYZ';
	$posLetter =strpos( $abc, $letter );

	if ($posLetter === false) {
	   // console.log('Password letter ' + letter + ' not allowed.');
		return null;
	}

	$part1 =substr($abc,$posLetter,strlen($abc));

	$part2 =substr($abc,0,$posLetter);

	$newABC = '' . $part1 . '' . $part2;

	$posLetterToChange=strpos($newABC, $letterToChange);

   //$posLetterToChange = $newABC.indexOf( $letterToChange );

	if ($posLetterToChange === false) {

		return null;
	}
	$temp = str_split($abc);

	$letterAccordingToAbc = $temp[$posLetterToChange];

	return $letterAccordingToAbc;
}

function get_due_date($days , $excluded_weekends = null, array $exluded_special_dates = []){
    $due_date = Carbon::now();
    $start_date = Carbon::now();
    if($excluded_weekends){
        $excluded_weekends = is_array($excluded_weekends) && count($excluded_weekends) > 0? $excluded_weekends : [0,6];
        $due_date = addWeekdays($due_date, $days, $excluded_weekends);
    }else{
        $due_date = $due_date->addDays($days);
    }
    foreach($exluded_special_dates as $ex_date){
            if(Carbon::parse($ex_date)->betweenIncluded($start_date, $due_date)){
                if($excluded_weekends){
                    $due_date = addWeekdays($due_date, 1, $excluded_weekends);
                }else{
                    $due_date = $due_date->addDay();
                }
            }
    }
    return $due_date;
}

function addWeekdays(Carbon $due_date, int $days = 1, array $weekends = []) : Carbon
{
	$count = 0;
	while ($count < $days) {
		$due_date->addDay();
		if (!in_array($due_date->dayOfWeek, $weekends)) {
			$count++;
		}
	}
	return $due_date;
}

function local_storage_details()
{
    $local_storage = array(
    "RV_DATA_A" => "Orcid integration data",
    "RV_DATA_B" => "modulestatus",
    "RV_DATA_C" => "clientfunctionalities",
    "RV_DATA_D" => "token",
    "RV_DATA_E" => "temp_logged_userroles_journal",
    "RV_DATA_F" => "loggedplatformuserdata_journal",
    "RV_DATA_G" => "current_journal",
    "RV_DATA_H" => "platformdata_journal",
    "RV_DATA_I" => "loggedplatformrole_journal",
    "RV_DATA_J" => "platformurlarray_journal",
    "RV_DATA_K" => "RVuser",
    "RV_DATA_L" => "RVcode",
    "RV_DATA_M" => "logged_as_proxy_url_journal",
    "RV_DATA_N" => "logged_as_journal",
    "RV_DATA_O" => "jnlactivetab",
    "RV_DATA_P" => "artactivetab",
    "RV_DATA_Q" => "lastusedurl",
    "RV_DATA_R" => "tabCommunicationChannel",
    "RV_DATA_S" => "loggedtempplatformrole_journal",
    "RV_DATA_T" => "redirect_url_journal",
    "RV_DATA_U" => "changedefaultplatformroleintoauthor",
    "RV_DATA_V" => "loginbyexternallink",
    "RV_DATA_W" => "permission_denied",
    "RV_DATA_X" => "single_journal_user",
    "RV_DATA_Y" => "sessionstarts",
    "RV_DATA_Z" => "insist_view_article",
    "RV_DATA_AA" => "TC and gender race ethnicity ",
	"RV_DATA_AB" => "first login status flag",
	"RV_DATA_AC" => "login with proxy password status",
	"RV_DATA_AD" => "terms and gender status",
	"RV_DATA_AE" => "Classification selection mode",
	"RV_DATA_AF" => "user role in dashboard",
	"RV_DATA_AG" => "live_socket_data",
	"RV_DATA_AH" => "es integration rv rite url",
	"RV_DATA_AI" => "Alert for insist_view_article",
	"RV_DATA_AJ" => "path of previous page for insist_view_article",
	"RV_DATA_AK" => "Classification required",
	"RV_DATA_AL" => "es integration cookie id",
	"RV_DATA_AM" => "For Maintenance running text",
	"RV_DATA_AN" => "es integration browser id",
	"RV_DATA_AO" => "ORCID Client function status for user list",
	"RV_DATA_AP" => "View article status blind link user role status",
	"RV_DATA_AQ" => " Adhoc current template id",
	"RV_DATA_AR" => "use only for keeping reply mails attachment files id in array",
	"RV_DATA_AS" => "Adhoc template basicArray",
	"RV_DATA_AT" => "While clicking the 'View Article' submit button, the validation status of the forms will be checked, and if there are no errors, the forms will be submitted.",
	);
}

function customTrans($key, $replace = []){
    $replacements = Config('langSubstitution.API')[env('PLATFORMTYPE')];
    $txt = __($key, array_merge($replacements,$replace));

    return $txt;
}

if (! function_exists('array_merge_recursive_distinct')) {
    /**
     * @param array<int|string, mixed> $array1
     * @param array<int|string, mixed> $array2
     *
     * @return array<int|string, mixed>
     */
    function array_merge_recursive_distinct(array &$array1, array &$array2): array
    {
        $merged = $array1;
        foreach ($array2 as $key => &$value) {
            if (is_array($value) && isset($merged[$key]) && is_array($merged[$key])) {
                $merged[$key] = array_merge_recursive_distinct($merged[$key], $value);
            } else {
                $merged[$key] = $value;
            }
        }

        return $merged;
    }
}

function get_ui_locale_json($client_code = 'default'){
    $common_path = base_path('resources/js/components/locales/default/journal/en');
    $client_specific_file = base_path('resources/js/components/locales/client/journal/en/client_locale.json');
    $mergedData = [];

    $files = scandir($common_path);
    foreach ($files as $file) {
        if (pathinfo($file, PATHINFO_EXTENSION) === 'json') {
            if($file == 'translation.json' || $file == 'sudo.json') continue;

            $jsonData = json_decode(file_get_contents($common_path . '/' . $file), true);

            $mergedData = array_merge($mergedData, $jsonData);
        }
    }

    $ClientjsonData = json_decode(file_get_contents($client_specific_file), true);

    $specific_client_data = $ClientjsonData[$client_code];
    $result = json_encode(array_merge_recursive_distinct($mergedData, $specific_client_data));

    return $result;
}

function getColumnsWithDefault($model, $array_for_updation, $operation){
	$prefix = ('App\\Models\\'.$model)::$column_prefix;
	$default = [$prefix."posted_date" => date('Y-m-d H:i:s'), $prefix."posted_by" => session('user_id') ?? 0, $prefix."proxy_id" => session('proxy_user_id') ?? 0, $prefix.'operation' => $operation];
	return array_merge($default, $array_for_updation);
}

/*
*recurse delete
*   Except $dir full path
*	Default value of $del_parent_folder is true and delete parent folder itself, if not required 
*	then send it as FALSE
*/
function delfolder($dir,$del_parent_folder = TRUE)
{
	if (is_dir($dir)) {
		$objects = scandir($dir);
		foreach ($objects as $object) {
			if ($object != "." && $object != "..") {
				if (is_dir($dir . "/" . $object))
					delfolder($dir . "/" . $object);
				else
					unlink($dir . "/" . $object);
			}
		}
		if($del_parent_folder == TRUE)
			rmdir($dir);
	}
}

/**
 * Recursively traverses all values of a multi-level nested array.
 *
 * @param array $array The nested array to traverse.
 * @param callable|null $callback A callback function to process each value (optional).
 */
function traverseNestedArray(array &$array, callable $callback)
{
    foreach ($array as $key => &$value) {
        if (is_array($value)) {
            traverseNestedArray($value, $callback);
        } else {
            $callback($key, $value, $array);
        }
    }
	return $array;
}
/*
*Permitted User Dropdown
*   Permitted User dropdown implemention for global email template
*	Based on adding key and value in $permittedUserArr will give dropdown.
*	Key represents etmp_notification and value represents column name of journal permission table.
*/
function permittedUserGlobalMail($key,$note = false)
{
	$arr = array(
		'status'=> false
	);
	$permittedUserArr = array(
		'prevent_edit_request_access' => 'jp_prevent_edit' 
	);
	if(isset($permittedUserArr[$key])){
		$arr = [
			'status' => true,
			'label' => 'Permitted role users',
			'value' => $permittedUserArr[$key]
		];

		if($note){
			$noteArr = array(
				'prevent_edit_request_access' => customTrans('viewarticle.prevent_edit_global_val')
			);
			$str =customTrans('viewarticle.prevent_edit_global_note');
            $str = str_replace('##NOTE##', isset($noteArr[$key])?$noteArr[$key]:"",$str);
			$arr['note'] = $str;
		}
	}
return $arr;
}


function getArraySymmetricalDifference($array1, $array2) {
    $diff1 = array_diff($array1, $array2);
    $diff2 = array_diff($array2, $array1);

    return array_merge($diff1, $diff2);
}

 function get_client_enviornment()
{
   return array('t'=>'Lts','s'=>'Staging','l'=>'Live','o'=>'Other');
}

function string_date_format($date_string,$format)
{
    try
    {
         $formated_date =  Carbon::createFromFormat(
				'Y-m-d\TH:i:s.v\Z',
				$date_string,
				'UTC'
			)->format($format);
			
            return $formated_date;

    } catch (Exception $e)
    {
        return false;
    }
}
/**
 * Merge arrays by a specified key
 *
 * @param array $arrays Array of arrays to merge
 * @param string $key Key to merge by
 * @return array Merged result
 */
function singlePassMergeByKey(array $inputRows, string $mergeKey = 'usr_id'): array
{
    $result = [];

    foreach ($inputRows as $rowGroup) {
        foreach ($rowGroup as $item) {
			if(is_array($item)){
            	$id = (string) $item[$mergeKey];
			}else{
            	$id = (string) $item->$mergeKey;
			}

            if (!isset($result[$id])) {
                $result[$id] = [$mergeKey => $id];
            }

            foreach ($item as $k => $v) {
                if ($k !== $mergeKey) {
                    $result[$id][$k] = $result[$id][$k] ?? $v ?? null;
                }
            }
        }
    }

    return $result;
}
function generateCSV($id, $out_dir, $data)
{
	// $data = $data->map(function($obj) { $obj; unset($obj->custom_art_id, $obj->custom_artp_id); return (array)$obj;})->all();
	// $path = storage_path("/app/public/tempdata");
	if (!File::exists($out_dir)) {
		File::makeDirectory($out_dir, 0777, true);
	}
    $csvFilePath = $out_dir."tempdata$id.csv";
    $handle = fopen($csvFilePath, 'w');
    // fputcsv($handle, array_keys((array)$data[0]));

    foreach ($data['templated_report_data'] as $row) {
        fputcsv($handle, (array)$row);
    }
	$total_data = array();
	$i=0;
	if(isset($data['templated_total_count']) && !empty($data['templated_total_count'])){
		fputcsv($handle, array());
		foreach ($data['templated_total_count'] as $each_key => $each_value) {
			$total_data[$i][] = $each_key;
			$total_data[$i][] = $each_value;  
			fputcsv($handle, $total_data[$i]);
			$i++;
		}
	}
	if(isset($data['templated_footer_content']) && !empty($data['templated_footer_content'])){
		fputcsv($handle, $data['templated_footer_content']);
	}
    fclose($handle);

    return $csvFilePath;
}
?>
