<?php

use App\Models\User;
use App\Models\Flags;
use App\Models\Roles;
use App\Models\Terms;
use App\Models\Issues;
use App\Models\Authors;
use App\Models\Country;
use App\Models\Articles;
use App\Models\Journals;
use App\Models\Keywords;
use App\Models\Copyright;
use App\Models\Article_flag;
use App\Models\Article_flow;
use App\Models\Article_types;
use App\Models\Generic_flows;
use App\Models\Payment_order;
use App\Models\Classifications;
use App\Models\Article_keywords;
use App\Models\Copyright_master;
use App\Models\User_affiliations;
use App\Models\Article_export_data;
use App\Models\Article_classification;

$users = (new User)->getTable();
$flags = (new Flags)->getTable();
$roles = (new Roles())->getTable();
$terms = (new Terms())->getTable();
$issues = (new Issues())->getTable();
$journals = (new Journals)->getTable();
$articles = (new Articles)->getTable();
$country = (new Country())->getTable();
$keywords = (new Keywords())->getTable();
$articles = (new Articles())->getTable();
$copyright = (new Copyright())->getTable();
$article_authors = (new Authors)->getTable();
$article_flag = (new Article_flag)->getTable();
$article_flow = (new Article_flow)->getTable();
$article_types = (new Article_types)->getTable();
$payment_order = (new Payment_order())->getTable();
$journal_workflows = (new Generic_flows)->getTable();
$classifications = (new Classifications())->getTable();
$article_keywords = (new Article_keywords())->getTable();
$copyright_master = (new Copyright_master())->getTable();
$user_affiliation = (new User_affiliations())->getTable();
$article_export_data = (new Article_export_data)->getTable();
$article_classification = (new Article_classification())->getTable();

return [
    'article' => [
        'journal_and_article_types' => [
            'journal_category' => [
                'label' => ':Journal category',
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=', 'article_types.artp_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['journals.jnl_journal_type', 'LIKE', '%?%']],
                        [['journals.jnl_journal_type', 'NOT LIKE', '%?%']]
                    ],
                    'options' => [
                        [
                            'query' => "select jnl_journal_type as value, jnl_journal_type as label from $journals where jnl_journal_name like ? ",
                            'options_from' => ['model' => 'Journals', 'columns' => ['jnl_journal_type as value', 'jnl_journal_type as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'
            ],
            'journal' => [
                'label' => ':Journal name',
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=',  'article_types.artp_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['journals.jnl_id', '=', '?']],
                        [['journals.jnl_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select jnl_id as value, jnl_journal_name as label from $journals where jnl_journal_name like ? ",
                            'options_from' => ['model' => 'Journals', 'columns' => ['jnl_id as value', 'jnl_journal_name as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'
            ],
            'article_type' => [
                'label' => 'Submitted :article type',
                'tables' => [],
                'independant' => true,
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["$articles.art_artp_id", '=', '?']],
                        [["$articles.art_artp_id", '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select artp_id as value, artp_article_type as label, jnl_journal_name as parent from $article_types inner join $journals on artp_jnl_id = jnl_id ",
                            'options_from' => ['model' => 'Article_types', 'columns' => ['artp_id as value', 'artp_article_type as label']],
                            'search_value' => false,
                            'component' => "select_box",
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'
            ],
            'published_article_type' => [
                'label' => 'Published :article type',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["$articles.art_published_article_type", '=', '?']],
                        [["$articles.art_published_article_type", '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select artp_id as value, artp_article_type as label, jnl_journal_name as parent from $article_types inner join $journals on artp_jnl_id = jnl_id ",
                            'options_from' => ['model' => 'Article_types', 'columns' => ['artp_id as value', 'artp_article_type as label']],
                            'search_value' => false,
                            'component' => "select_box",
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'
            ],
            'submitted_published_article_type' => [
                'label' => 'Submitted and published :article types',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Are same',
                            'value' => 0
                        ],
                        [
                            'label' => 'Are different',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["$articles.art_artp_id", '=', "$articles.art_published_article_type"]],
                        [["$articles.art_artp_id", '!=', "$articles.art_published_article_type"]]
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'
            ],
            'is_standalone' => [
                'label' => 'Is standalone :journal',
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=',  'article_types.artp_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['journals.jnl_standalone', '=', 'y']],
                        [['journals.jnl_standalone', '=', 'n']]
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'
            ],
            'is_archieved' => [
                'label' => 'Is archieved :journal',
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=',  'article_types.artp_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['journals.jnl_journal_status', '=', 'n']],
                        [['journals.jnl_journal_status', '=', 'y']]
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'

            ],
        ],
        'article' => [
            'article_id' => [
                'label' => ':Article ID',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' => "condition_params",      //to refer condition_params from 'report_generation.php'
                    'fixed_value' => [
                        'type' => 'string',      //referer for condition_params['type']['string'] from 'report_generation.php'
                        'col' => "$articles.art_code"
                    ],
                    'options' => [
                        [
                            'component' => "text"
                        ]
                    ],
                ],
                'parent' => ':article'
            ],
            'art_pre_all_ids' => [
                'label' => 'Original ID of paper (if resubmitted)',
                'tables' => [
                    [
                        'name' => "$articles as art_cp",
                        'join' => '',
                        'on' => ["$articles.art_id", '=', "SUBSTRING_INDEX(art_cp.art_pre_all_ids, ',', 1)"]
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' => "condition_params",      //to refer condition_params from 'report_generation.php'
                    'fixed_value' => [
                        'type' => 'string',      //referer for condition_params['type']['string'] from 'report_generation.php'
                        'col' => 'art_cp.art_code'
                    ],
                    'options' => [
                        [
                            'component' => "text"
                        ]
                    ],
                ],
                'parent' => ':article'
            ],
            'article_title' => [
                'label' => ':Article title',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' => "condition_params",      //to refer condition_params from 'report_generation.php'
                    'fixed_value' => [
                        'type' => 'string',      //referer for condition_params['type']['string'] from 'report_generation.php'
                        'col' => "$articles.art_title"
                    ],
                    'options' => [
                        [
                            'component' => "text"
                        ]
                    ],
                ],
                'parent' => ':article'
            ],
            'article_status' => [
                'label' => ':Article status',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Can be',
                            'value' => 0,
                        ],
                        [
                            'label' => 'Cannot be',
                            'value' => 1
                        ],
                    ],
                    'fixed_value' => [
                        [["(CASE WHEN '?' LIKE 'ta' THEN ($articles.art_status = 't' AND $articles.art_delete_status = 'n' AND $articles.art_transfer_article = 'n') WHEN '?' LIKE 'd' THEN $articles.art_delete_status = 'y' WHEN '?' LIKE 't' THEN $articles.art_transfer_status = 'y' WHEN '?' IN ('a', 'r', 'y', 'n', 'c') THEN ($articles.art_status = '?' AND $articles.art_delete_status = 'n') WHEN '?' IN ('h', 'w') THEN $articles.art_delete_status = '?' END)", '', 'raw_cdtn']],
                        [["(CASE WHEN '?' LIKE 'ta' THEN ($articles.art_status != 't' AND $articles.art_delete_status = 'n' AND $articles.art_transfer_article = 'n') WHEN '?' LIKE 'd' THEN $articles.art_delete_status != 'y' WHEN '?' LIKE 't' THEN $articles.art_transfer_status != 'y' WHEN '?' IN ('a', 'r', 'y', 'n', 'c') THEN ($articles.art_status != '?' AND $articles.art_delete_status = 'n') WHEN '?' IN ('h', 'w') THEN $articles.art_delete_status != '?' END)", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'custom_opt' => [
                                ['label' => 'Deleted', 'value' => 'd'],
                                ['label' => 'Withdrawn', 'value' => 'w'],
                                ['label' => 'On hold', 'value' => 'h'],
                                ['label' => 'Transfer in progress', 'value' => 'ta'],  
                                ['label' => 'Transferred', 'value' => 't'],
                                ['label' => 'Submission in progress', 'value' => 'n'],
                                ['label' => 'Accepted', 'value' => 'a'],
                                ['label' => 'Rejected', 'value' => 'r'],
                                ['label' => 'Submitted', 'value' => 'y'],
                                ['label' => 'Closed', 'value' => 'c'],
                            ],
                            'search_value' => false,
                            'component' => 'select_box',
                        ]
                    ],
                ],
                'parent' => ':article'
            ],
            'flag' => [
                'label' => 'Article flags',
                'tables' => [
                    [
                        'name' => 'article_flags',
                        'join' => 'LEFT',
                        'on' => ["$articles.art_id", '=', 'article_flags.aflg_art_id']
                    ],
                    [
                        'name' => 'flags',
                        'join' => '',
                        'on' => ['article_flags.aflg_flag_id', '=', 'flags.flag_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'contains',
                            'value' => 0
                        ],
                        [
                            'label' => 'does not contains',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['flags.flag_id', '=', '?']],
                        [['flags.flag_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select distinct flag_id as value,flag_name as label from $flags where flag_name like ? AND flag_type IN ('a','g') AND flag_status != 'n'",
                            'options_from' => ['model' => 'Flags', 'columns' => ['flag_id as value', 'flag_name as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => ':article'
            ],
            'article_keyword' => [
                'label' => ':Article keywords',
                'tables' => [
                    [
                        'name' => 'article_keywords',
                        'join' => '',
                        'on' => ["$articles.art_id", '=', 'article_keywords.ak_art_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['article_keywords.ak_keyword_id', 'IN', '?']],
                        [['article_keywords.ak_keyword_id', 'NOT IN', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select kwd_id as value,kwd_name as label from $keywords where kwd_name like ? and kwd_user_keyword = 'n'",
                            'options_from' => ['model' => 'Keywords', 'columns' => ['kwd_id as value', 'kwd_name as label']],
                            'search_value' => true,
                            'component' => "multi_box",
                            'enable_search' => true
                        ]
                    ],
                ],
                'parent' => ':article'
            ],
            'article_classification' => [
                'label' => ':Article classifications',
                'tables' => [],
                'addl_required_table' => [
                    'art_term_table'
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can have',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t have',
                            'value' => 1
                        ],
                    ],
                    'fixed_value' => [
                        [["$articles.art_id IN (select cls_art_id from art_term_table where cls_term_id = ?)", "", "raw_cdtn"]],
                        [["$articles.art_id NOT IN (select cls_art_id from art_term_table where cls_term_id = ?)", "", "raw_cdtn"]]
                    ],
                    'options' => [
                        [
                            'query' => "select term_id as value,term_name as label from $terms where term_name like ? ",
                            'options_from' => ['model' => 'Terms', 'columns' => ['term_id as value', "term_name as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                        ],
                    ],
                ],
                'parent' => ':article'
            ],
            'issue' => [
                'label' => 'Issue (Volume)',
                'tables' => [
                    [
                        'name' => 'article_issue',
                        'join' => 'LEFT',
                        'on' => ['article_issue.issue_art_id', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['article_issue.iss_id', '=', '?']],
                        [['article_issue.iss_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "SELECT iss_title AS label,iss_id as value  FROM $issues",
                            'options_from' => ['model' => 'Issues', 'columns' => ['iss_id as value', 'iss_title as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => ':article'
            ],
            'biorxiv' => [
                'label' => 'bioRxiv',
                'tables' => [],
                'client_functionality' => 'cfty_biorxiv',
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'B2J',
                            'value' => 0
                        ],
                        [
                            'label' => 'J2B',
                            'value' => 1
                        ],
                        [
                            'label' => 'None',
                            'value' => 3
                        ]
                    ],
                    'fixed_value' => [
                        [["$articles.art_biorxiv", 'is not', null], ["$articles.art_biorxiv", '=', 'y']],
                        [["$articles.art_biorxiv", 'is not', null], ["$articles.art_biorxiv", '=', 'b']],
                        [["$articles.art_biorxiv", 'is', null], ["$articles.art_biorxiv", '=', 'n']]
                    ],
                    'options' => [
                        [
                            'component' => null
                        ]
                    ]
                ],
                'parent' => ':article'
            ],
            'resub_paper' => [
                'label' => 'Is resubmitted paper',
                'tables' => [],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["$articles.art_prev_article_id", 'is not', null]],
                        [["$articles.art_prev_article_id", 'is', null]]
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ]
                ],
                'parent' => ':article'
            ],
            'is_revised' => [
                'label' => 'Is revised paper',
                'tables' => [],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["$articles.art_prev_article_id", 'is not', null], ["$articles.art_transfer_article", '=', 'n']],
                        [["$articles.art_prev_article_id", 'is', null], ["$articles.art_transfer_article", '!=', 'n']]
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ]
                ],
                'parent' => ':article'
            ],
            'is_transfered' => [
                'label' => 'Is transfered paper',
                'tables' => [],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["$articles.art_prev_article_id", 'is not', null], ["$articles.art_transfer_article", '=', 'y']],
                        [["$articles.art_transfer_article", '<>', 'y']]
                    ],
                    'options' => [
                        [
                            'component' => null
                        ]
                    ]
                ],
                'parent' => ':article'
            ],
            'is_deleted' => [
                'label' => 'Is deleted paper',
                'tables' => [],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'No',
                            'value' => 0
                        ],
                        [
                            'label' => 'Yes',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["$articles.art_delete_status", '<>', 'y']],
                        [["$articles.art_delete_status", '=', 'y']],
                    ],
                    'options' => [
                        [
                            'component' => null
                        ]
                    ]
                ],
                'parent' => ':article'
            ],
            'is_withdrawn' => [
                'label' => 'Is withdrawn paper',
                'tables' => [],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'No',
                            'value' => 0
                        ],
                        [
                            'label' => 'Yes',
                            'value' => 1
                        ],
                    ],
                    'fixed_value' => [
                        [["$articles.art_delete_status", '<>', 'w']],
                        [["$articles.art_delete_status", '=', 'w']],
                    ],
                    'options' => [
                        [
                            'component' => null
                        ]
                    ]
                ],
                'parent' => ':article'
            ],
            'is_holded' => [
                'label' => 'Is holded paper',
                'tables' => [],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'No',
                            'value' => 0
                        ],
                        [
                            'label' => 'Yes',
                            'value' => 1
                        ],
                    ],
                    'fixed_value' => [
                        [["$articles.art_delete_status", '<>', 'h']],
                        [["$articles.art_delete_status", '=', 'h']],
                    ],
                    'options' => [
                        [
                            'component' => null
                        ]
                    ]
                ],
                'parent' => ':article'
            ],
            'is_special_issue' => [
                'label' => 'Is special issue',
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=', 'article_types.artp_id']
                    ],
                ],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [[" (article_types.artp_special_issue = 'y' or art_publication_issue is not null or art_publication_issue in (select iss_id from $issues where iss_special_issue = 'y')) ", '', 'raw_cdtn']],
                        [[" (article_types.artp_special_issue <> 'y' and (art_publication_issue is null or art_publication_issue not in (select iss_id from $issues where iss_special_issue = 'y'))) ", '', 'raw_cdtn']]
                    ],
                    'options' => [
                        [
                            'component' => null
                        ]
                    ]
                ],
                'parent' => ':article'
            ],
        ],
        'author_details' => [
            'submitting_author' => [
                'label' => 'Submitting author',
                'tables' => [
                    [
                        'name' => 'users_table',
                        'join' => '',
                        'on' => ["$articles.art_submitted_by", '=', 'users_table.usr_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['users_table.usr_id', '=', '?']],
                        [['users_table.usr_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select  usr_id as value, concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label from $users",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'Author details'
            ],
            'submitting_author_email' => [
                'label' => 'Submitting author email',
                'tables' => [
                    [
                        'name' => 'users_table',
                        'join' => '',
                        'on' => ["$articles.art_submitted_by", '=', 'users_table.usr_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["users_table.usr_id", '=', '?']],
                        [["users_table.usr_id", '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select  usr_id as value, usr_email as label from $users",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "usr_email as label"]],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'Author details'
            ],
            'co_author' => [
                'label' => 'Co authors',
                'tables' => [
                    [
                        'name' => 'article_authors',
                        'join' => '',
                        'on' => ["$articles.art_id", '=', 'article_authors.auth_art_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["article_authors.auth_usr_id", '=', '?'], ["article_authors.auth_corr_author", '=', 'n'], ["$articles.art_submitted_by", "!=", '?']],
                        [["article_authors.auth_usr_id", '!=', '?'], ["article_authors.auth_corr_author", '=', 'n'], ["$articles.art_submitted_by", "!=", '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select  usr_id as value, concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label from $users",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'Author details'
            ],
            'corr_author' => [
                'label' => ':Corresponding author',
                'tables' => [
                    [
                        'name' => 'article_authors',
                        'join' => '',
                        'on' => ["$articles.art_id", '=', 'article_authors.auth_art_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["article_authors.auth_usr_id", '=', '?'], ["article_authors.auth_corr_author", '=', 'y']],
                        [["article_authors.auth_usr_id", '!=', '?'], ["article_authors.auth_corr_author", '=', 'y']]
                    ],
                    'options' => [
                        [
                            'query' => "select  usr_id as value, concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label from $users",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'Author details'
            ],
            'corr_author_email' => [
                'label' => ':Corresponding author email',
                'tables' => [
                    [
                        'name' => 'article_authors',
                        'join' => '',
                        'on' => ["$articles.art_id", '=', 'article_authors.auth_art_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["article_authors.auth_usr_id", '=', '?'], ["article_authors.auth_corr_author", '=', 'y']],
                        [["article_authors.auth_usr_id", '!=', '?'], ["article_authors.auth_corr_author", '=', 'y']]
                    ],
                    'options' => [
                        [
                            'query' => "select  usr_id as value, usr_email as label from $users",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "usr_email as label"]],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'Author details'
            ],
            'corr_country' => [
                'label' => ':Corresponding author country',
                'tables' => [
                    [
                        'name' => "corres_auth_primary_aff_details",
                        'join' => 'LEFT',
                        'on' => ["$articles.art_id", '=', 'corres_auth_primary_aff_details.auth_art_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'contains',
                            'value' => 0
                        ],
                        [
                            'label' => 'does not contains',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['corres_auth_primary_aff_details.country_id', '=', '?']],
                        [['corres_auth_primary_aff_details.country_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select distinct cnt_id as value,cnt_country as label from $country where cnt_country like ?",
                            'options_from' => ['model' => 'Country', 'columns' => ['cnt_id as value', 'cnt_country as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'Author details'
            ],
        ],
        'submission' => [
            'submission_status' => [
                'label' => 'Submission status',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Can be',
                            'value' => 0,
                        ],
                        [
                            'label' => 'Cannot be',
                            'value' => 1
                        ],
                    ],
                    'fixed_value' => [
                        [["(CASE WHEN '?' IN ('a', 'r', 'y', 'n','c') THEN $articles.art_status = '?' WHEN '?' IN ('h', 'w') THEN $articles.art_delete_status = '?' END)", '', 'raw_cdtn']],
                        [["(CASE WHEN '?' IN ('a', 'r', 'y', 'n','c') THEN $articles.art_status != '?' WHEN '?' IN ('h', 'w') THEN $articles.art_delete_status != '?' END)", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'custom_opt' => [
                                ['label' => 'Accepted', 'value' => 'a'],
                                ['label' => 'Rejected', 'value' => 'r'],
                                ['label' => 'Submitted', 'value' => 'y'],
                                ['label' => 'Pending submission', 'value' => 'n'],
                                ['label' => 'Closed', 'value' => 'c'],
                                ['label' => 'Withdrawn', 'value' => 'w'],
                                ['label' => 'On hold', 'value' => 'h']
                            ],
                            'search_value' => false,
                            'component' => 'select_box',
                        ]
                    ],
                ],
                'parent' => 'Submission'
            ],
            'date_of_submission' => [
                'label' => 'Date of submission',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ],
                        [
                            'label' => 'On or after',
                            'value' => 2
                        ],
                        [
                            'label' => 'On or before',
                            'value' => 3
                        ],
                        [
                            'label' => 'Current month',
                            'value' => 4,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Current year',
                            'value' => 5,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Previous n week(s)',
                            'value' => 6,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n month(s)',
                            'value' => 7,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n year(s)',
                            'value' => 8,
                            'component' => 'number',
                        ],
                    ],
                    'fixed_value' => [
                        [["$articles.art_submission_date IS NOT NULL AND date($articles.art_submission_date)", '=', '?']],
                        [["$articles.art_submission_date IS NOT NULL AND date($articles.art_submission_date)", '!=', '?']],
                        [["$articles.art_submission_date IS NOT NULL AND date($articles.art_submission_date)", '>=', '?']],
                        [["$articles.art_submission_date IS NOT NULL AND date($articles.art_submission_date)", '<=', '?']],
                        [["$articles.art_submission_date IS NOT NULL AND MONTH($articles.art_submission_date) = MONTH(CURRENT_DATE()) AND YEAR($articles.art_submission_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["$articles.art_submission_date IS NOT NULL AND YEAR($articles.art_submission_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["$articles.art_submission_date IS NOT NULL AND $articles.art_submission_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? WEEK) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 WEEK)", '', 'raw_cdtn']],
                        [["$articles.art_submission_date IS NOT NULL AND $articles.art_submission_date BETWEEN DATE_FORMAT(DATE_SUB(CURRENT_DATE(), INTERVAL ? MONTH), '%Y-%m-01') AND LAST_DAY(DATE_SUB(CURRENT_DATE(), INTERVAL 1 MONTH))", '', 'raw_cdtn']],
                        [["$articles.art_submission_date IS NOT NULL AND $articles.art_submission_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? YEAR) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 YEAR)", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'component' => "date",
                            'explicit_fixed_option' => [0, 1, 2, 3, 4, 5, 6, 7, 8],
                        ]
                    ],
                ],
                'parent' => 'Submission'
            ],
            'date_of_orginal_submission' => [
                'label' => 'Date of original submission (if resubmitted)',
                'tables' => [
                    [
                        'name' => "$articles as inner_article_tbl",
                        'join' => 'LEFT',
                        'on' => ["inner_article_tbl.art_id", '=', "SUBSTRING_INDEX($articles.art_pre_all_ids, ',', 1)"]
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'On or before',
                            'value' => 0
                        ],
                        [
                            'label' => 'On or after',
                            'value' => 1
                        ],
                        [
                            'label' => 'Current month',
                            'value' => 2,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Current year',
                            'value' => 3,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Previous n week(s)',
                            'value' => 4,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n month(s)',
                            'value' => 5,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n year(s)',
                            'value' => 6,
                            'component' => 'number',
                        ],
                    ],
                    'fixed_value' => [
                        [["($articles.art_pre_all_ids IS NULL AND date($articles.art_submission_date) <= '?') OR ($articles.art_pre_all_ids IS NOT NULL AND date(inner_article_tbl.art_submission_date) <= '?')", '', 'raw_cdtn']],
                        [["($articles.art_pre_all_ids IS NULL AND date($articles.art_submission_date) >= '?') OR ($articles.art_pre_all_ids IS NOT NULL AND date(inner_article_tbl.art_submission_date) >= '?')", '', 'raw_cdtn']],
                        [["($articles.art_pre_all_ids IS NULL AND MONTH($articles.art_submission_date) = MONTH(CURRENT_DATE()) AND YEAR($articles.art_submission_date) = YEAR(CURRENT_DATE())) OR ($articles.art_pre_all_ids IS NOT NULL AND MONTH(inner_article_tbl.art_submission_date) = MONTH(CURRENT_DATE()) AND YEAR(inner_article_tbl.art_submission_date) = YEAR(CURRENT_DATE()))", '', 'raw_cdtn']],
                        [["($articles.art_pre_all_ids IS NULL AND YEAR($articles.art_submission_date) = YEAR(CURRENT_DATE())) OR ($articles.art_pre_all_ids IS NOT NULL AND YEAR(inner_article_tbl.art_submission_date) = YEAR(CURRENT_DATE()))", '', 'raw_cdtn']],
                        [["($articles.art_pre_all_ids IS NULL AND $articles.art_submission_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? WEEK) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 WEEK)) OR ($articles.art_pre_all_ids IS NOT NULL AND inner_article_tbl.art_submission_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? WEEK) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 WEEK))", '', 'raw_cdtn']],
                        [["($articles.art_pre_all_ids IS NULL AND $articles.art_submission_date BETWEEN DATE_FORMAT(DATE_SUB(CURRENT_DATE(), INTERVAL ? MONTH), '%Y-%m-01') AND LAST_DAY(DATE_SUB(CURRENT_DATE(), INTERVAL 1 MONTH))) OR ($articles.art_pre_all_ids IS NOT NULL AND inner_article_tbl.art_submission_date BETWEEN DATE_FORMAT(DATE_SUB(CURRENT_DATE(), INTERVAL ? MONTH), '%Y-%m-01') AND LAST_DAY(DATE_SUB(CURRENT_DATE(), INTERVAL 1 MONTH)))", '', 'raw_cdtn']],
                        [["($articles.art_pre_all_ids IS NULL AND $articles.art_submission_date  BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? YEAR) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 YEAR)) OR($articles.art_pre_all_ids IS NULL AND $articles.art_pre_all_ids IS NOT NULL AND inner_article_tbl.art_submission_date  BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? YEAR) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 YEAR))", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'component' => "date",
                            'explicit_fixed_option' => [0, 1, 2, 3, 4, 5, 6],
                        ]
                    ],
                ],
                'parent' => 'Submission'
            ],
            'paper_version_is' => [
                'label' => 'Paper version is',
                'tables' => [
                    [
                        'name' => "$articles as inner_article_tbl",
                        'join' => 'LEFT',
                        'on' => ["inner_article_tbl.art_id", '=', "SUBSTRING_INDEX($articles.art_pre_all_ids, ',', 1)"]
                    ],
                ],
                'condition' => [
                    'value_type' => null,
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Original',
                            'value' => 0
                        ],
                        [
                            'label' => 'Latest',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["($articles.art_pre_all_ids IS NULL)", '', 'raw_cdtn']],
                        [["( NOT EXISTS (SELECT 1 FROM $articles AS inner_tbl WHERE FIND_IN_SET($articles.art_id, inner_tbl.art_pre_all_ids)))", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ]
                ],
                'parent' => 'Submission'
            ],
        ],
        'decision' => [
            'art_decision' => [
                'label' => 'Decision',
                'tables' => [
                    [
                        'name' => "art_flow_table",
                        'sub_select' => ["MAX(aflw_id) max_aflw_id"],
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => ["$articles.art_id", '=', 'art_flow_table.aflw_art_id']
                    ],
                    [
                        'name' => 'article_flow',
                        'join' => '',
                        'on' => ['article_flow.aflw_id', '=', 'art_flow_table.max_aflw_id']
                    ],
                    [
                        'name' => 'journal_workflows',
                        'join' => '',
                        'on' => ['journal_workflows.jwf_id', '=', 'article_flow.aflw_jwf_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['journal_workflows.jwf_stage_type', '=', '?']],
                        [['journal_workflows.jwf_stage_type', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'custom_opt' => [
                                ['label' => 'Accept', 'value' => 'accept'],
                                ['label' => 'Reject', 'value' => 'reject'],
                                ['label' => 'Revision confirmation', 'value' => 'decision_revision'],
                                ['label' => 'Resubmission', 'value' => 'resubmission'],
                            ],
                            'search_value' => false,
                            'component' => 'select_box',
                        ]
                    ],
                ],
                'parent' => 'Decision'
            ],
            'decision_date' => [
                'label' => 'Decision date',
                'tables' => [
                    [
                        'name' => 'art_flow_last_decision',
                        'join' => 'LEFT',
                        'on' => ["$articles.art_id", '=', 'art_flow_last_decision.aflw_art_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'On or after',
                            'value' => 0
                        ],
                        [
                            'label' => 'On or before',
                            'value' => 1
                        ],
                        [
                            'label' => 'Current month',
                            'value' => 2,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Current year',
                            'value' => 3,
                            'component' => 'hidden',

                        ],
                        [
                            'label' => 'Previous n week(s)',
                            'value' => 4,
                            'component' => 'number',

                        ],
                        [
                            'label' => 'Previous n month(s)',
                            'value' => 5,
                            'component' => 'number',

                        ],
                        [
                            'label' => 'Previous n year(s)',
                            'value' => 6,
                            'component' => 'number',

                        ],
                    ],
                    'fixed_value' => [
                        [['date(art_flow_last_decision.aflw_returned_date)', '>=', '?']],
                        [['date(art_flow_last_decision.aflw_returned_date)', '<=', '?']],
                        [["MONTH(art_flow_last_decision.aflw_returned_date) = MONTH(CURRENT_DATE()) AND YEAR(art_flow_last_decision.aflw_returned_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["YEAR(art_flow_last_decision.aflw_returned_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["art_flow_last_decision.aflw_returned_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? WEEK) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 WEEK)", '', 'raw_cdtn']],
                        [["art_flow_last_decision.aflw_returned_date BETWEEN DATE_FORMAT(DATE_SUB(CURRENT_DATE(), INTERVAL ? MONTH), '%Y-%m-01') AND LAST_DAY(DATE_SUB(CURRENT_DATE(), INTERVAL 1 MONTH))", '', 'raw_cdtn']],
                        [["art_flow_last_decision.aflw_returned_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? YEAR) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 YEAR)", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'component' => "date",
                            'explicit_fixed_option' => [0, 1, 2, 3, 4, 5, 6],
                        ],
                    ],
                ],
                'parent' => 'Decision'
            ],
        ],
        'stage' => [
            'stage_name' => [
                'label' => 'Stage name',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["jwf_stage_name as stage_name"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=',  'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'In',
                            'value' => 0
                        ],
                        [
                            'label' => 'Not In',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["article_flow_table.stage_name IN('?')", '', 'raw_cdtn']], //awaiting_stage_tbl.aflw_status NOT IN ('g', 'd') AND 
                        [["article_flow_table.stage_name NOT IN('?')", '', 'raw_cdtn']]
                    ],
                    'options' => [
                        [
                            'query' => "select distinct jwf_stage_name as value, jwf_stage_name as label from $journal_workflows",
                            'options_from' => ['model' => 'Generic_flows', 'columns' => ['jwf_stage_name as value', 'jwf_stage_name as label']],
                            'search_value' => false,
                            'component' => "select_box",
                        ]
                    ],
                ],
                'parent' => 'Stage'
            ],
            'stage_and_assigned_date' => [
                'label' => 'Stage and assigned date',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["aflw_assigned_date"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=',  'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ],
                        [
                            'label' => 'Is',
                            'value' => 2
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 3
                        ],
                        [
                            'label' => 'On or after',
                            'value' => 4
                        ],
                        [
                            'label' => 'On or before',
                            'value' => 5
                        ],
                        [
                            'label' => 'Current month',
                            'value' => 6,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Current year',
                            'value' => 7,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Previous n week(s)',
                            'value' => 8,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n month(s)',
                            'value' => 9,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n year(s)',
                            'value' => 10,
                            'component' => 'number',
                        ],
                    ],
                    'fixed_value' => [
                        [["article_flow_table.jwf_stage_name", '=', '?']],
                        [["article_flow_table.jwf_stage_name", '!=', '?']],
                        [["date(article_flow_table.aflw_assigned_date)", '=', '?']],
                        [["date(article_flow_table.aflw_assigned_date)", '!=', '?']],
                        [["date(article_flow_table.aflw_assigned_date)", '>=', '?']],
                        [["date(article_flow_table.aflw_assigned_date)", '<=', '?']],
                        [["MONTH(article_flow_table.aflw_assigned_date) = MONTH(CURRENT_DATE()) AND YEAR(article_flow_table.aflw_assigned_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["YEAR(article_flow_table.aflw_assigned_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_assigned_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? WEEK) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 WEEK)", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_assigned_date BETWEEN DATE_FORMAT(DATE_SUB(CURRENT_DATE(), INTERVAL ? MONTH), '%Y-%m-01')AND LAST_DAY(DATE_SUB(CURRENT_DATE(), INTERVAL 1 MONTH))", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_accepted_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? YEAR) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 YEAR)", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'query' => "select distinct jwf_stage_name as value, jwf_stage_name as label from $journal_workflows",
                            'options_from' => ['model' => 'Generic_flows', 'columns' => ['jwf_stage_name as value', 'jwf_stage_name as label']],
                            'search_value' => false,
                            'component' => "select_box",
                            'explicit_fixed_option' => [0, 1],
                            'label' => ''

                        ],
                        [
                            'component' => "date",
                            'explicit_fixed_option' => [2, 3, 4, 5, 6, 7, 8, 9, 10],
                        ],
                    ],
                ],
                'parent' => 'Stage'
            ],
            'stage_and_accepted_date' => [
                'label' => 'Stage and accepted date',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["(CASE WHEN aflw_status='c' THEN aflw_accepted_date ELSE NULL END) as aflw_accepted_date"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=',  'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ],
                        [
                            'label' => 'Is',
                            'value' => 2
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 3
                        ],
                        [
                            'label' => 'On or after',
                            'value' => 4
                        ],
                        [
                            'label' => 'On or before',
                            'value' => 5
                        ],
                        [
                            'label' => 'Current month',
                            'value' => 6,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Current year',
                            'value' => 7,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Previous n week(s)',
                            'value' => 8,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n month(s)',
                            'value' => 9,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n year(s)',
                            'value' => 10,
                            'component' => 'number',
                        ],
                    ],
                    'fixed_value' => [
                        [["article_flow_table.jwf_stage_name", '=', '?']],
                        [["article_flow_table.jwf_stage_name", '!=', '?']],
                        [["date(article_flow_table.aflw_accepted_date)", '=', '?']],
                        [["date(article_flow_table.aflw_accepted_date)", '!=', '?']],
                        [["date(article_flow_table.aflw_accepted_date)", '>=', '?']],
                        [["date(article_flow_table.aflw_accepted_date)", '<=', '?']],
                        [["MONTH(article_flow_table.aflw_accepted_date) = MONTH(CURRENT_DATE()) AND YEAR(article_flow_table.aflw_accepted_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["YEAR(article_flow_table.aflw_accepted_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_accepted_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? WEEK) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 WEEK)", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_accepted_date BETWEEN DATE_FORMAT(DATE_SUB(CURRENT_DATE(), INTERVAL ? MONTH), '%Y-%m-01')AND LAST_DAY(DATE_SUB(CURRENT_DATE(), INTERVAL 1 MONTH))", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_accepted_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? YEAR) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 YEAR)", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'query' => "select distinct jwf_stage_name as value, jwf_stage_name as label from $journal_workflows",
                            'options_from' => ['model' => 'Generic_flows', 'columns' => ['jwf_stage_name as value', 'jwf_stage_name as label']],
                            'search_value' => false,
                            'component' => "select_box",
                            'explicit_fixed_option' => [0, 1],
                            'label' => ''
                        ],
                        [
                            'component' => "date",
                            'explicit_fixed_option' => [2, 3, 4, 5, 6, 7, 8, 9, 10],
                        ],
                    ],
                ],
                'parent' => 'Stage'
            ],
            'stage_and_completed_date' => [
                'label' => 'Stage and completed date',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["(CASE WHEN aflw_status='c' THEN aflw_returned_date ELSE NULL END) as aflw_completed_date"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=',  'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ],
                        [
                            'label' => 'Is',
                            'value' => 2
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 3
                        ],
                        [
                            'label' => 'On or after',
                            'value' => 4
                        ],
                        [
                            'label' => 'On or before',
                            'value' => 5
                        ],
                        [
                            'label' => 'Current month',
                            'value' => 6,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Current year',
                            'value' => 7,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Previous n week(s)',
                            'value' => 8,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n month(s)',
                            'value' => 9,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n year(s)',
                            'value' => 10,
                            'component' => 'number',
                        ],
                    ],
                    'fixed_value' => [
                        [["article_flow_table.jwf_stage_name", '=', '?']],
                        [["article_flow_table.jwf_stage_name", '!=', '?']],
                        [["date(article_flow_table.aflw_completed_date)", '=', '?']],
                        [["date(article_flow_table.aflw_completed_date)", '!=', '?']],
                        [["date(article_flow_table.aflw_completed_date)", '>=', '?']],
                        [["date(article_flow_table.aflw_completed_date)", '<=', '?']],
                        [["MONTH(article_flow_table.aflw_completed_date) = MONTH(CURRENT_DATE()) AND YEAR(article_flow_table.aflw_completed_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["YEAR(article_flow_table.aflw_completed_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_completed_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? WEEK) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 WEEK)", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_completed_date BETWEEN DATE_FORMAT(DATE_SUB(CURRENT_DATE(), INTERVAL ? MONTH), '%Y-%m-01')AND LAST_DAY(DATE_SUB(CURRENT_DATE(), INTERVAL 1 MONTH))", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_completed_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? YEAR) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 YEAR)", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'query' => "select distinct jwf_stage_name as value, jwf_stage_name as label from $journal_workflows",
                            'options_from' => ['model' => 'Generic_flows', 'columns' => ['jwf_stage_name as value', 'jwf_stage_name as label']],
                            'search_value' => false,
                            'component' => "select_box",
                            'explicit_fixed_option' => [0, 1],
                            'label' => ''
                        ],
                        [
                            'component' => "date",
                            'explicit_fixed_option' => [2, 3, 4, 5, 6, 7, 8, 9, 10],
                        ],
                    ],
                ],
                'parent' => 'Stage'
            ],
            'stage_and_rejected_date' => [
                'label' => 'Stage and rejected date',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["(CASE WHEN (aflw_status='d' AND aflw_remarks != 'timeout') THEN aflw_returned_date ELSE NULL END) as aflw_rejected_date"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=',  'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ],
                        [
                            'label' => 'Is',
                            'value' => 2
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 3
                        ],
                        [
                            'label' => 'On or after',
                            'value' => 4
                        ],
                        [
                            'label' => 'On or before',
                            'value' => 5
                        ],
                        [
                            'label' => 'Current month',
                            'value' => 6,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Current year',
                            'value' => 7,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Previous n week(s)',
                            'value' => 8,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n month(s)',
                            'value' => 9,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n year(s)',
                            'value' => 10,
                            'component' => 'number',
                        ],
                    ],
                    'fixed_value' => [
                        [["article_flow_table.jwf_stage_name", '=', '?']],
                        [["article_flow_table.jwf_stage_name", '!=', '?']],
                        [["date(article_flow_table.aflw_rejected_date)", '=', '?']],
                        [["date(article_flow_table.aflw_rejected_date)", '!=', '?']],
                        [["date(article_flow_table.aflw_rejected_date)", '>=', '?']],
                        [["date(article_flow_table.aflw_rejected_date)", '<=', '?']],
                        [["MONTH(article_flow_table.aflw_rejected_date) = MONTH(CURRENT_DATE()) AND YEAR(article_flow_table.aflw_rejected_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["YEAR(article_flow_table.aflw_rejected_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_rejected_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? WEEK) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 WEEK)", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_rejected_date BETWEEN DATE_FORMAT(DATE_SUB(CURRENT_DATE(), INTERVAL ? MONTH), '%Y-%m-01')AND LAST_DAY(DATE_SUB(CURRENT_DATE(), INTERVAL 1 MONTH))", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_rejected_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? YEAR) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 YEAR)", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'query' => "select distinct jwf_stage_name as value, jwf_stage_name as label from $journal_workflows",
                            'options_from' => ['model' => 'Generic_flows', 'columns' => ['jwf_stage_name as value', 'jwf_stage_name as label']],
                            'search_value' => false,
                            'component' => "select_box",
                            'explicit_fixed_option' => [0, 1],
                            'label' => ''
                        ],
                        [
                            'component' => "date",
                            'explicit_fixed_option' => [2, 3, 4, 5, 6, 7, 8, 9, 10],
                        ],
                    ],
                ],
                'parent' => 'Stage'
            ],
            'stage_and_auto_rejected_date' => [
                'label' => 'Stage and auto rejected date',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["(CASE WHEN (aflw_status='d' AND aflw_remarks = 'timeout') THEN aflw_returned_date ELSE NULL END) as aflw_auto_rejected_date"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=',  'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ],
                        [
                            'label' => 'Is',
                            'value' => 2
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 3
                        ],
                        [
                            'label' => 'On or after',
                            'value' => 4
                        ],
                        [
                            'label' => 'On or before',
                            'value' => 5
                        ],
                        [
                            'label' => 'Current month',
                            'value' => 6,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Current year',
                            'value' => 7,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Previous n week(s)',
                            'value' => 8,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n month(s)',
                            'value' => 9,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n year(s)',
                            'value' => 10,
                            'component' => 'number',
                        ],
                    ],
                    'fixed_value' => [
                        [["article_flow_table.jwf_stage_name", '=', '?']],
                        [["article_flow_table.jwf_stage_name", '!=', '?']],
                        [["date(article_flow_table.aflw_auto_rejected_date)", '=', '?']],
                        [["date(article_flow_table.aflw_auto_rejected_date)", '!=', '?']],
                        [["date(article_flow_table.aflw_auto_rejected_date)", '>=', '?']],
                        [["date(article_flow_table.aflw_auto_rejected_date)", '<=', '?']],
                        [["MONTH(article_flow_table.aflw_auto_rejected_date) = MONTH(CURRENT_DATE()) AND YEAR(article_flow_table.aflw_auto_rejected_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["YEAR(article_flow_table.aflw_auto_rejected_date) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_auto_rejected_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? WEEK) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 WEEK)", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_auto_rejected_date BETWEEN DATE_FORMAT(DATE_SUB(CURRENT_DATE(), INTERVAL ? MONTH), '%Y-%m-01')AND LAST_DAY(DATE_SUB(CURRENT_DATE(), INTERVAL 1 MONTH))", '', 'raw_cdtn']],
                        [["article_flow_table.aflw_auto_rejected_date BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? YEAR) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 YEAR)", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'query' => "select distinct jwf_stage_name as value, jwf_stage_name as label from $journal_workflows",
                            'options_from' => ['model' => 'Generic_flows', 'columns' => ['jwf_stage_name as value', 'jwf_stage_name as label']],
                            'search_value' => false,
                            'component' => "select_box",
                            'explicit_fixed_option' => [0, 1],
                            'label' => ''
                        ],
                        [
                            'component' => "date",
                            'explicit_fixed_option' => [2, 3, 4, 5, 6, 7, 8, 9, 10],
                        ],
                    ],
                ],
                'parent' => 'Stage'
            ],
            'stage_based' => [
                'label' => 'Stage based',
                'tables' => [
                    [
                        'name' => 'journal_workflows_task',
                        'join' => 'LEFT',
                        'on' => ["baseUserArticle.jwf_id", '=', 'journal_workflows_task.jwf_id']
                    ],
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=',  'article_types.artp_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_jnl_id', '=', 'journals.jnl_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["journal_workflows_task.jwf_stage_name", '=', "?"]],
                        [["journal_workflows_task.jwf_stage_name", '!=', "?"]]
                    ],
                    'dependent_0' => [
                        [["article_types.artp_jnl_id", '=', "?"]],
                        [["article_types.artp_jnl_id", '!=', "?"]]
                    ],
                    'options' => [
                        [
                            'query' => "select jnl_id as value, jnl_journal_name as label from $journals",
                            'options_from' => ['model' => 'Journals', 'columns' => ['jnl_id as value', 'jnl_journal_name as label']],
                            'search_value' => false,
                            'component' => "select_box",
                            'label' => ':Journal name'
                        ],
                        [
                            'query' => "select distinct jwf_stage_name as value, jwf_stage_name as label from $journal_workflows join $article_types on jwf_fwm_id = artp_fwm_id where artp_jnl_id = ? and jwf_stage_name like ?",
                            'options_from' => ['model' => 'Generic_flows', 'columns' => ['jwf_stage_name as value', 'jwf_stage_name as label']],
                            'search_value' => true,
                            'component' => 'select_box',
                            'dependent' => "0",                     //index of depending option (here this option is depend on 0th option)
                            'type' => 'three',
                            'label' => 'Stage name'
                        ]
                    ],
                ],
                'parent' => 'Stage'
            ],
            'current_stage' => [
                'label' => 'Current stage',
                'tables' => [
                    [
                        'name' => 'current_status_tbl',
                        'join' => 'INNER',
                        'on' => ["$articles.art_id", '=',  'current_status_tbl.art_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'Cannot be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["current_status_tbl.jwf_stage_name", '=', '?']],
                        [["current_status_tbl.jwf_stage_name", '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select distinct jwf_stage_name as value, jwf_stage_name as label from $journal_workflows INNER JOIN $article_flow ON aflw_jwf_id = jwf_id",
                            'options_from' => ['model' => 'Generic_flows', 'columns' => ['jwf_stage_name as value', 'jwf_stage_name as label']],
                            'search_value' => false,
                            'component' => "select_box",
                        ]
                    ],
                ],
                'parent' => 'Stage'
            ],
            'awaiting_stage_is' => [
                'label' => 'Awaiting stage is',
                'tables' => [
                    [
                        'name' => 'awaiting_stage_tbl',
                        'join' => 'INNER',
                        'on' => ["$articles.art_id", '=',  'awaiting_stage_tbl.aflw_art_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Sending to production',
                            'value' => 0
                        ],
                        [
                            'label' => 'Sending of invitation emails',
                            'value' => 1
                        ],
                        [
                            'label' => 'Final decision',
                            'value' => 2
                        ],
                        [
                            'label' => 'Licence form checking',
                            'value' => 3
                        ]
                    ],
                    'fixed_value' => [
                        [["awaiting_stage_tbl.aflw_status ='a' AND awaiting_stage_tbl.aflw_jwf_id IN(SELECT REPLACE(REPLACE(REPLACE(inner_workflow_second.jwf_parent_stages, '\"', ''),'[',''),']','') AS production_parents FROM $journal_workflows AS inner_workflow_second WHERE inner_workflow_second.jwf_stage_type = 'production') ", '', 'raw_cdtn']],
                        [["awaiting_stage_tbl.aflw_status ='w' AND (SELECT COUNT(inner_article_flow.aflw_id) FROM $article_flow as inner_article_flow WHERE inner_article_flow.aflw_status = 'u' AND inner_article_flow.aflw_parent_flow_id = awaiting_stage_tbl.aflw_id) > 0 ", '', 'raw_cdtn']],
                        [["awaiting_stage_tbl.jwf_stage_type in('accept','reject') AND awaiting_stage_tbl.aflw_returned_date is null AND awaiting_stage_tbl.aflw_status ='a'", '', 'raw_cdtn']],
                        [["awaiting_stage_tbl.jwf_stage_type='license_check' AND awaiting_stage_tbl.aflw_returned_date is null", '', 'raw_cdtn']]
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ],
                ],
                'parent' => 'Stage'
            ],
            'days_passed_after_a_stage' => [
                'label' => 'Days passed after a stage',
                'tables' => [
                    [
                        'name' => 'awaiting_stage_tbl',
                        'join' => 'INNER',
                        'on' => ["$articles.art_id", '=',  'awaiting_stage_tbl.aflw_art_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ],
                        [
                            'label' => 'greater than or equal to',
                            'value' => 2
                        ],
                        [
                            'label' => 'less than or equal to',
                            'value' => 3
                        ]
                    ],
                    'fixed_value' => [
                        [["awaiting_stage_tbl.jwf_stage_name", '=', '?']],
                        [["awaiting_stage_tbl.jwf_stage_name", '!=', '?']],
                        [["datediff(now(), awaiting_stage_tbl.aflw_returned_date)", ">=", "?"]],
                        [["datediff(now(), awaiting_stage_tbl.aflw_returned_date)", "<=", "?"]]
                    ],
                    'options' => [
                        [
                            'query' => "select distinct jwf_stage_name as value, jwf_stage_name as label from $journal_workflows INNER JOIN $article_flow ON aflw_jwf_id = jwf_id",
                            'options_from' => ['model' => 'Generic_flows', 'columns' => ['jwf_stage_name as value', 'jwf_stage_name as label']],
                            'search_value' => false,
                            'component' => "select_box",
                            'explicit_fixed_option' => [0, 1],
                            'label' => ''
                        ],
                        [
                            'component' => "number",
                            'explicit_fixed_option' => [2, 3]
                        ]
                    ],
                ],
                'parent' => 'Stage'
            ],
            'recurrent_stage_count' => [
                'label' => 'Recurrent Stage Count',
                'tables' => [
                    [
                        'name' => 'recurent_stage_tbl',
                        'join' => 'INNER',
                        'on' => [['recurent_stage_tbl.art_id', '=', "$articles.art_id"],
                                ['recurent_stage_tbl.jwf_id','=','baseUserArticle.jwf_id']]
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ],
                        [
                            'label' => 'greater than or equal to',
                            'value' => 2
                        ],
                        [
                            'label' => 'less than or equal to',
                            'value' => 3
                        ]
                    ],
                    'fixed_value' => [
                        [["`recurent_stage_tbl`.`recurrent_count`", '=', '?']],
                        [["`recurent_stage_tbl`.`recurrent_count`", '!=', '?']],
                        [["`recurent_stage_tbl`.`recurrent_count`", ">=", "?"]],
                        [["datediff(now(), awaiting_stage_tbl.aflw_returned_date)", "<=", "?"]]
                    ],
                    'options' => [
                        [
                            'search_value' => false,
                            'component' => 'number',
                        ]
                    ],
                ],
                'parent' => 'Stage'
            ],
            'stage_abandoned_date' => [
                'label' => 'Stage abandoned',
                'tables' => [
                    [
                        'name' => 'task_abandoned_tbl',
                        'join' => 'LEFT',
                        'on' => ["baseUserArticle.article_id", '=', 'task_abandoned_tbl.abandoned_art_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ],
                        [
                            'label' => 'On or after',
                            'value' => 2
                        ],
                        [
                            'label' => 'On or before',
                            'value' => 3
                        ],
                        [
                            'label' => 'Current month',
                            'value' => 4,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Current year',
                            'value' => 5,
                            'component' => 'hidden',
                        ],
                        [
                            'label' => 'Previous n week(s)',
                            'value' => 6,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n month(s)',
                            'value' => 7,
                            'component' => 'number',
                        ],
                        [
                            'label' => 'Previous n year(s)',
                            'value' => 8,
                            'component' => 'number',
                        ],
                    ],
                    'fixed_value' => [
                        [["date(`task_abandoned_tbl`.`task_abadoned_date`)", '=', '?']],
                        [["date(`task_abandoned_tbl`.`task_abadoned_date`)", '!=', '?']],
                        [["date(`task_abandoned_tbl`.`task_abadoned_date`)", '>=', '?']],
                        [["date(`task_abandoned_tbl`.`task_abadoned_date`)", '<=', '?']],
                        [["MONTH(`task_abandoned_tbl`.`task_abadoned_date`) = MONTH(CURRENT_DATE()) AND YEAR(`task_abandoned_tbl`.`task_abadoned_date`) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["YEAR(`task_abandoned_tbl`.`task_abadoned_date`) = YEAR(CURRENT_DATE())", '', 'raw_cdtn']],
                        [["`task_abandoned_tbl`.`task_abadoned_date` BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? WEEK) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 WEEK)", '', 'raw_cdtn']],
                        [["`task_abandoned_tbl`.`task_abadoned_date` BETWEEN DATE_FORMAT(DATE_SUB(CURRENT_DATE(), INTERVAL ? MONTH), '%Y-%m-01') AND LAST_DAY(DATE_SUB(CURRENT_DATE(), INTERVAL 1 MONTH))", '', 'raw_cdtn']],
                        [["`task_abandoned_tbl`.`task_abadoned_date` BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL ? YEAR) AND DATE_SUB(CURRENT_DATE(), INTERVAL 1 YEAR)", '', 'raw_cdtn']],
                    ],
                    'options' => [
                        [
                            'component' => "date",
                            'explicit_fixed_option' => [0, 1, 2, 3, 4, 5, 6, 7, 8],
                        ]
                    ],

                ],
                'parent' => 'Stage'
            ]
        ],
        'generic_form_elements' => [
            'unique_identifier' => [
                'label' => 'Unique identifier',
                'tables' => [],
                'function_call' => [
                    'name' => 'getArtIdFromUniqueIdentifier',
                    'fixed_option' => 3
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'is',
                            'value' => 0,
                        ],
                        [
                            'label' => 'can contains',
                            'value' => 1
                        ],
                        [
                            'label' => 'can\'t contains',
                            'value' => 2
                        ]
                    ],
                    'fixed_value' => [
                        [['gdata_unique_identifier', '=', '?']],
                        [['gdata_display_data', 'like', '%?%']],
                        [['gdata_display_data', 'not like', '%?%']],
                        [['art_id', 'IN', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select distinct emt_unique_identifier as value, emt_unique_identifier as label from tbk_generic_form_elements where emt_operation in ('i', 'u') and emt_unique_identifier is not null AND emt_unique_identifier like ?",
                            'options_from' => ['model' => 'Generic_form_elements', 'columns' => ['emt_unique_identifier as value', 'emt_unique_identifier as label']],
                            'search_value' => true,
                            'component' => "select_box",
                            'type' => 'three',
                            'label' => 'Unique identifer',
                            'explicit_fixed_option' => [0]
                        ],
                        [
                            'component' => "text",
                            'explicit_fixed_option' => [1, 2]
                        ]
                    ],
                ],
                'parent' => 'Generic form elements'
            ],
        ],
        'roles' => [
            'roles' => [
                'label' => 'Roles',
                'tables' => [
                    [
                        'name' => 'article_flow',
                        'join' => '',
                        'on' => ["$articles.art_id", '=', 'article_flow.aflw_art_id']
                    ],
                    [
                        'name' => 'journal_workflows',
                        'join' => '',
                        'on' => ["article_flow.aflw_jwf_id", '=', 'journal_workflows.jwf_id']
                    ],
                    [
                        'name' => 'roles',
                        'join' => '',
                        'on' => ['baseUserArticle.jwf_role_id', '=', "roles.role_id"]
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["roles.role_id", '=', '?']],
                        [["roles.role_id", '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select  role_id as value, role_name as label from $roles",
                            'options_from' => ['model' => 'Roles', 'columns' => ['role_id as value', "role_name as label"]],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'Roles'
            ],
            'retired_role' => [
                'label' => "Retired roles",
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usrj_role_retired', '=', 'y'], ['user_to_journals.usrj_role_id', '=', "?"]],
                        [['usrj_role_retired', '=', 'y'], ['user_to_journals.usrj_role_id', '!=', "?"]]
                    ],
                    'options' => [
                        [
                            'query' => "select role_id as value, role_name as label from $roles where role_name like ?",
                            'options_from' => ['model' => 'Roles', 'columns' => ['role_id as value', 'role_name as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'Roles'
            ],
        ],
        'copyright' => [
            'copyright' => [
                'label' => 'Copyright',
                'tables' => [
                    [
                        'name' => 'copyright',
                        'join' => '',
                        'on' => ["$articles.art_id", '=', 'copyright.crt_art_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['copyright.crt_id', '=', '?']],
                        [['copyright.crt_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select  crtm_id as value, crtm_license_name as label from $copyright_master",
                            'options_from' => ['model' => 'Copyright_master', 'columns' => ['crtm_id as value', 'crtm_license_name as label']],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'Copyright'
            ],
            'copyright_open' => [
                'label' => 'Open access',
                'tables' => [
                    [
                        'name' => 'copyright',
                        'join' => '',
                        'on' => ["$articles.art_id", '=', 'copyright.crt_art_id']
                    ],
                    [
                        'name' => 'copyright_master',
                        'join' => 'INNER',
                        'on' => ['copyright_master.crtm_id', '=', 'copyright.crt_crtm_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['copyright_master.crtm_payment', '=', 'o']],
                        [['Copyright_master.crtm_payment', '!=', 'o']]
                    ],
                    'options' => [
                        [
                            'component' => null
                        ]
                    ],
                ]
            ]

        ],
        'payments' => [
            'payment_is' => [
                'label' => 'Payment status',
                'tables' => [
                    [
                        'name' => 'payment_order',
                        'join' => '',
                        'on' => ["$articles.art_id", '=', 'payment_order.pmt_ord_art_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['payment_order.pmt_transaction_status', '=', "$articles.art_published_article_type"]],
                        [['payment_order.pmt_transaction_status', '!=', "$articles.art_published_article_type"]]
                    ],
                    'options' => [
                        [
                            'custom_opt' => [
                                ['label' => 'Finished', 'value' => 'fn'],
                                ['label' => 'Cancelled', 'value' => 'cl'],
                                ['label' => 'Invoice generated', 'value' => 'cc'],
                            ],
                            'search_value' => false,
                            'component' => 'select_box',
                        ]
                    ],
                ],
                'parent' => 'Payments'
            ],
        ],
        'review' => [
            'reviewed_by' => [
                'label' => 'Reviewed by',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["jwf_stage_name as stage_name"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=',  'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['article_flow_table.aflw_status IN (\'c\' , \'a\') ', '', 'raw_cdtn'], ['article_flow_table.jwf_stage_type', '=', 'review'], ['article_flow_table.aflw_usr_id', '=', '?']],
                        [['article_flow_table.aflw_status IN (\'c\' , \'a\') ', '', 'raw_cdtn'], ['article_flow_table.jwf_stage_type', '=', 'review'], ['article_flow_table.aflw_usr_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label, usr_id as value from $users where concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) like ?",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                        ]
                    ],
                ],
                'parent' => 'Reviews'
            ],
            'reviewed_declined_by' => [
                'label' => 'Reviewed declined by',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["jwf_stage_name as stage_name"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=',  'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['article_flow_table.aflw_status', '=', 'd'], ['article_flow_table.jwf_stage_type', '=', 'review'], ['article_flow_table.aflw_usr_id', '=', '?']],
                        [['article_flow_table.aflw_status', '=', 'd'], ['article_flow_table.jwf_stage_type', '=', 'review'], ['article_flow_table.aflw_usr_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label, usr_id as value from $users where concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) like ?",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                        ]
                    ],
                ],
                'parent' => 'Reviews'
            ],
            'presently_reviewed_by' => [
                'label' => 'Being reviewed by',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["jwf_stage_name as stage_name"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=',  'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['article_flow_table.aflw_status', '=', 'a'], ['article_flow_table.jwf_stage_type', '=', 'review'], ['article_flow_table.aflw_usr_id', '=', '?']],
                        [['article_flow_table.aflw_status', '=', 'a'], ['article_flow_table.jwf_stage_type', '=', 'review'], ['article_flow_table.aflw_usr_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label, usr_id as value from $users where concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) like ?",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                        ]
                    ],
                ],
                'parent' => 'Reviews'
            ],
            'reviewed_by_and_days' => [
                'label' => 'Reviewer and days passed',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["jwf_stage_name as stage_name"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=',  'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ],
                        [
                            'label' => 'is',
                            'value' => 2
                        ],
                        [
                            'label' => 'is\'t',
                            'value' => 3
                        ],
                        [
                            'label' => 'greater than or equal to',
                            'value' => 4
                        ],
                        [
                            'label' => 'less than or equal to',
                            'value' => 5
                        ]
                    ],
                    'fixed_value' => [
                        [['article_flow_table.aflw_status', '=', 'c'], ['article_flow_table.jwf_stage_type', '=', 'review'], ['article_flow_table.aflw_usr_id', '=', '?']],
                        [['article_flow_table.aflw_status', '=', 'c'], ['article_flow_table.jwf_stage_type', '=', 'review'], ['article_flow_table.aflw_usr_id', '!=', '?']],
                        [["datediff(now(), article_flow_table.aflw_returned_date)", "=", "?"]],
                        [["datediff(now(), article_flow_table.aflw_returned_date)", "!=", "?"]],
                        [["datediff(now(), article_flow_table.aflw_returned_date)", ">=", "?"]],
                        [["datediff(now(), article_flow_table.aflw_returned_date)", "<=", "?"]]
                    ],
                    'options' => [
                        [
                            'query' => "select concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label, usr_id as value from $users where concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) like ?",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "concat(usr_first_name, if(usr_middle_name is not null and usr_middle_name != '', concat(' ',usr_middle_name, ' '), ' '), usr_last_name) as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                            'explicit_fixed_option' => [0, 1]
                        ],
                        [
                            'component' => "number",
                            'explicit_fixed_option' => [2, 3, 4, 5]
                        ]
                    ],
                ],
                'parent' => 'Reviews'
            ],
            'completed_reviews_count' => [
                'label' => 'Review and completed reviews count',
                'tables' => [
                    [
                        'name' => 'completed_review_count_table',
                        'sub_select' => ["jwf_stage_name as stage_name"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => [["baseUserArticle.jwf_id", '=',  'completed_review_count_table.jwf_id'],["baseUserArticle.article_id", '=',  'completed_review_count_table.aflw_art_id']]
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ],
                        [
                            'label' => 'is',
                            'value' => 2
                        ],
                        [
                            'label' => 'is\'t',
                            'value' => 3
                        ],
                        [
                            'label' => 'greater than or equal to',
                            'value' => 4
                        ],
                        [
                            'label' => 'Less than or equal to',
                            'value' => 5
                        ]
                    ],
                    'fixed_value' => [
                        [['completed_review_count_table.stage_name', '=', '?']],
                        [['completed_review_count_table.stage_name', '!=', '?']],
                        [['completed_review_count_table.completed_count', '=', '?']],
                        [['completed_review_count_table.completed_count', '!=', '?']],
                        [['completed_review_count_table.completed_count', '>=', '?']],
                        [['completed_review_count_table.completed_count', '<=', '?']],
                    ],
                    'options' => [
                        [
                            'query' => "SELECT distinct jwf_stage_name as value, jwf_stage_name as label  FROM $journal_workflows WHERE `jwf_stage_type` LIKE 'review' AND jwf_stage_name like ? ",
                            'options_from' => ['model' => 'Generic_flows', 'columns' => ['jwf_stage_name as value', "jwf_stage_name as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                            'explicit_fixed_option' => [0, 1]
                        ],
                        [
                            'component' => "number",
                            'explicit_fixed_option' => [2, 3, 4, 5]
                        ]
                    ],
                ],
                'parent' => 'Reviews'
            ],
        ],
    ],
    "user" => [
        'journal_and_article_types' => [
            'journal_category' => [
                'label' => ':Journal category',
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => 'LEFT',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => '',
                        'on' => ['user_to_journals.usrj_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['journals.jnl_journal_type', '=', '?']],
                        [['journals.jnl_journal_type', '=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select jnl_journal_type as value, jnl_journal_type as label from $journals where jnl_journal_name like ? ",
                            'options_from' => ['model' => 'Journals', 'columns' => ['jnl_journal_type as value', 'jnl_journal_type as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'
            ],
            'journal' => [
                'label' => ':Journal name',
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => 'LEFT',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => '',
                        'on' => ['user_to_journals.usrj_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['journals.jnl_id', '=', '?']],
                        [['journals.jnl_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select jnl_id as value, jnl_journal_name as label from $journals where jnl_journal_name like ? ",
                            'options_from' => ['model' => 'Journals', 'columns' => ['jnl_id as value', 'jnl_journal_name as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'
            ],
            'is_standalone' => [
                'label' => 'Is standalone :journal',
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => 'LEFT',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => '',
                        'on' => ['user_to_journals.usrj_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['journals.jnl_standalone', '=', 'y']],
                        [['journals.jnl_standalone', '=', 'n']]
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'
            ],
            'is_archieved' => [
                'label' => 'Is archived :journal',
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => 'LEFT',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => '',
                        'on' => ['user_to_journals.usrj_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Yes',
                            'value' => 0
                        ],
                        [
                            'label' => 'No',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['journals.jnl_journal_status', '=', 'n']],
                        [['journals.jnl_journal_status', '=', 'y']]
                    ],
                    'options' => [
                        [
                            'component' => null,
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'
            ],
            'article_type' => [
                'label' => 'Submitted :article type',
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => '',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_id', '=', "user_to_journals.usrj_artp_id",]
                    ],
                ],
                'independant' => true,
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["article_types.art_artp_id", '=', '?']],
                        [["article_types.art_artp_id", '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select artp_id as value, artp_article_type as label, jnl_journal_name as parent from $article_types inner join $journals on artp_jnl_id = jnl_id ",
                            'options_from' => ['model' => 'Article_types', 'columns' => ['artp_id as value', 'artp_article_type as label']],
                            'search_value' => false,
                            'component' => "select_box",
                        ]
                    ],
                ],
                'parent' => ':journal and :article types'
            ],
        ],
        'user' => [
            'full_name' => [
                'label' => 'Full name',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'contains',
                            'value' => 0
                        ],
                        [
                            'label' => 'does not contains',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usr_id', '=', '?']],
                        [['usr_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select distinct usr_id as value, trim(CONCAT($users.usr_first_name, IF( ($users.usr_middle_name IS NULL OR $users.usr_middle_name = ''), ' ', CONCAT(' ', $users.usr_middle_name, ' ')), $users.usr_last_name )) as label from $users where (CONCAT( $users.usr_first_name, IF(($users.usr_middle_name IS NULL OR $users.usr_middle_name = ''), ' ', CONCAT(' ', $users.usr_middle_name) ), $users.usr_last_name ) like ? ) ",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "CONCAT($users.usr_first_name, IF( ($users.usr_middle_name IS NULL OR $users.usr_middle_name = ''), ' ', CONCAT(' ', $users.usr_middle_name, ' ')), $users.usr_last_name ) as label"]],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'first_name' => [
                'label' => 'First name',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'contains',
                            'value' => 0
                        ],
                        [
                            'label' => 'does not contains',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usr_id', '=', '?']],
                        [['usr_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select distinct usr_id as value, $users.usr_first_name as label from $users where $users.usr_first_name like ? ",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "$users.usr_first_name as label"]],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'last_name' => [
                'label' => 'Last name',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'contains',
                            'value' => 0
                        ],
                        [
                            'label' => 'does not contains',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usr_id', '=', '?']],
                        [['usr_id', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select distinct usr_id as value, $users.usr_last_name as label from $users where $users.usr_last_name like ? ",
                            'options_from' => ['model' => 'User', 'columns' => ['usr_id as value', "$users.usr_last_name as label"]],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'email' => [
                'label' => 'Email address',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' => "condition_params",
                    'fixed_value' => [
                        'type' => 'string',      //referer for condition_params['type']['string'] from 'report_generation.php'
                        'col' => "$users.usr_email"
                    ],
                    'options' => [
                        [
                            'component' => "text"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'status' => [
                'label' => 'Status',
                'tables' => [],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'contains',
                            'value' => 0
                        ],
                        [
                            'label' => 'does not contains',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usr_status', '=', '?']],
                        [['usr_status', '!=', '?']]
                    ],
                    'options' => [
                        [
                            'custom_opt' => [
                                ['label' => 'Active', 'value' => 'a'],
                                ['label' => 'Inactive', 'value' => 'n'],
                                ['label' => 'Awaiting confirmation', 'value' => 'w'],
                                ['label' => 'Suspended', 'value' => 's'],
                                ['label' => 'Unregistered', 'value' => 'u'],
                            ],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'user_flag' => [
                'label' => 'User flags',
                'tables' => [
                    [
                        'name' => 'user_flags',
                        'join' => '',
                        'on' => ["$users.usr_id", '=', 'user_flags.uf_usr_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['user_flags.uf_flag_id', 'IN', '?']],
                        [['user_flags.uf_flag_id', 'NOT IN', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select flag_id as value,flag_name as label from $flags where flag_name like ? AND flag_type IN ('u','s') AND flag_status != 'n'",
                            'options_from' => ['model' => 'Flags', 'columns' => ['flag_id as value', 'flag_name as label']],
                            'search_value' => true,
                            'component' => "multi_box",
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'global_user_flag' => [
                'label' => 'Global user flags',
                'tables' => [
                    [
                        'name' => 'global_user_flags',
                        'join' => '',
                        'on' => ["$users.usr_id", '=', 'global_user_flags.ugf_user_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['global_user_flags.ugf_flag_id', 'IN', '?']],
                        [['global_user_flags.ugf_flag_id', 'NOT IN', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select flag_id as value,flag_name as label from $flags where flag_name like ? AND flag_type = 'u' AND flag_status != 'n'",
                            'options_from' => ['model' => 'Flags', 'columns' => ['flag_id as value', 'flag_name as label']],
                            'search_value' => true,
                            'component' => "multi_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'user_keyword' => [
                'label' => 'User keywords',
                'tables' => [
                    [
                        'name' => 'user_keywords',
                        'join' => '',
                        'on' => ["$users.usr_id", '=', 'user_keywords.ukwd_usr_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['user_keywords.ukwd_kwd_id', 'IN', '?']],
                        [['user_keywords.ukwd_kwd_id', 'NOT IN', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select kwd_id as value,kwd_name as label from $keywords where kwd_name like ? and kwd_user_keyword = 'n'",
                            'options_from' => ['model' => 'Keywords', 'columns' => ['kwd_id as value', 'kwd_name as label']],
                            'search_value' => true,
                            'component' => "multi_box",
                            'enable_search' => true
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'user_classification' => [
                'label' => 'User classification',
                'tables' => [],
                'addl_required_table' => [
                    'usr_term_table'
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can have',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t have',
                            'value' => 1
                        ],
                    ],
                    'fixed_value' => [
                        [["$users.usr_id IN (select cls_usr_id from usr_term_table where cls_term_id = ?)", "", "raw_cdtn"]],
                        [["$users.usr_id NOT IN (select cls_usr_id from usr_term_table where cls_term_id = ?)", "", "raw_cdtn"]]
                    ],
                    'options' => [
                        [
                            'query' => "select term_id as value,term_name as label from $terms where term_name like ? ",
                            'options_from' => ['model' => 'Terms', 'columns' => ['term_id as value', "term_name as label"]],
                            'search_value' => true,
                            'component' => "select_box",
                        ],
                    ],
                ]
            ],
            'race' => [
                'label' => 'Race',
                'tables' => [],
                'client_functionality' => 'cfty_gender_race_ethnicity',
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["usr_race->'$.opt_val'", '=', '?']],
                        [["usr_race->'$.opt_val'", '!=', '?']],
                    ],
                    'options' => [
                        [
                            'custom_opt_fn' => [
                                'fn' => 'UserConfigData',
                                'param' => 'race',
                                'type' => 'key_value'
                            ],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'ethinicity' => [
                'label' => 'Ethinicity',
                'tables' => [],
                'client_functionality' => 'cfty_gender_race_ethnicity',
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["usr_ethnicity->'$.opt_val'", '=', '?']],
                        [["usr_ethnicity->'$.opt_val'", '!=', '?']],
                    ],
                    'options' => [
                        [
                            'custom_opt_fn' => [
                                'fn' => 'UserConfigData',
                                'param' => 'ethnic_origins',
                                'type' => 'key_value'
                            ],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'Gender_filter' => [
                'label' => 'Gender',
                'tables' => [],
                'client_functionality' => 'cfty_gender_race_ethnicity',
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["$users.usr_gender", '=', '?']],
                        [["$users.usr_gender", '!=', '?']],
                    ],
                    'options' => [
                        [
                            'custom_opt_fn' => [
                                'fn' => 'UserConfigData',
                                'param' => 'gender',
                                'type' => 'key_value'
                            ],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'reviewer_rating' => [
                'label' => 'Reviewer Rating',
                'tables' => [
                    [
                        'name' => 'reviewer_rating',
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'reviewer_rating.rvr_reviewer_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['reviewer_rating.rating', '=', "?"]],
                        [['reviewer_rating.rating', '!=', "?"]]
                    ],
                    'options' => [
                        [
                            'search_value' => false,
                            'component' => 'number',
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'five_star_rating' => [
                'label' => 'Reviewer ratings (five star)',
                'client_functionality' => 'cfty_fivestar_review_rating',
                'tables' => [
                    [
                        'name' => 'usr_review_rating_five',
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'usr_review_rating_five.rating_user_id']
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usr_review_rating_five.rating', '=', "?"]],
                        [['usr_review_rating_five.rating', '!=', "?"]]
                    ],
                    'options' => [
                        [
                            'search_value' => false,
                            'component' => 'number',
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'country_filter' => [
                'label' => "Country",
                'tables' => [
                    [
                        'name' => 'usr_affliation_table',
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'usr_affliation_table.usaff_user_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usr_affliation_table.usaff_cnt_id', '=', "?"]],
                        [['usr_affliation_table.usaff_cnt_id', '!=', "?"]]
                    ],
                    'options' => [
                        [
                            'query' => "select cnt_id as value, cnt_country as label from $country where cnt_country like ? ",
                            'options_from' => ['model' => 'Country', 'columns' => ['cnt_id as value', 'cnt_country as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'company_postal_code' => [
                'label' => "Zip/Postal code",
                'tables' => [
                    [
                        'name' => 'usr_affliation_table',
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'usr_affliation_table.usaff_user_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usr_affliation_table.usaff_postal_code', 'LIKE', "%?%"]],
                        [['usr_affliation_table.usaff_postal_code', 'NOT LIKE', "%?%"]]
                    ],
                    'options' => [
                        [
                            'component' => "text"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'completed_review_count' => [
                'label' => "Reviews completed",
                'tables' => [
                    [
                        'name' => "user_completed_review_tbl",
                        'join' => 'LEFT',
                        'on' => ["user_completed_review_tbl.aflw_usr_id", '=', "$users.usr_id"]
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ],
                        [
                            'label' => 'greater than or equal to',
                            'value' => 2
                        ],
                        [
                            'label' => 'less than or equal to',
                            'value' => 3
                        ]
                    ],
                    'fixed_value' => [
                        [['user_completed_review_tbl.review_count', '=', "?"]],
                        [['user_completed_review_tbl.review_count', '!=', "?"]],
                        [['user_completed_review_tbl.review_count', '>=', "?"]],
                        [['user_completed_review_tbl.review_count', '<=', "?"]],
                    ],
                    'options' => [
                        [
                            'component' => "number"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'review_inprogress_count' => [
                'label' => "Reviews in hand",
                'tables' => [
                    [
                        'name' => "user_inprogress_review_tbl",
                        'join' => 'LEFT',
                        'on' => ["user_inprogress_review_tbl.aflw_usr_id", '=', "$users.usr_id"]
                    ],
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ],
                        [
                            'label' => 'greater than or equal to',
                            'value' => 2
                        ],
                        [
                            'label' => 'less than or equal to',
                            'value' => 3
                        ]
                    ],
                    'fixed_value' => [
                        [['user_inprogress_review_tbl.review_count', '=', "?"]],
                        [['user_inprogress_review_tbl.review_count', '!=', "?"]],
                        [['user_inprogress_review_tbl.review_count', '>=', "?"]],
                        [['user_inprogress_review_tbl.review_count', '<=', "?"]],
                    ],
                    'options' => [
                        [
                            'component' => "text"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'company_institution' => [
                'label' => "Institute/Company name",
                'tables' => [
                    [
                        'name' => 'usr_affliation_table',
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'usr_affliation_table.usaff_user_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usr_affliation_table.usaff_company', '=', "?"]],
                        [['usr_affliation_table.usaff_company', '!=', "?"]]
                    ],
                    'options' => [
                        [
                            'query' => "select usaff_company as value, usaff_company as label from $user_affiliation where usaff_company like ?",
                            'options_from' => ['model' => 'User_affiliations', 'columns' => ['usaff_company as value', 'usaff_company as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'aff_state' => [
                'label' => "State",
                'tables' => [
                    [
                        'name' => 'usr_affliation_table',
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'usr_affliation_table.usaff_user_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usr_affliation_table.usaff_state', '=', "?"]],
                        [['usr_affliation_table.usaff_state', '!=', "?"]]
                    ],
                    'options' => [
                        [
                            'query' => "select usaff_state as value, usaff_state as label from $user_affiliation where usaff_state like ?",
                            'options_from' => ['model' => 'User_affiliations', 'columns' => ['usaff_state as value', 'usaff_state as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ]
            ],
            'aff_type' => [
                'label' => "Type",
                'tables' => [
                    [
                        'name' => 'usr_affliation_table',
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'usr_affliation_table.usaff_user_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usr_affliation_table.usaff_type', '=', "?"]],
                        [['usr_affliation_table.usaff_type', '!=', "?"]]
                    ],
                    'options' => [
                        [
                            'custom_opt_fn' => [
                                'fn' => 'getClientConfigdata',
                                'param' => 'aff_config.user_affiliation_type',
                                'type' => 'key_value'
                            ],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
        ],
        'roles' => [
            'roles' => [
                'label' => 'Roles',
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => '',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => '',
                        'on' => ['user_to_journals.usrj_jnl_id', '=', 'journals.jnl_id']
                    ],
                    [
                        'name' => 'roles',
                        'join' => "",
                        'on' => ["user_to_journals.usrj_role_id", "=", "roles.role_id"]
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'Is',
                            'value' => 0
                        ],
                        [
                            'label' => 'Is not',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [["roles.role_id", '=', '?']],
                        [["roles.role_id", '!=', '?']]
                    ],
                    'options' => [
                        [
                            'query' => "select  role_id as value, role_name as label from $roles",
                            'options_from' => ['model' => 'Roles', 'columns' => ['role_id as value', "role_name as label"]],
                            'search_value' => false,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
            'retired_role' => [
                'label' => "Retired roles",
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ]
                ],
                'condition' => [
                    'value_type' => 'post_value',
                    'fixed_option' =>
                    [
                        [
                            'label' => 'can be',
                            'value' => 0
                        ],
                        [
                            'label' => 'can\'t be',
                            'value' => 1
                        ]
                    ],
                    'fixed_value' => [
                        [['usrj_role_retired', '=', 'y'], ['user_to_journals.usrj_role_id', '=', "?"]],
                        [['usrj_role_retired', '=', 'y'], ['user_to_journals.usrj_role_id', '!=', "?"]]
                    ],
                    'options' => [
                        [
                            'query' => "select role_id as value, role_name as label from rvw_roles where role_name like ?",
                            'options_from' => ['model' => 'Roles', 'columns' => ['role_id as value', 'role_name as label']],
                            'search_value' => true,
                            'component' => "select_box"
                        ]
                    ],
                ],
                'parent' => 'user'
            ],
        ],

    ],

    "addtnl_data" => [
        "filter_headings" => [
            'article' => ":Article",
            'journal' => ":Journal",
        ]
    ]
];
