<?php

use App\Models\Articles;

$articles = (new Articles())->getTable();

use App\Models\User;
use App\Models\Flags;
use App\Models\Roles;
use App\Models\Issues;
use App\Models\Authors;
use App\Models\Journals;
use App\Models\Keywords;
use App\Models\Copyright;
use App\Models\User_flags;
use App\Models\Article_flag;
use App\Models\Article_flow;
use App\Models\Payment_order;
use App\Models\Article_types;
use App\Models\Generic_flows;
use App\Models\User_to_journals;
use App\Models\Article_keywords;
use App\Models\Copyright_master;
use App\Models\User_global_flags;
use App\Models\Article_export_data;

$users = (new User())->getTable();
$flags = (new Flags())->getTable();
$roles = (new Roles())->getTable();
$issues = (new Issues())->getTable();
$journal = (new Journals)->getTable();
$articles = (new Articles)->getTable();
$keywords = (new Keywords())->getTable();
$copyright = (new Copyright())->getTable();
$user_flags = (new User_flags())->getTable();
$article_authors = (new Authors)->getTable();
$article_flag = (new Article_flag)->getTable();
$article_flow = (new Article_flow)->getTable();
$article_types = (new Article_types)->getTable();
$payment_order = (new Payment_order())->getTable();
$journal_workflow = (new Generic_flows)->getTable();
$article_keyword = (new Article_keywords())->getTable();
$copyright_master = (new Copyright_master())->getTable();
$user_to_journals = (new User_to_journals())->getTable();
$user_global_flags = (new User_global_flags())->getTable();
$article_export_data = (new Article_export_data)->getTable();

return [
    'report_cache_path'     => 'report_temp/report_cache',
    'report_cron_send_path' => 'report_temp/report_cron_sent',
    'table_columns' => [
        'article' => [
            'article_journal_type' => [
                'label' => ':Journal category',
                'column' => 'jnl_journal_type',
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=', 'article_types.artp_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => ['type' => 'string'],
                'parent' => ':journal and :article types',
                'description' => "Represents the category/subject area of the :journal"
            ],
            'article_journal_code' => [
                'label' => ':Journal code',
                'column' => 'jnl_journal_code',
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=', 'article_types.artp_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => ['type' => 'string'],
                'parent' => ':journal and :article types',
                'description' => "A unique code assigned to each :journal."
            ],
            'article_journal' => [
                'label' => ':Journal name',
                'column' => 'jnl_journal_name',
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=', 'article_types.artp_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => ['type' => 'string'],
                'parent' => ':journal and :article types',
                'description' => "The full name/title of the :journal."
            ],
            'article_type' => [
                'label' => 'Submitted :article type',
                'column' => 'article_types.artp_article_type',
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=', 'article_types.artp_id']
                    ],
                ],
                'independant' => true,
                'condition' => ['type' => 'string'],
                'parent' => ':journal and :article types',
                'description' => "The :type of article at the time of submission."
            ],
            'published_article_type' => [
                'label' => 'Published :article type',
                'column' => 'pub_article_type.artp_article_type',
                'tables' => [
                    [
                        'name' => 'pub_article_type',
                        'join' => '',
                        'on' => ["$articles.art_published_article_type", '=', 'pub_article_type.artp_id']
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => ':journal and :article types',
                'description' => "The :type of article at the time of publication (may differ from submission type)."
            ],
            'artp_abbr_article_type' => [
                'label' => 'Submitted :article type code',
                'column' => 'article_types.artp_abbr_article_type',
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=', 'article_types.artp_id']
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => ':journal and :article types',
                'description' => "A system-generated or predefined code for the submitted :article type."
            ],
            'published_article_type_code' => [
                'label' => 'Published :article type code',
                'column' => 'pub_article_type.artp_abbr_article_type',
                'tables' => [
                    [
                        'name' => 'pub_article_type',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_published_article_type", '=', 'pub_article_type.artp_id']
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => ':journal and :article types',
                'description' => "A system-generated or predefined code for the published :article type."
            ],
            'art_code' => [
                'label' => ':Article ID',
                'column' => "$articles.art_code",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'description' => "Unique identifier for each :article."
            ],
            'art_pre_all_ids' => [
                'label' => 'Original ID of paper (if resubmitted)',
                'column' => 'art_cp.art_code',
                'tables' => [
                    [
                        'name' => 'art_cp',
                        'join' => '',
                        'on' => ['art_cp.art_id', '=', "IF( $articles.art_pre_all_ids is null,$articles.art_id,SUBSTRING_INDEX($articles.art_pre_all_ids, ',', 1))"]
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'description' => "Identifier from a previous submission if the :article was resubmitted."
            ],
            'art_title' => [
                'label' => ':Article title',
                'column' => "$articles.art_title", //'IF(LENGTH(`$articles`.`art_title`) > 50, CONCAT(LEFT(`$articles`.`art_title`, 47), "..."), `$articles`.`art_title`)'
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'description' => "Title of the :article."
            ],
            'art_abstract' => [
                'label' => ':Article abstract',
                'column' => "$articles.art_abstract", //'IF(LENGTH(`$articles`.`art_abstract`) > 50, CONCAT(LEFT(`$articles`.`art_abstract`, 47), "..."), `$articles`.`art_abstract`)'
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'description' => "Abstract or summary of the :article."
            ],
            'article_status' => [
                'label' => ':Article status',
                'column' => "article_status.art_stat",
                'tables' => [
                    [
                        'name' => 'article_status',
                        'join' => 'LEFT',
                        'on' => ['article_status.art_id', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'description' => "Current status of the :article (e.g., submitted, under review, published)."
            ],
            'art_flags' => [
                'label' => ':Article flags',
                'column' => 'flags.flag_name',
                'tables' => [
                    [
                        'name' => 'article_flags',
                        'join' => 'LEFT',
                        'on' => ["$articles.art_id", '=', 'article_flags.aflg_art_id']
                    ],
                    [
                        'name' => 'flags',
                        'join' => 'LEFT',
                        'on' => ['article_flags.aflg_flag_id', '=', 'flags.flag_id']
                    ]
                ],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => ':article',
                'description' => "Flags associated with the :article."
            ],
            'article_keyword' => [
                'label' => ':Article keywords',
                'column' => 'article_keywords_custom.kwd_name',
                'column_mod' => 'subselect',
                'tables' => [
                    [
                        'name' => 'article_keywords_custom',
                        'join' => 'LEFT',
                        'sub_select' => ['kwd_name'],
                        'temp_table' => true,
                        'on' => ["$articles.art_id", '=', 'article_keywords_custom.ak_art_id']
                    ],
                ],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => ':article',
                'description' => "Keywords defined for the :article."
            ],
            "article_classification" => [
                'label' => ":Article classifications",
                'column' => "hierarchy_path",
                'tables' => [
                    [
                        'name' => 'article_classification_custom',
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => ["$articles.art_id", "=", "article_classification_custom.art_id"]
                    ]
                ],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'new_line'],
                'parent' => ':article',
                'description' => "Classifications or categories assigned to the :article."
            ],
            'art_biorxiv' => [
                'label' => 'bioRxiv',
                'column' => "$articles.art_biorxiv",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'client_functionality' => 'cfty_biorxiv',
                'description' => "Name of the bioRxiv."
            ],
            'art_issue' => [
                'label' => 'Issue (Volume)',
                'column' => "article_issue.issue_name",
                'tables' => [
                    [
                        'name' => 'article_issue',
                        'join' => 'LEFT',
                        'on' => ['article_issue.issue_art_id', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'client_functionality' => 'cfty_manage_issues',
                'description' => "Issue at which the :article falls under."
            ],
            'art_notes' => [
                'label' => 'Notes',
                'column' => "article_notes.notes",
                'tables' => [
                    [
                        'name' => 'article_notes',
                        'join' => 'LEFT',
                        'on' => ['article_notes.note_art_id', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'description' => "Notes added by users to an :article during evaluation."
            ],
            'art_funders' => [
                'label' => 'Funder details',
                'column' => "article_funder.funders_list",
                'tables' => [
                    [
                        'name' => 'article_funder',
                        'join' => 'LEFT',
                        'on' => ['article_funder.funder_art_id', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'description' => "The information about organizations or agencies that financially supported the :article."
            ],
            'art_copyright' => [
                'label' => 'Copyright type',
                'column' => "article_copyright.copyright_list",
                'tables' => [
                    [
                        'name' => 'article_copyright',
                        'join' => 'LEFT',
                        'on' => ['article_copyright.cpy_art_id', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'description' => "Refers who owns the rights and how the work can be used."
            ],
            'art_discussion' => [
                'label' => 'Discussion',
                'column' => "article_discussion.comments",
                'tables' => [
                    [
                        'name' => 'article_discussion',
                        'join' => 'LEFT',
                        'on' => ['article_discussion.discussion_art', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'description' => "Discussion comments added by the users who participate in discussion."
            ],
            'art_blind_user' => [
                'label' => 'Blinded user list',
                'column' => "usr_article_blind.blind_users",
                'tables' => [
                    [
                        'name' => 'usr_article_blind',
                        'join' => 'LEFT',
                        'on' => ['usr_article_blind.blind_article', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => ':article',
                'description' => "Users who are restricted from accessing specific :articles to maintain confidentiality."
            ],
            'proposal_invitaion_status' => [
                'label' => 'Proposal invitation status', //- invite send/accepted/rejected
                'column' => "proposal_status.proposal_stat",
                'tables' => [
                    [
                        'name' => 'proposal_status',
                        'join' => 'LEFT',
                        'on' => ['proposal_status.proposal_art_id', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => ':article',
                'description' => "Status of the proposals sent to the authors."
            ],
            'art_export_date' => [
                'label' => 'Exported date',
                'column' => 'article_export_data.exp_posted_date',
                'tables' => [
                    [
                        'name' => 'article_export_data',
                        'join' => 'LEFT',
                        'on' => ["$articles.art_id", '=', 'article_export_data.exp_art_id']
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => ':article',
                'description' => "Denotes the date in which an :article is exported."
            ],
            'art_submitted_by' => [
                'label' => 'Submitting author',
                'column' => 'concat( LTRIM(users.`usr_first_name`),IF(LTRIM(users.`usr_middle_name`) IS NULL or LTRIM(users.`usr_middle_name`)="", " ", CONCAT(" ",LTRIM(users.usr_middle_name)," ")),LTRIM(users.`usr_last_name`))',
                'tables' => [
                    [
                        'name' => 'users',
                        'join' => '',
                        'on' => ['users.usr_id', '=', "$articles.art_submitted_by"]
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'author details',
                'description' => "Name of the submitting author."
            ],
            'submitted_by_email' => [
                'label' => 'Submitting author email',
                'column' => 'submitting_author_table.email',
                'tables' => [
                    [
                        'name' => "submitting_author_table",
                        'sub_select' => ["usr_email as email"],
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$articles.art_id", '=', 'submitting_author_table.art_id']
                    ],
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'author details',
                'description' => "Email id of the submitting author."
            ],
            'submitted_by_state' => [
                'label' => 'Submitting author state',
                'column' => 'submit_auth_primary_aff_details.state',
                'tables' => [
                    [
                        'name' => "submit_auth_primary_aff_details",
                        'join' => 'LEFT',
                        'on' => [["$articles.art_id", '=', 'submit_auth_primary_aff_details.auth_art_id'],["$articles.art_submitted_by", '=', 'submit_auth_primary_aff_details.auth_usr_id']]
                    ],
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'author details',
                'description' => "State of the submitting author."
            ],
            'submitted_by_country' => [
                'label' => 'Submitting author country',
                'column' => 'submit_auth_primary_aff_details.country',
                'tables' => [
                    [
                        'name' => "submit_auth_primary_aff_details",
                        'join' => 'LEFT',
                        'on' => [["$articles.art_id", '=', 'submit_auth_primary_aff_details.auth_art_id'],["$articles.art_submitted_by", '=', 'submit_auth_primary_aff_details.auth_usr_id']]
                    ],
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'author details',
                'description' => "Country of the submitting author"
            ],
            'co_author' => [
                'label' => 'Co authors',
                'column' => 'co_authors_table.co_authors',
                'tables' => [
                    [
                        'name' => "co_authors_table",
                        'sub_select' => ["CONCAT( LTRIM(usr_first_name), CASE WHEN LTRIM(usr_middle_name) IS NULL OR LTRIM(usr_middle_name) = '' THEN ' ' ELSE CONCAT(' ', LTRIM(usr_middle_name), ' ') END, LTRIM(usr_last_name)) AS co_authors"],
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$articles.art_id", '=', 'co_authors_table.auth_art_id']
                    ],
                ],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => 'author details',
                'description' => "Name of the Co-author"
            ],
            'corres_author' => [
                'label' => ':Corresponding author',
                'column' => 'corr_authors_table.corr_authors',
                'tables' => [
                    [
                        'name' => "corr_authors_table",
                        'sub_select' => ["CONCAT( LTRIM(usr_first_name), CASE WHEN LTRIM(usr_middle_name) IS NULL OR LTRIM(usr_middle_name) = '' THEN ' ' ELSE CONCAT(' ', LTRIM(usr_middle_name), ' ') END, LTRIM(usr_last_name)) AS corr_authors"],
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$articles.art_id", '=', 'corr_authors_table.auth_art_id']
                    ],
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'author details',
                'description' => "Name of :corresponding author."
            ],
            'corres_email' => [
                'label' => ':Corresponding author email',
                'column' => 'corr_authors_table.corr_email',
                'tables' => [
                    [
                        'name' => "corr_authors_table",
                        'sub_select' => ["usr_email as corr_email"],
                        'join' => '',
                        'temp_table' => true,
                        'on' => ["$articles.art_id", '=', 'corr_authors_table.auth_art_id']
                    ],
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'author details',
                'description' => "Email ID of :corresponding author."
            ],
            'corres_state' => [
                'label' => ':Corresponding author state',
                'column' => 'corres_auth_primary_aff_details.state',
                'tables' => [
                    [
                        'name' => "corres_auth_primary_aff_details",
                        'join' => 'LEFT',
                        'on' => ["$articles.art_id", '=', 'corres_auth_primary_aff_details.auth_art_id']
                    ],
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'author details',
                'description' => "State of :corresponding author based on primary affiliation."
            ],
            'corres_country' =>[
                'label' => ':Corresponding author country',
                'column' => 'corres_auth_primary_aff_details.country',
                'tables' => [
                    [
                        'name' => "corres_auth_primary_aff_details",
                        'join' => 'LEFT',
                        'on' => ["$articles.art_id", '=', 'corres_auth_primary_aff_details.auth_art_id']
                    ],
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'author details',
                'description' => "Country of :corresponding author based on primary affiliation."
            ],
            'art_submission_date' => [
                'label' => 'Date of submission',
                'column' => "$articles.art_submission_date",
                'tables' => [],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => 'submission',
                'description' => "Submission date of the :article (final submission date if resubmitted)."
            ],
            'art_original_submission_date' => [
                'label' => 'Date of original submission (if resubmitted)',
                'column' => 'arts_date.art_submission_date',
                'tables' => [
                    [
                        'name' => 'arts_date',
                        'join' => '',
                        'on' => ['arts_date.art_id', '=', "IF( $articles.art_pre_all_ids is null,$articles.art_id,SUBSTRING_INDEX($articles.art_pre_all_ids, ',', 1))"]
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => 'submission',
                'description' => "Submission date of :article (initial submission date if resubmitted)."
            ],
            'days_since_submission' => [
                'label' => 'Days since submission',
                'column' => "CASE WHEN  $articles.art_submission_date!=0 AND $articles.art_submission_date IS NOT NULL THEN  "
                    . "datediff(now(),$articles.art_submission_date) ELSE NULL  END",
                'tables' => [],
                'condition' => ['type' => 'number'],
                'parent' => 'submission',
                'description' => "Number of days since submission (from last submission if resubmitted)."
            ],
            'art_decision_name' => [
                'label' => 'Decision (e.g. Accept)',
                'column' => "journal_workflows.jwf_stage_name",
                'tables' => [
                    [
                        'name' => "art_flow_table",
                        'sub_select' => ["MAX(aflw_id) max_aflw_id"],
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => ["$articles.art_id", '=', 'art_flow_table.aflw_art_id']
                    ],
                    [
                        'name' => 'article_flow',
                        'join' => '',
                        'on' => ['article_flow.aflw_id', '=', 'art_flow_table.max_aflw_id']
                    ],
                    [
                        'name' => 'journal_workflows',
                        'join' => '',
                        'on' => ['journal_workflows.jwf_id', '=', 'article_flow.aflw_jwf_id']
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'decision',
                'description' => "Decisions taken towards submitted :article"
            ],
            'art_decision_date' => [
                'label' => 'Date of first decision',
                'column' => 'article_min_flow.aflw_returned_date',
                'tables' => [
                    [
                        'name' => "art_flow_table",
                        'sub_select' => ["min(aflw_id) min_aflw_id"],
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => ["$articles.art_id", '=', 'art_flow_table.aflw_art_id']
                    ],
                    [
                        'name' => 'article_min_flow',
                        'join' => '',
                        'on' => ['article_min_flow.aflw_id', '=', 'art_flow_table.min_aflw_id']
                    ],
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => 'decision',
                'description' => "Date of first decision taken towards the :article."
            ],
            'art_final_decision_date' => [
                'label' => 'Date of final decision',
                'column' => "CASE WHEN  $articles.art_final_decision_date!=0 AND $articles.art_final_decision_date IS NOT NULL THEN  "
                    . "$articles.art_final_decision_date ELSE NULL END",
                'tables' => [],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => 'decision',
                'description' => "Date of last decision taken towards the :article."
            ],
            'jwf_all_status_names' => [
                'label' => 'Stage name',
                'column' => 'article_flow_table.stage_name',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["jwf_stage_name as stage_name"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=', 'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'stage',
                'description' => "Name of the stage"
            ],
            'jwf_all_status_assigned_date' => [
                'label' => 'Stage assigned date',
                'column' => 'article_flow_table.aflw_assigned_date',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["aflw_assigned_date"],
                        'sub_select_grouping' => false,
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=', 'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => 'stage',
                'description' => "Date the stage is assigned."
            ],
            'jwf_all_status_accepted_date' => [
                'label' => 'Stage accepted date',
                'column' => 'article_flow_table.aflw_accepted_date',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["(CASE WHEN aflw_status='c' THEN aflw_accepted_date ELSE NULL END) as aflw_accepted_date"],
                        'temp_table' => true,
                        'sub_select_grouping' => false,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=', 'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => 'stage',
                'description' => "Date the stage is accepted."
            ],
            'jwf_all_status_completed_date' => [
                'label' => 'Stage completed date',
                'column' => 'article_flow_table.aflw_completed_date',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["(CASE WHEN aflw_status='c' THEN aflw_returned_date ELSE NULL END) as aflw_completed_date"],
                        'temp_table' => true,
                        'sub_select_grouping' => false,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=', 'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => 'stage',
                'description' => "Date the stage is completed."
            ],
            'jwf_task_abandoned_date' => [
                'label' => 'Stage abandoned date',
                'column' => 'task_abandoned_tbl.task_abadoned_date',
                'tables' => [
                    [
                        'name' => 'task_abandoned_tbl',
                        'join' => 'LEFT',
                        'on' => ["baseUserArticle.article_id", '=', 'task_abandoned_tbl.abandoned_art_id']
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => 'stage',
                'description' => "Date the stage is abondoned."
            ],
            'jwf_all_status_rejected_date' => [
                'label' => 'Stage rejected date',
                'column' => 'article_flow_table.aflw_rejected_date',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["(CASE WHEN (aflw_status='d' AND aflw_remarks != 'timeout') THEN aflw_returned_date ELSE NULL END) as aflw_rejected_date"],
                        'temp_table' => true,
                        'sub_select_grouping' => false,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=', 'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => 'stage',
                'description' => "Date the stage is rejected."
            ],
            'jwf_all_status_auto_rejected_date' => [
                'label' => 'Stage auto rejected date',
                'column' => 'article_flow_table.aflw_auto_rejected_date',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["(CASE WHEN (aflw_status='d' AND aflw_remarks = 'timeout') THEN aflw_returned_date ELSE NULL END) as aflw_auto_rejected_date"],
                        'temp_table' => true,
                        'sub_select_grouping' => false,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=', 'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => 'stage',
                'description' => "Date the stage is auto rejected"
            ],
            'jwf_all_status_rejected_reason' => [
                'label' => 'Stage rejected reason',
                'column' => 'article_flow_table.aflw_remarks',
                'tables' => [
                    [
                        'name' => 'article_flow_table',
                        'sub_select' => ["(CASE WHEN (aflw_status='d') THEN CAST(aflw_remarks AS CHAR(512)) ELSE NULL END) as aflw_remarks"],//["(CASE WHEN (aflw_status='d') THEN CAST(aflw_remarks AS CHAR(512)) ELSE NULL END) as aflw_remarks"],
                        'temp_table' => true,
                        'join' => 'INNER',
                        'on' => ["baseUserArticle.aflw_id", '=', 'article_flow_table.aflw_id']
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'stage',
                'description' => "Reason given by the reviewer for the rejection."
            ],
            'jwf_status_name_formatted' => [
                'label' => 'Current stage status (e.g. ready for check)',
                'column' => 'status_summary_table.status_summary',
                'tables' => [
                    [
                        'name' => "status_summary_table",
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => ["$articles.art_id", '=', 'status_summary_table.st_art_id']
                    ],
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'stage',
                'description' => "The stage at which the :article currently is."
            ],
            'jwf_recurrent_stage_count' => [
                'label' => 'Recurrent Stage Count',
                'column' => 'recurent_stage_tbl.recurrent_count',
                'tables' => [
                    [
                        'name' => 'recurent_stage_tbl',
                        'join' => 'INNER',
                        'on' => [['recurent_stage_tbl.art_id', '=', "$articles.art_id"],
                                ['recurent_stage_tbl.jwf_id','=','baseUserArticle.jwf_id']]
                    ]
                ],
                'condition' => ['type' => 'number'],
                'parent' => ':article',
                'description' => "Number of times the :article gone through the stage."
            ],
            'time_spend_in_review' => [
                'label' => 'TAT - Review',
                'column' => "time_spend_review.time_spend_in_review",
                'tables' => [
                    [
                        'name' => 'time_spend_review',
                        'join' => 'LEFT',
                        'on' => ['time_spend_review.art_id', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => ['type' => 'number'],
                'parent' => 'stage',
                'description' => "Number of days took to complete review stages."
            ],
            'tat_first_decision' => [
                'label' => 'TAT – Submission to first decision',
                'column' => "tat_submission_to_first_decision.tat_first",
                'tables' => [
                    [
                        'name' => 'tat_submission_to_first_decision',
                        'join' => 'LEFT',
                        'on' => ['tat_submission_to_first_decision.tat_first_art', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => ['type' => 'number'],
                'parent' => 'stage',
                'description' => "Number of days took to submit the :article."
            ],
            'tat_last_decision' => [
                'label' => 'TAT – Submission to last decision',
                'column' => "tat_submission_to_last_decision.tat_last",
                'tables' => [
                    [
                        'name' => 'tat_submission_to_last_decision',
                        'join' => 'LEFT',
                        'on' => ['tat_submission_to_last_decision.tat_last_art', '=', "$articles.art_id"]
                    ]
                ],
                'condition' => ['type' => 'number'],
                'parent' => 'stage',
                'description' => "Number of days took to complete last decision stage."
            ],
            'generic_form_elements' => [
                'label' => 'Generic form elements',
                'column' => 'gdata_display_data',
                'tables' => [],
                'function_call' => [
                    'name' => 'getUniqueIdentifierValue',
                    'cdtn_field' => 'gdata_unique_identifier'
                ],
                'condition' => ['type' => 'string'],
                'pre_options' => [
                    [
                        'query' => "select distinct emt_unique_identifier as value, emt_unique_identifier as label, emt_label as heading from tbk_generic_form_elements t INNER JOIN (SELECT emt_id, max(emt_posted_date) as max_created_at from tbk_generic_form_elements group by emt_id ) latest where t.emt_id = latest.emt_id and t.emt_posted_date = latest.max_created_at and emt_operation in ('i', 'u') and emt_unique_identifier is not null AND emt_unique_identifier like ?",
                        'options_from' => ['model' => 'Generic_form_elements', 'columns' => ['emt_unique_identifier as value', 'emt_unique_identifier as label']],
                        'search_value' => true,
                        'component' => "select_box",
                        'type' => 'three',
                        'label' => ':Journal name',
                    ],
                    [
                        'component' => "text",
                        'label' => 'Column name',
                    ]
                ],
                [
                    'component' => "text",
                    'label' => 'Column name',
                ],
                'parent' => 'form_elements',
                'description' => "Display data from forms where the fields are mapped to an Unique key."

            ],
            "roles" => [
                'label' => "Roles",
                'column' => "roles.role_name",
                'tables' => [
                    [
                        'name' => 'roles',
                        'join' => "",
                        'on' => ["baseUserArticle.jwf_role_id", "=", "roles.role_id"]
                    ]
                ],
                'independant' => true,
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => 'Roles',
                'description' => "Roles avaiable in the system (If used with other user relatable data, corresponding user role is displayed)."

            ],
            "article_type_roles" => [
                'label' => ":Article type - roles",
                'column' => "article_type_roles_table.role_name",
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=', 'article_types.artp_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_jnl_id', '=', 'journals.jnl_id']
                    ],
                    [
                        'name' => 'article_type_roles_table',
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => [["baseUserArticle.user_id", '=', "article_type_roles_table.user_id"],["article_type_roles_table.usrj_artp_id", '=', 'article_types.artp_id'],["article_type_roles_table.usrj_jnl_id", "=", "journals.jnl_id"]]
                    ],
                ],
                'independant' => true,
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => 'Roles',
                'description' => "Roles that are available within the :article type."

            ],
            "retired_roles" => [
                'label' => "Retired roles",
                'column' => "retired_roles_table.role_name",
                'tables' => [
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ["$articles.art_artp_id", '=', 'article_types.artp_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_jnl_id', '=', 'journals.jnl_id']
                    ],
                    [
                        'name' => 'retired_roles_table',
                        'join' => "LEFT",
                        'temp_table' => true,
                        'on' => [["baseUserArticle.user_id", "=", "retired_roles_table.user_id"],["retired_roles_table.usrj_jnl_id", "=", "journals.jnl_id"]]
                    ]
                ],
                'independant' => true,
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => 'Roles',
                'description' => "Displays retired roles of users."

            ],
        ],

        'user' => [
            'article_journal_type' => [
                'label' => ':Journal category',
                'column' => 'jnl_journal_type',
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => 'LEFT',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => '',
                        'on' => ['user_to_journals.usrj_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => ['type' => 'string'],
                'parent' => ':journal and :article types',
                'description' => "Represents the category/subject area of the :journal"
            ],
            'article_journal_code' => [
                'label' => ':Journal code',
                'column' => 'jnl_journal_code',
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => '',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => '',
                        'on' => ['user_to_journals.usrj_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => ['type' => 'string'],
                'parent' => ':journal and :article types',
                'description' => "A unique code assigned to each :journal."
            ],
            'article_journal' => [
                'label' => ':Journal name',
                'column' => 'jnl_journal_name',
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => 'LEFT',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => '',
                        'on' => ['user_to_journals.usrj_jnl_id', '=', 'journals.jnl_id']
                    ]
                ],
                'independant' => true,
                'condition' => ['type' => 'string'],
                'parent' => ':journal and :article types',
                'description' => "The full name/title of the :journal."
            ],
            'article_type' => [
                'label' => 'Submitted :article type',
                'column' => 'article_types.artp_article_type',
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => '',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_id', '=', "user_to_journals.usrj_artp_id",]
                    ],
                ],
                'independant' => true,
                'condition' => ['type' => 'string'],
                'parent' => ':journal and :article types',
                'description' => "The :type of article at the time of submission."
            ],
            'usr_title' =>  [
                'label' => 'Title',
                'column' => "$users.usr_title",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'col_val_modifier' => [
                    'mod_name' => 'user_titles',
                    'fn' => 'UserConfigdata',
                    'param' => 'titles',
                    'type' => 'array',
                    'default_delimeters' => 'new_line'
                ],
                'parent' => 'user',
                'description' => "Title of the user."
            ],
            'user_first_name' =>  [
                'label' => 'First name',
                'column' => "$users.usr_first_name",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => 'user',
                'description' => "First name of the user."
            ],
            'user_last_name' =>  [
                'label' => 'Last name',
                'column' => "$users.usr_last_name",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => 'user',
                'description' => "Last name of the user."
            ],
            'user_full_name' =>  [
                'label' => 'Full name',
                'column' => "CONCAT( LTRIM($users.usr_first_name), IF( LTRIM($users.usr_middle_name) IS NULL OR LTRIM($users.usr_middle_name) = '', ' ', CONCAT(' ', LTRIM($users.usr_middle_name), ' ') ), LTRIM($users.usr_last_name) )",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => 'user',
                'description' => "Full name of the user."
            ],
            'user_name' =>  [
                'label' => 'Username',
                'column' => "$users.usr_username",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => 'user',
                'description' => "username of the user."
            ],
            'user_email_address' =>  [
                'label' => 'Email address',
                'column' => "$users.usr_email",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => 'user',
                'description' => "Email adddress of the user."

            ],
            'alt_user_email_address' =>  [
                'label' => 'Alt.email address',
                'column' => "user_alternative_email.uml_email",
                'tables' => [
                    [
                        'name' => "user_alternative_email",
                        'join' => 'LEFT',
                        'on' => ["$users.usr_id", '=', "user_alternative_email.uml_user_id"]
                    ],
                ],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => 'user',
                'description' => "alternative email adddress of the user."
            ],
            'user_phone_no' =>  [
                'label' => 'Phone number',
                'column' => "$users.usr_phone_no",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => 'user',
                'description' => "Phone number of the user."

            ],
            'user_registered_date' =>  [
                'label' => 'Registered date',
                'column' => "$users.usr_reg_date",
                'tables' => [],
                'condition' => ['type' => 'date', 'col_fn' => "date(col_name)", 'sel_fn' => "DATE_FORMAT(col_name,'DATE_FORMAT_KEY')"],
                'parent' => 'user',
                'description' => "Date when the user registered in the system."

            ],
            'user_orcid' =>  [
                'label' => 'ORCID',
                'column' => "$users.usr_orcid_id",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => 'user',
                'description' => "Phone number of the user."

            ],
            "affiliation" => [
                'label' => "Affiliation",
                'column' => "usr_affliation_table.affiliation",
                'tables' => [
                    [
                        'name' => 'usr_affliation_table',
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'usr_affliation_table.usaff_user_id']
                    ]
                ],
                'condition' => ['type' => 'string', 'default_delimeters' => 'new_line'],
                'parent' => 'user',
                'description' => "List of all the affiliations of the user avaiable in the system."

            ],
            'user_country' =>  [
                'label' => 'Country',
                'column' => "IF(user_affiliation_cntry.aff_user_country IS NULL,author_affiliation_cntry.author_country,user_affiliation_cntry.aff_user_country)",
                'tables' => [
                    [
                        'name' => "user_affiliation_cntry",
                        'join' => 'LEFT',
                        'on' => ["user_affiliation_cntry.aff_user_id", '=', "$users.usr_id"]
                    ],
                    [
                        'name' => "author_affiliation_cntry",
                        'join' => 'LEFT',
                        'on' => ["author_affiliation_cntry.auth_user_id", '=', "$users.usr_id"]
                    ],
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'user',
                'description' => "List of all the affiliations of the user avaiable in the system."

            ],
            'user_status' =>  [
                'label' => 'Status',
                'column' => "(CASE WHEN $users.usr_status = 'a' THEN 'Active' WHEN $users.usr_status = 'w' THEN 'Awaiting confirmation' WHEN $users.usr_status = 'n' THEN 'Inactive' WHEN $users.usr_status = 's' THEN 'Suspended' WHEN $users.usr_status = 'n' THEN 'Inactive' WHEN $users.usr_status = 'u' THEN 'Unregistered' END)",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'parent' => 'user',
                'description' => "Status of the user such as active, inactive, etc..."

            ],
            'user_flag' =>  [
                'label' => 'User flags',
                'column' => "$flags.flag_name",
                'tables' => [
                    [
                        'name' => "$user_flags",
                        'join' => 'LEFT',
                        'on' => ["$users.usr_id", '=', "$user_flags.uf_usr_id"]
                    ],
                    [
                        'name' => "$flags",
                        'join' => 'LEFT',
                        'on' => ["$user_flags.uf_flag_id", '=', "$flags.flag_id"]
                    ]
                ],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => 'user',
                'description' => "List of flags marked against the users related to :article/:journal."

            ],
            'global_user_flag' =>  [
                'label' => 'Global user flags',
                'column' => "flags_a.flag_name",
                'tables' => [
                    [
                        'name' => "$user_global_flags",
                        'join' => 'LEFT',
                        'on' => ["$users.usr_id", '=', "$user_global_flags.ugf_user_id"]
                    ],
                    [
                        'name' => 'flags_a',
                        'join' => 'LEFT',
                        'on' => ["$user_global_flags.ugf_flag_id", '=', 'flags_a.flag_id']
                    ]
                ],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => 'user',
                'description' => "List of flags marked against the users globally (in all :journal in the system)."
            ],
            'user_keyword' => [
                'label' => 'User keywords',
                'column' => 'user_keywords_custom.kwd_name',
                'column_mod' => 'subselect',
                'tables' => [
                    [
                        'name' => 'user_keywords_custom',
                        'join' => 'LEFT',
                        'sub_select' => ['kwd_name'],
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'user_keywords_custom.ukwd_usr_id']
                    ],
                ],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => 'user',
                'description' => "List of flags marked against the users globally (in all :journal in the system)."
            ],
            "user_classification" => [
                'label' => "User classifications",
                'column' => "hierarchy_path",
                'tables' => [
                    [
                        'name' => 'user_classification_custom',
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", "=", "user_classification_custom.usr_id"]
                    ]
                ],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'new_line'],
                'parent' => 'user',
                'description' => "classifications added towards the user profile."
            ],
            'user_unavail_date' =>  [
                'label' => 'User unavailable dates',
                'column' => "user_unavailable_dates_tbl.date_ranges",
                'tables' => [
                    [
                        'name' => "user_unavailable_dates_tbl",
                        'join' => 'LEFT',
                        'on' => ["user_unavailable_dates_tbl.unavail_user_id", '=', "$users.usr_id"]
                    ],
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'user',
                'description' => "Dates which are makred as unavaible by the user."
            ],
            /* 'user_standalone_journals' =>  [
                'label' => 'Standalone :Journals',
                'column' => "user_standalone_tbl.journals",
                'tables' => [
                    [
                        'name' => "user_standalone_tbl",
                        'join' => 'LEFT',
                        'on' => ["user_standalone_tbl.usrj_usr_id", '=', "$users.usr_id"]
                    ],
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'user'
            ], */
            "five_star_rating" => [
                'label' => "Reviewer ratings - five star",
                'column' => "usr_review_rating_five.rating",
                'tables' => [
                    [
                        'name' => 'usr_review_rating_five',
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'usr_review_rating_five.rating_user_id']
                    ]
                ],
                'condition' => ['type' => 'number'],
                'parent' => 'user',
                'client_functionality' => 'cfty_fivestar_review_rating',
                'description' => "Rating given towards the user for there review towards the :article (out of 5 star)."
                // 'skip_display' => true
            ],
            "gender" => [
                'label' => "Gender",
                'column' => "$users.usr_gender",
                'tables' => [],
                'condition' => ['type' => 'string'],
                'col_val_modifier' => [
                    'mod_name' => 'user_gender',
                    'fn' => 'UserConfigdata',
                    'param' => 'gender',
                    'type' => 'string'
                ],
                'parent' => 'user',
                'client_functionality' => 'cfty_gender_race_ethnicity',
                'description' => "Gender of the user."
            ],
            "ethnicity" => [
                'label' => "Ethinicity",
                'column' => "usr_ethnicity->'$.opt_val'",
                'tables' => [],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'col_val_modifier' => [
                    'mod_name' => 'user_ethnicity',
                    'fn' => 'UserConfigdata',
                    'param' => 'ethnic_origins',
                    'type' => 'array',
                    'default_delimeters' => 'new_line'
                ],
                'parent' => 'user',
                'client_functionality' => 'cfty_gender_race_ethnicity',
                'description' => "Ethinicity of the user."
            ],
            "race" => [
                'label' => "Race",
                'column' => "usr_race->'$.opt_val'",
                'tables' => [],
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'col_val_modifier' => [
                    'mod_name' => 'user_race',
                    'fn' => 'UserConfigdata',
                    'param' => 'race',
                    'type' => 'array',
                    'default_delimeters' => 'new_line'
                ],
                'parent' => 'user',
                'client_functionality' => 'cfty_gender_race_ethnicity',
                'description' => "Race of the user."
            ],
            "review_tat" => [
                'label' => "Average Review TAT",
                'column' => "user_review_tat.review_tat",
                'tables' => [
                    [
                        'name' => 'user_review_tat',
                        'join' => 'LEFT',
                        'on' => ["$users.usr_id", '=', 'user_review_tat.tat_user_id']
                    ]
                ],
                'condition' => ['type' => 'number', 'default_delimeters' => 'new_line'],
                'parent' => 'user',
                'description' => "Average number of days reviewer took to complete the review."
            ],
            'user_completed_review_count' =>  [
                'label' => 'Complete review count',
                'column' => "user_completed_review_tbl.review_count",
                'tables' => [
                    [
                        'name' => "user_completed_review_tbl",
                        'join' => 'LEFT',
                        'on' => ["user_completed_review_tbl.aflw_usr_id", '=', "$users.usr_id"]
                    ],
                ],
                'condition' => ['type' => 'number'],
                'parent' => 'user',
                'description' => "Number of :article reviews completed by the reviewer."
            ],
            'user_inprogress_review_count' =>  [
                'label' => 'Inprogress review count',
                'column' => "user_inprogress_review_tbl.review_count",
                'tables' => [
                    [
                        'name' => "user_inprogress_review_tbl",
                        'join' => 'LEFT',
                        'on' => ["user_inprogress_review_tbl.aflw_usr_id", '=', "$users.usr_id"]
                    ],
                ],
                'condition' => ['type' => 'number'],
                'parent' => 'user',
                'description' => "Number of :articles currently being reviewed by the reviewer."
            ],
            "ratings" => [
                'label' => "Reviewer ratings",
                'column' => "usr_review_rating.rating",
                'tables' => [
                    [
                        'name' => 'usr_review_rating',
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'usr_review_rating.rating_user_id']
                    ]
                ],
                'condition' => ['type' => 'number'],
                'parent' => 'user',
                'description' => "Rating given towards the user for there review towards the :article (out of 4 star)."
               // 'append_column' => 'five_star_rating'
            ],
            "five_star_rating" => [
                'label' => "Reviewer five star ratings",
                'column' => "usr_review_rating_five.rating",
                'tables' => [
                    [
                        'name' => 'usr_review_rating_five',
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'usr_review_rating_five.rating_user_id']
                    ]
                ],
                'condition' => ['type' => 'number'],
                'parent' => 'user',
                'description' => "Rating given towards the user for there review towards the :article (out of 5 star)."
                // 'skip_display' => true
            ],
            "roles" => [
                'label' => "Roles",
                'column' => "roles_table.role_name",
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => '',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => '',
                        'on' => ['user_to_journals.usrj_jnl_id', '=', 'journals.jnl_id']
                    ],
                    [
                        'name' => 'roles_table',
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => [["roles_table.user_id", '=', "$users.usr_id"],["roles_table.usrj_artp_id", 'is', 'null'],["roles_table.usrj_jnl_id", "=", "journals.jnl_id"]]
                    ],
                ],
                'independant' => true,
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => 'Roles',
                'description' => "Roles avaiable in the system (If used with other user relatable data, corresponding user role is displayed)."
            ],
            "article_type_roles" => [
                'label' => ":Article type - roles",
                'column' => "article_type_roles_table.role_name",
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => '',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'article_types',
                        'join' => 'RIGHT',
                        'on' => ['article_types.artp_id', '=', "user_to_journals.usrj_artp_id",]
                    ],
                    [
                        'name' => 'journals',
                        'join' => '',
                        'on' => ['user_to_journals.usrj_jnl_id', '=', 'journals.jnl_id']
                    ],
                    [
                        'name' => 'article_type_roles_table',
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => [["article_type_roles_table.user_id", '=', "$users.usr_id"],["article_type_roles_table.usrj_artp_id", '=', 'article_types.artp_id'],["article_type_roles_table.usrj_jnl_id", "=", "journals.jnl_id"]]
                    ],
                ],
                'independant' => true,
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => 'Roles',
                'description' => "Roles that are available within the :article type."
            ],
            "retired_roles" => [
                'label' => "Retired roles",
                'column' => "retired_roles_table.role_name",
                'tables' => [
                    [
                        'name' => 'user_to_journals',
                        'join' => '',
                        'on' => ["$users.usr_id", '=', 'user_to_journals.usrj_usr_id']
                    ],
                    [
                        'name' => 'journals',
                        'join' => '',
                        'on' => ['user_to_journals.usrj_jnl_id', '=', 'journals.jnl_id']
                    ],
                    [
                        'name' => 'retired_roles_table',
                        'join' => "LEFT",
                        'temp_table' => true,
                        'on' => [["retired_roles_table.user_id", "=", "$users.usr_id"],["retired_roles_table.usrj_jnl_id", "=", "journals.jnl_id"]]
                    ]
                ],
                'independant' => true,
                'condition' => ['type' => 'string', 'default_field_function' => 'group_concat', 'default_delimeters' => 'comma'],
                'parent' => 'Roles',
                'description' => "Displays retired roles of users."
            ],
        ],
    ],
    'condition_params' => [
        'type' => [
            'string' => [
                'is' => ["=", "?"],
                'contains' => ["like", "%?%"],
                'not_contains' => ["not like", "%?%", "Does not contains"],
                'starts_with' => ["like", "?%"],
                'ends_with' => ["like", "%?"],
                'not_start_with' => ["not like", "?%", "Does not starts with"],
                'not_end_with' => ["not like", "%?", "Does not ends with"],
                'is_empty' => ["is NULL", "IS NULL"],
                'is_not_empty' => ["is not NULL", "IS NOT NULL"]
            ],
            'number' => [
                'equals' => [" = ", "?"],
                'not_equal' => [" != ", "?", "Does not equals"],
                'greater_than' => [" > ", "?"],
                'greater_than_or_equal_to' => [" >= ", "?"],
                'less than' => [" < ", "?"],
                'less_than_or_equal_to' => [" <= ", "?"],
                'is_empty' => ["is NULL", "IS NULL"],
                'is_not_empty' => ["is not NULL", "IS NOT NULL"]
            ],
            'date' => [
                'is' => ["LIKE", "?"],
                'is_not' => ["NOT LIKE", "?"],
                'after' => [">", "?"],
                'on_or_after' => [">=", "?"],
                'before' => ["<", "?"],
                'on_or_before' => ["<=", "?"],
                'is_empty' => ["is NULL", "IS NULL"],
                'is_not_empty' => ["!= ''", "IS NOT NULL"]
            ]
        ]
    ],
    // 'filters' => [],
    'field_type_functions' => [
        'string' => [
            'group_by' => [
                'label'     => 'List as is',
                // 'function'  => 'GROUP BY REPLACE'
            ],
            'group_concat' => [
                'label'     => 'Collect in same row if possible',
                // 'function'  => 'GROUP_CONCAT(DISTINCT REPLACE SEPARATOR \'DIVIDER\')'
            ],
            'count' => [
                'label'     => 'Count number of occurrences',
                // 'function'  => 'count(distinct REPLACE)'
            ],
            /* 'ratio' => [
                'label'     => 'Ratio',
                // 'function'  => 'ROUND((count(distinct REPLACE)/(count(distinct REPLACE) + BASE_RATIO_FUNCTION )) * 100 ,2)',
                // 'function_ratio_base' => 'count(distinct REPLACE)',
            ] */
        ]
    ],
    'show_column_total_type' => [
        'unique_row_value' => [
            'label' => 'Unique values',
            'condition_value' => 'unique_row_value',
            'display_value' => 'Unique values in',
            'function' => 'count()',
            // 'action_on' => 'both', //both number and sting
        ],
        'total_row_count' => [
            'label' => 'Total values',
            'condition_value' => 'total_row_count',
            'display_value' => 'Total values in',
            'function' => 'count(REPLACE)',
            // 'action_on' => 'both', //both number and sting
        ],
        'sum_rows' => [
            'label' => 'Sum of values',
            'condition_value' => 'sum_rows',
            'display_value' => 'Sum of values in',
            'function' => 'sum(REPLACE) AS LABEL_NAME',
            // 'action_on' => 'number',
        ],
    ],
    'delimeters' => [
        'comma' => [
            'label' => 'Comma (,)',
            // 'condition_value' => 'comma',
            'value' => ', ',
        ],
        'semicolon' => [
            'label' => 'Semicolon (;)',
            // 'condition_value' => 'semicolon',
            'value' => '; ',
        ],
        'new_line' => [
            'label' => 'New line',
            // 'condition_value' => 'new_line',
            'value' => '<br/>',
        ]
    ],

    'base_join' => [
        'article' => [
            'name' => "$articles",
            'join' => 'LEFT',
            'on' => ['baseUserArticle.article_id', '=', "$articles.art_id"]
        ],
    ],
    'addition_column' => [
        'user' => [
            "five_star_rating" => [
                'label' => "Reviewer five star ratings",
                'column' => "usr_review_rating.rating",
                'tables' => [
                    [
                        'name' => 'usr_review_rating',
                        'join' => 'LEFT',
                        'temp_table' => true,
                        'on' => ["$users.usr_id", '=', 'usr_review_rating.rating_user_id']
                    ]
                ],
                'condition' => ['type' => 'string'],
                'parent' => 'user',
            ],
        ]
    ]

];
