<?php

use App\Models\Article_classification;
use App\Models\Article_export_data;
use App\Models\Article_flag;
use App\Models\Article_flow;
use App\Models\Article_keywords;
use App\Models\Article_types;
use App\Models\Articles;
use App\Models\Authors;
use App\Models\Authors_affiliation;
use App\Models\Classifications;
use App\Models\Copyright;
use App\Models\Copyright_master;
use App\Models\Country;
use App\Models\Flags;
use App\Models\Generic_flows;
use App\Models\Issues;
use App\Models\Journals;
use App\Models\Keywords;
use App\Models\Payment_order;
use App\Models\Review_rating;
use App\Models\Roles;
use App\Models\Terms;
use App\Models\User;
use App\Models\User_affiliations;
use App\Models\User_classification;
use App\Models\User_emails;
use App\Models\User_flags;
use App\Models\User_global_flags;
use App\Models\User_to_journals;
use App\Models\Userkeywords;
use App\Models\Generic_discussion;
use App\Models\Generic_discussion_comments;
use App\Models\Volumes;
use App\Models\Issue_management;
use App\Models\Article_notes;
use App\Models\Article_funder_details;
use App\Models\Funders;
use App\Models\Users_unavailability;
use App\Models\Blind_user_articles;

$journal = (new Journals)->getTable();
$article_types = (new Article_types)->getTable();
$articles = (new Articles)->getTable();
$article_flag = (new Article_flag)->getTable();
$users = (new User)->getTable();
$article_flow = (new Article_flow)->getTable();
$journal_workflow = (new Generic_flows)->getTable();
$article_export_data = (new Article_export_data)->getTable();
$article_authors = (new Authors)->getTable();
$flags = (new Flags)->getTable();
$issues = (new Issues())->getTable();
$article_keyword = (new Article_keywords())->getTable();
$copyright = (new Copyright())->getTable();
$copyright_master = (new Copyright_master())->getTable();
$payment_order = (new Payment_order())->getTable();
$roles = (new Roles())->getTable();
$keywords = (new Keywords())->getTable();
$article_keyword = (new Article_keywords())->getTable();
$article_classification = (new Article_classification())->getTable();
$classifications = (new Classifications())->getTable();
$terms = (new Terms())->getTable();
$user_emails = (new User_emails())->getTable();
$user_flags = (new User_flags)->getTable();
$global_user_flags = (new User_global_flags())->getTable();
$user_keyword = (new Userkeywords())->getTable();
$user_classification = (new User_classification())->getTable();
$reviewer_rating = (new Review_rating())->getTable();
$user_to_journals = (new User_to_journals())->getTable();
$user_affiliations = (new User_affiliations())->getTable();
$authors_affiliation = (new Authors_affiliation())->getTable();
$country = (new Country())->getTable();
$genric_discussion = (new Generic_discussion())->getTable();
$discussion_cmnts = (new Generic_discussion_comments())->getTable();
$issue_volume = (new Volumes())->getTable();
$issue_manage_mnt = (new Issue_management())->getTable(); 
$article_notes_tbl = (new Article_notes())->getTable(); 
$article_funder_dtls = (new Article_funder_details())->getTable();
$article_funders = (new Funders())->getTable();
$user_unavail_tbl = (new Users_unavailability())->getTable();
$blind_art_users = (new Blind_user_articles())->getTable();
return [
    "tables" => [
        "baseUserArticle" => "baseUserArticle",
        "articles" => "$articles",
        "journals" => "$journal as journals",
        "article_authors" => "$article_authors as article_authors",
        "article_users" => "$article_authors as article_users",
        "article_types" => "$article_types as article_types",
        "user_to_journals" => "$user_to_journals as user_to_journals",
        "pub_article_type" => "$article_types as pub_article_type",
        "art_cp" => "$articles as art_cp",
        "article_flags" => "$article_flag as article_flags",
        "flags" => "$flags as flags",
        "flags_a" => "$flags as flags_a",
        "users" => "$users as users",
        "users_table" => "$users as users_table",// to overcome sql ambibuity error
        "arts_date" => "$articles as arts_date",
        "article_flow" => "$article_flow as article_flow",
        "article_min_flow" => "$article_flow as article_min_flow",
        "article_max_flow" => "$article_flow as article_max_flow",
        "art_flow_table" => "SELECT aflw_art_id,:art_flow_table FROM $article_flow JOIN $journal_workflow ON $article_flow.aflw_jwf_id = $journal_workflow.jwf_id WHERE $journal_workflow.jwf_stage_type IN( 'accept', 'reject', 'decision_revision', 'resubmission' ) AND aflw_returned_date IS NOT NULL GROUP BY aflw_art_id",
        "article_flow_table" => "select aflw_art_id, aflw_usr_id, aflw_id, :article_flow_table, aflw_status, aflw_returned_date, jwf_id, jwf_stage_type, jwf_stage_name from $article_flow inner join $journal_workflow ON $article_flow.aflw_jwf_id = $journal_workflow.jwf_id GROUP BY aflw_id",// WHERE $article_flow.aflw_status NOT IN('g', 'd')
        "completed_review_count_table" => "select aflw_art_id, aflw_usr_id, aflw_id, :completed_review_count_table, aflw_status, jwf_id, jwf_stage_type, COUNT(aflw_id) as completed_count from $article_flow inner join $journal_workflow ON $article_flow.aflw_jwf_id = $journal_workflow.jwf_id WHERE jwf_stage_type = 'review' and aflw_status = 'c' AND aflw_parent_flow_id is not null GROUP by aflw_jwf_id,aflw_art_id,aflw_parent_flow_id",
        "journal_workflows_task" => "$journal_workflow as journal_workflows_task",
        "article_export_data" => "$article_export_data as article_export_data",
        "status_summary_table" => "SELECT st_art_id, cast(GROUP_CONCAT(DISTINCT status_label SEPARATOR ', ') as char(512)) AS status_summary
                                    FROM (SELECT $articles.`art_id` as st_art_id, CASE
                                    WHEN $articles.`art_delete_status` = 'w'  
                                    THEN 'Withdrawn'
                                    WHEN $articles.`art_delete_status` = 'h'  
                                    THEN 'On hold'
                                    
                                    WHEN $articles.`art_status` IN ('y', 'n', 't') 
                                        AND `$article_flow`.`aflw_parent_flow_id` IS NULL 
                                    THEN 
                                        CASE `$article_flow`.`aflw_status`
                                            WHEN 'a' THEN CONCAT(`$journal_workflow`.`jwf_stage_name`, ' in progress')
                                            WHEN 'p' THEN CONCAT(`$journal_workflow`.`jwf_stage_name`, ': Assignment in progress')
                                            WHEN 'w' THEN
                        CASE
                            WHEN (
                                SELECT COUNT(aflw_id)
                                FROM $article_flow AS count_flow_1
                                WHERE count_flow_1.aflw_parent_flow_id = `$article_flow`.`aflw_id`
                                  AND count_flow_1.aflw_status IN ('u', 'a', 'i', 'c')
                            ) < `$article_flow`.`aflw_stage_min_users`
                            THEN CONCAT(`$journal_workflow`.`jwf_stage_name`, ': Shortlisting in progress')

                            WHEN (
                                (
                                    SELECT COUNT(aflw_id)
                                    FROM $article_flow AS count_flow_2
                                    WHERE count_flow_2.aflw_parent_flow_id = `$article_flow`.`aflw_id`
                                      AND count_flow_2.aflw_status IN ('u')
                                ) >= 1
                            ) AND (
                                (
                                    SELECT COUNT(aflw_id)
                                    FROM $article_flow AS count_flow_3
                                    WHERE count_flow_3.aflw_parent_flow_id = `$article_flow`.`aflw_id`
                                      AND count_flow_3.aflw_status IN ('a', 'i', 'c')
                                ) < `$article_flow`.`aflw_stage_min_users`
                            )
                            THEN CONCAT(`$journal_workflow`.`jwf_stage_name`, ': Invitation in progress')

                            WHEN (
                                (
                                    SELECT COUNT(aflw_id)
                                    FROM $article_flow AS count_flow_4
                                    WHERE count_flow_4.aflw_parent_flow_id = `$article_flow`.`aflw_id`
                                      AND count_flow_4.aflw_status IN ('a')
                                ) >= `$article_flow`.`aflw_stage_min_users`
                            ) AND (
                                (
                                    SELECT COUNT(aflw_id)
                                    FROM $article_flow AS count_flow_5
                                    WHERE count_flow_5.aflw_parent_flow_id = `$article_flow`.`aflw_id`
                                      AND count_flow_5.aflw_status IN ('c')
                                ) < `$article_flow`.`aflw_stage_min_users`
                            )
                            THEN CONCAT(`$journal_workflow`.`jwf_stage_name`, ': Awaiting reviews')
    
    WHEN (
                                (
                                    SELECT COUNT(aflw_id)
                                    FROM $article_flow AS count_flow_4
                                    WHERE count_flow_4.aflw_parent_flow_id = `$article_flow`.`aflw_id`
                                      AND count_flow_4.aflw_status IN ('i')
                                ) >= `$article_flow`.`aflw_stage_min_users`
                            ) AND (
                                (
                                    SELECT COUNT(aflw_id)
                                    FROM $article_flow AS count_flow_5
                                    WHERE count_flow_5.aflw_parent_flow_id = `$article_flow`.`aflw_id`
                                      AND count_flow_5.aflw_status IN ('c')
                                ) < `$article_flow`.`aflw_stage_min_users`
                            )
                            THEN CONCAT(`$journal_workflow`.`jwf_stage_name`, ': Invited')

                            WHEN (
                                SELECT COUNT(aflw_id)
                                FROM $article_flow AS count_flow_6
                                WHERE count_flow_6.aflw_parent_flow_id = `$article_flow`.`aflw_id`
                                  AND count_flow_6.aflw_status IN ('c')
                            ) >= `$article_flow`.`aflw_stage_min_users`
                            THEN CONCAT(`$journal_workflow`.`jwf_stage_name`, ': Completed')
                        END
                                            WHEN 'i' THEN CONCAT('Ready for ', `$journal_workflow`.`jwf_stage_name`)
                                            WHEN 'u' THEN CONCAT('Ready for ', `$journal_workflow`.`jwf_stage_name`)
                                        END
                                    
                                    WHEN $articles.`art_status` IN ('a', 'r', 'c') 
                                        AND `$article_flow`.`aflw_parent_flow_id` IS NULL 
                                    THEN 
                                        CASE `$article_flow`.`aflw_status`
                                            WHEN 'a' THEN CONCAT(`$journal_workflow`.`jwf_stage_name`, ' in progress')        
                                            WHEN 'u' THEN CONCAT('Ready for ', `$journal_workflow`.`jwf_stage_name`)        
                                            WHEN 'c' 
                                            THEN 
                                                CASE 
                                    WHEN `$journal_workflow`.`jwf_stage_type` IN ('production', 'reject', 'decision_revision', 'transit')
                                    THEN CONCAT('Completed ', `$journal_workflow`.`jwf_stage_name`)
                                                            END
                                                    END
                                            END AS status_label
                                        FROM $articles
                                        LEFT JOIN $article_flow 
                                            ON $articles.art_id = $article_flow.aflw_art_id
                                        LEFT JOIN $journal_workflow 
                                            ON $article_flow.aflw_jwf_id = $journal_workflow.jwf_id
                                    ) AS status_table GROUP BY st_art_id",
        "co_authors_table" => "SELECT auth_art_id,:co_authors_table FROM $article_authors JOIN $users ON auth_usr_id = usr_id WHERE auth_corr_author = 'n' GROUP BY auth_id",
        "corr_authors_table" => "SELECT auth_art_id,:corr_authors_table FROM $article_authors JOIN $users ON auth_usr_id = usr_id WHERE auth_corr_author = 'y' GROUP BY auth_id",
        "submitting_author_table" => "SELECT art_id,:submitting_author_table FROM $articles JOIN $users ON art_submitted_by = usr_id",
        // "corr_authors_table" => "SELECT auth_art_id,:corr_authors_table FROM $article_authors JOIN $users ON auth_usr_id = usr_id GROUP BY auth_art_id",
        // "journal_workflows_task" => "$journal_workflow as journal_workflows_task",
        "issues" => "$issues as issues",
        'article_keyword' => "$article_keyword as article_keyword",
        "copyright" => "$copyright as copyright",
        "copyright_master" => "$copyright_master as copyright_master",
        "payment_order" => "$payment_order as payment_order",
        "reviewer_work_flow" => "$article_flow as reviewer_work_flow",
        "reviewer_article_flow" => "$article_flow as reviewer_article_flow",
        "reviewer_journal_workflow" => "$journal_workflow as reviewer_journal_workflow",
        "editor_workflows" => "(select jwf_id from $journal_workflow journal_workflows JOIN $roles roles on journal_workflows.jwf_role_id = roles.role_id where roles.role_assigned_role = 'editor_in_chief') as editor_workflows",
        "editor_user" => "$users as editor_user",
        "article_flow_editor" => "$article_flow as article_flow_editor",
        "journal_workflows" => "$journal_workflow as journal_workflows",
        "roles" => "$roles as roles",
        "roles_table" => "SELECT $users.usr_id as user_id,$roles.role_id,$roles.role_name,$user_to_journals.usrj_artp_id,$user_to_journals.usrj_jnl_id FROM $roles JOIN $user_to_journals ON $roles.role_id = $user_to_journals.usrj_role_id JOIN $users ON $user_to_journals.usrj_usr_id = $users.usr_id",
        "retired_roles_table" => "SELECT $users.usr_id as user_id,$roles.role_id,$roles.role_name,$user_to_journals.usrj_jnl_id FROM $roles JOIN $user_to_journals ON $roles.role_id = $user_to_journals.usrj_role_id JOIN $users ON $user_to_journals.usrj_usr_id = $users.usr_id WHERE $user_to_journals.usrj_role_retired IN('y')",
        "article_type_roles_table" => "SELECT $users.usr_id as user_id,$roles.role_id,$roles.role_name,$user_to_journals.usrj_artp_id,$user_to_journals.usrj_jnl_id FROM $roles JOIN $user_to_journals ON $roles.role_id = $user_to_journals.usrj_role_id JOIN $users ON $user_to_journals.usrj_usr_id = $users.usr_id",
        "current_status_tbl" => "(SELECT rvw_article_flow_article_status.aflw_art_id AS art_id, rvw_journal_workflows_article_status.jwf_stage_name AS jwf_stage_name FROM $article_flow AS rvw_article_flow_article_status LEFT JOIN $journal_workflow AS rvw_journal_workflows_article_status ON rvw_journal_workflows_article_status.jwf_id = rvw_article_flow_article_status.aflw_jwf_id WHERE ((rvw_article_flow_article_status.aflw_status IN('a', 'u') AND rvw_article_flow_article_status.aflw_parent_flow_id IS NULL) OR ((rvw_article_flow_article_status.aflw_status = 'w' OR rvw_article_flow_article_status.aflw_status = 'p') AND rvw_article_flow_article_status.aflw_parent_flow_id IS NULL AND aflw_skip_review = 'n' AND (SELECT COUNT(inner_article_flow.aflw_id) FROM $article_flow AS inner_article_flow WHERE inner_article_flow.aflw_parent_flow_id = rvw_article_flow_article_status.aflw_id AND inner_article_flow.aflw_status = 'c') < rvw_article_flow_article_status.aflw_stage_min_users) OR (rvw_article_flow_article_status.aflw_status = 'c' AND ( SELECT COUNT(inner_article_flow_second.aflw_id) FROM $article_flow as inner_article_flow_second WHERE inner_article_flow_second.aflw_level > rvw_article_flow_article_status.aflw_level AND inner_article_flow_second.aflw_art_id = rvw_article_flow_article_status.aflw_art_id) = 0))) AS current_status_tbl",
        "awaiting_stage_tbl" => "(SELECT article_flow_tbl.aflw_art_id as aflw_art_id,article_flow_tbl.aflw_id as aflw_id,article_flow_tbl.aflw_assigned_date as aflw_assigned_date,article_flow_tbl.aflw_returned_date as aflw_returned_date,article_flow_tbl.aflw_accepted_date as aflw_accepted_date,workflow_tbl.jwf_stage_type as jwf_stage_type,workflow_tbl.jwf_stage_name as jwf_stage_name,workflow_tbl.jwf_id as jwf_id,article_flow_tbl.aflw_status as aflw_status,article_flow_tbl.aflw_jwf_id as aflw_jwf_id FROM $article_flow AS article_flow_tbl INNER JOIN $journal_workflow AS workflow_tbl ON article_flow_tbl.aflw_jwf_id = workflow_tbl.jwf_id) AS awaiting_stage_tbl",
        "art_flow_last_decision" => "(SELECT MAX(article_flow.aflw_id) max_aflw_id, article_flow.aflw_id as aflw_id,article_flow.aflw_art_id,article_flow.aflw_returned_date as aflw_returned_date, journal_workflows.jwf_stage_type FROM $article_flow as article_flow JOIN $journal_workflow as journal_workflows ON article_flow.aflw_jwf_id = journal_workflows.jwf_id WHERE journal_workflows.jwf_stage_type IN( 'accept', 'reject', 'decision_revision', 'resubmission' ) AND article_flow.aflw_returned_date IS NOT NULL GROUP BY article_flow.aflw_art_id) art_flow_last_decision",
        "keywords" => "$keywords as keywords",
        "article_keywords" => "$article_keyword as article_keywords",
        "article_keywords_custom" => "select ak_art_id, :article_keywords_custom from $article_keyword as article_keywords join $keywords as keywords on article_keywords.ak_keyword_id = keywords.kwd_id group by ak_art_id",
        "article_classification" => "$article_classification as article_classification",
        "art_term_table" => "select arcls_art_id as cls_art_id, cls_term_id from $article_classification JOIN $classifications ON cls_id = arcls_cls_id",
        "article_classification_custom" => "WITH RECURSIVE Hierarchy AS ( SELECT cls_id, cls_id as child_id, cls_term_id, cls_primary_id, rac.arcls_art_id as art_id, ct.term_name AS hierarchy_path FROM $classifications t INNER JOIN $terms ct ON t.cls_term_id = ct.term_id INNER JOIN $article_classification rac ON rac.arcls_cls_id = t.cls_id  UNION ALL SELECT t.cls_id, h.child_id, t.cls_term_id, t.cls_primary_id, h.art_id, CONCAT(ct.term_name, ' >> ', h.hierarchy_path) FROM $classifications t INNER JOIN Hierarchy h ON t.cls_id = h.cls_primary_id INNER JOIN $terms ct ON t.cls_term_id = ct.term_id ) SELECT art_id, hierarchy_path FROM Hierarchy WHERE cls_primary_id IS NULL ORDER BY hierarchy_path",
        "article_notes" => "(SELECT GROUP_CONCAT( CONCAT( 'Posted by: ', ' ', COALESCE(`usr_first_name`), ' ', COALESCE(`usr_middle_name`), ' ', COALESCE(`usr_last_name`), '<br>', ' . ' 'Subject: ', an_title, '<br>', 'Content:', an_note ) SEPARATOR '<br><br>' ) as notes,an_art_id as note_art_id FROM `$article_notes_tbl` JOIN `$users` ON `$users`.`usr_id` = $article_notes_tbl.an_posted_by GROUP BY `$article_notes_tbl`.`an_art_id` ORDER BY `$article_notes_tbl`.`an_posted_date` DESC) as article_notes",
        "article_funder" => "(SELECT GROUP_CONCAT( CONCAT( 'Funder: ', funder_name, '<BR> Grand number: ', afd_grant_number ) SEPARATOR '<BR><BR>' ) as funders_list,afd_art_id as funder_art_id FROM `$article_funder_dtls` JOIN `$article_funders` ON `funder_id` = afd_funder_id GROUP BY afd_art_id ORDER BY afd_posted_date DESC) as article_funder",
        "article_copyright" => "(SELECT GROUP_CONCAT(`crtm_license_name`) as copyright_list,crt_art_id as cpy_art_id FROM `$copyright_master` JOIN `$copyright` ON `crtm_id` = `crt_crtm_id` GROUP BY crt_art_id) as article_copyright",
        "time_spend_review" => "(SELECT DATEDIFF(MAX(rvw_article_flow_for_all_stages.aflw_returned_date),MIN(rvw_article_flow_for_all_stages.aflw_assigned_date))  AS time_spend_in_review,aflw_art_id as art_id FROM $article_flow AS rvw_article_flow_for_all_stages LEFT JOIN $journal_workflow AS rvw_journal_workflows_for_all_stages ON rvw_journal_workflows_for_all_stages.jwf_id = rvw_article_flow_for_all_stages.aflw_jwf_id WHERE rvw_journal_workflows_for_all_stages.`jwf_stage_type` = 'review' GROUP BY rvw_article_flow_for_all_stages.aflw_art_id) as time_spend_review",
        "user_alternative_email" => "$user_emails as user_alternative_email",
        "user_flags" => "$user_flags as user_flags",
        "global_user_flags" => "$global_user_flags as global_user_flags",
        "user_keywords_custom" => "select ukwd_usr_id, :user_keywords_custom from $user_keyword as user_keywords join $keywords as keywords on user_keywords.ukwd_kwd_id = keywords.kwd_id WHERE kwd_user_keyword = 'n' group by ukwd_usr_id",
        "user_keywords" => "$user_keyword as user_keywords",
        "user_classification_custom" => "WITH RECURSIVE Hierarchy AS ( SELECT cls_id, cls_id as child_id, cls_term_id, cls_primary_id, rac.usrcls_usr_id as usr_id, ct.term_name AS hierarchy_path FROM $classifications t INNER JOIN $terms ct ON t.cls_term_id = ct.term_id INNER JOIN $user_classification rac ON rac.usrcls_cls_id = t.cls_id  UNION ALL SELECT t.cls_id, h.child_id, t.cls_term_id, t.cls_primary_id, h.usr_id, CONCAT(ct.term_name, ' >> ', h.hierarchy_path) FROM $classifications t INNER JOIN Hierarchy h ON t.cls_id = h.cls_primary_id INNER JOIN $terms ct ON t.cls_term_id = ct.term_id ) SELECT usr_id, hierarchy_path FROM Hierarchy WHERE cls_primary_id IS NULL ORDER BY hierarchy_path",
        "usr_term_table" => "select usrcls_usr_id as cls_usr_id, cls_term_id from $user_classification JOIN $classifications ON cls_id = usrcls_cls_id",
        "article_discussion" => "(SELECT GROUP_CONCAT(CONCAT( 'Posted by: ', ' ', COALESCE(`usr_first_name`), ' ', COALESCE(`usr_middle_name`), ' ', COALESCE(`usr_last_name`), '<br>', " . " 'Comment: ', gdsc_comment) SEPARATOR '<br><br>' ) as comments,gdis_art_id as discussion_art FROM $discussion_cmnts INNER JOIN $genric_discussion ON gdsc_gdis_id = gdis_id INNER JOIN $users ON gdsc_posted_by = usr_id GROUP BY gdis_art_id) as article_discussion",
        "task_started_date" => "(SELECT CASE WHEN flow_tbl.aflw_status IN ('a','c','u','g','p','w') THEN flow_tbl.aflw_assigned_date ELSE NULL END as started_date,aflw_art_id as flow_art_id FROM $article_flow as flow_tbl) as task_started_date",
        "tat_submission_to_first_decision" => "(WITH valid_stage_articles AS (
    SELECT aflw_art_id, MIN(aflw_returned_date) AS aflw_returned_date
    FROM $article_flow f
    JOIN $journal_workflow w ON f.aflw_jwf_id = w.jwf_id
    WHERE w.jwf_stage_type IN ('accept', 'decision_revision', 'reject', 'resubmission')
    GROUP BY aflw_art_id
),

fallback_articles AS (
    SELECT 
        a.art_id,
        MAX(f.aflw_assigned_date) AS aflw_returned_date
    FROM $articles a
    JOIN $articles parent ON FIND_IN_SET(a.art_id, parent.art_pre_all_ids) > 0
    JOIN $article_flow f ON f.aflw_art_id = parent.art_id
    WHERE a.art_id NOT IN (
        SELECT aflw_art_id FROM valid_stage_articles
    )
    GROUP BY a.art_id
),

combined_articles AS (
    SELECT 
        a.art_id,
        a.art_code,
        a.art_submission_date,
        w.jwf_stage_type,
        vs.aflw_returned_date,
        DATEDIFF(vs.aflw_returned_date, a.art_submission_date) AS days_to_return
    FROM valid_stage_articles vs
    JOIN $articles a ON a.art_id = vs.aflw_art_id
    JOIN $article_flow f ON f.aflw_art_id = vs.aflw_art_id AND f.aflw_returned_date = vs.aflw_returned_date
    JOIN $journal_workflow w ON f.aflw_jwf_id = w.jwf_id

    UNION ALL

    SELECT 
        a.art_id,
        a.art_code,
        a.art_submission_date,
        NULL AS jwf_stage_type,
        fb.aflw_returned_date,
        DATEDIFF(fb.aflw_returned_date, a.art_submission_date) AS days_to_return
    FROM fallback_articles fb
    JOIN $articles a ON a.art_id = fb.art_id
),

ranked_articles AS (
    SELECT *,
           ROW_NUMBER() OVER (
               PARTITION BY art_id
               ORDER BY aflw_returned_date ASC, COALESCE(jwf_stage_type, '') ASC
           ) AS rn
    FROM combined_articles
)

SELECT art_id as tat_first_art, days_to_return as tat_first
FROM ranked_articles
WHERE rn = 1
) AS `tat_submission_to_first_decision`",
"tat_submission_to_last_decision" => "(WITH valid_stage_articles AS (
    SELECT aflw_art_id, MAX(aflw_returned_date) AS aflw_returned_date
    FROM $article_flow f
    JOIN $journal_workflow w ON f.aflw_jwf_id = w.jwf_id
    WHERE w.jwf_stage_type IN ('accept', 'decision_revision', 'reject', 'resubmission')
    GROUP BY aflw_art_id
),

fallback_articles AS (
    SELECT 
        a.art_id,
        MAX(f.aflw_assigned_date) AS aflw_returned_date
    FROM $articles a
    JOIN $articles parent ON FIND_IN_SET(a.art_id, parent.art_pre_all_ids) > 0
    JOIN $article_flow f ON f.aflw_art_id = parent.art_id
    WHERE a.art_id NOT IN (
        SELECT aflw_art_id FROM valid_stage_articles
    )
    GROUP BY a.art_id
),

combined_articles AS (
    SELECT 
        a.art_id,
        a.art_code,
        a.art_submission_date,
        w.jwf_stage_type,
        vs.aflw_returned_date,
        DATEDIFF(vs.aflw_returned_date, a.art_submission_date) AS days_to_return
    FROM valid_stage_articles vs
    JOIN $articles a ON a.art_id = vs.aflw_art_id
    JOIN $article_flow f ON f.aflw_art_id = vs.aflw_art_id AND f.aflw_returned_date = vs.aflw_returned_date
    JOIN $journal_workflow w ON f.aflw_jwf_id = w.jwf_id

    UNION ALL

    SELECT 
        a.art_id,
        a.art_code,
        a.art_submission_date,
        NULL AS jwf_stage_type,
        fb.aflw_returned_date,
        DATEDIFF(fb.aflw_returned_date, a.art_submission_date) AS days_to_return
    FROM fallback_articles fb
    JOIN $articles a ON a.art_id = fb.art_id
),

ranked_articles AS (
    SELECT *,
           ROW_NUMBER() OVER (
               PARTITION BY art_id
               ORDER BY aflw_returned_date ASC, COALESCE(jwf_stage_type, '') ASC
           ) AS rn
    FROM combined_articles
)

SELECT art_id as tat_last_art, days_to_return as tat_last
FROM ranked_articles
WHERE rn = 1
) AS `tat_submission_to_last_decision`",
"usr_affliation_table" => "SELECT usaff_user_id, cast(concat(if(usaff_department is not null AND usaff_department != '', concat('Department: ', usaff_department, ', <br/>'),''),if(usaff_company is not null AND usaff_company != '', concat('Institution: ', usaff_company,', <br/>'),''),CONCAT(  IF( usaff_address_line1 IS NOT NULL AND usaff_address_line1 != '', CONCAT('Address line: ', usaff_address_line1), '' ), IF( usaff_address_line2 IS NOT NULL AND usaff_address_line2 != '', CONCAT( IF( usaff_address_line1 IS NOT NULL AND usaff_address_line1 != '', ', ', 'Address line: ' ), usaff_address_line2 ), '' ), IF( (usaff_address_line1 IS NOT NULL AND usaff_address_line1 != '') OR (usaff_address_line2 IS NOT NULL AND usaff_address_line2 != ''), ',<br/>', '' )),if(usaff_state  is not null AND usaff_state != '', concat('State: ', usaff_state, ', <br/>'),''),if(usaff_cnt_id  is not null AND usaff_cnt_id != '', concat('Country: ', cnt_country),'')) as char(512) ) as affiliation, usaff_cnt_id, usaff_state, usaff_company,usaff_postal_code FROM $user_affiliations join $country on $user_affiliations.usaff_cnt_id = $country.cnt_id",
"usr_review_rating" => "SELECT * FROM (SELECT ROUND(AVG(rvr_rating), 2) AS rating, rvr_reviewer_id AS rating_user_id FROM $reviewer_rating WHERE rvr_five_star = 'n' GROUP BY rvr_reviewer_id ) AS usr_review_rating",
"usr_review_rating_five" => "SELECT * FROM (SELECT ROUND(AVG(rvr_rating), 2) AS rating, rvr_reviewer_id AS rating_user_id FROM $reviewer_rating WHERE rvr_five_star = 'y' GROUP BY rvr_reviewer_id ) AS usr_review_rating_five",
"usr_article_blind" => "(SELECT uc.bau_art_id AS blind_article, CONCAT_WS( ' ',u.usr_first_name, u.usr_last_name) AS blind_users FROM $blind_art_users uc JOIN JSON_TABLE( uc.bau_usr_ids, '$[*]' COLUMNS(usr_id VARCHAR(255) PATH '$')) AS jt ON TRUE JOIN $users u ON u.usr_id = jt.usr_id) AS usr_article_blind",
"proposal_status" => "(SELECT CASE WHEN (aflw_status LIKE 'u' AND `art_proposal_method` = 'invite') THEN 'Not invited' WHEN (aflw_status LIKE 'u' AND `art_proposal_method` = 'assign') THEN 'Not assigned' WHEN (aflw_status LIKE 'a') THEN 'Submission in progress' WHEN (aflw_status LIKE 'c') THEN 'Submitted' WHEN (aflw_status LIKE 'i' AND `art_proposal_method` = 'invite') THEN 'Invited' WHEN (aflw_status LIKE 'd' AND `art_proposal_method` = 'invite') THEN 'Declined' ELSE NULL END AS proposal_stat, art_id AS proposal_art_id, art_code FROM `$articles` INNER JOIN $article_flow ON aflw_art_id = art_id INNER JOIN $journal_workflow ON aflw_jwf_id = jwf_id WHERE `art_stage_submission_method` LIKE 'b' AND jwf_stage_type = 'author_submission' GROUP BY aflw_art_id, art_id, art_code) as proposal_status",
"article_status" => "(SELECT CASE WHEN art_transfer_status = 'y' THEN 'Transferred' WHEN art_delete_status = 'y' THEN 'Deleted' WHEN art_delete_status = 'w' THEN 'Withdrawn' WHEN art_delete_status = 'h' THEN 'On hold' WHEN art_status = 'a' THEN 'Accepted' WHEN art_status = 'r' THEN 'Rejected' WHEN art_status = 'y' THEN 'Submitted' WHEN art_status = 'n' THEN 'Submission in progress' WHEN art_status = 'c' THEN 'Closed' WHEN art_status = 't' AND art_delete_status = 'n' AND art_transfer_article = 'n' THEN 'Transfer in progress' ELSE NULL END AS art_stat, `art_id`,`art_code`,`art_status`,`art_delete_status`,`art_transfer_status` FROM rvw_articles) as article_status",
"reviewer_rating" => "select rvr_reviewer_id, round(avg((rvr_rating/(if(rvr_five_star = 'y', 5, 4)))*5), 1) rating from $reviewer_rating group by rvr_reviewer_id;",
"user_affiliation_cntry" =>"(SELECT ua.usaff_user_id as aff_user_id, c.cnt_country as aff_user_country
FROM $user_affiliations ua
INNER JOIN $country c ON ua.usaff_cnt_id = c.cnt_id
INNER JOIN (
    SELECT usaff_user_id, MAX(usaff_id) AS max_usaff_id
    FROM $user_affiliations
    WHERE usaff_prime_affiliation = 'y'
    GROUP BY usaff_user_id
) last_aff ON ua.usaff_user_id = last_aff.usaff_user_id AND ua.usaff_id = last_aff.max_usaff_id) AS user_affiliation_cntry",
 "author_affiliation_cntry" => "(SELECT ar.auth_usr_id AS auth_user_id, c.cnt_country as author_country FROM $authors_affiliation  aa INNER JOIN $article_authors ar ON aa.auaff_auth_id = ar.auth_id INNER JOIN $users u ON ar.auth_usr_id = u.usr_id INNER JOIN $country c ON aa.auaff_cnt_id = c.cnt_id INNER JOIN ( SELECT ar.auth_usr_id, MAX(aa.auaff_id) AS last_auaff_id FROM $authors_affiliation  aa INNER JOIN $article_authors ar ON aa.auaff_auth_id = ar.auth_id WHERE aa.auaff_prime_affiliation = 'y' GROUP BY ar.auth_usr_id ) latest ON ar.auth_usr_id = latest.auth_usr_id AND aa.auaff_id = latest.last_auaff_id WHERE aa.auaff_prime_affiliation = 'y'
) AS author_affiliation_cntry",
 "user_unavailable_dates_tbl" => "(SELECT unavail_user_id,GROUP_CONCAT(CONCAT('From ', unavail_start_date, ' To ', unavail_end_date) SEPARATOR '\n') AS date_ranges FROM `$user_unavail_tbl` GROUP BY unavail_user_id) AS user_unavailable_dates_tbl",
 "user_journal_roles_tbl" => "( SELECT usrj_usr_id, jnl_journal_name AS journal_name, GROUP_CONCAT(DISTINCT r.role_name ORDER BY r.role_name SEPARATOR ', ') AS roles_per_journal FROM $user_to_journals jt INNER JOIN $roles r ON jt.usrj_role_id = r.role_id INNER JOIN $journal oj ON jt.usrj_jnl_id = oj.jnl_id WHERE jt.usrj_artp_id IS NULL GROUP BY usrj_usr_id, oj.jnl_id ) AS user_journal_roles_tbl",
 "user_article_type_roles_tbl" => "(SELECT 
        jt.usrj_usr_id,
        oj.jnl_id,
        oj.jnl_journal_name AS journal_name,
        GROUP_CONCAT(
            CONCAT('  ', at.artp_article_type, ' - ', at_roles.role_names)
            ORDER BY at.artp_article_type
            SEPARATOR '\n'
        ) AS article_roles_per_journal
    FROM 
        $user_to_journals jt
    INNER JOIN $roles r ON jt.usrj_role_id = r.role_id
    INNER JOIN $journal oj ON jt.usrj_jnl_id = oj.jnl_id
    LEFT JOIN $article_types at ON jt.usrj_artp_id = at.artp_id
    LEFT JOIN (
        SELECT 
            jt2.usrj_usr_id,
            jt2.usrj_artp_id,
            GROUP_CONCAT(DISTINCT r2.role_name ORDER BY r2.role_name SEPARATOR ', ') AS role_names
        FROM 
            $user_to_journals jt2
        INNER JOIN $roles r2 ON jt2.usrj_role_id = r2.role_id
        WHERE jt2.usrj_artp_id IS NOT NULL
        GROUP BY jt2.usrj_usr_id, jt2.usrj_artp_id
    ) at_roles ON jt.usrj_usr_id = at_roles.usrj_usr_id AND jt.usrj_artp_id = at_roles.usrj_artp_id
    WHERE jt.usrj_artp_id IS NOT NULL
    GROUP BY jt.usrj_usr_id, oj.jnl_id
) AS user_article_type_roles_tbl",
 "user_standalone_tbl" => "(SELECT GROUP_CONCAT(DISTINCT jnl_journal_name) as journals,usrj_usr_id FROM $user_to_journals INNER JOIN $journal ON usrj_jnl_id = jnl_id WHERE usrj_artp_id IS NULL AND jnl_standalone = 'y' GROUP BY usrj_usr_id) as user_standalone_tbl",
 "user_completed_review_tbl" => "(SELECT COUNT(aflw_id) as review_count,aflw_usr_id FROM $article_flow INNER JOIN $journal_workflow ON aflw_jwf_id = jwf_id WHERE jwf_stage_type = 'review' AND aflw_parent_flow_id IS NOT NULL AND aflw_status = 'c' GROUP BY aflw_usr_id) AS user_completed_review_tbl",
 "user_inprogress_review_tbl" => "(SELECT COUNT(aflw_id) as review_count,aflw_usr_id FROM $article_flow INNER JOIN $journal_workflow ON aflw_jwf_id = jwf_id WHERE jwf_stage_type = 'review' AND aflw_parent_flow_id IS NOT NULL AND aflw_status = 'a' GROUP BY aflw_usr_id) as user_inprogress_review_tbl",
 "submit_auth_primary_aff_details" => "
    (SELECT
        auth_art_id,
        auth_usr_id,
        IF(
            author_aff_tbl.cnt_country IS NULL,
            user_aff_tbl.cnt_country,
            author_aff_tbl.cnt_country
        ) AS country,
        IF(
            author_aff_tbl.auaff_state IS NULL,
            user_aff_tbl.usaff_state,
            author_aff_tbl.auaff_state
        ) AS state
    FROM
        $article_authors
    LEFT JOIN(
        SELECT
            usaff_user_id,
            usaff_state,
            cnt_country
        FROM
            $user_affiliations
        INNER JOIN $country ON usaff_cnt_id = cnt_id
        WHERE
            usaff_prime_affiliation = 'y'
        GROUP BY
            usaff_user_id
        ORDER BY
            usaff_id ASC
    ) AS user_aff_tbl
    ON
        user_aff_tbl.usaff_user_id = auth_usr_id
    LEFT JOIN(
        SELECT
            auaff_auth_id,
            auaff_state,
            cnt_country
        FROM
            $authors_affiliation
        INNER JOIN $country ON auaff_cnt_id = cnt_id
        WHERE
            auaff_prime_affiliation = 'y'
    ) AS author_aff_tbl
    ON
        author_aff_tbl.auaff_auth_id = auth_id
    GROUP BY
        auth_art_id
    ORDER BY
        auth_id) AS submit_auth_primary_aff_details",
 "corres_auth_primary_aff_details" => "
    (SELECT
        auth_art_id,
        IF(
            author_aff_tbl.cnt_id IS NULL,
            user_aff_tbl.cnt_id,
            author_aff_tbl.cnt_id
        ) AS country_id,
        IF(
            author_aff_tbl.cnt_country IS NULL,
            user_aff_tbl.cnt_country,
            author_aff_tbl.cnt_country
        ) AS country,
        IF(
            author_aff_tbl.auaff_state IS NULL,
            user_aff_tbl.usaff_state,
            author_aff_tbl.auaff_state
        ) AS state
    FROM
        $article_authors
    LEFT JOIN(
        SELECT
            usaff_user_id,
            usaff_state,
            cnt_id,
            cnt_country
        FROM
            $user_affiliations
        INNER JOIN $country ON usaff_cnt_id = cnt_id
        WHERE
            usaff_prime_affiliation = 'y'
        GROUP BY
            usaff_user_id
        ORDER BY
            usaff_id ASC
    ) AS user_aff_tbl
    ON
        user_aff_tbl.usaff_user_id = auth_usr_id
    LEFT JOIN(
        SELECT
            auaff_auth_id,
            auaff_state,
            cnt_id,
            cnt_country
        FROM
            $authors_affiliation
        INNER JOIN $country ON auaff_cnt_id = cnt_id
        WHERE
            auaff_prime_affiliation = 'y'
    ) AS author_aff_tbl
    ON
        author_aff_tbl.auaff_auth_id = auth_id
    WHERE
        auth_corr_author = 'y'
    GROUP BY
        auth_art_id
    ORDER BY
        auth_id) AS corres_auth_primary_aff_details",
    "article_issue" => "( SELECT CONCAT(iss_title, ' (', vol_title, ')') AS issue_name,ism_art_id AS issue_art_id,iss_id FROM $issue_manage_mnt INNER JOIN $issues ON ism_iss_id = iss_id INNER JOIN $issue_volume ON vol_id = iss_vol_id) as article_issue",
    "user_review_tat" => "(SELECT ROUND(AVG(DATEDIFF(aflw_returned_date, aflw_accepted_date)), 2) as review_tat,aflw_usr_id as tat_user_id FROM $article_flow INNER JOIN $journal_workflow ON aflw_jwf_id = jwf_id WHERE jwf_stage_type = 'review' AND aflw_parent_flow_id IS NOT NULL AND aflw_status = 'c' GROUP BY aflw_usr_id) AS user_review_tat",
    "recurent_stage_tbl" => "(SELECT
        COUNT(jwf_id) AS recurrent_count,
        jwf_id,
        art_id
    FROM
        $articles
    INNER JOIN $article_flow ON art_id = aflw_art_id
    INNER JOIN $journal_workflow ON jwf_id = aflw_jwf_id
    WHERE
        aflw_parent_flow_id IS NULL
    GROUP BY
        jwf_id,
        art_id ) AS recurent_stage_tbl",
"task_abandoned_tbl" => "(SELECT
    MIN(aflw_assigned_date) as task_abadoned_date,
    aflw_art_id as abandoned_art_id
FROM
    rvw_article_flow
INNER JOIN rvw_journal_workflows AS outer_workflow 
    ON aflw_jwf_id = jwf_id
WHERE
    outer_workflow.jwf_stage_type = 'revision'
    AND EXISTS (
        SELECT 1
        FROM rvw_journal_workflows AS inner_workflow
        WHERE FIND_IN_SET(
                  outer_workflow.jwf_id,
                  REPLACE(REPLACE(REPLACE(inner_workflow.jwf_child_stages, '\"', ''), '[', ''), ']', '')
              )
          AND inner_workflow.jwf_fwm_id = outer_workflow.jwf_fwm_id
          AND inner_workflow.jwf_stage_type = 'staff_check'
    )
GROUP BY aflw_art_id) as task_abandoned_tbl",
    ],
    'indexing' => [
        'usr_affliation_table' => [
            'index_name' => 'idx_usr_affliation_table',
            'index_columns' => 'usaff_user_id'
        ],
        'article_flow_table' => [
            'index_name' => 'idx_article_flow_table',
            'index_columns' => 'aflw_id'
        ]
    ]
];
