<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        DB::unprepared("
        DROP FUNCTION IF EXISTS `strip_tags`;
        CREATE FUNCTION `strip_tags`(`input_str` TEXT CHARSET utf8mb3) RETURNS TEXT CHARSET utf8mb3 DETERMINISTIC CONTAINS SQL SQL SECURITY DEFINER BEGIN DECLARE iStart, iEnd, iLength INT ; 
        WHILE LOCATE('<', input_str) > 0 AND LOCATE( '>', input_str, LOCATE('<', input_str) ) > 0 
        DO 
        BEGIN SET iStart = LOCATE('<', input_str), iEnd = LOCATE( '>', input_str, LOCATE('<', input_str) ) ; 
        SET iLength =(iEnd - iStart) + 1 ; IF iLength > 0 THEN BEGIN SET input_str = INSERT (input_str, iStart, iLength, '') ; 
        END ; 
        END IF ; 
        END ; 
        END WHILE ; 
        RETURN input_str ; 
        END ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::unprepared(" DROP FUNCTION `strip_tags`; 
             CREATE FUNCTION `strip_tags`(`input_str` TEXT) RETURNS TEXT CHARSET latin1 DETERMINISTIC CONTAINS SQL SQL SECURITY DEFINER BEGIN DECLARE iStart, iEnd, iLength INT ;
             WHILE LOCATE('<', input_str) > 0 AND LOCATE( '>', input_str, LOCATE('<', input_str) ) > 0 
             DO 
             BEGIN SET iStart = LOCATE('<', input_str), iEnd = LOCATE( '>', input_str, LOCATE('<', input_str) ) ; 
             SET iLength =(iEnd - iStart) + 1 ; IF iLength > 0 THEN BEGIN SET input_str = INSERT (input_str, iStart, iLength, '') ;
             END ;
             END IF ;
             END ;
             END WHILE ;
             RETURN input_str ;
             END ");
    }
};
