<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('rvw_sheet_view_optional_selected_colums', function (Blueprint $table) {
            $table->bigIncrements('sosc_id');
            $table->bigInteger('sosc_user_id');
            $table->bigInteger('sosc_jnl_id');
            $table->text('sosc_colums')->collation('utf8_unicode_ci');
            $table->bigInteger('sosc_posted_by');
            $table->dateTime('sosc_posted_date');
            $table->bigInteger('sosc_proxy_id');
            $table->char('sosc_operation',1)->comment('u-update,i-insert')->collation('utf8_unicode_ci');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('rvw_sheetview_optional_selected_colums');
    }
};
