<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            DB::statement("ALTER TABLE `rvw_payment_order` DROP FOREIGN KEY `FK_paymnt_art_id`;");
            DB::statement("ALTER TABLE `rvw_payment_order` DROP INDEX `pmt_ord_art_id`;");
            DB::statement("ALTER TABLE `rvw_payment_order` ADD CONSTRAINT `FK_paymnt_art_id` FOREIGN KEY (`pmt_ord_art_id`) REFERENCES `rvw_articles` (`art_id`) ON DELETE CASCADE;");
        } catch (\Exception $e) {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::rollback();
    }
};
