<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('rvw_article_types', 'artp_status'))
        {
            Schema::table('rvw_article_types', function (Blueprint $table) {
                $table->char('artp_status', 1)->default('y')->comment('y:active journal,n:deactive journal')->after('artp_article_submission_status')->change();           
            });
        }
        if (Schema::hasColumn('tbk_article_types', 'artp_status'))
        {
            Schema::table('tbk_article_types', function (Blueprint $table) {
                $table->char('artp_status', 1)->default('y')->comment('y:active journal,n:deactive journal')->after('artp_article_submission_status')->change();       
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('rvw_article_types', 'artp_status'))
        {
            Schema::table('rvw_article_types', function (Blueprint $table) {
                $table->dropColumn('artp_status');           
            });
        }
        if (Schema::hasColumn('tbk_article_types', 'artp_status'))
        {
            Schema::table('tbk_article_types', function (Blueprint $table) {
                $table->dropColumn('artp_status');           
            });
        }
    }
};
