<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    { 
        DB::statement ("DROP TABLE IF EXISTS `rw_article_custom_reasons`");
        DB::statement("CREATE TABLE IF NOT EXISTS  `rvw_article_custom_reasons` (
            `cusr_id` bigint UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
            `cusr_art_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_articles',
            `cusr_aflw_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_article_flow',
            `cusr_action_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci  NOT NULL,
            `cusr_reason` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci  NOT NULL,
            `cusr_posted_by` bigint UNSIGNED NOT NULL,
            `cusr_posted_date` datetime NOT NULL,
            `cusr_proxy_id` bigint NOT NULL,
            `cusr_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert'
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
        ");

        DB::statement("CREATE TABLE IF NOT EXISTS  `tbk_article_custom_reasons` (
            `cusr_id` bigint UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
            `cusr_art_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_articles',
            `cusr_aflw_id` bigint UNSIGNED NOT NULL COMMENT 'pk of rvw_article_flow',
            `cusr_action_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci  NOT NULL,
            `cusr_reason` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci  NOT NULL,
            `cusr_posted_by` bigint UNSIGNED NOT NULL,
            `cusr_posted_date` datetime NOT NULL,
            `cusr_proxy_id` bigint NOT NULL,
            `cusr_operation` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
            `tbk_id` int UNSIGNED NOT NULL
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
        ");
           
           DB::unprepared('
            CREATE TRIGGER trg_article_custom_reasons_after_insert AFTER INSERT ON `rvw_article_custom_reasons` FOR EACH ROW
            BEGIN
            INSERT INTO tbk_article_custom_reasons SELECT *,NULL tbk_id FROM rvw_article_custom_reasons WHERE cusr_id= NEW.cusr_id;
            END
        ');
        DB::unprepared("
            CREATE TRIGGER trg_article_custom_reasons_after_update AFTER UPDATE ON `rvw_article_custom_reasons` FOR EACH ROW
            BEGIN
            IF (NEW.cusr_operation != 'm') THEN INSERT INTO tbk_article_custom_reasons SELECT *,NULL tbk_id FROM rvw_article_custom_reasons WHERE cusr_id= OLD.cusr_id;
            END IF;
            END
        ");     
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_article_custom_reasons');
        Schema::dropIfExists('tbk_article_custom_reasons');
    }
};
