<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::beginTransaction();
        try
        {
            DB::statement("CREATE TABLE IF NOT EXISTS `rvw_ithenticate_webhooks` (
                `iwh_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                `iwh_webhook_id` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'ithenticate webhook id from turnitin',
                `iwh_posted_by` bigint(20) UNSIGNED NOT NULL,
                `iwh_posted_date` datetime NOT NULL,
                `iwh_proxy_id` bigint(20) UNSIGNED DEFAULT NULL,
                `iwh_operation` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u' COMMENT 'u-update,i-insert',
                PRIMARY KEY (`iwh_id`)
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

            DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_ith_v2_view_settings` JSON NULL DEFAULT NULL COMMENT 'ith_v2 view settings options' AFTER `jset_plagiarism_checking`;");
            DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_ith_v2_view_settings` JSON NULL DEFAULT NULL COMMENT 'ith_v2 view settings options' AFTER `jset_plagiarism_checking`;");

            DB::statement("ALTER TABLE `rvw_article_type_advance_options` ADD `atotp_ith_v2_view_settings` JSON NULL DEFAULT NULL COMMENT 'ith_v2 view settings options' AFTER `atotp_plagiarism_checking`;");
            DB::statement("ALTER TABLE `tbk_article_type_advance_options` ADD `atotp_ith_v2_view_settings` JSON NULL DEFAULT NULL COMMENT 'ith_v2 view settings options' AFTER `atotp_plagiarism_checking`;");
        }
        catch(\Exception $e)
        {
            DB::rollback();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rvw_ithenticate_webhooks');
    }
};
